{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMPLL2.PAS
              Shows flowing pull-down menu features, including
              Multiple Pop-ups, Main Hot keys, and Implementing a menu loop
}

program DEMPLL2;

{$I GOLDFLAG.INC}

uses DOS, CRT, GoldFast, GoldKey, GoldMenu, GoldAttr, GoldWin, GoldStr,
               GoldMisc, GoldTint;

var
   MainMenu: Bar;
   FileMenu: PopUp;
   OptionsMenu: PopUp;
   Choice: integer;

procedure DefineFilePopUp;
{}
begin
   InitPopUp(FileMenu);
   PopUpAddItem(FileMenu,'~N~ew',101,78,'Create a new file in a new Edit window',nil);
   PopUpAddItem(FileMenu,'~O~pen...:F3',102,79,'Locate and open in an Edit window',nil);
   PopUpAddItem(FileMenu,'~S~ave:F2',103,83,'Save the file in the active Edit window',nil);
   PopUpAddItem(FileMenu,'Save ~a~s...',104,65,'Save the current file under a different name directory or drive',nil);
   PopUpAddItem(FileMenu,'Save a~l~l',105,76,'Save all modified files',nil);
   PopUpAddItem(FileMenu,'-',0,0,'',nil); {separator}
   PopUpAddItem(FileMenu,'~C~hange dir...',106,67,'Choose a new default directory',nil);
   PopUpAddItem(FileMenu,'~P~rint',107,80,'Print the contents of the active Edit window',nil);
   PopUpAddItem(FileMenu,'P~r~inter setup',108,82,'Choose printer filter to use for printing',nil);
   PopUpAddItem(FileMenu,'~D~os shell',109,68,'Temporily exit to DOS',nil);
   PopUpAddItem(FileMenu,'E~x~it:Alt-X',110,88,'~Exit~ Turbo Pascal',nil);
end; { DefineFilePopUp }

procedure DefineOptionsPopUp;
{}
begin
   InitPopUp(OptionsMenu);
   PopUpAddItem(OptionsMenu,'~C~ompiler...',801,67,'Set default compiler directives and conditional defines',nil);
   PopUpAddItem(OptionsMenu,'~M~emory sizes...',802,77,'Set default stack and heap sizes for generated programs',nil);
   PopUpAddItem(OptionsMenu,'~L~inker...',803,76,'Set linker options (link buffer; .MAP file options)',nil);
   PopUpAddItem(OptionsMenu,'De~b~ugger...',804,66,'Set debugger options (standalone, integrated, display swapping)',nil);
   PopUpAddItem(OptionsMenu,'~D~irectories...',805,68,'Set paths for units, include files, OBJs, and generated files',nil);
   PopUpAddItem(OptionsMenu,'Bro~w~ser...',806,87,'Set global browser settings',nil);
   PopUpAddItem(OptionsMenu,'~T~ools...',807,84,'Create or change tools',nil);
   PopUpAddItem(OptionsMenu,'-',0,0,'',nil);
   PopUpAddItem(OptionsMenu,'~E~nvironment...',808,69,'Specify environment settings',nil);
   PopUpAddItem(OptionsMenu,'-',0,0,'',nil);
   PopUpAddItem(OptionsMenu,'~O~pen...',809,79,'Load options file previously created with Save Options',nil);
   PopUpAddItem(OptionsMenu,'~S~ave:\BP\BIN\BP.TP',810,83,'Save all the settings you''ve made in the Options menu',nil);
   PopUpAddItem(OptionsMenu,'Save ~a~s',811,65,'Save all the settings in the Options menu to another file',nil);
end; { DefineOptionsPopUp }

procedure DefineMainMenu;
{}
begin
   InitBar(MainMenu);
   BarAddItem(MainMenu,'~F~ile',100,70,289,'File management commands (open, new, etc).',@FileMenu);
   BarAddItem(MainMenu,'~O~ptions',800,79,280,'Set defaults for compiler, editor, mouse, debugger, etc.',@OptionsMenu);
   BarAddHK(MainMenu,317,102); {F3 - File Open}
   BarAddHK(MainMenu,316,103); {F2 - File Save}
   BarAddHK(MainMenu,301,110); {Alt-X - bug outta there}
end; { DefineMainMenu }

procedure SetScreen;
{Paints the background}
begin
   FBox(1,2,80,24,LightgrayOnBlue,1);
   ClearLine(1,BlackOnLightgray);
   ClearLine(25,BlackOnLightgray);
   WriteCenter(25,UseTint,'Copyright (c) 1995 TechnoJock Software, Inc.');
   WriteHi(5,5,YellowOnBlue,UseTint,'Press the ~/~ or ~F10~ keys to activate the menu, or');
   WriteHi(5,6,YellowOnBlue,UseTint,'click on the menu bar with the mouse. The menu can also');
   WriteHi(5,7,YellowOnBlue,UseTint,'be activated by pressing ~Alt-F~ or ~Alt-O~.');
   WriteHi(5,9,YellowOnBlue,UseTint,'You can also press the short-cut keys luke ~F2~ and ~F3~.');
   WriteHi(5,12,YellowOnBlue,UseTint,'To exit press ~Alt-X~, or select Exit from the file menu.');
end; {SetScreen}

procedure DisposeMenus;
{}
begin
   DestroyBar(MainMenu);
   DestroyPopUp(FileMenu);
   DestroyPopUp(OptionsMenu);
end; { DisposeMenus }

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   DefineFilePopUp;
   DefineOptionsPopUp;
   DefineMainMenu;
   SetScreen;
   DrawBar(MainMenu);
   MouseShow(true);
   CursorOff;
   repeat
      Choice := 0;
      GetInput;
      with KeyVars do
      begin
        if (LastKey = 47) {/} or (LastKey = 324) {F10} then
           Choice := ActivatePullMenu(mainmenu)
        else if IsPullKey(MainMenu, LastKey, LastX, LastY) then
           Choice := PullPushKey(MainMenu, LastKey, LastX, LastY);
        if (Choice <> 0) and (Choice <> 110) then
           PromptOK(' Gold ','You chose menu ID '+IntToStr(Choice));
      end;
   until Choice = 110; {the exit choice}
   MouseShow(false);
   DisposeMenus;
   ResetStartUpMode;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
