{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DemMen5.PAS
              Shows how to create nested menus using DisplayMenu.
}

program DEMMEN5;

uses CRT, DOS, GoldFast, GoldMenu, GoldAttr, GoldTint,
               GoldMisc, GoldKey, GoldWin, GoldStr;


var
  MM,M1: MenuRecord;
  SubChoice,
  Choice,
  Ecode: integer;

procedure SetScreen;
{}
begin
   Clear(WhiteOnBlue,chr(176));
   ClearLine(1,WhiteOnBlue);
   ClearLine(25,WhiteOnBlue);
   WriteCenter(1,LightgrayOnBlue,' Copyright (c) 1995 TechnoJock Software Inc. ');
end; {SetScreen}

Procedure DefineMenu1;
begin
   MenuSet(M1);
   with M1 do
   begin
      Heading1 := 'Main Menu';
      Topic[1] := 'File Tasks';
      Topic[2] := 'Edit';
      Topic[3] := 'Print';
      Topic[4] := 'Email';
      Topic[5] := 'Quit';
      TotalPicks := 5;
      PicksPerLine := 1;            {one column of choices}
      Addprefix := 1;               {add function key prefixes}
      TopleftXY[1] := 0;            {system will center menu}
      TopleftXY[2] := 5;            {Y coordinate}
      Boxtype := 5;                 {fancy box}
      AllowEsc := false;            {inactivate the escape key}
      Margins := 5;
   end;
end; {Define_Menu1}

Procedure DefineSubMenu;
begin
   MenuSet(MM);
   with MM do
   begin
      Heading1 := 'File Tasks';
      Topic[1] := 'Load';
      Topic[2] := 'Save';
      Topic[3] := 'Save As';
      Topic[4] := 'Close';
      Topic[5] := 'Return to main menu ';
      TotalPicks := 5;
      TopleftXY[1] := 40;            {Y coordinate}
      TopleftXY[2] := 9;            {Y coordinate}
      AddPrefix := 4;
      Boxtype := 5;                 {fancy box}
      AllowEsc := true;            {inactivate the escape key}
      Margins := 5;
   end;
end; {DefineSubMenu}

begin { main }
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   clrscr;
   SetScreen;
   DefineMenu1;
   DefineSubMenu;
   MouseShow(true);
   Choice := 1;
   SubChoice := 1;
   repeat
      DisplayMenu(M1,false,Choice,ECode);
      case Choice of
         1: begin
            repeat
               DisplayMenu(MM,true,SubChoice,ECode);
               if Ecode <> 0 then
                  SubChoice := 5;
               case SubChoice of
                 1: ;
                 2: ;
                 {etc.}
               end;
            until SubChoice = 5;
         end;
         2..4: PromptOK(' Selection ','You chose menu item '+IntToStr(Choice));
      end;
   until Choice = 5;
   MouseShow(false);
   clrscr;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end. { DEMMEN5 }
