{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{              Copyright 1986-1995  TechnoJock Software, Inc.              }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description:  DEMMEM5.PAS
               An desktop providing a text editor.
}

program DEMMEM5;

uses DOS, CRT,
     GoldFast, GoldWin, GoldMenu, GoldMisc, GoldDesk,
     GoldKey, GoldStr, GoldMemo, GoldDir, GoldLink, GoldHard;

type
   FileInfo = record
       Fname: string[127];
       Cfg: MemoCfg;
       FLines: DoubleLL;
       WinNum: byte;
   end; { FileInfo }

var
   MainMenu,
   StatusBar: Bar;
   WinMenu,
   SubMenu: PopUp;
   Action : dAction;
   FileList: SingleLL;

                          {**********************}
                          {**  Error Routines  **}
                          {**********************}

procedure DisplayError(ErrNum:longint);
{}
var Msg:StrScreen;
begin
   case ErrNum of
      1: Msg := 'Unable to load file for editing';
      2: Msg := 'Insufficient memory to complete operation';
      3: Msg := 'Unable to create edit window';
      4: Msg := 'The file is already in memory!';
      5: Msg := 'Problem saving the file';
      else
         Msg := 'Internal error';
   end;
   PromptOK(' Error ',Msg);
end; { DisplayError }

                          {*********************}
                          {**  Menu Routines  **}
                          {*********************}


{$F+}
procedure MenuHelp(ID:integer);
{}
begin
   PromptOK(' Help! ','You asked for help on menu item ID: '+IntToStr(ID));
end; { MenuHelp }
{$F-}

procedure DefineMenus;
{}
begin
   InitPopUp(SubMenu);
   PopUpAddItem(SubMenu,'~O~pen...:F3',102,79,'Locate and open in an Edit window',nil);
   PopUpAddItem(SubMenu,'~S~ave:F2',103,83,'Save the file in the active Edit window',nil);
   PopUpAddItem(SubMenu,'-',0,0,'',nil); {separator}
   PopUpAddItem(SubMenu,'~A~bout',900,65,'Show version and copyright information',nil);
   PopUpAddItem(SubMenu,'E~x~it',999,88,'~Exit~ this little demo',nil);
   InitPopUp(WinMenu);
   PopUpAddItem(WinMenu,'~T~ile',901,84,'Arrange windows on desktop by tiling',nil);
   PopUpAddItem(WinMenu,'C~a~scade',902,65,'Arrange windows on desktop by cascading',nil);
   PopUpAddItem(WinMenu,'Cl~o~se all',903,79,'Close all windows on the desktop',nil);
   PopUpAddItem(WinMenu,'~R~efresh display',904,82,'Redraw the screen',nil);
   PopUpAddItem(WinMenu,'-',0,0,'',nil);
   PopUpAddItem(WinMenu,'~M~ove:Ctrl+F5',905,83,'Change the size or position of the active window',nil);
   PopUpAddItem(WinMenu,'~S~tretch:',906,83,'Change the size or position of the active window',nil);
   PopUpAddItem(WinMenu,'~Z~oom:F5',907,90,'Enlarge or restore the size of the active window',nil);
   PopUpAddItem(WinMenu,'~N~ext:F6',908,78,'Make the next window active',nil);
   PopUpAddItem(WinMenu,'~P~revious:Shift+F6',909,80,'Make the previous window active',nil);
   PopUpAddItem(WinMenu,'~C~lose:Alt+F3',910,67,'Close the active window',nil);
   PopUpAddItem(WinMenu,'-',0,0,'',nil);
   PopUpAddItem(WinMenu,'~L~ist...:Alt+0',911,76,' Show a list of all open windows',nil);
   InitBar(MainMenu);
   BarAddItem(MainMenu,'~F~ile',100,70,289,'File Commands',@SubMenu);
   BarAddItem(MainMenu,'~W~indow',200,87,273,'Open, arrange and list windows',@WinMenu);
   BarAddHK(MainMenu,354,905); {Ctrl+F5 - Move}
   BarAddHK(MainMenu,364,906); {Alt+F5 - Stretch}
   BarAddHK(MainMenu,319,907); {F5 - Zoom}
   BarAddHK(MainMenu,320,908); {F6 - Next}
   BarAddHK(MainMenu,345,909); {Shift+F6 - Previous}
   BarAddHK(MainMenu,342,910); {Alt+F3 - Close}
   BarAddHK(MainMenu,385,911); {Alt+0 - List}
   BarAddHK(MainMenu,316,103); {F2 - Save}
   BarAddHK(MainMenu,317,102); {F3 - Open}
   MainMenu.Style := 2;
   AssignMenuHelpHook(MainMenu,MenuHelp);
end; { DefineMenus }

procedure DefineStatusBar;
{}
begin
   InitBar(StatusBar);
   BarAddItem(StatusBar,'~F1~ Help',1001,315,315,'',nil);
   BarAddItem(StatusBar,'~Alt+X~ Exit the demo',999,301,301,'',nil);
end; { DefineStatusBar }

procedure DisposeMenus;
{}
begin
   DestroyBar(MainMenu);
   DestroyPopUp(SubMenu);
   DestroyPopUp(WinMenu);
   DestroyBar(StatusBar);
end; { DisposeMenus }

                        {**************************}
                        {**  MemoCfg Management  **}
                        {**************************}
procedure InitFileList;
{}
begin
   InitSLL(Filelist);
   SLLSetActiveList(FileList);
end; { InitFileList }

procedure SaveFile(Handle:integer);
{}
var
   SNP: SingleNodePtr;
begin
   SLLSetActiveList(FileList);
   SNP := SLLNodePtr(1);
   while (SNP <> nil) and (FileInfo(SNP^.DataPtr^).WinNum <> Handle) do
      SNP := SNP^.NextPtr;
   if SNP <> nil then
   begin
      DLLSetActiveList(FileInfo(SNP^.DataPtr^).FLines);
      MemoStoreActiveLine(FileInfo(SNP^.DataPtr^).CFG);
      if DLLSaveToFile(FileInfo(SNP^.DataPtr^).Fname) <> 0 then
         DisplayError(5)
      else
         MemoSetDirty(FileInfo(SNP^.DataPtr^).CFG,false);
   end;
end; {SaveFile}

function CloseFile(Handle:integer):boolean;
{Returns false if the user cancelled}
var
   SNP: SingleNodePtr;
   Choice: integer;
begin
   SLLSetActiveList(FileList);
   SNP := SLLNodePtr(1);
   while (SNP <> nil) and (FileInfo(SNP^.DataPtr^).WinNum <> Handle) do
      SNP := SNP^.NextPtr;
   if SNP <> nil then
   begin
      DLLSetActiveList(FileInfo(SNP^.DataPtr^).FLines);
      if MemoIsDirty(FileInfo(SNP^.DataPtr^).CFG) then
      begin
         Choice :=  PromptCustom(' Information ',FileInfo(SNP^.DataPtr^).Fname+' has been modified.|Save?',
                         '   ~Y~es   ','   ~N~o   ',' ~C~ancel ',277,305,302,1,0);
         if Choice = 1 then
         begin
            MemoStoreActiveLine(FileInfo(SNP^.DataPtr^).CFG);
            if DLLSaveToFile(FileInfo(SNP^.DataPtr^).Fname) <> 0 then
               DisplayError(5)
         end
         else if Choice = 3 then
         begin
            CloseFile := false;
            exit;
         end;
      end;
      CloseFile := true;
      DLLDestroy;
      SLLDelNode(SNP);
   end;
end; { CloseFile }

procedure CloseFileList;
{}
var
   SNP: SingleNodePtr;
begin
   SLLSetActiveList(FileList);
   repeat
      SNP := SLLNodePtr(1);
      if SNP <> nil then
         if not CloseFile(FileInfo(SNP^.DataPtr^).WinNum) then
            exit;
   until SNP = nil;
   SLLDestroy;
end; { CloseFileList }

                      {******************************}
                      {**  Window Close Procedure  **}
                      {******************************}

{$F+}
function CloseEditWin(MemoDetailsPtr:MemoCfgPtr; Handle:integer):boolean;
{}
begin
   CloseEditWin :=  CloseFile(Handle);
end; { CloseEditWin }
{$F-}

                          {*********************}
                          {**  File Routines  **}
                          {*********************}

function FileInMemory(var NewFile: string): boolean;
{}
var
  I: integer;
  SNP: SingleNodePtr;
begin
   if NewFile = '' then
      FileInMemory := true
   else
   begin
      SLLSetActiveList(FileList);
      SNP := SLLNodePtr(1);
      while SNP <> nil do
      begin
         if FileInfo(SNP^.DataPtr^).Fname = NewFile then
         begin
            FileInMemory := true;
            DisplayError(4);
            exit;
         end;
         SNP := SNP^.NextPtr;
      end;
      FileInMemory := false;
   end;
end; { FileInMemory }

procedure LoadAFile;
{}
var
  NewFile: string;
  TempInfo: FileInfo;
  SNP: SingleNodePtr;
begin
   NewFile :=  FExpand(PromptFile('*.pas *.inc *.txt'));
   if not FileInMemory(NewFile) then
   begin
      SLLSetActiveList(FileList);
      if SLLAdd(TempInfo,sizeof(TempInfo)) <> 0 then
         DisplayError(2)
      else
      begin
         SNP := FileList.EndNodePtr;
         with FileInfo(SNP^.DataPtr^) do
         begin
            FName := NewFile;
            InitDLLStr(FLines);
            DLLSetActiveList(FLines);
            if DLLLoadFromFile(NewFile) <> 0 then {file not found or not loaded}
            begin
               DLLDestroy;
               SLLDelNode(SNP);
               DisplayError(1);
            end
            else
            begin
               InitMemoCfg(CFG);
               MemoAssignDLL(CFG,FLines);
               MemoSetWordWrap(CFG,false);
               with MemoVars do  {set the position and dimensions of the new window}
               begin
                  DeskNextWinCoords(WX1,WY1);
                  WX2 := HardVars.Width;
                  WY2 := HardVars.Depth - BBBot;
               end;
               WinNum := LaunchMemo(CFG,NewFile,CloseEditWin);
               if WinNum = 0 then
               begin
                  DLLDestroy;
                  SLLDelNode(SNP);
                  DisplayError(1);
               end;
            end;
         end;
      end;
   end;
end; { LoadAFile }

                        {**************************}
                        {**  Desktop Management  **}
                        {**************************}

{$F+}
procedure MyActionProc(Choice:integer;var Action:DAction);
{}
begin
   case Choice of
     102: LoadAFile;
     103: SaveFile(WinWithFocus);
     {Window options}
     901: if not DeskTile then
        PromptOK(' Message ','Unable to tile the windows');
     902: DeskCascade;
     903: if not DeskCloseAllWindows then
        PromptOK(' Message ','Unable to close all windows');
     904: DeskRefresh;
     905:  if not DeskMoveTopWin then
        PromptOK(' Message ','The top window cannot be moved');
     906:  if not DeskStretchTopWin then
        PromptOK(' Message ','The top window cannot be stretched');
     907:  if not DeskZoomTopWin then
        PromptOK(' Message ','The top window cannot be zoomed');
     908: DeskNextWin;
     909: DeskPrevWin;
     910: Action := DCloseTop;
     911: DeskWinList;
     {help and quit}
     900: PromptOK(' Editor Demo ','^Copyright 1995 TechnoJock Software, Inc.|'+
                     '^All Rights Reserved');
     1001: PromptOK(' Tools Help ','^Honey if you need help, we got problems!');
     999: Action := DFinished;
   end;
end; { MyActionProc }
{$F-}

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   DefineMenus;
   DefineStatusBar;
   DeskAssignMainMenu(MainMenu);
   DeskAssignActionProc(MyActionProc);
   DeskAssignStatusBar(Statusbar);
   MouseShow(true);
   CursorOff;
   InitFileList;
   Action := DeskProcessInput;
   CloseFileList;
   MouseShow(false);
   DisposeMenus;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end. { DEMMEM5 }
