{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMMEM4.PAS
              Shows how the RunMemo function can be
              used to edit a string array
}

program DemMem4;

{$I GOLDFLAG.INC}

uses CRT, GoldAttr, GoldFast, GoldMisc, GoldLink, GoldKey, GoldWin, GoldMemo;

const
  MaxLines = 10;
  LineLength = 80;

var
  TextData: array [1..Maxlines] of string[LineLength];
  MemoSettings: MemoCFG;

procedure SetScreen;
{}
begin
   Clear(WhiteOnBlack,'');
   ClearLine(1,RedOnLightgray);
   WriteCenter(1,UseTInt,'TTT Gold');
   ClearLine(25,BlackOnLightgray);
   WritePlain(8,25,'');
end; { SetScreen }

procedure BuildArray;
{}
begin
   fillchar(TextData,sizeof(TextData),#0);
   TextData[1] := 'Turbo Pascal with Objects 7.0 is the highest productivity professional';
   TextData[2] := 'programming system for DOS, DOS protected mode (DPMI), and Windows';
   TextData[3] := 'development.Features DOS, Windows IDEs; new ObjectBrowsers; object-oriented';
   TextData[4] := 'application frameworks; world''s fastest compiler. Exclusive ability to';
   TextData[5] := 'create DOS, Windows Dynamic Link Libraries (DLLs) so code can be shared';
   TextData[6] := 'across platforms.Better still, the entire product is fully compatible';
   TextData[7] := 'with the award-winning TechnoJock''s Turbo Toolkit!';
end; {BuildArray}

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   SetScreen;
   BuildArray;
   InitMemoCfg(MemoSettings);
   MemoAssignArray(MemoSettings,TextData,LineLength,MaxLines);
   MouseShow(true);
   RunMemo(MemoSettings,' Editing Arrays ');
   MouseShow(false);
   ResetStartUpMode;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
