{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMMEM1.PAS
              Shows how the RunMemo function can be used to provide a
              fully functional word wrapping memo editor.
}

program DemMen1;

{$I GOLDFLAG.INC}

uses CRT, GoldAttr, GoldFast, GoldMisc, GoldLink, GoldKey, GoldWin, GoldMemo;

var
  TextData: SingleLL;
  MemoSettings: MemoCFG;
  Heading: string;

procedure SetScreen;
{}
begin
   Clear(WhiteOnBlack,'');
   ClearLine(1,RedOnLightgray);
   WriteCenter(1,UseTint,'TTT Gold');
   ClearLine(25,BlackOnLightgray);
   WritePlain(8,25,'');
end; { SetScreen }

procedure BuildSLL;
{}
var I: integer;
begin
   InitSLLStr(TextData);
   I := 0;
   SLLSetActiveList(TextData);
   inc(I,SLLAddStr('Turbo Pascal with Objects 7.0 is the highest productivity professional'));
   inc(I,SLLAddStr('programming system for DOS, DOS protected mode (DPMI), and Windows'));
   inc(I,SLLAddStr('development.Features DOS, Windows IDEs; new ObjectBrowsers; object-oriented'));
   inc(I,SLLAddStr('application frameworks; world''s fastest compiler. Exclusive ability to' ));
   inc(I,SLLAddStr('create DOS, Windows Dynamic Link Libraries (DLLs) so code can be shared'));
   inc(I,SLLAddStr('across platforms.Better still, the entire product is fully compatible'));
   inc(I,SLLAddStr('with the award-winning TechnoJock''s Turbo Toolkit!'));
   if I <> 0 then
   begin
      PromptOK(' ERROR ','Not enough memory to execute program!');
      halt;
   end;
end; {BuildSLL}

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   SetScreen;
   BuildSLL;
   MouseShow(true);
   InitMemoCfg(MemoSettings);
   MemoAssignSLL(MemoSettings,TextData);
   Heading := '^Way Cool';
   MemoAssignHeader(MemoSettings,1,Heading);
   MemoSetGaps(MemoSettings,1,1,1,1);
   RunMemo(MemoSettings,' A Word Wrapping Window, Wow! ');
   MouseShow(false);
   SLLSetActiveList(TextData);
   SLLDestroy;
   ResetStartUpMode;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
