{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMLS4.PAS
              Illustrates how to enable list tagging, and
              then process each tagged item. The example uses
              a list of files
}

program DEMLS4;

uses   DOS,CRT,
       GoldMisc, GoldLInk, GoldList, GoldKey,
       GoldWin, GoldFast, GoldAttr, GoldStr;

var
   Properties: ListCfg;
   Files: DoubleLL;
   I,Counter,
   RetCode: integer;

const
   DemoMask: string[12] = '*.*';

function BuildTheList: boolean;
{Reads all the files matching DemoMask and returns true if there
 is at least one entry in the list}
var
   SrchRec: SearchRec;
begin
   InitDLLStr(Files);
   DLLSetActiveList(Files);
   findfirst(DemoMask,Anyfile - Hidden - Directory - SysFile - VolumeID,SrchRec);
   while DosError = 0 do
   begin
      if (SrchRec.Attr and Directory <> Directory) then
      begin
         Retcode := DLLAddStr(SrchRec.Name);
         if (Retcode <> 0) then
         begin
            BuildTheList := false;
            exit;
         end;
      end;
      findnext(SrchRec);
   end;
   DLLSort(0,true);
end; { BuildTheList }

procedure SetScreen;
{Paints the background}
begin
   Clear(WhiteOnBlack,'');
   ClearLine(1,YellowOnBlue);
   WriteCenter(1,UseTint,' A Simple List Window ');
   ClearLine(25,YellowOnBlue);
   WriteHiCenter(25,YellowOnBlue,LightgrayOnBlue,'~T~ tag  ~U~ untag  ~SPACE~ toggle  ~Alt-T~ tag all'+
                                             '  ~Alt-U~ untag all, or use mouse');
   GotoXY(1,1);
end; {SetScreen}

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   SetScreen;
   if not BuildTheList then
      PromptOK(' Error ','Unable to build the list')
   else
   begin
      InitListCfg(Properties);
      ListAssignDLL(Properties,Files);
      ListSetColWidth(Properties,15);
      ListSetWin(Properties, 5,3,75,23,1);
      ListSetTagging(Properties, true);
      MouseShow(true);
      CursorOff;
      RunList(Properties,' Tag some files! ');
      MouseShow(false);
      {now list the selected files}
      ResetStartUpMode;
      clear(YellowOnBlue,' ');
      Writeln('You tagged the following files:');
      Counter := 0;
      for I := 1 to Properties.TotalNodes do
      begin
         if DLLGetBit(DLLNodePtr(I),TagBit) then
         begin
            writeln(DLLGetStr(I));
            inc(Counter);
         end;
         if (Counter <> 0) and (Counter mod 24 = 0) then
         begin
            write('Press any key...');
            GetInput;
            writeln;
            Clear(YellowOnBlue,' ');
         end;
      end;
   end;
   DLLSetActiveList(Files);
   DLLDestroy;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end. { DEMLS4 }
