{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMLS3.PAS
              An extension of DEMLS2.PAS which shows hwo to customize
              the colors of a single List window.
}

program DEMLS3;

uses   DOS,CRT,
       GoldMisc, GoldLink, GoldList, GoldKey,
       GoldWin, GoldFast, GoldAttr, GoldStr, GoldTint;

var
   Properties: ListCfg;
   GirlFriends: SingleLL;
   RetCode: integer;


procedure BuildTheList;
{}
begin
   InitSLLStr(GirlFriends);
   SLLSetActiveList(GirlFriends);
   Retcode := SLLAddStr('Erica');
   inc(Retcode,SLLAddStr('Theresa'));
   inc(Retcode,SLLAddStr('Lynn'));
   inc(Retcode,SLLAddStr('Donna'));
   inc(Retcode,SLLAddStr('Godzilla'));
end; { BuildTheList }

procedure SetScreen;
{Paints the background}
begin
   Clear(WhiteOnBlack,'');
   ClearLine(1,YellowOnBlue);
   WriteCenter(1,UseTint,' A Simple List Window ');
   GotoXY(1,1);
end; {SetScreen}

procedure CustomizeColors;
{}
begin
   ListSetColor(Properties,ListHi1,BlackonGreen);
   ListSetColor(Properties,ListHi2,YellowOnGreen);
   ListSetColor(Properties,ListNorm1,YellowOnMagenta);
   ListSetColor(Properties,ListNorm2,WhiteOnMagenta);
   ListSetColor(Properties,ListMarkers,LightgrayonMagenta);
   ListSetColor(Properties,ListScrollbarHi,WhiteOnMagenta);
   ListSetColor(Properties,ListScrollbarNorm,WhiteOnMagenta);
   ListSetColor(Properties,ListBorder1,YellowOnMagenta);
   ListSetColor(Properties,ListBorder2,YellowOnMagenta);
   ListSetColor(Properties,ListBorderOff,BlackOnMagenta);
   ListSetColor(Properties,ListTitle,WhiteOnMagenta);
   ListSetColor(Properties,ListHeaders,GreenOnMagenta);
   ListSetColor(Properties,ListIcons,LightCyanOnMagenta);
end; { CustomizeColors }

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   BuildTheList;
   SetScreen;
   if RetCode <> 0 then
      PromptOK(' Error ','Unable to build the list')
   else
   begin
      InitListCfg(Properties);
      ListAssignSLL(Properties,Girlfriends);
      ListSetWin(Properties,25,5,55,11,1);
      CustomizeColors;
      MouseShow(true);
      CursorOff;
      RunList(Properties,' My first list! ');
      MouseShow(false);
   end;
   SLLSetActiveList(GirlFriends);
   SLLDestroy;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end. { DEMLS3 }
