{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMLS1.PAS
              A "minimal" example showing how to display a list
              window.
}

program DEMLS1;

uses   DOS,CRT,
       GoldMisc, GoldLInk, GoldList, GoldKey,
       GoldWin, GoldFast, GoldAttr, GoldStr;

var
   Properties: ListCfg;
   GirlFriends: SingleLL;
   RetCode: integer;


procedure BuildTheList;
{}
begin
   InitSLLStr(GirlFriends);
   SLLSetActiveList(GirlFriends);
   Retcode := SLLAddStr('Erica');
   inc(Retcode,SLLAddStr('Theresa'));
   inc(Retcode,SLLAddStr('Lynn'));
   inc(Retcode,SLLAddStr('Donna'));
   inc(Retcode,SLLAddStr('Godzilla'));
end; { BuildTheList }

procedure SetScreen;
{Paints the background}
begin
   Clear(WhiteOnBlack,'');
   ClearLine(1,YellowOnBlue);
   WriteCenter(1,UseTint,' A Simple List Window ');
   GotoXY(1,1);
end; {SetScreen}

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   BuildTheList;
   SetScreen;
   if RetCode <> 0 then
      PromptOK(' Error ','Unable to build the list')
   else
   begin
      InitListCfg(Properties);
      ListAssignSLL(Properties,Girlfriends);
      MouseShow(true);
      RunList(Properties,' My first list! ');
      MouseShow(false);
   end;
   SLLSetActiveList(GirlFriends);
   SLlDestroy;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end. { DEMLS1 }
