{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMKY5.PAS
              Illustrates how to use a character hook to update the display
              while waiting for input. Also, shows how to use the
               StuffBuffer routines to add  macros to a program
}

program DEMKY5;

{$I GOLDFLAG.INC}

uses CRT, GoldAttr, GoldStr, GoldKey, GoldFast, GoldMisc, GoldDate;

{$F+}
procedure ClockHook;
{}
begin
   SetWinIgnore(true);
   if KeyGetCaps then
      WritePlain(40,24,'CAPS')
   else
      WritePlain(40,24,'    ');
   if KeyGetNum then
      WritePlain(45,24,'NUM')
   else
      WritePlain(45,24,'   ');
   if KeyGetScroll then
      WritePlain(50,24,'SCROLL')
   else
      WritePlain(50,24,'      ');
   if KeyPressed then
   begin
      SetWinIgnore(false);
      exit;
   end;
   if KeyAltPressed then
      WritePlain(60,24,'Alt')
   else
      WritePlain(60,24,'   ');
   if KeyCtrlPressed then
      WritePlain(65,24,'Ctrl')
   else
      WritePlain(65,24,'    ');
   if KeyLeftShiftPressed then
      WritePlain(70,24,'L-')
   else
      WritePlain(70,24,'   ');
   if KeyRightShiftPressed then
      WritePlain(75,24,'R-')
   else
      WritePlain(75,24,'   ');
   if KeyPressed then 
   begin
      SetWinIgnore(false);
      exit;
   end;
   WritePlain(1,24,Time);
   SetWinIgnore(false);
end; {ClockHook}

procedure MacroHook(var W:word;var X,Y:byte);
{}
begin
   case W of
      286: begin
              KeyStuffBufferStr(' Apple '); {Alt-A}
              W := 0;
           end;
      304: begin
              KeyStuffbufferStr(' Bravo '); {Alt-B}
              W := 0;
           end;
      301: begin
              KeyStuffBuffer(27);           {Alt-X}
              W := 0;
           end;
      315: begin
              KeyStuffbufferStr(' No help! '); {F1}
              W := 0;
           end;
   end; {case}
end; {MacroHook}
{$F-}

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   Clear(YellowOnBlue,' ');
   PartClear(1,23,80,25,YellowOnMagenta,' ');
   WritePlain(5,1,'Press any alpha characters, or Alt-A,B for macros. Esc or Alt-X to quit');
   GotoXY(1,3);
   KeySetCaps(true);
   KeySetNum(true);
   KeySetScroll(true);
   AssignIdleHook(ClockHook);
   AssignPressedHook(MacroHook);
   repeat
       GetInput;
       if Isletter(KeyVars.Lastkey) then
          Write(char(KeyVars.LastKey));
   until KeyVars.LastKey = 27;
   KeySetCaps(false);
   KeySetNum(false);
   KeySetScroll(false);
   clrscr;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
