{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMKY3.PAS
              Illustrates how to access the Num, Scroll and
              Caps lock keys using GoldKey.
}

program DEMKY3;

{$I GOLDFLAG.INC}

uses CRT, GoldMisc, GoldAttr, GoldKey, GoldFast;

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   FillScreen(1,1,80,22,WhiteOnBlue,' ');
   FillScreen(1,23,80,25,YellowOnMagenta,' ');
   WritePlain(10,5,'Press Num, Scroll, Caps Lock, or hold down the Alt,');
   WritePlain(10,6,'Ctrl, Left/Right Shift keys. The active keys will be');
   WritePlain(10,7,'displayed at the foot of the display.');
   WritePlain(10,9,'Any other key quits.');
   KeySetCaps(true);
   KeySetNum(true);
   KeySetScroll(true);
   repeat
      if KeyGetCaps then
         WritePlain(40,24,'CAPS')
      else
         WritePlain(40,24,'    ');
      if KeyGetNum then
         WritePlain(45,24,'NUM')
      else
         WritePlain(45,24,'   ');
      if KeyGetScroll then
         WritePlain(50,24,'SCROLL')
      else
         WritePlain(50,24,'      ');
      if KeyAltPressed then
         WritePlain(60,24,'Alt')
      else
         WritePlain(60,24,'   ');
      if KeyCtrlPressed then
         WritePlain(65,24,'Ctrl')
      else
         WritePlain(65,24,'    ');
      if KeyLeftShiftPressed then
         WritePlain(70,24,'L-')
      else
         WritePlain(70,24,'   ');
      if KeyRightShiftPressed then
         WritePlain(75,24,'R-')
      else
         WritePlain(75,24,'   ');
   until KeyPressed;
   KeySetCaps(false);
   KeySetNum(false);
   KeySetScroll(false);
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
