{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMIO2.PAS
              Shows how to spruce up DEMIO1 with messages, labels,
              default values, a default push button, etc.
}

Program DemoIOTwo;

{$I GOLDFLAG.INC}

uses CRT, GoldAttr, GoldFast, GoldCal, GoldDate, GoldMisc, GoldKey, GoldIO,
          GoldIO2, GoldStr;

var
  Name,Tel:string;
  Age:byte;
  Sex: string[1];

procedure SetScreen;
{}
begin
   Clear(WhiteOnCyan,'');
   ClearLine(1,WhiteOnBlue);
   WriteCenter(1,UseTint,'An Improved version of DEMIO1');
   WriteAt(1,2,BlueOnRed,replicate(80,''));
   WriteAT(70,2,WhiteOnBlack,'TTT Gold!');
   Box3d(5,5,75,22,WhiteOnLightGray,BlackOnLightgray,1);
   Box3d(10,18,70,20,BlackOnCyan,LightCyanOnCyan,1);
   ClearLine(25,YellowOnBlue);
end; { SetScreen }

procedure SetVars;
{Sets the default values for the fields}
begin
   Name := 'Jack Palance';
   Tel := '8776542';
   Age  := 41;
   Sex := 'M';
end; { SetVars }

procedure SetFields;
{Defines the form by postioning the fields, linking the fields to
 variables, and adding labels, hotkeys and messages}
begin
   {create the 5 fields}
   KwikAddField(1, 25,8);      {Field 1, column 25, line 5}
   KwikAddField(2, 30,10);     {Field 2, column 25, line 9}
   KwikAddField(3, 35,12);     {Field 3, column 25, line 9}
   KwikAddField(4, 48,12);     {Field 4, column 25, line 11}
   KwikAddField(5, 26,15);     {Field 5, column 25, line 14}
   KwikAddLastField(6, 43,15); {Field 6, column 43, line 14}
   {now define the individual field properties}
   {Field 1}
   StringField(1, Name, '******************************'); {Field 1, use variable Name, accept any 30 characters}
   SetLabel(1, LabelLeft,LabelLeft,'Full ~n~ame:');
   SetMessage(1, 0,0,'Enter the full name using the format "First I. Last"');
   SetHK(1,305); {alt-N}
   {Field 2}
   StringField(2, Tel, '(###) ###-####'); {Field 2, use a format mask to define tel. field}
   FieldRules(2,EraseDefault+rightjustify,[#0],[#0]); {set input to right justify}
   SetLabel(2, LabelLeft,LabelLeft,'~T~el:');
   SetMessage(2, 0,0,'Enter the telephone number, including area code');
   SetHK(2,276); {alt-T}
   {Field 3}
   ByteField(3, Age, '##', 13,65);  {two digit number in the range 13 to 65}
   SetLabel(3, LabelLeft,LabelLeft,'Patients ~a~ge:');
   SetHK(3,286); {alt-A}
   SetMessage(3, 0,0,'Enter the person''s age in the range 13 to 65');
   {Field 4}
   StringField(4, Sex, '!');  {single character field; force input to uppercase}
   SetLabel(4, LabelLeft,LabelLeft,'~S~ex:');
   SetMessage(4, 0,0,'Enter gender: "F" for female or "M" for male');
   SetHK(4,287); {alt-S}
   {Fields 4 & 5: buttons}
   ButtonDefaultField(5,'   ~O~K   ',finished);
   SetHK(5,280); {alt-O}
   SetMessage(5, 0,0,'Press Enter to save the changes and edits');
   ButtonField(6,' ~C~ancel ',escaped);
   SetMessage(6, 0,0,'Press Enter to abort the changes and edits');
   SetHK(6,302); {alt-C}
   {Set the default location of all the messages}
   SetMessageXY(0,19,true);  {centered on line 18}
end; { SetFields }

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   SetScreen;
   SetVars;
   SetFields;
   {by default each field is checked as the user tries to move from one field
    to the next -- the following line instructs TTT to check it when OK is pressed}
   SetValidation(ValidateAtEnd);
   MouseShow(true);
   ProcessInput(1);
   GotoXY(1,25);
   writeln;
   if FormExitAction = Finished then
   begin
      writeln('Name: ',Name);
      writeln('Tel:  ',PicFormat(Tel,'(###) ###-####',' ',true));
      writeln('Age:  ',Age);
      write('Sex:  ',Sex);
   end
   else
     write('You cancelled!');
   DelayKey(5000);
   DisposeFields;
   DisposeForms;
   MouseShow(false);
   Clear(LightGrayOnBlack,' ');
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
