{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMIO12.PAS
              Uses an IO form in a window to create a grid-style pick-list.
}

program DEMIO12;

{$I GOLDFLAG.INC}

uses  DOS, CRT, GoldAttr, GoldHard, GoldFast, GoldWin, GoldIO, GoldIO2,
                GoldLink, GoldStr, GoldKey, GoldMisc, GoldList, GoldGrid;

var
   SourceList: SingleLL;
   ListProperties: ListCfg;
   TabsString,
   GridHeading: string;
   TabStops: array[1..5] of integer;

procedure SetScreen;
{Paints the background}
begin
   Clear(WhiteOnLightGray,'');
   ClearLine(1,YellowOnBlue);
   ClearLine(25,LightgrayOnBlue);
   WriteCenter(25,UseTint,' Copyright (c) 1995 TechnoJock Software Inc. ');
   WriteCenter(1,UseTint,' A Grid Window ');
end; {SetScreen}

procedure ShutDown;
{}
begin
   PromptOK(' ERROR! ','Not enough memory to run program!');
   halt;
end; { ShutDown }


procedure FillTheList;
{}
var I: integer;
begin
   I := 0;
   InitSLLStr(SourceList);
   SLLSetActiveList(SourceList);
   inc(I,SLLAddStr('R D Smith        22202 Chevy Chase    Maryland      WI  23233'));
   inc(I,SLLAddStr('M J Dooley       1123 Queens Blvd     Madison       WI  23278'));
   inc(I,SLLAddStr('E L G Jognson    12623 Ashford Hills  Houston       TX  77079'));
   inc(I,SLLAddStr('P R Group        4585 The Grille #21  Bose          HI  90991'));
   inc(I,SLLAddStr('Mark Norman      34 The Ridgeway      Delaware      OR  33789'));
   inc(I,SLLAddStr('Jennifer Worth   22 The Circle        Illinois      RI  22445'));
   inc(I,SLLAddStr('Susan Jones      52242 #12 South Road Fort Bender   MA  26889'));
   inc(I,SLLAddStr('J T Ainsworth    164 Dunvale Lanee    Texas         TX  77023'));
   inc(I,SLLAddStr('Geoff Range      18 Meadow Wood       Washington    WA  67833'));
   inc(I,SLLAddStr('Joey Doolittle   229 Oak Drive        San Francisco CA  21345'));
   inc(I,SLLAddStr('Sally Weathers   79 Anchors Road      Kennebunport  MA  66720'));
   inc(I,SLLAddStr('G N Greene       816a Hwy 68 South    Portland      OR  23763'));
   if I <> 0 then
      Shutdown;
   Gridheading := 'Name             Street               City          ST  Zip';
   TabStops[1] := 1;
   TabStops[2] := 18;
   TabStops[3] := 39;
   TabStops[4] := 53;
   TabStops[5] := 57;
end; {FillTheList}

procedure SetFields;
{}
var I : Integer;
begin
   CreateForms(1);
   ActivateForm(1);
   AllowEsc(true);
   {Add all the fields}
   SetFormWindow(15,6,65,19,1);
   WinSetTitle(FormWinNum,' Tag one or more names ');
   WinSetType(FormWinNum,WMove);
   WinSetShowNum(FormWinNum,false);
   KwikAddField(1, 2,2);
   KwikAddField(2,13,11);
   KwikAddLastField(3, 30,11);
   {The List}
   FillTheList;
   InitListCfg(ListProperties);
   ListSetTagging(ListProperties,true);
   ListAssignSLL(ListProperties,SourceList);
   GridAssignTabs(ListProperties,@TabStops,5);
   GridListField(1,47,8,ListProperties);
   {Buttons}
   ButtonDefaultField(2,'   ~O~K   ',finished);  {OK selected if user presses Enter}
   ButtonField(3,' C~a~ncel ',escaped);
   SetHK(2,280);
   SetHK(3,286);
end; {SetFields}

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   SetScreen;
   SetFields;
   MouseShow(true);
   ProcessInput(1);
   DisposeFields;
   DisposeForms;
   SLLSetActiveList(SourceList);
   SLLDestroy;               {dispose of the list 'cos IO won't do it!}
   MouseShow(false);
   Clear(LightGrayOnBlack,' ');
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
