{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMGRD4.PAS
              A variation of DEMGRD3 which uses a selection hook to
              provide record editing functions. Is a cool.
}

program DemGrd4;

{$I GOLDFLAG.INC}

uses CRT, DOS, GoldDb, GoldFast, GoldWin, GoldTint, GoldAttr,
     GoldStr, Goldio, Goldio2, Goldio3, GoldDate, GoldMisc, GoldGrid,
     GoldKey, GoldLink, GoldList;

const FN = 'DEMCUST.DBF';

type
     UserRecord = record
       ENTERED: Dates;
       CLIENT: string[30];
       ADDR1: string[30];
       ADDR2: string[30];
       CITY: string[22];
       STATE: string[2];
       ZIP: string[9];
       COUNTRY: string[20];
       PHONE: string[10];
       UNITS: longint;
     end;

const
   ColumnSep:char = '';
   ColumnEnd:char = '';

var
   GridLayout: ListCfg;
   TabStops: array[1..10] of integer;
   GridHeading: string;
   Win1,Ecode: integer;
   UserRec: UserRecord;

procedure SetScreen;
{}
begin
   Clear(WhiteOnBlack,'');
   ClearLine(1,WhiteOnBlue);
   WriteCenter(1,WhiteOnBlue,' Listing a database ');
   WriteAT(68,1,YellowOnBlack,' TTT Gold! ');
   ClearLine(25,YellowonBlue);
   WriteHiCenter(25,YellowOnBlue,WhiteOnBlue,'~Double Click~ or press ~Enter~ to edit a record');
end; { SetScreen }

                      {******************************}
                      {**  Custom String Provider  **}
                      {******************************}

{$F+}
function GetStrfromDB(P:pointer; Element,Start,Finish: longint): string;
{}
var
   RecNo: longint;
   FullLen: integer;
   WorkStr: string;
begin
   RecNo := NdxGetRecNum(Element);
   FullLen := 1;
   WorkStr := '';
   repeat
      case FullLen of
         1: begin  {date field}
            if FullLen >= Start then
               WorkStr := JulToStr(DbGetFldDate(RecNo,1),DDMMYY)+ColumnSep;
            FullLen := 10;
         end;
         10: begin {client field}
            if FullLen >= Start then
               WorkStr := WorkStr+Padleft(DbgetFldString(RecNo,2),30,' ')+ColumnSep;
            FullLen := 41;
         end;
         41: begin {Addr1 field}
            if FullLen >= Start then
               WorkStr := WorkStr+Padleft(DbgetFldString(RecNo,3),30,' ')+ColumnSep;
            FullLen := 72;
         end;
         72: begin {Addr2 field}
            if FullLen >= Start then
               WorkStr := WorkStr+Padleft(DbgetFldString(RecNo,4),30,' ')+ColumnSep;
            FullLen := 103;
         end;
         103: begin {City field}
            if FullLen >= Start then
               WorkStr := WorkStr+Padleft(DbgetFldString(RecNo,5),23,' ')+ColumnSep;
            FullLen := 127;
         end;
         127: begin {ST field}
            if FullLen >= Start then
               WorkStr := WorkStr+Padleft(DbgetFldString(RecNo,6),2,' ')+ColumnSep;
            FullLen := 130;
         end;
         130: begin {Zip Field}
            if FullLen >= Start then
               WorkStr := WorkStr+Padleft(DbgetFldString(RecNo,7),9,' ')+ColumnSep;
            FullLen := 140;
         end;
         140: begin {Country field}
            if FullLen >= Start then
               WorkStr := WorkStr+Padleft(DbgetFldString(RecNo,8),20,' ')+ColumnSep;
            FullLen := 161;
         end;
         161: begin {Phone field}
            if FullLen >= Start then
               WorkStr := WorkStr+PicFormat(DbgetFldString(RecNo,9),'(###) ###-####',' ',true)+ColumnSep;
            FullLen := 176;
         end;
         176: begin {Units field}
            if FullLen >= Start then
               WorkStr := WorkStr+Padleft(IntToStr(DbgetFldLong(RecNo,10)),8,' ')+ColumnEnd;
            FullLen := Finish;
         end;
      end; {case}
   until (FullLen >= Finish);
   GetStrfromDB := padleft(WorkStr,succ(Finish-Start),' ');
end; { GetStrfromDB }
{$F-}


                     {********************************}
                     {**  Record Editing Functions  **}
                     {********************************}
procedure DatabaseToScreen(RecNo:longint);
{}
begin
   with UserRec do
   begin
      Entered := DbGetFldDate(RecNo,1);
      Client := DbGetFldString(RecNo,2);
      Addr1 := DbGetFldString(RecNo,3);
      Addr2 := DbGetFldString(RecNo,4);
      City := DbGetFldString(RecNo,5);
      State := DbGetFldString(RecNo,6);
      Zip := DbGetFldString(RecNo,7);
      Country := DbGetFldString(RecNo,8);
      Phone := DbGetFldString(RecNo,9);
      Units := DbGetFldLong(RecNo,10);
   end;
end; { DatabaseToScreen }

procedure ScreenToDatabase;
{}
begin
   with UserRec do
   begin
      DbSetFldDate(1,Entered);
      DbSetFldString(2,Client);
      DbSetFldString(3,Addr1);
      DbSetFldString(4,Addr2);
      DbSetFldString(5,City);
      DbSetFldString(6,State);
      DbSetFldString(7,Zip);
      DbSetFldString(8,Country);
      DbSetFldString(9,Phone);
      DbSetFldInt(10,Units);
   end;
   DbPutRecord;
end; { ScreenToDatabase }

procedure BuildForm;
{}
begin
   CreateForms(1);
   ActivateForm(1);
   SetFormWindow(14,4,70,19,7);
   Win1 := FormWinNum;
   WinSetTitle(Win1,' Editing Record ');
   WinSetShowNum(Win1,false);
   SetMessageXY(12,25,false);
   WinDisplay(Win1);
   KwikAddField(1, 17,2);         { ENTERED D 8 }
   KwikAddField(2, 17,4);         { CLIENT C 30 }
   KwikAddField(3, 17,5);         { ADDR1 C 30 }
   KwikAddField(4, 17,6);         { ADDR2 C 30 }
   KwikAddField(5, 17,7);         { CITY C 22 }
   KwikAddField(6, 45,7);         { STATE C 2 }
   KwikAddField(7, 17,8);         { ZIP C 10 }
   KwikAddField(8, 17,11);        { COUNTRY C 20}
   KwikAddField(9, 17,12);        { PHONE C 10}
   KwikAddField(10, 17,13);       { UNITS N 10 }
   KwikAddField(11, 43,11);       { edit/save }
   KwikAddLastField(12, 43,13);   { quit/cancel }
   with UserRec do
   begin
      SpinDropDateField(1,Entered,MMDDYY,'',0,0);
      StringField(2,Client,Replicate(30,'*'));
      FieldRules(2,NoRules+EraseDefault,[NoChar],[NoChar]);
      { turns off allowNul, turn on EraseDefault }
      StringField(3,Addr1,Replicate(30,'*'));
      StringField(4,Addr2,Replicate(30,'*'));
      StringField(5,City,Replicate(22,'*'));
      StringField(6,State,'!!');
      StringField(7,Zip,'#####-####');
      StringField(8,Country,Replicate(20,'*'));
      StringField(9,Phone,'(###) ###-####');
      SpinLongField(10,Units,10,0,0,1);
   end;
   ButtonField(11,' ~S~ave ',Finished);
   SetHK(11,287);
   ButtonDefaultField(12,'~C~ancel',escaped);
   SetHK(11,302);
   { define labels }
   SetLabel(1,LabelLeft,LabelLeft,'Date');
   SetLabel(2,LabelLeft,LabelLeft,'Clients name');
   SetLabel(3,LabelLeft,LabelLeft,'Address');
   SetLabel(5,LabelLeft,LabelLeft,'City, State');
   SetLabel(7,LabelLeft,LabelLeft,'Zip code');
   SetLabel(8,LabelLeft,LabelLeft,'Country');
   SetLabel(9,LabelLeft,LabelLeft,'Phone #');
   SetLabel(10,LabelLeft,LabelLeft,'Units ordered');
end; { BuildForm }

{$F+}
function SelectHook(ListdetailsPtr:ListCfgPtr):gAction;
{}
var
   LastAction: gAction;
   RecNo: longint;
begin
   SelectHook := None;
   with KeyVars do
   begin
      if (LastKey = 600)
      or (LastKey = 27) then
      begin
         if PromptOKCancel(' Confirmation ','Are you sure you want to exit?') = 1 then
            SelectHook := Escaped
      end
      else if ((LastKey = 540) and (LastX <> 0))
      or (LastKey = 13) then
      begin
         RecNo := ListdetailsPtr^.ActiveNode;
         DataBaseToScreen(NdxGetRecNum(RecNo));
         BuildForm;
         LastAction := EditForm(1);
         if LastAction = Finished then
         begin
            ScreenToDatabase;
            SelectHook := Refresh;
         end;
         DisposeFields;
         DisposeForms;
      end;
   end
end; {SelectHook}
{$F-}

                        {**************************}
                        {**  Grid Configuration  **}
                        {**************************}


procedure SetGridLayout;
{}
begin
   Gridheading := 'Date|Client|Addr1|Addr2|City|ST|Zip|Country|Tel|Units';
   TabStops[1] := 1;
   TabStops[2] := 10;
   TabStops[3] := 41;
   TabStops[4] := 72;
   TabStops[5] := 103;
   TabStops[6] := 127;
   TabStops[7] := 130;
   TabStops[8] := 140;
   TabStops[9] := 161;
   TabStops[10] := 176;
   InitListCfg(GridLayout);
   ListAssignCustom(GridLayout,NdxCount,GetStrfromDB);
   ListAssignHeader(GridLayout,1,GridHeading);
   ListAssignSelectHook(GridLayout,SelectHook);
   ListSetWin(GridLayout,5,5,75,20,7);
   ListSetGaps(GridLayout,1,0,0,1);
   GridAssignTabs(GridLayout,@TabStops,10);
end; { SetGridLayout }

begin { main }
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   if DbOpenDataSet(FN) <> 0 then
   begin
      SetScreen;
      MouseShow(true);
      DbSetFullStrings(false);
      ECode := NdxGotoFirst;
      MouseShow(true);
      SetGridLayout;
      CursorOff;
      RunGrid(GridLayout,' List View ');
      CursorOn;
      MouseShow(false);
      DbCloseAllDatabases;
   end else
      PromptOK(' DATA ERROR ','Unable to open '+FN+' or one of its related files.');
   ResetStartupMode;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.  {DemGrd4}
