{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMGRD1.PAS
              Shows how to display a grid list in a pop-up window using a
              SingleLL as the list source.
}

program DemGrd1;

{$I GOLDFLAG.INC}

uses CRT, GoldAttr, GoldFast, GoldMisc, GoldLink, GoldKey, GoldWin, GoldList,
          GoldGrid;

var
   SourceList: SingleLL;
   GridLayout: ListCfg;
   GridHeading: string;
   TabStops: array[1..5] of integer;

procedure ShutDown;
{}
begin
   PromptOK(' ERROR! ','Not enough memory to run program!');
   halt;
end; { ShutDown }

procedure SetScreen;
{}
begin
   Clear(whiteonblue,' ');
   ClearLine(1,RedOnLightgray);
   WriteCenter(1,UseTint,'TTT Gold');
   ClearLine(25,BlackOnLightgray);
   WritePlain(8,25,'');
end; { SetScreen }

procedure FillTheList;
{}
var I: integer;
begin
   I := 0;
   InitSLLStr(SourceList);
   SLLSetActiveList(SourceList);
   inc(I,SLLAddStr('R D Smith        22202 Chevy Chase    Maryland      WI  23233'));
   inc(I,SLLAddStr('M J Dooley       1123 Queens Blvd     Madison       WI  23278'));
   inc(I,SLLAddStr('E L G Jognson    12623 Ashford Hills  Houston       TX  77079'));
   inc(I,SLLAddStr('P R Group        4585 The Grille #21  Bose          HI  90991'));
   inc(I,SLLAddStr('Mark Norman      34 The Ridgeway      Delaware      OR  33789'));
   inc(I,SLLAddStr('Jennifer Worth   22 The Circle        Illinois      RI  22445'));
   inc(I,SLLAddStr('Susan Jones      52242 #12 South Road Fort Bender   MA  26889'));
   inc(I,SLLAddStr('J T Ainsworth    164 Dunvale Lane     Texas         TX  77023'));
   inc(I,SLLAddStr('Geoff Range      18 Meadow Wood       Washington    WA  67833'));
   inc(I,SLLAddStr('Joey Doolittle   229 Oak Drive        San Francisco CA  21345'));
   inc(I,SLLAddStr('Sally Weathers   79 Anchors Road      Kennebunport  MA  66720'));
   inc(I,SLLAddStr('G N Greene       816a Hwy 68 South    Portland      OR  23763'));
   if I <> 0 then
      Shutdown;
end; {FillTheList}

procedure SetGridLayout;
{}
begin
   Gridheading := 'Name|Street|City|ST|Zip';
   TabStops[1] := 1;
   TabStops[2] := 18;
   TabStops[3] := 39;
   TabStops[4] := 53;
   TabStops[5] := 57;
   InitListCfg(GridLayout);
   ListAssignSLL(GridLayout,SourceList);
   ListAssignHeader(GridLayout,1,GridHeading);
   ListSetWin(GridLayout,15,5,65,15,7);
   ListSetGaps(GridLayout,1,0,0,1);
   GridAssignTabs(GridLayout,@TabStops,5);
end; { SetGridLayout }

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   SetScreen;
   FillTheList;
   MouseShow(true);
   SetGridLayout;
   CursorOff;
   RunGrid(GridLayout,' People! ');
   CursorOn;
   MouseShow(false);
   SLLSetActiveList(SourceList);
   SLLDestroy;
   clrscr;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
