{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMFS9.PAS
              Illustrates how to use virtual screens to
              slide images onto the display.
}

program DEMFS9;

{$I GOLDFLAG.INC}

uses DOS,CRT, GoldAttr, GoldMisc, GoldFast,GoldWin,GoldKey;

procedure Welcome;
{paints an introduction screen}
begin
   CreateScreen(3,80,25,LightBlueOnBlue);
   ActivateVirtualScreen(3);          {all subsequent writes will be to screen 3}
   ClearText(1,1,80,25,WhiteOnBlue);   {clear the screen with a blue background }
   WriteCenter(1,WhiteOnBlue,'Virtual Screen Demonstration');  { write in middle of line 1} { white,blue }
   FBox(20,5,61,15,WhiteOnRed,1);      {draw a single line filled box }
   WriteAT(22,7,WhiteOnRed, 'This demo is designed to illustrate');
   WriteAT(22,8,WhiteOnRed, 'the how virtual screens add pizazz to');
   WriteAT(22,9,WhiteOnRed, 'applications.');
   WriteAT(22,11,WhiteOnRed,'While you have been reading this, two');
   WriteAT(22,12,WhiteOnRed,'other screens have been written on the');
   WriteAT(22,13,WhiteOnRed,'heap.');
   ActivateVisibleScreen;
end; {Welcome}

procedure PrepareVirtualScreen1;
{ allocates a new screen on the heap and writes text to it }
begin
   CreateScreen(1,80,25,LightBlueOnBlue); {create a new screen - referred to as screen 1}
   ActivateVirtualScreen(1);   {all subsequent writes will be to screen 1}
   ClearText(1,1,80,25,YellowOnGreen); {clear the screen on the heap}
   WriteCenter(1,YellowOnGreen,'Virtual Screens'); {write a heading in the center of line 1}
   HorizLine(15,65,2,YellowOnGreen,2);   {draw a double line}
   WritePlain(10,4,'Virtual screens have all the characteristics of the visible');
   WritePlain(10,5,'screen. The main advantage of virtual screens is that they can');
   WritePlain(10,6,'be prepared while the user is viewing a different image.');
   WritePlain(10,8,'They are very useful for preparing screens that you want');
   WritePlain(10,9,'to slide onto the display. This screen was prepared while you');
   WritePlain(10,10,'were viewing the welcome screen.');
   GotoXY(43,10);                {GotoXY works on virtual screens as well}
   ActivateVisibleScreen;      {set subsequent writes to the visble screen}
end; {PrepareVirtualScreen1}

procedure PrepareVirtualScreen2;
{ allocates a new screen on the heap and writes text to it }
begin
   CreateScreen(2,80,25,LightBlueOnBlue);  {create a new screen - referred to as screen 2}
   ActivateVirtualScreen(2);              {all subsequent writes will be to screen 2}
   ClearText(1,1,40,25,WhiteOnRed);        {clear the screen on the heap}
   ClearText(41,1,80,25,BlackOnLightGray); {clear the screen on the heap}
   WritePlain(28,1,'This was written with Plainwrite');  {use default display colors}
   Fillscreen(10,5,25,10,WhiteOnRed,'*');
   CopyScreenBlock(10,5,25,10,50,15);  {the copy and move operations work on the virtual screen}
   CopyScreenBlock(10,5,25,10,10,15);  {the copy and move operations work on the virtual screen}
   MoveScreenBlock(10,15,25,20,30,18);
   ActivateVisibleScreen;              {set subsequent writes to the visble screen}
end; { PrepareVirtualScreen1}

procedure PressAKey;
{display a message in a single lined box}
begin
   TempMessageBox(50,20,BlackOnCyan,1,'Press any key to continue');
end; {PressAKey}

begin    {main program}
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   Clear(WhiteOnBlack,'');
   Welcome;
   DelayKey(3000);
   SlideRestoreScreen(3,Up);
   PrepareVirtualScreen1;
   PrepareVirtualScreen2;
   PressAkey;
   SlideRestoreScreen(1,Down);      {Display screen 1 that was created on the heap}
   PressAkey;
   RestoreScreen(2);
   PressAKey;
   DisposeScreen(1);      {release the heap space taken by the screens}
   DisposeScreen(2);
   DisposeScreen(3);
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
