{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{              Copyright 1986-1995  TechnoJock Software, Inc.              }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description:  DEMDESK5.PAS
               An extension of DEMDESK3 with a some list
               items added to the menu.
}

program DEMDESK5;

uses DOS, CRT,
     GoldFast, GoldWin, GoldMenu, GoldMisc, GoldDesk,
     GoldKey, GoldCalc, GoldCal, GoldDate, GoldStr,
     GoldList, GoldLink;

var
   MainMenu,
   StatusBar: Bar;
   SubMenu: PopUp;
   ListMenu: PopUp;
   Action : dAction;
   TaskList: SingleLL;
   TaskFormat: ListCfg;
   GirlList: SingleLL;
   GirlFormat: ListCfg;


                         {***********************}
                         {**  Menu Management  **}
                         {***********************}

{$F+}
procedure MenuHelp(ID:integer);
{}
begin
   PromptOK(' Help! ','You asked for help on menu item ID: '+IntToStr(ID));
end; { MenuHelp }
{$F-}

procedure DefineSubMenu;
{}
begin
   InitPopUp(SubMenu);
   PopUpAddItem(SubMenu,'~C~alculator',101,67,'Display a calculator',nil);
   PopUpAddItem(SubMenu,'Ca~l~endar',102,76,'Display a calendar',nil);
   PopUpAddItem(SubMenu,'~A~bout',103,65,'Show version and copyright information',nil);
   PopUpAddItem(SubMenu,'E~x~it',999,88,'~Exit~ this little demo',nil);
   InitPopUp(ListMenu);
   PopUpAddItem(ListMenu,'~T~o do List',201,84,'Display a list of tasks',nil);
   PopUpAddItem(ListMenu,'~G~irlfriends',202,71,'Display a list of girlfriends',nil);
end; { DefineSubMenu }

procedure DefineMainMenu;
{}
begin
   InitBar(MainMenu);
   BarAddItem(MainMenu,'~T~ools',100,84,276,'Select one of Desktop tools',@SubMenu);
   BarAddItem(MainMenu,'~L~ists',200,76,294,'Select a list to display',@ListMenu);
   MainMenu.Style := 2;
   AssignMenuHelpHook(MainMenu,MenuHelp);
end; { DefineMainMenu }

procedure DefineStatusBar;
{}
begin
   InitBar(StatusBar);
   BarAddItem(StatusBar,'~F1~ Help',1001,315,315,'',nil);
   BarAddItem(StatusBar,'~Alt+X~ Exit the demo',999,301,301,'',nil);
end; { DefineStatusBar }

procedure DisposeMenus;
{}
begin
   DestroyBar(MainMenu);
   DestroyPopUp(SubMenu);
   DestroyPopUp(ListMenu);
   DestroyBar(StatusBar);
end; { DisposeMenus }
                         {***********************}
                         {**  List Management  **}
                         {***********************}
{$F+}
function GoodbyeList(ListDetails:ListCfgPtr; Handle:integer): boolean;
{}
begin
   PopUpSetActive(ListMenu,201,true);
   SLLDestroy;
   GoodbyeList := true;
end; { GoodbyeList }
{$F-}

procedure ShowToDo;
{}
   function PopulateTaskList:boolean;
   {}
   var I: integer;
   begin
      I := 0;
      InitSLLStr(TaskList);
      SLLSetActiveList(TaskList);
      inc(I,SLLAddStr('Wash the car'));
      inc(I,SLLAddStr('Floss teeth'));
      inc(I,SLLAddStr('Build BBQ'));
      inc(I,SLLAddStr('Watch Fletch'));
      inc(I,SLLAddStr('Phone Home'));
      inc(I,SLLAddStr('Finish Gold'));
      if I <> 0 then
      begin
         PromptOK(' Unable to populate list ',' Aborting! ');
         PopulateTaskList := false
      end
      else
         PopulateTaskList := true;
   end; { PopulateTaskList }

begin
   if PopulateTaskList then
   begin
      PopUpSetActive(ListMenu,201,false);
      InitListCfg(TaskFormat);
      with TaskFormat do
      begin
         WX1 := 26;
         WX2 := 52;
         WY1 := 4;
         WY2 := 12;
      end;
      ListAssignSLL(TaskFormat,TaskList);
      if LaunchList(TaskFormat,'Jobs',GoodByeList) = 0 then
      begin
         if GoodbyeList(@TaskFormat,0) then
            {WhoCares};
         PromptOK(' Error ','^Unable to display the list of jobs');
      end;
   end;
end; { ShowToDo }

{$F+}
function GoodbyeGirls(ListDetails:ListCfgPtr; Handle:integer):boolean;
{}
begin
   PopUpSetActive(ListMenu,202,true);
   SLLDestroy;
   GoodbyeGirls := true;
end; { GoodbyeGirls }
{$F-}

procedure ShowGirls;
{}

   function PopulateGirlList:boolean;
   {}
   var I: integer;
   begin
      I := 0;
      InitSLLStr(GirlList);
      SLLSetActiveList(GirlList);
      inc(I,SLLAddStr('Erica'));
      inc(I,SLLAddStr('Alison'));
      inc(I,SLLAddStr('Barbara'));
      inc(I,SLLAddStr('Katy'));
      inc(I,SLLAddStr('Brenda'));
      inc(I,SLLAddStr('Theresa'));
      inc(I,SLLAddStr('Shirley'));
      inc(I,SLLAddStr('Alene'));
      inc(I,SLLAddStr('Chris'));
      inc(I,SLLAddStr('Trojan'));
      if I <> 0 then
      begin
         PromptOK(' Unable to populate list ',' Aborting! ');
         PopulateGirlList := false
      end
      else
         PopulateGirlList := true;
   end; { PopulateGirlList }

begin
   if PopulateGirlList then
   begin
      PopUpSetActive(ListMenu,202,false);
      InitListCfg(GirlFormat);
      with GirlFormat do
      begin
         WX1 := 27;
         WX2 := 53;
         WY1 := 5;
         WY2 := 15;
      end;
      ListAssignSLL(GirlFormat,GirlList);
      if LaunchList(GirlFormat,'Girl Friends',GoodByeGirls) = 0 then
      begin
         if GoodbyeGirls(@GirlFormat,0) then
            {whocares};
         PromptOK(' Error ','^Unable to display the list of girlfriends');
      end;
   end;
end; { ShowGirls }
                            {*****************}
                            {**  Scheduler  **}
                            {*****************}
{$F+}
procedure MyActionProc(Choice:integer;var Action:DAction);
{}
begin
   case Choice of
     101: if LaunchCalculator(' Punch Me ') = 0 then
        PromptOK(' Error ', 'Unable to display the Calculator');
     102: if LaunchCalendar(TodayInJul,' Calendar ') = 0 then
        PromptOK(' Error ', 'Unable to display the Calendar');
     103: PromptOK(' Tools Demo ','^Copyright 1995 TechnoJock Software, Inc.|'+
                     '^All Rights Reserved');
     201: ShowToDo;
     202: ShowGirls;
     1001: PromptOK(' Tools Help ','^Honey if you need help, we got problems!');
     999: Action := DFinished;
   end;
end; { MyActionProc }
{$F-}

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   DefineSubMenu;
   DefineMainMenu;
   DefineStatusBar;
   DeskAssignMainMenu(MainMenu);
   DeskAssignActionProc(MyActionProc);
   DeskAssignStatusBar(Statusbar);
   SetBlinking(false);
   MouseShow(true);
   CursorOff;
   Action := DeskProcessInput;
   CursorOn;
   MouseShow(false);
   DisposeMenus;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.

