{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMDB8.PAS

}

program Demdb8;

{$I GOLDFLAG.INC}

uses CRT, DOS, GoldDb, GoldFast, GoldWin, GoldTint, GoldAttr, GoldMemo,
     GoldStr, Goldio, Goldio2, Goldio3, GoldDate, GoldMisc, GoldKey, GoldLink;

const FN = 'DEMCUST.DBF';
      Msg1 = 'An Example Of Browsing And Editing With a Memo Field';
      Msg2 = ' Client Profiles ';
      Msg5 = ' Top of file ';
      Msg6 = '^Looping to last record';
      Msg7 = ' End of file ';
      Msg8 = '^Looping to first record';
      Msg9 = ' Deleting Record! ';
      Msg10 = '^Are you sure?';
      Msg11 = ' Returning to DOS ';
      Msg12 = '^Have you really finished?';
      Msg13 = ' About to cancel! ';
      Msg14 = 'Unable to create all the fields!';
      Msg15 = 'Unable to create data file!';
      Msg16 = ' File Error ';
      EdtBtn = '~E~dit';
      AddBtn = '~A~dd';
      SavBtn = '~S~ave';
      CanBtn = '~C~ancel';
      DelBtn = '~D~el';
      QuiBtn = ' ~Q~uit ';

type UserRecord = record
       ENTERED: Dates;
       CLIENT: string[30];
       ADDR1: string[30];
       ADDR2: string[30];
       CITY: string[22];
       STATE: string[2];
       ZIP: string[9];
       COUNTRY: string[20];
       PHONE: string[10];
       UNITS: longint;
       COMMENTS: SingleLL;
     end;

var I, Win1, Handle,
    ActiveField: integer;
    UserTerminates,
    Cancelling, Adding: boolean;
    RecNum, X, SavedX: longint;
    LastAction: gAction;
    UserRec, SavdUserRec: UserRecord;
    NdxFld: integer;
    SavValidate: gValidate;
    MemoFldVar: MemoCfg;

procedure SetScreen;
{}
begin
   Clear(WhiteOnBlack,'');
   ClearLine(1,WhiteOnBlue);
   WriteCenter(1,WhiteOnBlue,Msg1);
   WriteAT(68,1,YellowOnBlack,' TTT Gold! ');
   ClearLine(25,BlackOnRed);
   Tint[IOLabelNorm] := LightBlueOnLightGray;
   Tint[IOLabelNormHot] := LightBlueOnLightGray;
   Tint[IOLabelHi] := LightBlueOnLightGray;
   Tint[IOLabelHiHot] := LightBlueOnLightGray;
   Tint[IOLabelOff] := LightBlueOnLightGray;
end; { SetScreen }

procedure SaveUserRec;
{}
begin
   SavdUserRec := UserRec;
   SavedX := X;
end; { SaveUserRec }

procedure RestoreUserRec;
{}
begin
   UserRec := SavdUserRec;
   X := SavedX;
end; { RestoreUserRec }

function DataHasChanged: boolean;
{}
begin
   DataHasChanged := Different(UserRec,SavdUserRec,sizeof(UserRec));
end; { DataHasChanged }

procedure InitData;
{}
begin
   with UserRec do
   begin
      Entered := TodayInJul;
      Client := '';
      Addr1 := '';
      Addr2 := '';
      City := '';
      State := '';
      Zip := '';
      Country := '';
      Phone := '';
      Units := 0;
      InitSLL(Comments);
   end;
end; { InitData }

procedure DatabaseToScreen(RecNo:longint);
{}
begin
   with UserRec do
   begin
      Entered := DbGetFldDate(RecNo,1);
      Client := DbGetFldString(RecNo,2);
      Addr1 := DbGetFldString(RecNo,3);
      Addr2 := DbGetFldString(RecNo,4);
      City := DbGetFldString(RecNo,5);
      State := DbGetFldString(RecNo,6);
      Zip := DbGetFldString(RecNo,7);
      Country := DbGetFldString(RecNo,8);
      Phone := DbGetFldString(RecNo,9);
      Units := DbGetFldLong(RecNo,10);
      DbGetFldMemo(RecNo,11,MemoFldVar);
   end;
end; { DatabaseToScreen }

procedure ScreenToDatabase;
{}
var MemRecNum: longint;
begin
   with UserRec do
   begin
      DbSetFldDate(1,Entered);
      DbSetFldString(2,Client);
      DbSetFldString(3,Addr1);
      DbSetFldString(4,Addr2);
      DbSetFldString(5,City);
      DbSetFldString(6,State);
      DbSetFldString(7,Zip);
      DbSetFldString(8,Country);
      DbSetFldString(9,Phone);
      DbSetFldInt(10,Units);
      MemRecNum := DbSetFldMemo(11,Comments);
   end;
   if Adding then
   begin
      DbAddRecord;
      Adding := false;
   end else
      DbPutRecord;
end; { ScreenToRecord }

procedure BuildForm;
{}
begin
   CreateForms(1);
   ActivateForm(1);
   AllowEsc(true);
   SetFormWindow(2,3,78,22,7);
   Win1 := FormWinNum;
   WinSetTitle(Win1,Msg2);
   WinSetType(Win1,WMoveNoClose);
   WinSetShowNum(Win1,false);
   SetMessageXY(12,25,false);
   WinDisplay(Win1);
   KwikAddField(1, 40,2);         { ENTERED D 8 }
   KwikAddField(2, 15,4);         { CLIENT C 30 }
   KwikAddField(3, 10,5);         { ADDR1 C 30 }
   KwikAddField(4, 10,6);         { ADDR2 C 30 }
   KwikAddField(5, 14,7);         { CITY C 22 }
   KwikAddField(6, 38,7);         { STATE C 2 }
   KwikAddField(7, 11,8);         { ZIP C 10 }
   KwikAddField(8, 10,9);         { COUNTRY C 20}
   KwikAddField(9, 10,10);        { PHONE C 10}
   KwikAddField(10, 16,11);       { UNITS N 10 }
   KwikAddField(11, 33,8);        { MEMO M 10 }
   KwikAddField(12, 3,17);        { goto top }
   KwikAddField(13, 9,17);        { prev }
   KwikAddField(14, 14,17);       { next }
   KwikAddField(15, 19,17);       { goto end }
   KwikAddField(16, 26,17);       { add }
   KwikAddField(17, 33,17);       { del }
   KwikAddField(18, 40,17);       { edit/save }
   KwikAddField(19, 48,17);       { quit/cancel }
   KwikAddLastField(20, 12,2);    { Record No }
   with UserRec do
   begin
      SpinDropDateField(1,Entered,MMDDYY,'',0,0);
      StringField(2,Client,Replicate(30,'*'));
      FieldRules(2,NoRules+EraseDefault,[NoChar],[NoChar]);
      { turns off allowNul, turn on EraseDefault }
      StringField(3,Addr1,Replicate(30,'*'));
      StringField(4,Addr2,Replicate(30,'*'));
      StringField(5,City,Replicate(22,'*'));
      StringField(6,State,'!!');
      StringField(7,Zip,'#####-####');
      StringField(8,Country,Replicate(20,'*'));
      StringField(9,Phone,'(###) ###-####');
      SpinLongField(10,Units,10,0,0,1);
      MemoField(11,40,8,MemoFldVar);
   end;
   ButtonField(12,'',Stop1);
   ButtonField(13,'',Stop2);
   ButtonField(14,'',Stop3);
   ButtonField(15,'',Stop4);
   ButtonField(16,AddBtn,Stop8);
   ButtonField(17,DelBtn,Stop9);
   ButtonField(18,EdtBtn,Stop5);
   ButtonDefaultField(19,QuiBtn,escaped);
   LongintField(20,RecNum,'',0,0);
   FieldSetState(20,FldOff); { display only }
   { define labels }
   SetLabel(1,LabelLeft,LabelLeft,'Date');
   SetLabel(2,LabelLeft,LabelLeft,'Clients name');
   SetLabel(3,LabelLeft,LabelLeft,'Address');
   SetLabel(5,LabelLeft,LabelLeft,'City, State');
   SetLabel(7,LabelLeft,LabelLeft,'Zip code');
   SetLabel(8,LabelLeft,LabelLeft,'Country');
   SetLabel(9,LabelLeft,LabelLeft,'Phone #');
   SetLabel(10,LabelLeft,LabelLeft,'Units ordered');
   SetLabel(20,LabelLeft,LabelLeft,'Record No');
   { define messages }
   SetMessage(1,0,0,'Entry date');
   SetMessage(2,0,0,'Client''s name');
   SetMessage(3,0,0,'Street address');
   SetMessage(4,0,0,'Post office box (etc.)');
   SetMessage(5,0,0,'City');
   SetMessage(6,0,0,'State');
   SetMessage(7,0,0,'Zip code');
   SetMessage(8,0,0,'Country');
   SetMessage(9,0,0,'Telephone number');
   SetMessage(10,0,0,'Number of units client has ordered');
   SetMessage(11,0,0,'Pertinent comments');
   SetMessage(12,0,0,'Go to first record in database');
   SetMessage(13,0,0,'Go to previous record in database');
   SetMessage(14,0,0,'Go to next record in database');
   SetMessage(15,0,0,'Go to last record in database');
   SetMessage(16,0,0,'Add a new record');
   SetMessage(17,0,0,'Delete current record');
   SetMessage(18,0,0,'Edit or Save record');
   SetMessage(19,0,0,'Cancel or Return to DOS');
   { define hotkeys }
   SetHK(16,287);  { Alt+S } {add button}
   SetHK(17,288);  { Alt+D } {del button}
   SetHK(18,274);  { Alt+E } {edit button}
   SetHK(19,272);  { Alt+Q } {quit button}
   for I := 1 to 11 do  { set for browse }
      FieldSetState(I,FldOff);
end; { BuildForm }

procedure CreateNewDataFile;
{could be built on the fly via I/O form}
var EValue: integer;
begin
   EValue := DbAddDbfField('DATE','D',8,0);
   inc(EValue,DbAddDbfField('CLIENT','C',30,0));
   inc(EValue,DbAddDbfField('ADDR1','C',30,0));
   inc(EValue,DbAddDbfField('ADDR2','C',30,0));
   inc(EValue,DbAddDbfField('CITY','C',22,0));
   inc(EValue,DbAddDbfField('STATE','C',2,0));
   inc(EValue,DbAddDbfField('ZIP','C',10,0));
   inc(EValue,DbAddDbfField('COUNTRY','C',20,0));
   inc(EValue,DbAddDbfField('PHONE','C',10,0));
   inc(EValue,DbAddDbfField('UNITS','N',10,0));
   inc(EValue,DbAddDbfField('COMMENTS','M',10,0));
   if EValue <> 0 then
   begin
      PromptOK(Msg16,Msg14);
      Halt;
   end else
   begin
      EValue := DbBuildDataFile(FN,0);
      if EValue <> 0 then
      begin
         PromptOK(Msg16,Msg15);
         Halt;
      end;
   end;
end; { CreateNewDataFile }

procedure PreSetFields;
{}
begin
   if DbGetNumRecs < 2 then
   begin
      for I := 12 to 15 do { turn off VCR buttons }
         FieldSetState(I,FldHidden);
      FieldSetState(18,FldHidden); { turn off edit button }
      FieldSetState(17,FldHidden); { turn off del button }
      ActiveField := 16;  {add button}
   end else
      ActiveField := 14;
end; { PreSetFields }

procedure CompleteStop6or7; { save / cancel }
{}
begin
   for I := 1 to 11 do          { fields }
      FieldSetState(I,FldOff);
   for I := 12 to 19 do
      FieldSetState(I,FldOn);
   ButtonChangeSettings(18,EdtBtn,Stop5);
   ButtonChangeSettings(19,QuiBtn,Escaped);
   ActiveField := 14;  { next }
end; { CompleteStop6or7 }

procedure SetValidation;
{}
begin
   SavValidate := IOVars.DefaultValidate;
   IOVars.DefaultValidate := ValidateAtEnd;
end; { SetValidation }

procedure RestoreValidation;
{}
begin
   IOVars.DefaultValidate := SavValidate;
end; { RestoreValidation }

begin { main }
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   if not Exist(FN) then
      CreateNewDataFile;
   NdxFld := 2;
   Handle := DbOpenDataSet(FN); {extremely important assignment}
   if Handle <> 0 then
   begin
      if DbIndexedField = 0 then
         if NdxBuildNew(NdxFld) <> 0 then
         begin
            PromptOK(' INDEX ERROR ','Index is missing!');
            halt;
         end;
      Tint[IOWinTitle] := WhiteOnRed;
      InitData;
      MemoAssignSLL(MemoFldVar,UserRec.Comments);
      SetValidation;
      SetScreen;
      BuildForm;
      MouseShow(true);
      Adding := false;
      PreSetFields;
      UserTerminates := false;
      DbSetFullStrings(false);
      X := NdxGotoFirst;
      repeat
         RecNum := X;
         if (DbGetNumRecs > 0) and (X > 0) then
            DatabaseToScreen(X);
         DisplayForm;
         LastAction := EditForm(ActiveField);
         ActiveField := FieldWithFocus;
         case LastAction of
            Stop1: begin
                      X := NdxGotoFirst;
                      ActiveField := 14;  { next }
                   end;
            Stop2: begin
                      X := NdxGotoPrev;
                      if X = 0 then
                      begin
                         X := NdxGotoLast;
                         PromptOK(Msg5,Msg6)
                      end;
                   end;
            Stop3: begin
                      X := NdxGotoNext;
                      if X = 0 then
                      begin
                         X := NdxGotoFirst;
                         PromptOK(Msg7,Msg8);
                      end;
                   end;
            Stop4: begin
                      X := NdxGotoLast;
                      ActiveField := 13;  { prev }
                   end;
            Stop8,         { add  }
            Stop5: begin   { edit }
                      SaveUserRec;
                      if (LastAction = Stop8) then
                      begin
                         Adding := true;
                         InitData;
                         X := 0; { prevents redisplaying previous data }
                         FieldSetState(16,FldHidden); { add }
                         FieldSetState(18,FldOn);  { edit/save }
                      end;

                      for I := 1 to 11 do          { fields }
                         FieldSetState(I,FldOn);
                      for I := 12 to 17 do         { vcr }
                         FieldSetState(I,FldHidden);
                      {FieldSetState(19,FldHidden);}    { add }
                      ButtonChangeSettings(18,SavBTn,Stop6);
                      ButtonChangeSettings(19,CanBtn,Cancel1);
                      ActiveField := 2;
                      ClearText(1,1,80,25,Tint[IOLabelNorm]);
                   end;
            Stop6: begin   { save }
                      if DataHasChanged then
                         ScreenToDatabase;
                      CompleteStop6or7;
                   end;
          Cancel1: begin   { cancel (Stop7) }
                      Cancelling := true;
                      if PromptYesNo(Msg13,Msg10) = 1 then
                      begin
                         Adding := false;
                         if DbGetNumRecs > 0 then
                            RestoreUserRec;
                         CompleteStop6or7;
                      end
                   end;
            Stop9: begin   { delete }
                      for I := 12 to 16 do
                         FieldSetState(I,FldHidden);
                      FieldSetState(18,FldHidden);
                      if PromptYesNo(Msg9,Msg10) = 1 then
                      begin
                         DbDeleteRecord(X);
                         X := NdxGotoNext;
                         if X = 0 then
                            X := NdxGotoFirst;
                      end;
                      for I := 12 to 16 do
                         FieldSetState(I,FldOn);
                      FieldSetState(18,FldOn);
                      ActiveField := 14;
                   end;
          Escaped: begin
                      if PromptYesNo(Msg11,Msg12) = 1 then
                         UserTerminates := true;
                   end;
         end;  { case }
      until UserTerminates;
      DisposeFields;
      DisposeForms;
      SLLDestroy;
      MouseShow(false);
      DbCloseAllDatabases;
      RestoreValidation;
   end else
      PromptOK(' DATA ERROR ','Unable to open '+FN+' or one of its related files.');
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
