{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMDB10.PAS
              A variation of DEMGRD1 which shows how to lock
              columns when scrolling left and right.
}

program DemDb10;

{$I GOLDFLAG.INC}

uses CRT, GoldAttr, GoldFast, GoldMisc, GoldLink, GoldTint, GoldDate,
          GoldStr, GoldDb, GoldKey, GoldWin, GoldList, GoldGrid;

const FN: string[12] = 'DEMCUST.DBF';

var
   SourceList: SingleLL;
   GridLayout: ListCfg;
   GridHeading: string;
   TabStops: array[1..4] of integer;
   Handle: integer;
   RecLen: integer;

procedure ShutDown;
{}
begin
   PromptOK(' ERROR! ','Not enough memory to run program!');
   halt;
end; { ShutDown }

procedure SetScreen;
{}
begin
   Clear(whiteonblue,' ');
   ClearLine(1,RedOnLightgray);
   WriteCenter(1,UseTint,'TTTGOLD');
   ClearLine(25,BlackOnLightgray);
   WritePlain(8,25,'');
end; { SetScreen }

function FieldType(Field:integer): string;
{}
begin
   case DbGetFldType(Field) of
      'C': FieldType := 'Character    ';
      'N': FieldType := 'Numeric      ';
      'D': FieldType := 'Date         ';
      'L': FieldType := 'Logical      ';
      'M': FieldType := 'Memo         ';
   end;
end; {FieldType}

function FieldLength(FL:integer):string;
{}
var Len: integer;
begin
   Len := DbGetFldLength(FL);
   FieldLength := PadLeft(IntToStr(Len),9,' ');
   inc(RecLen,Len);
end;

procedure FillTheList;
{}
var I,X: integer;
begin
   I := 0;
   InitSLLStr(SourceList);
   SLLSetActiveList(SourceList);
   for X := 1 to DbTotalFields do
      inc(I,SLLAddStr(PadLeft(DbGetFldName(X),12,' ')
                     +FieldType(X)
                     +FieldLength(X)
                     +IntToStr(DbGetFldDec(X))));
   if I <> 0 then
      Shutdown;
   Gridheading := 'Name|Type|Length|DecPl';
   TabStops[1] := 1;
   TabStops[2] := 13;
   TabStops[3] := 24;
   TabStops[4] := 33;
end; {FillTheList}

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   SetScreen;
   PromptOK(' DEMDBSX ','Displays the structure of a database file');
   Handle := DbOpenDataSet(FN);
   if Handle > 0 then
   begin
      RecLen := 1; {accounts for the status byte}
      FillTheList;
      MouseShow(true);
      InitListCfg(GridLayout);
      ListAssignSLL(GridLayout,SourceList);
      ListAssignHeader(GridLayout,1,GridHeading);
      ListScrollHeader(GridLayout,true);
      GridAssignTabs(GridLayout,@TabStops,4);
      GridSetLocks(GridLayout,1,0);
      GridLayout.Col[Listheaders] := 15;
      with GridLayOut do
      begin
         WX1 := 17;
         WY1 := 12;
         WX2 := 64;
         WY2 := 22;
         WStyle := 6;
         LeftGap := 1;
         RightGap := 1;
         TopGap := 1;
      end;
      UseCustomChars;
      MouseShow(true);
      CursorOff;
      Box3D(13,3,68,10,BlackOnCyan,WhiteOnCyan,1);
      WriteAT(26,5,BlackOnCyan,'File Name : '+FN);
      WriteAT(26,6,BlackOnCyan,'Date last updated : '+JulToStr(DbGetUpDate,MMDDYY));
      WriteAT(26,7,BlackOnCyan,'Number of records : '+IntToStr(DbGetNumRecs));
      WriteAT(26,8,BlackOnCyan,'Record Length : '+IntToStr(DbGetRecLen));
      RunGrid(GridLayout,' File Structure ');
      CursorOn;
      MouseShow(false);
      SLLSetActiveList(SourceList);
      SLLDestroy;
      DbCloseDataBase(Handle);
   end
   else
      PromptOK(' App Error ','Unable to load Structure');
   clrscr;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
