{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMBRS6.PAS
              A variant of DEMBRS5 which sets a protected
              heading and a footnote;
}

program DEMBRS6;

{$I GOLDFLAG.INC}

uses CRT, GoldAttr, GoldMisc, GoldFast, GoldList, GoldKey, GoldDir,
          GoldWin, GoldLink, GoldStr;

var
  Header1,
  Header2,
  Footer,
  Filename:string;

   procedure SetScreen;
   {}
   begin
      Clear(BlueOnLightRed,' ');
      ClearLine(1,YellowOnLightBlue);
      WriteCenter(1,0,' Browsing Gold-Style ');
      ClearLine(25,BlackOnYellow);
      WriteCenter(25,0,'Press ESC to finish...');
   end; { SetScreen }

   procedure HighlightLine(var DLL:DoubleLL; Str:string; caseSens: boolean);
   {for fun, highlight everyline that contains the sub-string Str}
   var
      NodePtr: DoubleNodePtr;
      LineCount: string[10];
      Counter: Longint;
      P: byte;
      TempStr: string;
   begin
      GrowMkWin(20,10,60,13,whiteonBlue,4);
      WriteCenter(11,0,'Scanning File');
      LineCount := IntToStr(DLL.TotalNodes);
      NodePtr := DLL.StartNodePtr;
      Counter := 0;
      while NodePtr <> nil do
      begin
         inc(Counter);
         WriteCenter(12,0,'Processing line '+IntToStr(Counter)+' of '+LineCount);
         TempStr := DLLGetNodeStr(NodePtr,0,0);
         if CaseSens then
            P := pos(Str,TempStr)
         else
            P := pos(SetUpper(Str),SetUpper(TempStr));
         if P > 0 then
            DLLSetBit(NodePtr,1,true);
         NodePtr := NodePtr^.NextPtr;
      end;
      RmWin;
   end; {HighlightLine}

   procedure DisplayTheFile;
   {}
   var
      DirFormat: ListCfg;
      DLL: DoubleLL;
      gResult: integer;
   begin
      {First fill the linked list with the file contents}
      InitDLLStr(DLL);
      DLLSetActiveList(DLL);
      gResult := DLLLoadFromFile(Filename);
      if gResult = 0 then
      begin
         HighLightLine(DLL,'{',true);
         {set the state of the browse record}
         InitListCfg(DirFormat);
         ListAssignDLL(Dirformat,DLL);
         Header1 := '^This is a centered header';
         Header2 := 'This is a second header';

         Footer := '^This is a footer';
         with DirFormat do
         begin
            AllowTwoColors := true;
            WX1 := 1;
            WY1 := 2;
            WX2 := 80;
            WY2 := 24;
            ListAssignHeader(DirFormat,1,Header1);
            ListAssignHeader(DirFormat,2,Header2);
            ListAssignFooter(DirFormat,1,Footer);
         end;
         RunBrowse(DirFormat,' Browsing '+FileName);
      end
      else
         PromptOK(' Error ','Unable to load the file');
      DLLDestroy;
   end; { DisplayTheFile }

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   SetBlinking(false);
   BBtop := 1;  {delete for beta}
   BBbot := 1;
   SetScreen;
   UseCustomChars;
   MouseShow(true);
   KeySetFast;
   FileName := FileList('*.pas',' Pick a Pascal file ');
   if Filename = '' then
      PromptOK('','You Cancelled!')
   else
      DisplayTheFile;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
