{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMBRS2.PAS
              Shows how to display a text file in a browse
              window and customize the display window.
}

Program DEMBRS2;

{$I GOLDFLAG.INC}

uses CRT, GoldAttr, GoldMisc, GoldFast,  GoldList, GoldKey, GoldDir,
          GoldWin, GoldLink, GoldStr;

var
  Filename:string;

   procedure SetScreen;
   {}
   begin
      Clear(BlueOnLightRed,' ');
      ClearLine(1,YellowOnLightBlue);
      WriteCenter(1,0,' Browsing Gold-Style ');
      ClearLine(25,BlackOnYellow);
      WriteCenter(25,0,'Press ESC to finish...');
   end; { SetScreen }

   procedure DisplayTheFile;
   {}
   var
      Settings: ListCfg;
      DLL: DoubleLL;
      gResult: integer;
   begin
      {First fill the linked list with the file contents}
      InitDLLStr(DLL);
      DLLSetActiveList(DLL);
      gResult := DLLLoadFromFile(Filename);
      if gResult = 0 then
      begin
         InitListCfg(Settings);
         ListAssignDLL(Settings,DLL);
         ListSetWin(Settings,1,2,80,24,1);
         CursorOff;
         RunBrowse(Settings,' Browsing '+FileName);
      end
      else
         PromptOK(' Error ','Unable to load the file');
      DLLDestroy;
   end; { DisplayTheFile }

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   SetBlinking(false);
   SetScreen;
   MouseShow(true);
   KeySetFast;
   FileName := FileList('*.pas',' Pick a Pascal file ');
   if Filename = '' then
      PromptOK('','You Cancelled!')
   else
      DisplayTheFile;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end. {DEMBRS2}
