/*

    TiMidity -- Experimental MIDI to WAVE converter
    Copyright (C) 1995 Tuukka Toivonen <toivonen@clinet.fi>

	 This program is free software; you can redistribute it and/or modify
	 it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
	 (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	 GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    pm_c.c: This is the interface for OS/2 Presentation Manager
    Copyright (C) 1997 Darwin O'Connor <doconno@cc.umanitoba.ca>    
*/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#define INCL_DOSSEMAPHORES
#define INCL_DOSPROCESS
#define INCL_WINMESSAGEMGR
#define INCL_WINLISTBOXES
#define INCL_WINSTDFILE
#define INCL_WINBUTTONS
#define INCL_WINPOINTERS
#define INCL_WINFRAMEMGR
#define INCL_WINTIMER
#define INCL_WINSTDSLIDER
#define INCL_WINMENUS
#define INCL_WINSYS
#define INCL_WINWINDOWMGR
#define INCL_WINCIRCULARSLIDER
#define INCL_WINMLE
#define INCL_WINSHELLDATA
#define INCL_MCIOS2
#include <os2.h>
#include <os2me.h>
#include "config.h"
#include "controls.h"
#include "instrum.h"
#include "playmidi.h"
#include "output.h"
#include "pm_c.h"

extern MCI_AMP_OPEN_PARMS AmpOpenParms;
HWND Frame;
HAB Timidab,
    PMab;
HMQ Timidmq,
    PMmq;
HWND FILELISTBOXwin,
     PLAYwin,
     PAUSEwin,
     STOPwin,
     FILENAMETEXTwin,
     AUTOPLAYwin,
     CURRTIMEwin,
     TOTALTIMEwin,
     POSSLIDERwin,
     RESTARTwin,
     SKIPwin,
     BACKwin,
     PREVwin,
     FFWDwin,
     INFO_TEXTwin;
   /*     VOLUMEwin,
     BUFFLEFTwin,
     PRIORITYwin;*/
HEV pausesem;
int paused = 0;
MCI_GENERIC_PARMS GenericParms = {0};
unsigned int currtime;
int oldtime,
    sliderwidth,
    maxtime,
    maxtimidtime,
    drawticks = 0,
    timeoffset=0,
    manualslide=1,
   /*    manualvolume=1,*/
    playing=0,
    sectime,
    mintime,
    thinghidden=0,
    infoboxshown=0;
POINTL tickorg;
MCI_STATUS_PARMS gettimeparms = {NULLHANDLE,0,MCI_STATUS_POSITION,0};
USHORT mmos2DeviceID;
extern int numout;
extern PTIB ptib;
typedef struct {
   void *next;
   char line[200];
} msgnode;
msgnode *msgstart=NULL;
msgnode *msgend=NULL;
char mleio[200];
IPT point;
LONG logotime;

#define PLAY_DART 1
#define PLAY_MMOS2 2

#define UM_EXIT (WM_USER+1)
#define UM_PLAY (WM_USER+2)
#define UM_PAUSE (WM_USER+3)
#define UM_STOP (WM_USER+4)
#define UM_RESTART (WM_USER+5)
#define UM_SKIP (WM_USER+6)
#define UM_JUMPTO (WM_USER+7)
#define UM_PREV (WM_USER+8)
#define UM_STEP (WM_USER+9)
#define UM_VOLUME (WM_USER+10)
#define UM_MMOS2_DONE (WM_USER+11)
#define UM_RESUME (WM_USER+12)

unsigned int muldiv(unsigned int a, unsigned int b, unsigned int c);

static void ctl_refresh(void) {}
static void ctl_total_time(int tt);
static void ctl_master_volume(int mv);
static void ctl_file_name(char *name);
static void ctl_current_time(int ct) {}
static void ctl_note(int v) {}
static void ctl_program(int ch, int val) {}
static void ctl_volume(int channel, int val) {}
static void ctl_expression(int channel, int val) {}
static void ctl_panning(int channel, int val) {}
static void ctl_sustain(int channel, int val) {}
static void ctl_pitch_bend(int channel, int val) {}
static void ctl_reset(void) {}
static int ctl_open(int using_stdin, int using_stdout);
static void ctl_close(void);
static int ctl_read(int32 *valp);
static int cmsg(int type, int verbosity_level, char *fmt, ...);
static void ctl_pass_playing_list(int number_of_files, char *list_of_files[]);

#define ctl pm_control_mode

ControlMode ctl= 
{
  "OS/2-PM interface", 'p',
  1,0,0,
  ctl_open, ctl_pass_playing_list, ctl_close, ctl_read, cmsg,
  ctl_refresh, ctl_reset, ctl_file_name, ctl_total_time, ctl_current_time, 
  ctl_note, 
  ctl_master_volume, ctl_program, ctl_volume, 
  ctl_expression, ctl_panning, ctl_sustain, ctl_pitch_bend
};

MRESULT AboutProc(HWND wnd, ULONG msg, MPARAM mp1, MPARAM mp2) {
   switch (msg) {
   case WM_INITDLG:
      if (logotime!=-1) WinStartTimer(PMab,wnd,667,logotime);
      return FALSE;
   case WM_TIMER:
      WinPostMsg(wnd,WM_CLOSE,0,0);
      return 0;
   case WM_CLOSE:
      WinStopTimer(PMab,wnd,667);
   }
   return (WinDefDlgProc(wnd,msg,mp1,mp2));  
}

MRESULT InfoProc(HWND wnd, ULONG msg, MPARAM mp1, MPARAM mp2) {
   msgnode *curr;
   int length;
   
   switch (msg) {
   case WM_INITDLG:
      INFO_TEXTwin=WinWindowFromID(wnd,INFO_TEXT);
      WinSendMsg(INFO_TEXTwin,MLM_SETIMPORTEXPORT,MPFROMP(mleio),MPFROMLONG(122));
      curr=msgstart;
      point=-1;
      while (curr) {
	 length=strlen(strcpy(mleio,curr->line));
	 mleio[length]='\r';
	 mleio[length+1]=' ';
	 mleio[length+2]='\0';
	 WinSendMsg(INFO_TEXTwin,MLM_IMPORT,MPFROMP(&point),MPFROMLONG(length+2));
	 curr=curr->next;
      }
      infoboxshown=1;
      return FALSE;
   case WM_CLOSE:
      infoboxshown=0;
      break;
   }
   return (WinDefDlgProc(wnd,msg,mp1,mp2));
}

MRESULT DialogProc(HWND wnd, ULONG msg, MPARAM mp1, MPARAM mp2) {
   SHORT item;
   char *filename;
   HWND dialogwin;
   static FILEDLG fileDlg = {sizeof(FILEDLG),FDS_OPEN_DIALOG | FDS_MULTIPLESEL,
			     0,0,0,"File Open",NULL,NULL,NULL,NULL,NULL,NULL,
			     NULLHANDLE,"*",NULL,0,0,0,0,0};
   static LBOXINFO ListboxInfo = {LIT_END,0,0,0};
   char timestr[7];
   POINTL pnt;
   int even;
   LONG loop;
   int currsec,
       currpos;
   static int oldsec,
              oldpos;
   
   switch (msg) {
   case WM_CLOSE:
      WinPostMsg(Frame,WM_QUIT,0,0);
      break;
   case WM_CONTROL:
      if (mp1==MPFROM2SHORT(FILELISTBOX,LN_ENTER)) {
	 item=SHORT1FROMMR(WinSendMsg(FILELISTBOXwin,LM_QUERYSELECTION,
				      MPFROMSHORT(LIT_FIRST),0));
	 filename=malloc(100);
	 WinSendMsg(FILELISTBOXwin,LM_QUERYITEMTEXT,MPFROM2SHORT(item,100),
		    filename);
	 WinPostQueueMsg(Timidmq,UM_PLAY,filename,MPFROMLONG(item));
	 return 0;
      }
      if (mp1==MPFROM2SHORT(POSSLIDER,SLN_CHANGE) && manualslide) {
	 WinPostQueueMsg(Timidmq,UM_JUMPTO,mp2,0);
	 return 0;
      }
      /*      if (mp1==MPFROM2SHORT(VOLUME,CSN_CHANGED) && manualvolume) {
	 WinPostQueueMsg(Timidmq,UM_VOLUME,mp2,0);
	 return 0;
      }*/
      break;
   case WM_COMMAND:
      switch (SHORT1FROMMP(mp1)) {
      case PLAY:
	 item=SHORT1FROMMR(WinSendMsg(FILELISTBOXwin,LM_QUERYSELECTION,
				      MPFROMSHORT(LIT_FIRST),0));
	 filename=malloc(100);
	 WinSendMsg(FILELISTBOXwin,LM_QUERYITEMTEXT,MPFROM2SHORT(item,100),
		    filename);
	 WinPostQueueMsg(Timidmq,UM_PLAY,filename,MPFROMLONG(item));
	 return 0;
      case PAUSE:
	 if (playing==PLAY_DART) {
	    if (paused)
	       DosPostEventSem(pausesem);
	    else {
	       DosResetEventSem(pausesem,&loop);
	       WinPostQueueMsg(Timidmq,UM_PAUSE,0,0);
	    }
	 }
	 paused=!paused;
	 if (playing==PLAY_DART) {
	    mciSendCommand(AmpOpenParms.usDeviceID,paused?MCI_PAUSE:MCI_RESUME,
			   MCI_WAIT,&GenericParms,0);
	 }
	 if (playing==PLAY_MMOS2) {
	    WinPostQueueMsg(Timidmq,paused?UM_PAUSE:UM_RESUME,0,0);
	 }
	 WinSetWindowText(PAUSEwin,paused?"Res~ume":"Pa~use");
	 return 0;
      case STOP:
	 WinPostQueueMsg(Timidmq,UM_STOP,0,0);
	 return 0;
      case OPEN:
	 dialogwin=WinFileDlg(HWND_DESKTOP,Frame,&fileDlg);
	 if (fileDlg.lReturn==DID_OK) {
	    ListboxInfo.ulItemCount=fileDlg.ulFQFCount;
	    WinSendMsg(FILELISTBOXwin,LM_INSERTMULTITEMS,&ListboxInfo,
		       fileDlg.papszFQFilename);
	 }
	 return 0;
      case RESTART:
	 WinPostQueueMsg(Timidmq,UM_RESTART,0,0);
	 return 0;
      case SKIP:
	 WinPostQueueMsg(Timidmq,UM_SKIP,0,0);
	 return 0;
      case PREV:
	 WinPostQueueMsg(Timidmq,UM_PREV,0,0);
	 return 0;
      case FFWD:
	 WinPostQueueMsg(Timidmq,UM_STEP,MPFROMSHORT(TRUE),0);
	 return 0;
      case BACK:
	 WinPostQueueMsg(Timidmq,UM_STEP,MPFROMSHORT(FALSE),0);
	 return 0;
      case INFOBUTTON:
	 WinLoadDlg(HWND_DESKTOP,HWND_DESKTOP,InfoProc,NULLHANDLE,INFO,
		    NULL);
	 return 0;
      }
      break;
   case WM_TIMER:
      /*      WinSetWindowText(BUFFLEFTwin,_itoa(numout,timestr,10));
      WinSetWindowText(PRIORITYwin,_ultoa(ptib->tib_ptib2->tib2_ulpri,timestr,10));*/
      if (playing==PLAY_MMOS2) {
	 mciSendCommand(mmos2DeviceID,MCI_STATUS,
			MCI_WAIT | MCI_STATUS_ITEM,&gettimeparms,0);
	 currtime=gettimeparms.ulReturn;
      }
      if (SHORT1FROMMP(mp1)==666 && currtime!=oldtime) {
	 currsec=((currtime/sectime) % 60);
	 if (currsec!=oldsec) {	    
	    sprintf(timestr,"%d:%02d",currtime/mintime,currsec);
	    WinSetWindowText(CURRTIMEwin,timestr);
	    oldsec=currsec;
	 }
	 currpos=muldiv(currtime,sliderwidth,maxtime);
	 if (currpos!=oldpos) {
	    manualslide=0;
	    WinSendMsg(POSSLIDERwin,SLM_SETSLIDERINFO,
		       MPFROM2SHORT(SMA_SLIDERARMPOSITION,SMA_RANGEVALUE),
		       MPFROMLONG(currpos));
	    manualslide=1;
	    oldpos=currpos;
	 }
	 oldtime=currtime;
      }
      return 0;
   case WM_DRAWITEM:
      if (SHORT1FROMMP(mp1)==POSSLIDER && drawticks && ((POWNERITEM)mp2)->idItem==SDA_BACKGROUND) {
	 WinFillRect(((POWNERITEM)mp2)->hps,&((POWNERITEM)mp2)->rclItem,
		     SYSCLR_DIALOGBACKGROUND);
	 GpiSetColor(((POWNERITEM)mp2)->hps,CLR_BLACK);
	 loop=0;
	 even=1;
	 while (loop<=maxtime) {
	    pnt.x=tickorg.x+muldiv(loop,sliderwidth,maxtime);
	    pnt.y=tickorg.y;
	    GpiMove(((POWNERITEM)mp2)->hps,&pnt);
	    pnt.y-=even?5:3;
	    GpiLine(((POWNERITEM)mp2)->hps,&pnt);
	    even=!even;
	    loop+=mintime >> 1;
	 }
	 return MRFROMLONG(TRUE);
      } else return FALSE;
   case MM_MCINOTIFY:
      WinPostQueueMsg(Timidmq,msg,mp1,mp2);
      return 0;
   case MM_MCIPASSDEVICE:
      if (AmpOpenParms.usDeviceID==SHORT1FROMMP(mp1) && playing==PLAY_DART) {
	 if (SHORT1FROMMP(mp2)==MCI_GAINING_USE) {
	    mciSendCommand(AmpOpenParms.usDeviceID,MCI_ACQUIREDEVICE,MCI_WAIT,
			   &GenericParms,0);
	    DosPostEventSem(pausesem);
	    paused=0;
	 } else {
	    DosResetEventSem(pausesem,&loop);
	    WinPostQueueMsg(Timidmq,UM_PAUSE,0,0);
	    paused=1;
	 }
	 return 0;
      }
      break;
   case WM_MINMAXFRAME:
      if (thinghidden) {
	 WinShowWindow(BACKwin,TRUE);
	 thinghidden=0;
	 return FALSE;
      }
      if ((((PSWP)mp1)->fl & SWP_MINIMIZE) && !thinghidden) {
	 WinShowWindow(BACKwin,FALSE);
	 thinghidden=1;
	 return FALSE;
      }
      break;
   }
   return (WinDefDlgProc(wnd,msg,mp1,mp2));
}

void pmmain() {
   QMSG     qmsg;
   MRESULT  messret;
   ULONG junk;

   PMab=WinInitialize(0);
   PMmq=WinCreateMsgQueue(PMab,0);
   logotime=PrfQueryProfileInt(HINI_PROFILE,"PM_ControlPanel",
			       "LogoDisplayTime",0);
   if (logotime) WinDlgBox(HWND_DESKTOP,HWND_DESKTOP,AboutProc,NULLHANDLE,
			   DLG_ABOUT,NULL);
   Frame=WinLoadDlg(HWND_DESKTOP,HWND_DESKTOP,DialogProc,NULLHANDLE,MAINWIN,
		    NULL);
   FILELISTBOXwin=WinWindowFromID(Frame,FILELISTBOX);
   DosPostEventSem(pausesem);
   PLAYwin=WinWindowFromID(Frame,PLAY);
   PAUSEwin=WinWindowFromID(Frame,PAUSE);
   STOPwin=WinWindowFromID(Frame,STOP);
   RESTARTwin=WinWindowFromID(Frame,RESTART);
   SKIPwin=WinWindowFromID(Frame,SKIP);
   BACKwin=WinWindowFromID(Frame,BACK);
   PREVwin=WinWindowFromID(Frame,PREV);
   FFWDwin=WinWindowFromID(Frame,FFWD);
   FILENAMETEXTwin=WinWindowFromID(Frame,FILENAMETEXT);
   AUTOPLAYwin=WinWindowFromID(Frame,AUTOPLAY);
   CURRTIMEwin=WinWindowFromID(Frame,CURRTIME);
   TOTALTIMEwin=WinWindowFromID(Frame,TOTALTIME);
   POSSLIDERwin=WinWindowFromID(Frame,POSSLIDER);
   /*   BUFFLEFTwin=WinWindowFromID(Frame,BUFFLEFT);
   PRIORITYwin=WinWindowFromID(Frame,PRIORITY);*/
   sliderwidth=SHORT2FROMMR(WinSendMsg(POSSLIDERwin,SLM_QUERYSLIDERINFO,
				       MPFROM2SHORT(SMA_SLIDERARMPOSITION,
						    SMA_RANGEVALUE),0))-1;
   messret=WinSendMsg(POSSLIDERwin,SLM_QUERYTICKPOS,MPFROMSHORT(0),0);
   tickorg.x=SHORT1FROMMR(messret);tickorg.y=SHORT2FROMMR(messret);
   /*   VOLUMEwin=WinWindowFromID(Frame,VOLUME);
   WinSendMsg(VOLUMEwin,CSM_SETRANGE,MPFROMSHORT(0),MPFROMSHORT(100));
   WinSendMsg(VOLUMEwin,CSM_SETINCREMENT,MPFROMSHORT(10),MPFROMSHORT(2));
   WinSendMsg(VOLUMEwin,CSM_SETVALUE,MPFROMSHORT(amplification),0);*/
   WinSendMsg(Frame,WM_SETICON,(MPARAM)WinLoadPointer(HWND_DESKTOP,
              NULLHANDLE,MAINWIN),NULL);
   while(WinGetMsg(PMab,&qmsg,(HWND)NULL,0,0))
      WinDispatchMsg(PMab,&qmsg);
   DosResetEventSem(pausesem,&junk);
   WinPostQueueMsg(Timidmq,UM_EXIT,0,0);
   WinDismissDlg(Frame,TRUE);
   if (infoboxshown) WinDismissDlg(INFO_TEXTwin,TRUE);
   WinDestroyMsgQueue(PMmq);
   WinTerminate(PMab);
   if (DosWaitEventSem(pausesem,10000)==640) {
/*      WinMessageBox(HWND_DESKTOP,NULLHANDLE,
		    "The Timidity thread is not responding because of some bug in the program. However, the program will force itself to end.",
		    "Timidity for OS/2",0,MB_OK | MB_ERROR | MB_MOVEABLE);
      WinDestroyMsgQueue(PMmq);
      WinTerminate(PMab);*/
      DosExit(EXIT_PROCESS,0);
   }
}

int playmmos2file(char *filename) {
   MCI_AMP_OPEN_PARMS mmos2openparms = {Frame,0,0,NULL,filename,NULL,NULL};
   MCI_PLAY_PARMS playparms = {Frame,0,0};
   MCI_GENERIC_PARMS genericparms = {Frame};
   MCI_SEEK_PARMS seekparms = {Frame,0};
   ULONG rc;
   QMSG qmsg;
   MCI_STATUS_PARMS mcistatusparms = {Frame,0,MCI_STATUS_LENGTH,0};
   char timestr[8];
   int returnval=0;

#define PLAYUSER 22   
   
   rc=mciSendCommand(0,MCI_OPEN,MCI_WAIT | MCI_OPEN_ELEMENT | MCI_READONLY,
		     &mmos2openparms,0);
   mmos2DeviceID=mmos2openparms.usDeviceID;
   WinSetWindowText(FILENAMETEXTwin,filename);
   rc=mciSendCommand(mmos2openparms.usDeviceID,MCI_STATUS,
		  MCI_WAIT | MCI_STATUS_ITEM,&mcistatusparms,0);
   if (rc==MCIERR_SUCCESS) return RC_ERROR;
   maxtime=mcistatusparms.ulReturn;
   sectime=3000;
   mintime=180000;
   sprintf(timestr,"%ld:%02ld",mcistatusparms.ulReturn/180000,
	   (mcistatusparms.ulReturn/3000)%60);
   WinSetWindowText(TOTALTIMEwin,timestr);
   drawticks=1;
   WinInvalidateRect(POSSLIDERwin,NULL,FALSE);
   playing=PLAY_MMOS2;
   rc=mciSendCommand(mmos2openparms.usDeviceID,MCI_PLAY,MCI_NOTIFY,&playparms,
		     PLAYUSER);
   do {
      WinWaitMsg(Timidab,0,0);
      WinPeekMsg(Timidab,&qmsg,NULLHANDLE,0,0,0);
      switch(qmsg.msg) {
      case MM_MCINOTIFY:
	 WinGetMsg(Timidab,&qmsg,NULLHANDLE,0,0);
	 if (qmsg.mp1==MPFROM2SHORT(MCI_NOTIFY_SUCCESSFUL,PLAYUSER)) {
	    returnval=RC_TUNE_END;
	 }
	 break;
      case UM_STOP:
	 WinGetMsg(Timidab,&qmsg,NULLHANDLE,0,0);
      case UM_EXIT:
	 returnval=RC_QUIT;
	 break;
      case UM_PLAY:
	 returnval=RC_LOAD_FILE;
	 break;
      case UM_RESTART:
	 WinGetMsg(Timidab,&qmsg,NULLHANDLE,0,0);
	 rc=mciSendCommand(mmos2openparms.usDeviceID,MCI_SEEK,
			   MCI_WAIT | MCI_TO_START,&seekparms,0);
	 if (!paused) rc=mciSendCommand(mmos2openparms.usDeviceID,MCI_PLAY,
					MCI_NOTIFY,&playparms,PLAYUSER);
	 break;
      case UM_SKIP:
	 WinGetMsg(Timidab,&qmsg,NULLHANDLE,0,0);
	 returnval=RC_NEXT;
	 break;
      case UM_JUMPTO:
	 WinGetMsg(Timidab,&qmsg,NULLHANDLE,0,0);
	 seekparms.ulTo=muldiv(LONGFROMMP(qmsg.mp1),maxtime,sliderwidth);
	 rc=mciSendCommand(mmos2openparms.usDeviceID,MCI_SEEK,
			   MCI_WAIT | MCI_TO,&seekparms,0);
	 if (!paused) rc=mciSendCommand(mmos2openparms.usDeviceID,MCI_PLAY,
					MCI_NOTIFY,&playparms,PLAYUSER);
	 break;
      case UM_PREV:
	 WinGetMsg(Timidab,&qmsg,NULLHANDLE,0,0);
	 returnval=RC_REALLY_PREVIOUS;
	 break;
      case UM_STEP:
	 WinGetMsg(Timidab,&qmsg,NULLHANDLE,0,0);
	 seekparms.ulTo=(currtime*3)+(SHORT1FROMMP(qmsg.mp1)?3000:-3000);
	 rc=mciSendCommand(mmos2openparms.usDeviceID,MCI_SEEK,
			   MCI_WAIT | MCI_TO,&seekparms,0);
	 if (!paused) rc=mciSendCommand(mmos2openparms.usDeviceID,MCI_PLAY,
					MCI_NOTIFY,&playparms,PLAYUSER);
	 break;
      case UM_PAUSE:
	 WinGetMsg(Timidab,&qmsg,NULLHANDLE,0,0);
	 rc=mciSendCommand(mmos2openparms.usDeviceID,MCI_PAUSE,MCI_WAIT,
			   &genericparms,0);
	 break;
      case UM_RESUME:
	 WinGetMsg(Timidab,&qmsg,NULLHANDLE,0,0);
	 rc=mciSendCommand(mmos2openparms.usDeviceID,MCI_PLAY,MCI_NOTIFY,
			   &playparms,PLAYUSER);
	 /*	 rc=mciSendCommand(mmos2openparms.usDeviceID,MCI_RESUME,MCI_WAIT,
			   &genericparms,0);*/
	 break;
      default:
	 WinGetMsg(Timidab,&qmsg,NULLHANDLE,0,0);      
      }
   } while (!returnval);
   mciSendCommand(mmos2openparms.usDeviceID,MCI_STOP,MCI_WAIT,
		  &genericparms,0);
   playing=0;
   rc=mciSendCommand(mmos2openparms.usDeviceID,MCI_CLOSE,MCI_WAIT,
		     &genericparms,0);
   return returnval;
}   

static void ctl_file_name(char *name) {
   WinSetWindowText(FILENAMETEXTwin,name);
}   
     
static void ctl_total_time(int tt) {
   char timestr[8];

   sprintf(timestr,"%ld:%02ld",tt/(play_mode->rate*60),(tt/play_mode->rate)%60);
   WinSetWindowText(TOTALTIMEwin,timestr);
   maxtimidtime=tt;
   maxtime=tt;
   sectime=play_mode->rate;
   if (!(play_mode->encoding & PE_MONO)) {sectime*=2; maxtime*=2;}
   if (play_mode->encoding & PE_16BIT) {sectime*=2; maxtime*=2;}
   mintime=60*sectime;
   drawticks=1;
   WinInvalidateRect(POSSLIDERwin,NULL,FALSE);
}

static int ctl_open(int using_stdin, int using_stdout) {
   Timidab=WinInitialize(0);
   Timidmq=WinCreateMsgQueue(Timidmq,0);
   DosCreateEventSem(NULL,&pausesem,0,FALSE);
   if (_beginthread(pmmain,NULL,64*1024,NULL)!=-1) ctl.opened=1;
   DosWaitEventSem(pausesem,-1);
   return 0;
}

static void ctl_master_volume(int mv) {
   /*   manualvolume=0;
   WinSendMsg(VOLUMEwin,CSM_SETVALUE,MPFROMLONG(mv),0);
   manualvolume=1;*/
}

static void ctl_close(void) {
   DosPostEventSem(pausesem);
   DosCloseEventSem(pausesem);
}

static int ctl_read(int32 *valp) {
   QMSG qmsg;
   
   if (WinPeekMsg(Timidab,&qmsg,NULLHANDLE,0,0,0)) {
      switch (qmsg.msg) {
      case UM_PAUSE:
	 WinGetMsg(Timidab,&qmsg,NULLHANDLE,0,0);
	 DosWaitEventSem(pausesem,-1);
	 return RC_NONE;
      case UM_STOP:
	 WinGetMsg(Timidab,&qmsg,NULLHANDLE,0,0);
      case UM_EXIT:
      case WM_QUIT:
	 return RC_QUIT;
      case UM_PLAY:
	 return RC_LOAD_FILE;
      case UM_RESTART:
	 WinGetMsg(Timidab,&qmsg,NULLHANDLE,0,0);
	 currtime=0;
	 return RC_RESTART;
      case UM_SKIP:
	 WinGetMsg(Timidab,&qmsg,NULLHANDLE,0,0);
	 return RC_NEXT;
      case UM_JUMPTO:
	 WinGetMsg(Timidab,&qmsg,NULLHANDLE,0,0);
	 *valp=muldiv(LONGFROMMP(qmsg.mp1),maxtimidtime,sliderwidth);
	 currtime=muldiv(LONGFROMMP(qmsg.mp1),maxtime,sliderwidth);
	 return RC_JUMP;
      case UM_PREV:
	 WinGetMsg(Timidab,&qmsg,NULLHANDLE,0,0);
	 return RC_REALLY_PREVIOUS;
      case UM_STEP:
	 WinGetMsg(Timidab,&qmsg,NULLHANDLE,0,0);
	 *valp=play_mode->rate;
	 currtime+=SHORT1FROMMP(qmsg.mp1)?1000:-1000;
	 return SHORT1FROMMP(qmsg.mp1)?RC_FORWARD:RC_BACK;
	 /*      case UM_VOLUME:
	 WinGetMsg(Timidab,&qmsg,NULLHANDLE,0,0);
	 *valp=LONGFROMMP(qmsg.mp1)-amplification;
	 return RC_CHANGE_VOLUME;*/
      default:
	 WinGetMsg(Timidab,&qmsg,NULLHANDLE,0,0);
      }
   }
   return RC_NONE;
}

void play(char *filename, int listpos) {
   int rc;
   
   WinEnableWindow(PAUSEwin,TRUE);
   WinEnableWindow(STOPwin,TRUE);
   WinEnableWindow(RESTARTwin,TRUE);
   WinEnableWindow(SKIPwin,TRUE);
   WinEnableWindow(BACKwin,TRUE);
   WinEnableWindow(PREVwin,TRUE);
   WinEnableWindow(FFWDwin,TRUE);
   currtime=0;
   WinStartTimer(Timidab,Frame,666,100);
   while (TRUE) {
      if (strstr(filename,".mid") || strstr(filename,".MID")) {
	 playing=PLAY_DART;
	 rc=play_midi_file(filename);
	 mciSendCommand(AmpOpenParms.usDeviceID,MCI_STOP,MCI_WAIT,
			&GenericParms,0);
	 playing=0;
      }
      else {
	 rc=playmmos2file(filename);
      }
      currtime=oldtime=0;
      WinSetWindowText(FILENAMETEXTwin,"");
      WinSetWindowText(CURRTIMEwin,"0:00");
      WinSetWindowText(TOTALTIMEwin,"0:00");
      manualslide=0;
      WinSendMsg(POSSLIDERwin,SLM_SETSLIDERINFO,
		 MPFROM2SHORT(SMA_SLIDERARMPOSITION,SMA_RANGEVALUE),0);
      manualslide=1;
      drawticks=0;
      WinInvalidateRect(POSSLIDERwin,NULL,FALSE);
      timeoffset=0;
      if (rc==RC_NEXT || rc==RC_REALLY_PREVIOUS || (rc==RC_TUNE_END && SHORT1FROMMR(WinSendMsg(AUTOPLAYwin,BM_QUERYCHECK,0,0))==1)) {
	 if (rc!=RC_REALLY_PREVIOUS) listpos++;
	 else
	    if (--listpos<0) listpos=SHORT1FROMMR(WinSendMsg(FILELISTBOXwin,LM_QUERYITEMCOUNT,0,0))-1;
	 WinSendMsg(FILELISTBOXwin,LM_QUERYITEMTEXT,
		    MPFROM2SHORT(listpos,100),filename);
	 if (*filename=='\0') {
	    listpos=0;
	    WinSendMsg(FILELISTBOXwin,LM_QUERYITEMTEXT,
		       MPFROM2SHORT(listpos,100),filename);
	 }
      } else {
	 WinStopTimer(Timidab,Frame,666);
	 free(filename);
	 WinEnableWindow(PAUSEwin,FALSE);
	 WinEnableWindow(STOPwin,FALSE);
	 WinEnableWindow(RESTARTwin,FALSE);
	 WinEnableWindow(SKIPwin,FALSE);
	 WinEnableWindow(BACKwin,FALSE);
	 WinEnableWindow(PREVwin,FALSE);
	 WinEnableWindow(FFWDwin,FALSE);
	 return;
      }
   } 
} 

static int cmsg(int type, int verbosity_level, char *fmt, ...) {
   msgnode *new;
   va_list ap;
   int length;
   char line[200];

   if ((type==CMSG_TEXT || type==CMSG_INFO || type==CMSG_WARNING) &&
       ctl.verbosity<verbosity_level) return 0;
   va_start(ap,fmt);
   vsprintf(line,fmt,ap);
   va_end(ap);
   new=malloc(sizeof(void *)+1+strlen(line));
   new->next=NULL;
   strcpy(new->line,line);
   if (msgend==NULL) msgstart=msgend=new;
   else {
      msgend->next=new;
      msgend=new;
   }
   if (infoboxshown) {
      length=strlen(strcpy(mleio,new->line));
      mleio[length]='\r';
      mleio[length+1]=' ';
      mleio[length+2]='\0';
      WinSendMsg(INFO_TEXTwin,MLM_IMPORT,MPFROMP(&point),MPFROMLONG(length+2));
   }      
   return 0;
}

static void ctl_pass_playing_list(int number_of_files, char *list_of_files[]) {
   LBOXINFO ListboxInfo = {LIT_END,number_of_files,0,0};
   QMSG     qmsg;

   /*   FILELISTBOXwin=WinWindowFromID(Frame,FILELISTBOX);*/
   WinPostMsg(FILELISTBOXwin,LM_INSERTMULTITEMS,&ListboxInfo,list_of_files);
   while (WinGetMsg(Timidab,&qmsg,NULLHANDLE,0,0)) {
      switch(qmsg.msg) {
      case UM_EXIT: return;
      case UM_PLAY:
	 play(qmsg.mp1,LONGFROMMP(qmsg.mp2));
	 break;
	 /*      case UM_VOLUME:
	 amplification=LONGFROMMP(qmsg.mp1);*/
      }
   }
}
