//==========================================================================
// THRDTSTS.CPP - routines that run thread tests (primes and graphics).
//==========================================================================
#include <windows.h>
#include <stdlib.h>

#include "thrdtsts.h"

UINT DoPrimesCalc(UINT uTotalPrimes, UINT uNumPrimesThisPass, LONG *pPrimesArray, UINT uNumCurrentPrimes)
{
	long lTestVal = 1L;

	long lModulus;

	BOOL bFactorFound = FALSE;

	UINT uFoundPrimes = uNumCurrentPrimes;

	UINT uTotalPrimesThisPass = 0;
	
	if(uFoundPrimes == 0)
	{
		// Giving ourselves a head start with 2 as first prime
		pPrimesArray[0] = 2;
		uFoundPrimes = 1;
		uTotalPrimesThisPass++;
	}
		
	// Calculate. primes using array as factors.
	while(1)
	{
		lTestVal += 2; // Skip even numbers.			

		bFactorFound = FALSE;

		for(UINT i = 0; i < uFoundPrimes; i++) 
		{
			lModulus = lTestVal % pPrimesArray[i];
			if(!lModulus)
			{		
				bFactorFound = TRUE;				
				break;
			}
		}
	
		if(!bFactorFound)
		{
			// Then it's a prime.
			pPrimesArray[uFoundPrimes] = lTestVal;
			uFoundPrimes++;
			uTotalPrimesThisPass++;
			if(uFoundPrimes >= uTotalPrimes || uTotalPrimesThisPass >= uNumPrimesThisPass)
				break;
		}
	}

	// Return total in whole array so we know when to stop.
	return uFoundPrimes;
}

UINT DoGraphics(HWND hwndDraw, UINT uTotalReps, UINT uRepsThisPass, UINT uCurrentReps)
{
	// Draws random shapes in specified window.
	// Uses specified number of repetitions unless
	// 0--then continue indefinitely.
	RECT rClient;
	
	int nLines;

	HPEN hpenOld;
	HBRUSH hbrOld;

	HPEN hpenNew;
	HPEN hbrNew;

	HDC hdc = GetDC(hwndDraw);
	
	GetClientRect(hwndDraw, &rClient);
	
	for(UINT i = 0; i < uRepsThisPass; i++)
	{
	 	// Draw random rectangle, random ellipse and random line.
	   hpenNew = CreatePen(PS_SOLID, 2, RGB(rand() % 256, rand() % 256, rand() % 256));  
	   hbrNew = CreateSolidBrush(RGB(rand() % 256, rand() % 256, rand() % 256));    
	             
		hpenOld = SelectObject(hdc, hpenNew);
		hbrOld = SelectObject(hdc, hbrNew);

		Rectangle(hdc, 
					 rand() % rClient.right,
					 rand() % rClient.bottom,
					 rand() % rClient.right,
					 rand() % rClient.bottom);
					 
		SelectObject(hdc, hpenOld);
		SelectObject(hdc, hbrOld);

		DeleteObject(hpenNew);
		DeleteObject(hbrNew);

		// New colors for ellipse.
		hpenNew = CreatePen(PS_SOLID, 2, RGB(rand() % 256, rand() % 256, rand() % 256));  
	   hbrNew = CreateSolidBrush(RGB(rand() % 256, rand() % 256, rand() % 256));    
	             
		hpenOld = SelectObject(hdc, hpenNew);
		hbrOld = SelectObject(hdc, hbrNew);

		Ellipse(hdc, 
					 rand() % rClient.right,
					 rand() % rClient.bottom,
					 rand() % rClient.right,
					 rand() % rClient.bottom);
					 
		SelectObject(hdc, hpenOld);
		SelectObject(hdc, hbrOld);

		DeleteObject(hpenNew);
		DeleteObject(hbrNew);
		
		MoveToEx(hdc, 
				 rand() % rClient.right,
				 rand() % rClient.bottom,
				 NULL);
			  
		// New colors for line.
		nLines = rand() % 10;
		for(int j = 0; j < nLines; j++)
		{		
			hpenNew = CreatePen(PS_SOLID, 2, RGB(rand() % 256, rand() % 256, rand() % 256));  
	             
			hpenOld = SelectObject(hdc, hpenNew);

			LineTo(hdc, 
				 rand() % rClient.right,
				 rand() % rClient.bottom);
					 
			SelectObject(hdc, hpenOld);
		
			DeleteObject(hpenNew);
		}

		if(uTotalReps)
		{
			if((i + uCurrentReps) >= uTotalReps)
				break;  // Max. reps completed; we're done.
		}
	}
	
	ReleaseDC(hwndDraw, hdc);

	return i + uCurrentReps;
}


