// thrdoptn.cpp : implementation file
//

#include "stdafx.h"
#include "thrdomtr.h"
#include "thrdoptn.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CThreadOptionsDlg dialog


CThreadOptionsDlg::CThreadOptionsDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CThreadOptionsDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CThreadOptionsDlg)
	m_nThreadCount = 0;
	m_strLogFilename = _T("");
	m_bLogOutput = FALSE;
	m_bUseWindowPerThread = FALSE;
	//}}AFX_DATA_INIT

	m_dwThreadPriorityClass = NORMAL_PRIORITY_CLASS; 
	m_nTestType = 1;
	m_bUseMutexObjects = TRUE;
}


void CThreadOptionsDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CThreadOptionsDlg)
	DDX_Text(pDX, IDC_THREAD_COUNT, m_nThreadCount);
	DDV_MinMaxInt(pDX, m_nThreadCount, 1, 64);
	DDX_Text(pDX, IDC_LOG_FILENAME, m_strLogFilename);
	DDV_MaxChars(pDX, m_strLogFilename, 255);
	DDX_Check(pDX, IDC_LOG_OUTPUT_CHECK, m_bLogOutput);
	DDX_Check(pDX, IDC_USE_WINDOW_PER_THREAD, m_bUseWindowPerThread);
	//}}AFX_DATA_MAP

	// Do-it-ourselves data transfer.
	if(pDX->m_bSaveAndValidate == FALSE)	
	{
		// Write member variables to controls.

		// Thread class.
	 	if(m_dwThreadPriorityClass == IDLE_PRIORITY_CLASS)
			CheckDlgButton(IDC_IDLE_TIME_THREADS, 1);
		else if(m_dwThreadPriorityClass == HIGH_PRIORITY_CLASS)
			CheckDlgButton(IDC_HIGH_PRIORITY_THREADS, 1);
		else if(m_dwThreadPriorityClass == REALTIME_PRIORITY_CLASS)
			CheckDlgButton(IDC_TIME_CRITICAL_THREADS, 1);
		else // Default to 'normal' priority.
			CheckDlgButton(IDC_NORMAL_PRIORITY_THREADS, 1);

		// Type of demo. to run.
		if(m_nTestType == 1)
		{
			CheckDlgButton(IDC_PRIMES_DEMO, 1);							
		}
		else if(m_nTestType == 2)
		{
			CheckDlgButton(IDC_FP_CALC_DEMO, 1);
		}
		else if(m_nTestType == 3)
		{
			CheckDlgButton(IDC_TIMED_GRAPHICS_DEMO, 1);
			CheckDlgButton(IDC_USE_WINDOW_PER_THREAD, TRUE);
			GetDlgItem(IDC_USE_WINDOW_PER_THREAD)->EnableWindow(FALSE);
		}
		else // I.e., m_nTestType == 4
		{
			CheckDlgButton(IDC_UNTIMED_GRAPHICS_DEMO, 1);
			CheckDlgButton(IDC_USE_WINDOW_PER_THREAD, TRUE);
			GetDlgItem(IDC_USE_WINDOW_PER_THREAD)->EnableWindow(FALSE);
		}

		// Mutex or critical sections.
		if(m_bUseMutexObjects)
			CheckDlgButton(IDC_USE_MUTEX_OBJECTS, 1);
		else
			CheckDlgButton(IDC_USE_CRITICAL_SECTIONS, 1);				
	}
	else
	{
		// Save controls to member variables.
		// Thread class.
		if(IsDlgButtonChecked(IDC_IDLE_TIME_THREADS))
			m_dwThreadPriorityClass = IDLE_PRIORITY_CLASS;
		else if(IsDlgButtonChecked(IDC_HIGH_PRIORITY_THREADS))
			m_dwThreadPriorityClass = HIGH_PRIORITY_CLASS;
		else if(IsDlgButtonChecked(IDC_TIME_CRITICAL_THREADS))
			m_dwThreadPriorityClass = REALTIME_PRIORITY_CLASS;
		else // Default to 'normal' priority.
			m_dwThreadPriorityClass = NORMAL_PRIORITY_CLASS;

		// Demo. test.
		if(IsDlgButtonChecked(IDC_PRIMES_DEMO))							
			m_nTestType = 1;
		else if(IsDlgButtonChecked(IDC_FP_CALC_DEMO))
			m_nTestType = 2;
		else if(IsDlgButtonChecked(IDC_TIMED_GRAPHICS_DEMO))
			m_nTestType = 3;
		else  // Then IDC_UNTIMED_GRAPHICS_DEMO.
			m_nTestType = 4;			

		// Mutex or critical sections.
		if(IsDlgButtonChecked(IDC_USE_MUTEX_OBJECTS))
			m_bUseMutexObjects = TRUE;
		else
			m_bUseMutexObjects = FALSE;
	}
}


BEGIN_MESSAGE_MAP(CThreadOptionsDlg, CDialog)
	//{{AFX_MSG_MAP(CThreadOptionsDlg)
	ON_BN_CLICKED(IDC_LOG_OUTPUT_CHECK, OnLogOutputCheck)
	ON_BN_CLICKED(IDC_BROWSE_LOG_BTN, OnBrowseLogBtn)
	ON_WM_VSCROLL()
	ON_BN_CLICKED(IDC_TIMED_GRAPHICS_DEMO, OnTimedGraphicsDemo)
	ON_BN_CLICKED(IDC_UNTIMED_GRAPHICS_DEMO, OnUntimedGraphicsDemo)
	ON_BN_CLICKED(IDC_PRIMES_DEMO, OnPrimesDemo)
	ON_BN_CLICKED(IDC_FP_CALC_DEMO, OnFpCalcDemo)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CThreadOptionsDlg message handlers

void CThreadOptionsDlg::OnLogOutputCheck() 
{
	// Enable or disable filename controls depending on whether
	// log option is enabled.
	int bEnabled = IsDlgButtonChecked(IDC_LOG_OUTPUT_CHECK);

	GetDlgItem(IDC_LOG_FILENAME)->EnableWindow(bEnabled);
	GetDlgItem(IDC_BROWSE_LOG_BTN)->EnableWindow(bEnabled);
}

BOOL CThreadOptionsDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	if(IsDlgButtonChecked(IDC_LOG_OUTPUT_CHECK))
	{
		GetDlgItem(IDC_LOG_FILENAME)->EnableWindow(TRUE);
		GetDlgItem(IDC_BROWSE_LOG_BTN)->EnableWindow(TRUE);
	}
	else
	{
		GetDlgItem(IDC_LOG_FILENAME)->EnableWindow(FALSE);
		GetDlgItem(IDC_BROWSE_LOG_BTN)->EnableWindow(FALSE);
	}
		
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CThreadOptionsDlg::OnBrowseLogBtn() 
{
	// Allow user to set a filename.
	CFileDialog BrowseFileDlg(FALSE, "*.txt", NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, "Log files (*.txt)|*.txt|All files (*.*)|*.*||");
	
	CString strNewPath;

	BrowseFileDlg.m_ofn.lpstrTitle = "Save Log File As";

	int rc = BrowseFileDlg.DoModal();

	if(rc)
	{
		strNewPath = BrowseFileDlg.GetPathName();
		GetDlgItem(IDC_LOG_FILENAME)->SetWindowText(strNewPath);
	}
}

void CThreadOptionsDlg::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	// Do 'spin-button' functionality for # of threads edit control.
	
	// ***Note that MFC v. 3.2 provides a Windows 95 CSpinButtonCtrl to 
	// do this for you.  (Using MFC 3.0 functionality for Visual C++ 2.0/2.1
	// users.)
	
	if(pScrollBar->GetDlgCtrlID() == IDC_SPIN_THREAD_COUNT)
	{
		int nNewThreadCount = GetDlgItemInt(IDC_THREAD_COUNT);
		
		if(nSBCode == SB_LINEDOWN)
			nNewThreadCount--;
		else if(nSBCode == SB_LINEUP)
			nNewThreadCount++;

		// Ensure range from 1 to 64.
		nNewThreadCount = max(nNewThreadCount, 1);
		nNewThreadCount = min(nNewThreadCount, 64);

		SetDlgItemInt(IDC_THREAD_COUNT, nNewThreadCount, FALSE);
				
		CEdit *ThreadCountEdit = (CEdit *)GetDlgItem(IDC_THREAD_COUNT);
		
		// Highlight all chars. inside edit control.
		ThreadCountEdit->SetSel(0, -1);
						
		// Give it the focus as well.
		ThreadCountEdit->SetFocus();
	}
	else
		CDialog::OnVScroll(nSBCode, nPos, pScrollBar);
}

void CThreadOptionsDlg::OnTimedGraphicsDemo() 
{
	// Must use window for this test.
	CheckDlgButton(IDC_USE_WINDOW_PER_THREAD, TRUE);
	GetDlgItem(IDC_USE_WINDOW_PER_THREAD)->EnableWindow(FALSE);
}

void CThreadOptionsDlg::OnUntimedGraphicsDemo() 
{
	// Must use window for this test.
	CheckDlgButton(IDC_USE_WINDOW_PER_THREAD, TRUE);
	GetDlgItem(IDC_USE_WINDOW_PER_THREAD)->EnableWindow(FALSE);
}


void CThreadOptionsDlg::OnPrimesDemo() 
{
	// Window is optional for this test.
	GetDlgItem(IDC_USE_WINDOW_PER_THREAD)->EnableWindow(TRUE);
}

void CThreadOptionsDlg::OnFpCalcDemo() 
{
	// Window is optional for this test.
	GetDlgItem(IDC_USE_WINDOW_PER_THREAD)->EnableWindow(TRUE);
}
