// THRDOMTR.H : Declares CMainWindow class for THRDOMTR.EXE application.

#ifndef __THRDOMTR_H__
#define __THRDOMTR_H__

#include "resource.h"

// 'Private' messages to signal threads have ended.
#define PM_THREAD_STATUS_MSG 			(WM_USER + 1)
#define PM_FILE_THREAD_ENDED 			(WM_USER + 2)
#define PM_START_THREAD_PROCESSING  (WM_USER + 3)

const long BUFF_SIZE = 4096;

typedef struct _FILETHREADPARAMS
{
	char szFileName[256];
	DWORD dwTotalBytes;
	HWND hwndParent;
	BOOL bIsAsync;
} FILETHREADPARAMS;

typedef struct _THREADPARAMS
{
	int nDemoType;
	BOOL bIsTimed;
	int nThreadNum;
	BOOL bUseWindow;
	BOOL bUseMutex;
	POINT ptWinStart;
	HWND hwndParent;
} THREADPARAMS;

/////////////////////////////////////////////////////////////////////////////

// CMainWindow:
// See THRDOMTR.cpp for the code to the member functions and the message map.
//
class CMainWindow : public CFrameWnd
{
public:
	CMainWindow();

	//{{AFX_MSG( CMainWindow )
	afx_msg void OnAbout();
	afx_msg void OnThreadDemoOptions();
	afx_msg void OnFileIOOptions();
	afx_msg void OnPaint();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnDoFileIODemo();
	afx_msg void OnDoThreadDemo();
	afx_msg void OnUpdateFileIODemo(CCmdUI* pCmdUI);
	afx_msg LRESULT OnThreadStatusMsg(WPARAM uUnused, LPARAM lpszMsg);
	afx_msg LRESULT OnFileThreadEnded(WPARAM uUnused, LPARAM lResult);
	afx_msg void OnUpdateFileIOOptions(CCmdUI* pCmdUI);
	afx_msg void OnUpdateThreadDemo(CCmdUI* pCmdUI);
	afx_msg void OnUpdateThreadDemoOptions(CCmdUI* pCmdUI);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnDestroy();
	//}}AFX_MSG
   
	void AddMsgToLB(CString& strMsg, BOOL bShowInStatusBarToo = TRUE);
	
	void AddMsgToLB(LPSTR lpszMsg, BOOL bShowInStatusBarToo = TRUE) {
		CString s = lpszMsg;  AddMsgToLB(s, bShowInStatusBarToo); }

	void ClearMsgsInLB(BOOL bClearInStatusBarToo = TRUE) {
			StatusLB.ResetContent(); StatusLB.UpdateWindow();
			if(bClearInStatusBarToo) { StatusBar.SetWindowText(""); 
				StatusBar.UpdateWindow(); }
		}

	void SetStatusMsg(CString& strMsg) { StatusBar.SetWindowText(strMsg.GetBuffer(255));
	 	StatusBar.UpdateWindow(); }

	void SetStatusMsg(LPSTR lpszMsg) { StatusBar.SetWindowText(lpszMsg);
	 	StatusBar.UpdateWindow(); }

	// Shows elapsed time in second panel...
	void SetTimeMsg(CString& strTime)  { StatusBar.SetPaneText(1, strTime.GetBuffer(255));
		StatusBar.UpdateWindow(); }
	void SetTimeMsg(LPSTR lpszTime)  { StatusBar.SetPaneText(1, lpszTime); 
		StatusBar.UpdateWindow(); }

	LPSTR GetElapsedTimeAsStr(DWORD dwEarlier, DWORD dwLater);
	void ShowElapsedTime(DWORD dwEarlier, DWORD dwLater);

	int cxTextWidth;
	int cyTextHeight;

	HANDLE hMutex;
	
	// Variables to track thread demo. settings.

	// For file I/O demo.
	BOOL bFileIODemoStarted;
	CString strWorkFileName;  // File for read/write test.
	BOOL bDoAsynchronousFileIO;  // False for synchronous.
	BOOL bDoFileWrite;  // FALSE = Do Read
	UINT uFileKB;
	HANDLE hThrdFileDemo;

	int cxScreen;
	int cyScreen;

	// For thread demo.
	BOOL bThreadDemoStarted;
	HANDLE hThrd[64]; 
	
	// Coordinate of most recent thread window.
	int xThrdWnd;
	int yThrdWnd;
	int cxThrdWnd;
	int cyThrdWnd;

	// Elapsed time.
	DWORD dwTimeStart;
	DWORD dwTimeStop;

	// For thread demo.
	int nThreadCount;
	int nThreadCountActual;  // How many threads we successfully created.
	int nTestType;
	DWORD dwThreadPriorityClass;
	BOOL bUseMutexObjects;  // FALSE = use Critical Sections.
	BOOL bUseWindowPerThread; 

	// For both.	
	BOOL bLogOutput;
	HFILE hfLogFile;	
	CString strLogFilename;
	
	// Controls in main window, needed to show demo. output
	CStatic StatusLBLabel;
	CListBox StatusLB;

	CStatusBar StatusBar;
	
	// Simple demo. error tracking.
	int nErrCode;
	CString sErrMsg;

	// These 'friend' procedures are used to run separate threads.
	friend void FileWriteThreadProc(void *pParams);
	friend void FileReadThreadProc(void *pParams);

	friend void ThreadDemoProc(void *pParams);
	
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

// CTheApp:
// See THRDOMTR.cpp for the code to the InitInstance member function.
//
class CTheApp : public CWinApp
{
public:
	virtual BOOL InitInstance();
};

/////////////////////////////////////////////////////////////////////////////

#endif // __THRDOMTR_H__
