// FPCALC.H -- Prototypes for floating point calculations.
#if !defined(_FPCALC_H)
	#define _FPCALC_H

#include <windows.h>

#ifdef __cplusplus
extern "C" {
#endif

// Called from THRDOMTR.CPP
UINT DoFloatingPointCalc(UINT uReps, UINT uRepsThisPass, UINT uCurrentReps);

// For complex numbers.
struct complex 
{ 
	float rp;
   float ip;             
};

// Functions used internally for calculations.
float Cos (float x);
void Uniform11(long iy, float yfl);	
void Exptab(int n, struct complex e[]);
void Fft( int n, struct complex z[], struct complex w[], struct complex e[], float sqrinv);
void Oscar(void);

#ifdef __cplusplus
}
#endif

#endif
