// fileopts.cpp : implementation file
//

#include <stdlib.h>

#include "stdafx.h"
#include "thrdomtr.h"
#include "fileopts.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFileDemoOptionsDlg dialog


CFileDemoOptionsDlg::CFileDemoOptionsDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CFileDemoOptionsDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFileDemoOptionsDlg)
	m_uFileKB = 0;
	m_strWorkFileName = _T("");
	//}}AFX_DATA_INIT

	m_bDoAsynchronousFileIO = TRUE;
	m_bDoFileWrite = TRUE;

}

void CFileDemoOptionsDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFileDemoOptionsDlg)
	DDX_Text(pDX, IDC_FILE_KB, m_uFileKB);
	DDV_MinMaxUInt(pDX, m_uFileKB, 1, 64000);
	DDX_Text(pDX, IDC_FILENAME, m_strWorkFileName);
	DDV_MaxChars(pDX, m_strWorkFileName, 255);
	//}}AFX_DATA_MAP

	// Do-it-ourselves data transfer.
	if(pDX->m_bSaveAndValidate == FALSE)	
	{
		// Write member variables to controls.
		if(m_bDoAsynchronousFileIO)
			CheckDlgButton(IDC_ASYNCH_FILE_IO, 1);
		else
			CheckDlgButton(IDC_SYNCH_FILE_IO, 1);

		if(m_bDoFileWrite)
			CheckDlgButton(IDC_WRITE_FILE, 1);
		else
			CheckDlgButton(IDC_READ_FILE, 1);
	}
	else
	{
		// Save control values to member variables.
		if(IsDlgButtonChecked(IDC_ASYNCH_FILE_IO))
			m_bDoAsynchronousFileIO = TRUE;
		else
			m_bDoAsynchronousFileIO = FALSE;
						
		if(IsDlgButtonChecked(IDC_WRITE_FILE))
			m_bDoFileWrite = TRUE;
		else
			m_bDoFileWrite = FALSE;			
	}
}


BEGIN_MESSAGE_MAP(CFileDemoOptionsDlg, CDialog)
	//{{AFX_MSG_MAP(CFileDemoOptionsDlg)
	ON_BN_CLICKED(IDC_READ_FILE, OnReadFile)
	ON_BN_CLICKED(IDC_WRITE_FILE, OnWriteFile)
	ON_BN_CLICKED(IDC_BROWSE_BTN, OnBrowseBtn)
	ON_WM_VSCROLL()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CFileDemoOptionsDlg message handlers

void CFileDemoOptionsDlg::OnReadFile() 
{
	// Enable read options and disable write options.
	GetDlgItem(IDC_FILENAME)->EnableWindow(TRUE);
	GetDlgItem(IDC_BROWSE_BTN)->EnableWindow(TRUE);

	GetDlgItem(IDC_FILE_KB)->EnableWindow(FALSE);
	GetDlgItem(IDC_SPIN_FILE_KB)->EnableWindow(FALSE);
}

void CFileDemoOptionsDlg::OnWriteFile() 
{
	// Disable read options and enable write options.
	GetDlgItem(IDC_FILENAME)->EnableWindow(FALSE);
	GetDlgItem(IDC_BROWSE_BTN)->EnableWindow(FALSE);

	GetDlgItem(IDC_FILE_KB)->EnableWindow(TRUE);
	GetDlgItem(IDC_SPIN_FILE_KB)->EnableWindow(TRUE);
}

BOOL CFileDemoOptionsDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	if(IsDlgButtonChecked(IDC_READ_FILE))
	{
		GetDlgItem(IDC_FILENAME)->EnableWindow(TRUE);
		GetDlgItem(IDC_BROWSE_BTN)->EnableWindow(TRUE);

		GetDlgItem(IDC_FILE_KB)->EnableWindow(FALSE);
		GetDlgItem(IDC_SPIN_FILE_KB)->EnableWindow(FALSE);
	}
	else
	{
		GetDlgItem(IDC_FILENAME)->EnableWindow(FALSE);
		GetDlgItem(IDC_BROWSE_BTN)->EnableWindow(FALSE);

		GetDlgItem(IDC_FILE_KB)->EnableWindow(TRUE);
		GetDlgItem(IDC_SPIN_FILE_KB)->EnableWindow(TRUE);
	}

	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CFileDemoOptionsDlg::OnBrowseBtn() 
{
	// Allow user to set filename to read in.
	CFileDialog BrowseFileDlg(TRUE, "*.*", NULL, OFN_HIDEREADONLY | OFN_FILEMUSTEXIST, "All files (*.*)|*.*||");
	
	CString strNewPath;

	int rc = BrowseFileDlg.DoModal();

	if(rc)
	{
		strNewPath = BrowseFileDlg.GetPathName();
		GetDlgItem(IDC_FILENAME)->SetWindowText(strNewPath);
	}
}

void CFileDemoOptionsDlg::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	// Do 'spin-button' functionality for KB control.
	
	// ***Note that MFC v. 3.2 provides a Windows 95 CSpinButtonCtrl to 
	// do this for you.  (Using MFC 3.0 functionality for Visual C++ 2.0/2.1
	// users.)
	
	if(pScrollBar->GetDlgCtrlID() == IDC_SPIN_FILE_KB)
	{
		int nNewKB = GetDlgItemInt(IDC_FILE_KB);

		nNewKB = (nNewKB / 4) * 4;

		if(nSBCode == SB_LINEDOWN)
			nNewKB -= 4;	
		else if(nSBCode == SB_LINEUP)
			nNewKB += 4;	 

		// Ensure positive result.
		nNewKB = max(nNewKB, 1);

		SetDlgItemInt(IDC_FILE_KB, nNewKB, FALSE);
				
		CEdit *FileKBEdit = (CEdit *)GetDlgItem(IDC_FILE_KB);
		
		// Highlight all chars. inside edit control.
		FileKBEdit->SetSel(0, -1);
						
		// Give it the focus as well.
		FileKBEdit->SetFocus();
	}
	else
		CDialog::OnVScroll(nSBCode, nPos, pScrollBar);
}
