*-----------------------
* INITHERM.PRG  by Michael Mostov, 1993
* Initializes Thermometer window.
*
* Created by Michael Mostov
* Idea is taken from YAG Codebook
* Interface is copied from Genscrn.Prg
*
* Parameters:
*  n_records - Number of records to process.  If omitted, defaults to RECCOUNT().
*  lcMessage - Message to print on top line of the thermometer
*                 Not needed.  Ignored if not sent\
*
*  USAGE: =initherm() or DO initherm
*
*  Works in Pair with UpdTherm()
***************************************

PARAMETERS n_records, lcmessage
PRIVATE parm
parm = PARAMETERS()
DO CASE
	CASE parm = 0
		lcmessage = ""
		n_records = RECCOUNT()
	CASE parm = 1
		** Find out which of 2 possible parameters passed.
		DO CASE
			CASE TYPE("n_records") = 'N'
				lcmessage = ""
			CASE TYPE("n_records") = 'C'
				lcmessage = n_records
				n_records = RECCOUNT()
		ENDCASE
ENDCASE

DO stoptherm  && Kill all related public varibles

PUBLIC  lnrecsdone, lnrecstodo, lnLastRecord
PUBLIC lcthermwidth
lcthermwidth = 0             && Thermometer width, needs to be public


DO acttherm WITH lcmessage

lnrecstodo = n_records
lnrecsdone = 0
lnLastRecord = 0

RETURN ""


*************************************


PROCEDURE acttherm
	PARAMETER mprompt
	IF PARAMETERS() = 0 .OR. TYPE("mprompt")<>"C"
		mprompt = ""
	ENDIF

	PUBLIC c_dlgface, c_dlgsize, c_dlgstyle
	c_dlgface = "MS Sans Serif"
	c_dlgsize = 8.000
	c_dlgstyle= "B"

	m.g_boxstrg = ['','','','','','','','','','','','','','','','']

	IF _windows
		IF TXTWIDTH(mprompt, c_dlgface, c_dlgsize, c_dlgstyle) > 43
			DO WHILE TXTWIDTH(mprompt+"...", c_dlgface, c_dlgsize, c_dlgstyle) > 43
				mprompt = LEFT(mprompt, LEN(mprompt)-1)
			ENDDO
		ENDIF

		DEFINE WINDOW thermomete ;
			AT  INT((SROW() - (( 5.615 * ;
			FONTMETRIC(1, c_dlgface, c_dlgsize, c_dlgstyle )) / ;
			FONTMETRIC(1, WFONT(1,""), WFONT( 2,""), WFONT(3,"")))) / 2), ;
			INT((SCOL() - (( 63.833 * ;
			FONTMETRIC(6, c_dlgface, c_dlgsize, c_dlgstyle )) / ;
			FONTMETRIC(6, WFONT(1,""), WFONT( 2,""), WFONT(3,"")))) / 2) ;
			SIZE 5.615,63.833 ;
			FONT c_dlgface, c_dlgsize ;
			STYLE c_dlgstyle ;
			NOFLOAT ;
			NOCLOSE ;
			NONE ;
			COLOR RGB(0, 0, 0, 192, 192, 192)
		MOVE WINDOW thermomete CENTER
		ACTIVATE WINDOW thermomete NOSHOW

		@ 0.5,3 SAY mprompt FONT c_dlgface, c_dlgsize STYLE c_dlgstyle
		**		@ 1.5,3 SAY m.text FONT c_dlgface, c_dlgsize STYLE c_dlgstyle
		@ 0.000,0.000 TO 0.000,63.833 ;
			COLOR RGB(255, 255, 255, 255, 255, 255)
		@ 0.000,0.000 TO 5.615,0.000 ;
			COLOR RGB(255, 255, 255, 255, 255, 255)
		@ 0.385,0.667 TO 5.231,0.667 ;
			COLOR RGB(128, 128, 128, 128, 128, 128)
		@ 0.308,0.667 TO 0.308,63.167 ;
			COLOR RGB(128, 128, 128, 128, 128, 128)
		@ 0.385,63.000 TO 5.308,63.000 ;
			COLOR RGB(255, 255, 255, 255, 255, 255)
		@ 5.231,0.667 TO 5.231,63.167 ;
			COLOR RGB(255, 255, 255, 255, 255, 255)
		@ 5.538,0.000 TO 5.538,63.833 ;
			COLOR RGB(128, 128, 128, 128, 128, 128)
		@ 0.000,63.667 TO 5.615,63.667 ;
			COLOR RGB(128, 128, 128, 128, 128, 128)
		@ 3.000,3.333 TO 4.231,3.333 ;
			COLOR RGB(128, 128, 128, 128, 128, 128)
		@ 3.000,60.333 TO 4.308,60.333 ;
			COLOR RGB(255, 255, 255, 255, 255, 255)
		@ 3.000,3.333 TO 3.000,60.333 ;
			COLOR RGB(128, 128, 128, 128, 128, 128)
		@ 4.231,3.333 TO 4.231,60.500 ;
			COLOR RGB(255, 255, 255, 255, 255, 255)
		lcThermwidth = 56.269

		SHOW WINDOW thermomete TOP
	ELSE

		DEFINE WINDOW thermomete;
			FROM INT((SROW()-6)/2), INT((SCOL()-57)/2) ;
			TO INT((SROW()-6)/2) + 6, INT((SCOL()-57)/2) + 57;
			DOUBLE COLOR SCHEME 5
		ACTIVATE WINDOW thermomete NOSHOW
		lcthermwidth = 50
		@ 0,3 SAY UPPER(mprompt)
		@ 2,1 TO 4,lcthermwidth+4 &g_boxstrg

		SHOW WINDOW thermomete TOP
	ENDIF
RETURN


	*************************************


PROCEDURE stoptherm
	IF WEXIST("thermomete")
		RELEASE WINDOW thermomete
		RELEASE lnrecsdone, lnrecstodo, lnLastRecord
		RELEASE lcthermwidth
		RELEASE c_dlgface, c_dlgsize, c_dlgsize
	ENDIF
RETURN

