*:*********************************************************************
*:
*:        TDBS Enhanced Text Reading Utility
*:
*:        Revision 1.0
*:        Written by Alan D. Bryant
*:        for eSoft, Inc.
*:        - included with TDBS to illustrate techniques.
*:
*:        Revision 1.1
*:        Modified by Tom Whittenburg
*:        for public release
*:        - updated to include support for non-ansi callers
*:
*:        Revision 1.2
*:        Modified by Jace Carlson
*:        for public release
*:        - updated to provide for increased error checking and cleanup
*:          and to demonstrateas modular programming design
*:
*:  Procs & Fncts: PINITREAD      - initialization
*:               : PREAD          - read & display text file
*:               : PPROMPT        - prompt user and accept input
*:               : XEXITREAD      - cleanup and exit
*:
*:          Calls: PINITREAD      (procedure in TEXTREAD.PRG)
*:               : PREAD          (procedure in TEXTREAD.PRG)
*:               : PPROMPT        (procedure in TEXTREAD.PRG)
*:               : XEXITREAD      (procedure in TEXTREAD.PRG)
*:
*:      Documented 06/03/96 at 22:29                SNAP!  version 4.01a
*:*********************************************************************

public gTimeout, gAnsi, gPriv, gLine, gOptdata
public vFile, vHandle, vSize, vDbf, pos, offset
public vStr, key, sel, rV5

*
* mainline
*
*

do while .t.
   
   private counter, page, lRead
   
   do pInitRead
   
   *
   * get starting offset, then calculate the percentage done
   *
   fseek vHandle moof 0
   percent = (moof * 100) / vSize
   
   counter = 1
   page = 1
   lRead = .t.
   
   *
   * start a loop for our file processing
   *
   do while .t.
      
      if lRead

         *
         * read the text file and display it
         *
         do pRead
         
         *
         * get our current file offset, then calculate the percentage done
         *
         fseek vHandle moof 0
         percent = (moof * 100) / vSize
         
         if rV5                                  && end of page
            counter = 1                           && reset counter
            vStr = "Page "+ltrim(str(page))+" ("+ltrim(str(percent))+"%)  <S>top, <P>revious Page, <D>ownload Text, <Enter> Continues."
         else
            vStr = "Page "+ltrim(str(page))+" (100%)  <S>top, <P>revious Page, <D>ownload Text."
         endif
         
      endif

      *
      * prompt the user for a command key
      *
      do pPrompt with vStr
      
      *
      * handle the prompt line selection
      *
      do case
         
         *
         * stop
         *
         case sel = "S"
           do xExitRead
         
         *
         * download then exit
         *
         case sel = "D"
            dotbbs type 1 optdata vFile+" /D/NBC/NB"
            do xExitRead
         
         *
         * previous page
         *
         case sel = "P"
            *
            * decrement our page counter (if possible) then goto that
            * record in our temp database
            *
            if page > 1
               page = page - 1
               goto page
               *
               * take the offset of that page, and move our pointer in the
               * text file there and then loop
               *
               fseek vHandle new FPOS 0
               if .not. rV5
                  counter = 1
               endif
               if gAnsi
                  @ 1,0 clear
               else
                  ?
                  ?
                  ?
               endif
               lRead = .t.
            else
               lRead = .f.
            endif
            loop
         
         *
         * <Enter>
         *
         case key = 13
            if rV5                          && if not end of file
               if gAnsi
                  @ 1,0 clear
               else
                  ?
                  ?
                  ?
               endif
               page = page + 1
               if reccount() < page
                  fseek vHandle scratch 0
                  append blank
                  replace FPOS with scratch
               endif
               lRead = .t.
               loop
            endif
         
         *
         * any other keypress and we should do nothing
         *
         otherwise
            lRead = .f.
            loop
         
      endcase                               && end of key selection
      
   enddo && end file read loop

   *
   * cleanup and exit
   *
   do xExitRead
   
enddo

*
* initialization
*
*!*********************************************************************
*!
*!      Procedure: PINITREAD
*!
*!      Called by: TEXTREAD.PRG                  
*!
*!          Calls: UANSI()        (function in TDBS)
*!               : UPRIV()        (function in TDBS)
*!               : ULINE()        (function in TDBS)
*!               : OPTDATA()      (function in TDBS)
*!
*!           Uses: &VDBF.DBF      
*!               : NEWSTRUC.DBF   
*!
*!*********************************************************************
procedure pInitRead
   store 240 to gTimeout
   store uansi() to gAnsi
   store upriv() to gPriv
   store uline() to gLine
   store optdata() to gOptdata

   * make temporary database filename based on unique line number
   *
   vDbf = "TR" + gLine + ".DBF"

   *
   * if an old version of that file exists, delete it
   *
   if file(vDbf)
      erase &vDbf
   endif

   *
   * create the database in real time
   *
   create newstruc
   use newstruc
   append blank
   replace field_name with "FPOS", field_type with "N", field_len with 10
   use
   create &vDbf from newstruc
   erase newstruc.dbf

   *
   * use the database we just created
   *
   use &vDbf

   *
   * look for filename in the opt data; it comes after the "&&"
   *
   offset = at(chr(38)+chr(38), gOptdata)
   vFile = trim(substr(gOptdata, offset + 3))

   *
   * set initial value for file position
   *
   pos = 0

   *
   * open the text file in read mode, and report an error if there was one
   *
   fopen vHandle (vFile) 10
   if vHandle = -1
      ? "Error: "+message(ferror())
      ? "File was: ["+vFile+"]"
      wait
      quit
   endif

   *
   * get the size of the file we're reading so we can display the
   * percentage done
   *
   vSize = fsize(vFile)

   *
   * do initial screen prep
   *
   if gAnsi
      clear
      set color to w+/r
      @ 0,0 clear to 0,79
      @ 0,1 say "Enhanced Text Reader - "+vFile
      set color to w/n
   else
      ?
      ?
      ? "Enhanced Text Reader - "+vFile
      ?
   endif

   *
   * get and store our initial file offset to our temp database
   *
   fseek vHandle pos 0
   append blank
   replace FPOS with pos

   *
   * set colors for the text
   *
   if gAnsi
      set color to w/n
   endif

return

*!*********************************************************************
*!
*!      Procedure: PPROMPT
*!
*!      Called by: TEXTREAD.PRG                  
*!
*!          Calls: XEXITREAD      (procedure in TEXTREAD.PRG)
*!
*!*********************************************************************
procedure pPrompt
   parameter vStr

   *
   * display the prompt line and wait for input
   *
   if gAnsi
      set color to w+/r
      @24, 0 say vStr
      ?? replicate(" ", 79 - len(vStr))
      set color to w/n
   else
      ? ""
      ? vStr
   endif
   key = inkey(gTimeout)
   if key = 0
      do xExitRead
   endif
   sel = upper(chr(key))

return

*!*********************************************************************
*!
*!      Procedure: PREAD
*!
*!      Called by: TEXTREAD.PRG                  
*!
*!          Calls: CRTRIM()       (function in TDBS)
*!
*!*********************************************************************
procedure pRead

   do while counter < 21

      *
      * read a line from the file
      *
      flread vHandle count displ

      *
      * if we actually read any characters, display them and loop
      *
      if count # 0
         ? crtrim(displ)
         counter = counter + 1
         rV5 = .t.
      else
         rV5 = .f.
         exit
      endif

   enddo

return

*!*********************************************************************
*!
*!      Procedure: XEXITREAD
*!
*!      Called by: TEXTREAD.PRG                  
*!               : PPROMPT        (procedure in TEXTREAD.PRG)
*!
*!*********************************************************************
procedure xExitRead
   *
   * close stuff and quit
   *
   fclose(vHandle)
   use
   erase &vDbf
   quit
return

* <eof> textread.prg

