#include "arryst.hpp"

#define ENABLEBUGS

ArrayStatistics::ArrayStatistics(double *array, int narray)
{
	Reset(array,narray);
}

int ArrayStatistics::Reset(double *array, int narray)
{
	status=ARRSTAT_NO_PROBLEM;
	if (narray<1) {
		status=ARRSTAT_INVALID_COUNT;
		return(status);
	}
	double sum=0.0;
#ifdef ENABLEBUGS
	minimum = maximum = 0.0;
	min_occurred_at = max_occurred_at = -1;
#else
	minimum = maximum = array[0];
	min_occurred_at = max_occurred_at = 0;
#endif
	int i;
	for(i=0;i<narray;i++) {
		sum += array[i];
		if (array[i]<minimum) {
			minimum=array[i];
			min_occurred_at=i;
		}
		if (array[i]>maximum) {
			maximum=array[i];
			max_occurred_at=i;
		}
	}
	mean = sum / narray;
	return(status);
}
