  #include 'common.ch'
  #include 'inkey.ch'
  static cNotice
  static cTitle

  memvar getlist

    *  Function  MainMenu           Ŀ
    *   Description: This is where you define YOUR menu               
    *   Called from: Your opening .PRG                                
    * 
function MenuDemo()
  *-- LOCAL VARIABLES 
  *-- declare local variables to match the arrays that you create
  local aTopMenu   := {}  // array that holds the Top Menu information
  local aInventory := {}  // }
  local aOrders    := {}  // }
  local aReports   := {}  // }   arrays that hold the sub menu
  local aSystem    := {}  // }
  local aSupport1  := {}  // }   and third level menu information
  local aSupport2  := {}  // }
  local aHistory   := {}  // }
  local aQuit      := {}  // }

  *-- PERSONALIZE THE MENU
  *-- Include your client's name, your name, either or none.
  *-- Available in registered version only.
  local cTitle   := "ABC Travel"       // name of your client
  local cNotice  := "Janus Software"   // your name on the menu

  *-- 
  *-- THE ESCAPE FUNCTION
  *-- Note the use of the Escape() function in the aQuit array.
  *-- This is an example of the flexibility the menu system.
  *-- It simply duplicates the action of the ESC key.
  *-- 

  *-- 
  *-- HOT KEYS
  *-- You can make any key a Hot Key.
  *-- Place a tilde (~) in front of any letter - it automatically
  *-- is colored in a highlight and the cursor jumps to that selection
  *-- 

  *-- 
  *-- MENU COLORS
  *-- Menu colors can be changed in the MENULIB.PRG. The full
  *-- source code is supplied in the registered version.
  *-- 


*-- TOP MENU
  *-- array that holds three pieces of information:
  *--               Display on menu   array of submenut items   Line 24 message
  *--             ------------------- ------------------------ --------------------------
  aTopMenu   := {{" ~Inventory      ",{|| SubMenu(aInventory)},"Main Inventory Maintenance"},;
                 {" Support ~Tables ",{|| SubMenu(aSupport1) },"Support Tables Maintenance"},;
                 {" ~Reports        ",{|| SubMenu(aReports)  },"Report Printing"},;
                 {" ~System         ",{|| SubMenu(aSystem)   },"Change System Settings"},;
                 {" ~Exit           ",{|| SubMenu(aQuit)     },"Close all Files and EXIT Program"}}

  *-- 
  *-- CONSISTENT SPACING
  *-- Note that the items listed under "Display on submenu" are all
  *-- the same length within the array.  This is important to ensure
  *-- a pleasing appearance.
  *-- It is not necessary to do this for aTopMenu (above). The spaces
  *-- are stripped out and padded by the MenuLib.
  *-- 

*-- INVENTORY
  *-- array that holds three pieces of information
  *--              Display on submenu       function call  Line 24 message
  *--             ------------------------ -------------- ---------------------------
  aInventory := {{" ~Master Inventory    ",{|| Nothing()},"Main Inventory Data Maintenance"} ,;
                 {" Issue/~Dispose Items ",{|| Nothing()},"Issue and Disposal of Items to Members"} ,;
                 {" ~Order Items        ",{|| ThirdMenu(aOrders)},"Menu of Order Entry Options"}}

  *-- 
  *-- THIRDMENU() FUNCTION
  *-- note "Order Items" above.
  *-- instead of calling a function, it calls another array that holds
  *-- the sub-sub menu information.
  *-- When you call the third menu function you should also identify on the
  *-- display line that there is a deeper level of options. The following
  *-- might be considered:
  *--  (chr16).    (chr175). Take care before using chr(26)
  *-- 

  aOrders    := {{" ~View or Create Orders      ",{|| Nothing()},"View or Create New Orders"} ,;
                 {" ~Receive an Order           ",{|| Nothing()},"Enter Data for a Received Order"} ,;
                 {" ~Order History              ",{|| Nothing()},"View History of Orders by Item"},;
                 {" ~Set Minimum Stock Levels   ",{|| Nothing()},"Set Low Stock Levels"},;
                 {" ~Calculate Low Stock Levels ",{|| Nothing()},"Calculate Low Stock Levels"}}

*-- REPORTS
  aReports   := {{" In~ventory Levels ",{|| Nothing()},"Print Detailed Inventory Report by Item Code with Values"} ,;
                 {" ~Diary Listing    ",{|| Nothing()},"Print Report of Diary Items (Issued items not yet picked up) "} ,;
                 {" ~Purchase Orders  ",{|| Nothing()},"Print Details of a Purchase Order"},;
                 {" ~Supplier Listing ",{|| Nothing()},"Print a Supplier Listing"},;
                 {" Search ~for a S/N ",{|| Nothing()},"Search for an Item by a Serial Number"},;
                 {" Disposal ~History ",{|| Nothing()},"Report of History of Items Disposed from Stock"},;
                 {" P~O History      ",{|| ThirdMenu(aHistory)},"Report Menu of Purchase Order History"}}

  aHistory   := {{" ~Price History for Supplier    ",{|| Nothing()},"View a Price History for a Specific Suppler"} ,;
                 {" Price History for an ~Item     ",{|| Nothing()},"View a Price History for a Specific Item"} ,;
                 {" Purchase Order ~Master Listing ",{|| Nothing()},"Master Listing of Purchase Orders"},;
                 {" Purchase Order ~Detail Listing ",{|| Nothing()},"Detail Listing of Purchase Orders"}}

*-- SYSTEM
  aSystem    := {{" Build ~New Indexes ",{|| Nothing()},"Build New Index Files and Pack all Databases"} ,;
                 {" ~Backup Data       ",{|| Nothing()},"Backup and Restore Data Tables"} ,;
                 {" ~Configure System  ",{|| Nothing()},"Configure System Parameters"}}

*-- SUPPORT
  aSupport1  := {{" ~Password Setup       ",{|| Nothing()},"Set Up a New Password"} ,;
                 {" ~Color Setup          ",{|| DoReDraw()},"Set Up Custom Colors"} ,;
                 {" ~User Data Table      ",{|| Nothing()},"Maintain User Table"},;
                 {" Security ~Levels      ",{|| Nothing()},"Maintain Security Level Table"},;
                 {" Support ~Data Tables ",{|| ThirdMenu(aSupport2)},"Menu of Support Data Tables"}}

  aSupport2  := {{" S~uppliers Table     ",{|| Nothing()},"Suppliers Table Maintenance"} ,;
                 {" Item ~Names Table    ",{|| Nothing()},"Item Name Picklist Table Maintenance"},;
                 {" Item ~Descriptions   ",{|| Nothing()},"Item Description Picklist Table Maintenance"},;
                 {" Disposal ~from Stock ",{|| Nothing()},"Disposal of Stock Picklist Table Maintenance"},;
                 {" Notice E~xtra Notes  ",{|| Nothing()},"Notice to Members Extra Notes Table Maintenance"},;
                 {" Ship ~To Addresses   ",{|| Nothing()},"Purchase Order Ship To Address Table Maintenance"},;
                 {" ~P.O. Instructions   ",{|| Nothing()},"Purchase Order Instructions Table Maintenance"}}

*-- EXIT
  *-- a simple Yes/No exit routine.
  aQuit      := {{ " ~Yes   ", {|| Endit() }, "Exit to DOS"}, ;
                 { " ~No    ", {|| Escape() }, "Return"}}

  *-- call library function TOPMENU and pass in the aTopMenu array
  *-- no need to pass in the cNotice/cTitle variables, the library
  *-- has it's own routine to determine these. (cNotice and cTitle
  *-- work only in the registered version.)
  TopMenu( aTopMenu )

  return nil

  /*  
  *-- TEMPLATE
  *-- copy this template several times and fill in the blanks to
  *-- create your own menu.

  aArray     := {{" ", {||  }," "} ,;
                 {" ", {||  }," "} ,;
                 {" ", {||  }," "} ,;
                 {" ", {||  }," "} ,;
                 {" ", {||  }," "} ,;
                 {" ", {||  }," "} ,;
                 {" ", {||  }," "} ,;
                 {" ", {||  }," "} ,;
                 {" ~Quit ",{|| Escape() }, "Return" }}
  *-- */

  *  Function  Nothing            Ŀ
  *   Description: dummy function                                   
  *   Called from: MainMenu                                         
  * 
static function nothing()

  local cOldColor   := SetColor("w/n")
  local cOldScreen  := SaveScreen()

  clear screen
  @ 10,0 say PadC("This would be one of your functions",80)
  inkey(0)

  SetColor(cOldColor)
  RestScreen(,,,,cOldScreen)

  return nil

  *  Function  Endit()            Ŀ
  *   Description: Your own application closing routines            
  *   Called from: MainMenu                                         
  * 
static function Endit()
  *-- put your own application closing routine here
  *-- i.e. file closing, updating system information, check for
  *-- backup etc.
  *-- our example merely closes databases, resets colors & quits to DOS

  dbcloseall()
  setcolor("W/N, W/N, , ,W/N")
  cls
  quit

  return nil


  *-- These 2 function MUST be left in
  *-- even if you are not using these features.
  *-- They are called from the tdsMENU.lib

function getNotice()
  return cNotice

function getTitle()
  return cTitle
