{
          
                
              The DoorKit!
              
             
The BBS Door Development Kit By The People - For The People!


   Feel free to modify or optimize this code at will. All I ask is that if
   find a better way to do things (and you will), please send me a copy of
   your modifications. Thanks in advance!....Larry L. Athey....}

{$G+,A+}
UNIT FOSUNIT;

INTERFACE

FUNCTION  F_Init(Comport : BYTE) : BOOLEAN;
PROCEDURE F_Close(Comport : BYTE);
PROCEDURE F_Parms(Comport : BYTE; Baud : WORD; DataBits : BYTE; Parity : CHAR; StopBit : BYTE);
PROCEDURE F_SendChar(Comport : BYTE; C : CHAR);
PROCEDURE F_Write(Comport : BYTE; S : STRING);
PROCEDURE F_Writeln(Comport : BYTE; S : STRING);
FUNCTION  F_ReadChar(Comport : BYTE) : CHAR;
PROCEDURE F_Dtr(Comport : BYTE; State : BOOLEAN);
PROCEDURE F_Flow(Comport : BYTE; State : BOOLEAN);
FUNCTION  F_CD(Comport : BYTE) : BOOLEAN;
PROCEDURE F_Kill_Out(Comport : BYTE);
PROCEDURE F_Kill_In(Comport : BYTE);
PROCEDURE F_Flush(Comport : BYTE);
FUNCTION  F_Avail(Comport : BYTE) : BOOLEAN;
FUNCTION  F_OkToSend(Comport : BYTE) : BOOLEAN;
FUNCTION  F_Empty(Comport : BYTE) : BOOLEAN;

IMPLEMENTATION

{}
FUNCTION F_Init(Comport : BYTE) : BOOLEAN; assembler;
asm
  mov  ah,4
  mov  dl,[comport]
  XOR  dh,dh
  DEC  dl
  XOR  bx,bx
  INT  14h
  cmp  ax,1954h
  jne  @@no
@@yes :
  mov  al,1
  jmp  @@EXIT
@@no :
  XOR  al,al
@@EXIT :
END;
{}
PROCEDURE F_Close(Comport : BYTE); assembler;
asm
  mov  ah,5
  mov  dl,[comport]
  XOR  dh,dh
  DEC  dl
  INT  14h
END;
{}
PROCEDURE F_Parms(ComPort : BYTE; Baud : WORD; DataBits : BYTE; Parity : CHAR; StopBit : BYTE);
VAR
  c : BYTE;
BEGIN
  IF baud = 0 THEN EXIT;
  c := 0;
  c := (databits - 5);                       {000000xx}
  c := c OR ((stopbit - 1)SHL 2);            {00000x00}
  CASE UPCASE(Parity) OF                     {000xx000}
   {'N': c:=c or $00;}
    'O' : c := c OR $08;
    'E' : c := c OR $18;
  END;
  CASE Baud OF                               {xxx00000}
    19200 : c := c OR $00;  {0000-0000}
    38400 : c := c OR $20;  {0010-0000}
    300   : c := c OR $40;  {0100-0000}
    600   : c := c OR $60;  {0110-0000}
    1200  : c := c OR $80;  {1000-0000}
    2400  : c := c OR $A0;  {1010-0000}
    4800  : c := c OR $C0;  {1100-0000}
    9600  : c := c OR $E0;  {1110-0000}
    ELSE IF baud > 38400 THEN c := c OR $20;
  END;
  asm
    XOR  ah,ah;
    mov  al,[c];
    mov  dl,[comport]
    XOR  dh,dh
    DEC  dx;
    INT  14h;
  END;
END;
{}
PROCEDURE F_Dtr(Comport : BYTE; State : BOOLEAN); assembler;
asm
  mov  ah,6
  mov  dl,[comport]
  XOR  dh,dh
  DEC  dl
  mov  al,[state]
  INT  14h
END;
{}
FUNCTION F_CD(Comport : BYTE) : BOOLEAN; assembler;
asm
  mov  ah,3
  mov  dl,[comport]
  XOR  dh,dh
  DEC  dl
  INT  14h
  mov  bl,al
  XOR  al,al
  AND  bl,80h
  cmp  bl,80h
  jne  @@EXIT
  INC  al
@@EXIT :
END;
{}
PROCEDURE F_Flow(Comport : BYTE; State : BOOLEAN); assembler;
asm
  mov  ah,0Fh
  mov  dl,[comport]
  XOR  dh,dh
  DEC  dl
  XOR  al,al
  cmp  [state],0
  je   @@off
  mov  al,255
@@off :
  INT  14h
END;
{}
PROCEDURE F_Kill_Out(Comport : BYTE); assembler;
asm
  mov  ah,9
  mov  dl,[comport]
  XOR  dh,dh
  DEC  dl
  INT  14h
END;
{}
PROCEDURE F_Kill_In(Comport : BYTE); assembler;
asm
  mov  ah,10
  mov  dl,[comport]
  XOR  dh,dh
  DEC  dl
  INT  14h
END;
{}
PROCEDURE F_Flush(Comport : BYTE); assembler;
asm
  mov  ah,8
  mov  dl,[comport]
  XOR  dh,dh
  DEC  dl
  INT  14h
END;
{}
FUNCTION  F_Avail(Comport : BYTE) : BOOLEAN; assembler;
asm
  mov  ah,3
  mov  dl,[comport]
  XOR  dh,dh
  DEC  dl
  INT  14h
  AND  ah,1
  mov  al,ah
END;
{}
FUNCTION  F_OkToSend(Comport : BYTE) : BOOLEAN; assembler;
asm
  mov  ah,3
  mov  dl,[comport]
  XOR  dh,dh
  DEC  dl
  INT  14h
  AND  ah,20h
  SHR  ah,5
  mov  al,ah
END;
{}
FUNCTION  F_Empty(Comport : BYTE) : BOOLEAN; assembler;
asm
  mov  ah,3
  mov  dl,[comport]
  XOR  dh,dh
  DEC  dl
  INT  14h
  AND  ah,40h
  SHR  ah,6
  mov  al,ah
END;
{}
PROCEDURE F_SendChar(Comport : BYTE; C : CHAR); assembler;
asm
  mov  ah,1
  mov  dl,[comport]
  XOR  dh,dh
  DEC  dl
  mov  al,[c]
  INT  14h
END;
{}
PROCEDURE F_Write(Comport : BYTE; S : STRING);
VAR
  i : BYTE;
BEGIN
  FOR i := 1 TO LENGTH(S) DO F_SendChar(Comport,S[i]);
END;
{}
PROCEDURE F_Writeln(Comport : BYTE; S : STRING);
BEGIN
  F_Write(comport,s);
  F_SendChar(ComPort,#13);
  F_SendChar(ComPort,#10);
END;
{}
FUNCTION F_ReadChar(Comport : BYTE) : CHAR; assembler;
asm
  mov  ah,2
  mov  dl,[comport]
  XOR  dh,dh
  DEC  dl
  INT  14h  {al=char}
END;
{}
END.
