DECLARE SUB wipe (mode%, switch$, Colr%, Speed%)

'Screen Clearing Routines
'by Tika Carr
'Donated to the Public Domain
'No warranties or guarantees are expressed or implied

'Here are some Screen Wipes to use in Multimedia and other applications.
'The horizontal and vertical blinds are rather slow, so if anyone comes
'up with a faster formula, do let me know! The routines may take longer
'at higher screen modes (like 9, which is 640 across).
'
'Its use is pretty much self-explainatory. First, you pass the video mode
'(supported are screens 9, 12 and 13). If the video mode passed isn't
'supported, it will default to the 320 x 200/256 mode and do a SCREEN 13
'command, which clears the screen to black without effect.
'
'The switch may seem the most difficult, but really isn't. Look at
'the comments in the DATA statements for more info. Basically, its
'wipetype/diretion where wipe types are vw, hw, dw, vb, hb and db
'and directions can be u, d, l & r combinations.

'The color is the number of the color to use, which depends on the video
'mode you are using. And speed controls the size and speed of the wipes.

SCREEN 13

'Wipe Demo

FOR i = 1 TO 18
    READ m%, s$, c%, p%
    wipe m%, s$, c%, p%
    SLEEP 2
NEXT

SCREEN 0, 0, 0, 0: WIDTH 80: COLOR 7, 0: CLS : END

'For most of these, the higher the number, the slower. Except where noted.

'Vertical Wipes
DATA 13,"vwrl",1,10
DATA 13,"vwlr",2,10

'Horizontal Wipes
DATA 13,"hwud",3,10
DATA 13,"hwdu",4,10

'Diagonal Wipes
DATA 13,"dwlrud",5,3:        'or "dwudlr"
DATA 13,"dwrlud",6,3:        'or "dwudrl"
DATA 13,"dwlrdu",7,3:        'or "dwdulr"
DATA 13,"dwrldu",8,3:        'or "dwdurl"

'Square Pixellite
DATA 13,"sp",9,2:           '10 x 10 squares (instead of "speed")

'Circle Pixellite
DATA 13,"cp",10,2:           'Radius of 10 circles (instead of "speed")

'For Horizontal and Vertical blinds, the lower the speed, the faster the
'display

'Vertical Blinds
DATA 13,"vbrl",11,3
DATA 13,"vblr",12,3

'Horizontal Blinds
DATA 13,"hbud",13,3
DATA 13,"hbdu",14,3

'Diagonal Blinds
DATA 13,"dblrud",35,3:        'or "dbudlr"
DATA 13,"dbrlud",45,3:        'or "dbudrl"
DATA 13,"dblrdu",55,3:        'or "dbdulr"
DATA 13,"dbrldu",65,3:        'or "dbdurl"

SUB wipe (mode%, switch$, Colr%, Speed%)

SELECT CASE mode%
    CASE 13: mx = 320: my = 200
    CASE 12: mx = 640: my = 480
    CASE 9: mx = 640: my = 350
    CASE ELSE: mx = 320: my = 200: SCREEN 13    'Default
END SELECT

switch$ = LCASE$(switch$)

SELECT CASE switch$
    CASE "vwlr": '*** Vertical Wipe - L/R (VWLR)
        FOR x = 0 TO mx STEP Speed%: FOR y = 0 TO my STEP Speed%
            LINE (xb, yb)-(x + Speed%, y + Speed%), Colr%, BF
            xb = x: yb = y
        NEXT y, x
    CASE "vwrl": '*** Vertical Wipe - R/L (VWRL)
        xb = mx: yb = my
        FOR x = mx TO 0 STEP -Speed%: FOR y = my TO 0 STEP -Speed%
            LINE (xb, yb)-(x - Speed%, y - Speed%), Colr%, BF
            xb = x: yb = y
        NEXT y, x
    CASE "hwdu": '*** Horizontal Wipe - D/U (HWDU)
        xb = mx: yb = my
        FOR y = my TO 0 STEP -Speed%: FOR x = mx TO 0 STEP -Speed%
            LINE (xb, yb)-(x - Speed%, y - Speed%), Colr%, BF
            xb = x: yb = y
        NEXT x, y
    CASE "hwud": '*** Horizontal Wipe - U/D  (HWUD)
        FOR y = 0 TO my STEP Speed%: FOR x = 0 TO mx STEP Speed%
            LINE (xb, yb)-(x + Speed%, y + Speed%), Colr%, BF
            xb = x: yb = y
        NEXT x, y
    CASE "dwlrud", "dwudlr": '*** Diagonal Wipe - L/R U/D  (DWLRUD)
        FOR i = 0 TO mx * 2: LINE (i, 0)-(0, i), Colr%: NEXT
    CASE "dwrldu", "dwdurl": '*** Diagonal Wipe - R/L D/U  (DWRLDU)
        FOR i = mx * 2 TO 0 STEP -1: LINE (i, 0)-(0, i), Colr%: NEXT
    CASE "dwlrdu", "dwdulr": '*** Diagonal Wipe - L/R D/U  (DWLRDU)
        x = mx: y = 0
        FOR i = mx * 2 TO 0 STEP -1: LINE (x, y + i)-(x - i, y), Colr%: NEXT
    CASE "dwrlud", "dwudrl": '*** Diagonal Wipe - R/L U/D  (DWRLUD)
        x = mx: y = 0
        FOR i = 0 TO mx * 2: LINE (x, y + i)-(x - i, y), Colr%: NEXT
    CASE "sp": '*** Square Pixellite     (SP)
        Cover = 50000 / Speed%
        FOR i = 1 TO Cover
            x = RND * mx: y = RND * my
            LINE (x, y)-(x + Speed%, y + Speed%), Colr%, BF
        NEXT
        LINE (0, 0)-(mx, my), Colr%, BF
    CASE "cp": '*** Circle Pixellite  (CP)
        Cover = 50000 / Speed%
        FOR i = 1 TO Cover
            x = RND * mx: y = RND * my
            CIRCLE (x, y), Speed%, Colr%: PAINT (x, y), Colr%, Colr%
        NEXT
        LINE (0, 0)-(mx, my), Colr%, BF
    CASE "vblr": '*** Vertical Blind - L/R  (VBLR)
        FOR i = 1 TO Speed%
        FOR x = 0 + (Speed% - i) TO mx STEP Speed%: FOR y = 0 TO my
            LINE (x, y)-(x, y), Colr%
        NEXT y, x, i
    CASE "vbrl": '*** Vertical Blind - R/L  (VBRL)
        FOR i = Speed% TO 1 STEP -1
        FOR x = mx + (Speed% - i) TO 0 STEP -Speed%: FOR y = 0 TO my
            LINE (x, y)-(x, y), Colr%
        NEXT y, x, i
    CASE "hbud": '*** Horizontal Blind - U/D   (HBUD)
        FOR i = 1 TO Speed%
        FOR y = 0 + (Speed% - i) TO my STEP Speed%: FOR x = 0 TO mx
            LINE (x, y)-(x, y), Colr%
        NEXT x, y, i
    CASE "hbdu": '*** Horizontal Blind - D/U   (HBDU)
        FOR i = Speed% TO 1 STEP -1
        FOR y = my + (Speed% - i) TO 0 STEP -Speed%: FOR x = 0 TO mx
            LINE (x, y)-(x, y), Colr%
        NEXT x, y, i
    CASE "dblrud", "dbudlr":  '*** Diagonal Blind - L/R U/D   (DBLRUD)
        FOR j = 1 TO Speed%: FOR i = 0 TO mx * 2 STEP Speed%
            LINE (i, j)-(j, i), Colr%
        NEXT i, j
        LINE (0, 0)-(mx, my), Colr%, BF  'get rid of rough edges
    CASE "dbrldu", "dbdurl": '*** Diagonal Blind - R/L D/U  (DBRLDU)
        FOR j = 1 TO Speed%: FOR i = mx * 2 TO 0 STEP -Speed%
            LINE (i, j)-(j, i), Colr%
        NEXT i, j
        LINE (0, 0)-(mx, my), Colr%, BF  'get rid of rough edges
    CASE "dblrdu", "dbdulr":  '*** Diagonal Blind - L/R D/U  (DBLRDU)
        x = mx: y = 0
        FOR j = 1 TO Speed%: FOR i = mx * 2 TO 0 STEP -Speed%
            LINE (x + j, y + i)-(x - i, y - j), Colr%
        NEXT i, j
    CASE "dbrlud", "dbudrl": '*** Diagonal Blind - R/L U/D   (DBRLUD)
        x = 0: y = my
        FOR j = 1 TO Speed%: FOR i = mx * 2 TO 0 STEP -Speed%
            LINE (x + i, y + j)-(x - j, y - i), Colr%
        NEXT i, j
END SELECT

END SUB

