' SBSOUND.BAS
' by Tika Carr
'
' Donated to the public domain
' No warranties or guarantees are expressed or implied.
'
' Purpose: Demonstrates how to make a sound using Sound Blaster
'
' Start QuickBasic with: QB /L QB.QLB
'
'
' Credits: Wouter Bergmann Tiest - QBasic SoundBlaster Documentation
'          Nancy Backus          - Note/Frequency & Tuning Information

DECLARE SUB WriteReg (r%, v%)
DEFINT A-Z

CONST BaseAddr = &H220
CONST DataReg = BaseAddr + 9, RegAddr = BaseAddr + 8

CLS

I = 1
DO UNTIL INSTR(ENVIRON$(I), "BLASTER") OR ENVIRON$(I) = "": I = I + 1: LOOP

'BaseReg = VAL(RIGHT$(MID$(ENVIRON$(i), INSTR(ENVIRON$(i), "=A"), 5), 3))
'IF BaseReg = 0 THEN PRINT "No Sound Card Found or Environment Variable not set.": END

'*** clear all registers
FOR I = 0 TO 224: WriteReg I, 0: NEXT

'*** start channel

'Change &H1 in the next line to change the instrument sound.
WriteReg &H20, &H1    'Plays carrier note at spcified octave ch. 1

'Change &H1 in the next line to change the instrument timbre or tonal sound.
WriteReg &H23, &H1    'Plays modulator note at specified octave ch. 1

'Changing &H1F in the next line also seems to change the tonal sound
WriteReg &H40, &H1F   'Set carrier total level to softest ch. 1

'The next one I can't figure out. But Guess best to leave at &H1.
WriteReg &H43, &H1    'Set modulator level to loudest ch. 1


'The next 2 lines lets you set how long to play the note, and its
'attack/decay rate. Original code had it set to &HE4. I found that the
'first 4 bits are what does it(ie, &HE0 - &HE9, etc.) &HE0 is the
'longest length and &HE9 is the shortest. I set this to make a steady tone.

'This line gives or takes the "bass-like" sound.
WriteReg &H60, &HE1 'Set carrier attack and decay ch. 1

'The second line is how long to hold the note, I think...
WriteReg &H63, &HE0 'Set modulator attack and decay ch. 1

'The next two lines are same as above, I guess, but with respect to
'Sustain and release.
WriteReg &H80, &H9D 'Set carrier sustain and release ch. 1
WriteReg &H83, &H9D 'Set modulator sustain and release ch. 1

'**************** The Frequency of Notes *********************
'
'     C                middle C   D   E   F   G   A              C
'     128 Hz           256 Hz                     440 Hz         512 Hz
'                                                   SB-A
'                                                   442/443 Hz

'Middle C is at 256 Hz. The C octaves are in the powers of 2.
'Normal A is at 440 Hz to 445 Hz. The Sound Card's A note is somewhere
'between 442 and 443 Hz.

'Play "A" note (at 442 - 443 Hz)
'&HA0 (Decimal 160) is between 442 and 443 Hz.
'&HA1 (Decimal 161) is one whole note below A (ie. a "G" note)
'but so is &H9F (decimal 159) a G note.

'&H41 (decimal 65) actually changes the PITCH (Frequency) of the note!
'Change &H41 to &H30 (decimal 48) and leave &HA0 the same. Notice the change!

WriteReg &HA0, &H41         'Set note number

'Change the &H22 in the next line to make the octive go higher/lower
WriteReg &HB0, &H22 + 4 * 2 'Set base + 4 * octave and turn on voice

time! = TIMER: duration! = 1
DO: LOOP WHILE time! + duration! > TIMER    'wait as long as duration

WriteReg &HB0, 0    'Turn off voices

DEFSNG A-Z
SUB WriteReg (r%, v%)
OUT RegAddr, r%
OUT DataReg, v%
END SUB

