' Passing Records by Reference
' by Tika Carr
' May 7, 1997
'
' Notice how you can pass a record to a sub and have it returned changed.
' Another useful way to eliminate the need for global variables! And, you
' won't need to worry about that record being altered by any other routine
' other than the one that is supposed to alter it.

DECLARE SUB another ()
DECLARE SUB test (ret AS ANY, flag$)

DEFINT A-Z

TYPE inftst
  x AS INTEGER
  y AS INTEGER
  b AS INTEGER
END TYPE

DIM var AS inftst

CLS

PRINT "Round 1: Parameter = one"
test var, "one"
PRINT
PRINT "x = "; var.x, "y = "; var.y, "b ="; var.b
PRINT
another
PRINT "Round 2: Parameter = two"
test var, "two"
PRINT
PRINT "x = "; var.x, "y = "; var.y, "b ="; var.b
PRINT
another
END

SUB another

'I purposely named this the same as in the test sub, to show you it will
'_NOT_ keep the values:
DIM ret AS inftst

PRINT "Meanwhile, inside 'another' function:"
PRINT "x = "; ret.x, "y ="; ret.y, "b ="; ret.b
PRINT
END SUB

SUB test (ret AS inftst, flag$) STATIC

IF flag$ = "one" THEN
  ret.x = 1: ret.y = 1: ret.b = 0
END IF

IF flag$ = "two" THEN
  ret.x = 2: ret.y = 2: ret.b = 1
END IF

END SUB

