'---------------------------------------------------------------------------
'Percent.bas
'Original code by Charles Godard 06/22/96
'Revised by Tika Carr 11/16/96
'  Revisions: o Fixed bugs so that bar can be positioned anywhere, correctly
'               display a centered title, and update properly, no matter what
'               the width or height of box is.
'             o Error checking on Height of box to allow room for text & bar
'             o Fixed colors so they are always definable
'             o Allows you to chose a separate color for the percent bar
'             o Made global variables to position percent box, and define
'               colors & text
'
'Instructions by Charles Goddard:
'
'Opens, maintains, then closes a popup box to be used when
'copying a file or performing other task, to pacify the user
'while he waits.
'
'Switch% = 0 turns it on
'Switch% = 1 maintains it
'Switch% = 2 closes it
'
'Pass to it, a number between 1 and 100 and the proper switch
'PercentBox 0, 0                      'You must 1st open the box
'PercentBox 1, (Percent%)             'Maintain it with this
'Percent% MUST be in parenthesis or else MUST be a numeric value.
'PercentBox 2, 0                      'Close it with this
'
'Give it a number between 0 and 100, and increment it as needed
'the delay's, STEP, and for/next are for demo only
'
'Inspired by reading in the conference.. Alex Wellerstein to James Goldbloom
'---------------------------------------------------------------------------
DEFINT A-Z
DECLARE SUB PercentBox (Switch%, Percent%)

TYPE Sdata
   Char  AS STRING * 1
   Attr AS STRING * 1
END TYPE
REDIM SHARED x(25, 80) AS Sdata

DIM SHARED by, bx, W, H, bg, fg, bar, Text$

'----------------------------- DEMO ----------------------------------------
COLOR , 3: CLS

'Set up box
'bx and by are the upper left location of the box
'W and H are the width and height. Anything less than 3 defaults to
'3 so that you have room for the bar and for text above the bar.
'fg and bg are foreground and background colors, bar is the bar color

bx = 20: by = 11: W = 20: H = 1: fg = 15: bg = 1: bar = 14
Text$ = " Progress "
PercentBox 0, 0

Dly = 1: GOSUB delay
   FOR Percent% = 1 TO 100 STEP 9
      PercentBox 1, (Percent%)  'you can change the name of
      GOSUB delay               'Percent% and remove the ()
   NEXT Percent%
GOSUB delay

PercentBox 2, 0

COLOR 7, 0: CLS : END

delay:
T& = TIMER: DO WHILE (ABS(T& - TIMER) < Dly) AND INKEY$ = "": LOOP
RETURN
'---------------------------------------------------------------------------

SUB PercentBox (Switch%, Percent%)
IF H < 3 THEN H = 3       'Error checking for height
STATIC boxOpen
SELECT CASE Switch%
  CASE IS = 0
    FOR cr = by TO by + H: FOR cc = bx TO bx + W
      x(cr, cc).Char = CHR$(SCREEN(cr, cc))
      x(cr, cc).Attr = CHR$(SCREEN(cr, cc, 1))
    NEXT cc, cr
    FOR cr = by TO by + H
      LOCATE cr, bx: COLOR fg, bg: PRINT STRING$(W, " ")
    NEXT
    boxOpen = 1
    BDRtl = 218: BDRby = 191: BDRbx = 192: BDRrc = 217: 'corners
    BDRv = 179: BDRh = 196:          'horizontal, vertical sides
    COLOR fg, bg
    LOCATE by, bx: PRINT CHR$(BDRtl);  'top lt corner BDR
    FOR i = by TO by + W - 2: PRINT CHR$(BDRh); : NEXT
    LOCATE by, bx + W: PRINT ; CHR$(BDRby);
    FOR i = by + 1 TO by + H - 1:
      LOCATE i, bx: PRINT CHR$(BDRv); : LOCATE i, bx + W: PRINT CHR$(BDRv);
    NEXT
    LOCATE by + H, bx + W: PRINT CHR$(BDRrc);
    LOCATE by + H, bx: PRINT CHR$(BDRbx): LOCATE by + H, bx + 1
    FOR i = bx TO bx + W - 2: PRINT CHR$(BDRh); : NEXT
    LOCATE by, bx + ((W \ 2) - (LEN(Text$) \ 2)): PRINT Text$
  CASE IS = 1 'maintain box
    IF boxOpen = 1 THEN
      'Center percent status according to bx location and W(idth)
      LOCATE by + 1, bx + (W \ 2) - 2: PRINT STR$(Percent%); "%"
      COLOR bar, bg
      Percent% = (Percent% / 100) * (W - 3)     'Bug Fix to allow any size
      LOCATE by + 2, bx + 2: PRINT STRING$(Percent%, 219)
      COLOR fg
    END IF
  CASE IS = 2
    IF boxOpen = 1 THEN
      boxOpen = 0: COLOR fg, bg
      FOR cr = by TO by + H: FOR cc = bx TO bx + W
        LOCATE cr, cc: Attr = ASC(x(cr, cc).Attr)
        fg = Attr AND &HF: bg = Attr \ &H10: COLOR fg, bg
        PRINT x(cr, cc).Char;
      NEXT cc, cr
    END IF
  CASE ELSE
END SELECT
END SUB

