'File Manager Selector
'FILEMAN.BAS
'by Tika Carr & Charles Godard, QuickBasic Echo
'Donated to the Public Domain
'No Warranties or Guarantees are expressed or implied.

'Features: Fi$ returns the name of the file or directory
'          FiFlag = 1 denotes a file
'          FiFlag = 0 denotes a directory
'          FiFlag = -1 denotes that you were trying to find a file
'                   FL$ will then tell you if the file was found or not
'
' Some ideas for adding to this program:
'
'    -> Delete File
'    -> Change Directory
'    -> Rename File
'    -> View File
'    -> Edit File
'    -> View/Process if its an Archived file

DEFINT A-Z
DECLARE FUNCTION DIR$ (FileSpec$)
DECLARE SUB Selector (Mode$, FileSpec$)

'$INCLUDE: 'QB.BI'

DIM SHARED InRegs AS RegType, OutRegs AS RegType, DTA AS STRING * 44

CONST DOS = &H21
CONST SetDTA = &H1A00
CONST FindFirst = &H4E00, FindNext = &H4F00
CONST Bkgrnd = 1, DirClr = 15, FileClr = 14, HiLite = 4

COMMON SHARED Fi$, FiFlag, FL$

' Call the Main Routine. If you wanted to find, say, COMMAND.COM, you'd use:
' Selector "find", "C:\COMMAND.COM"
' Note that when getting a directory listing, you MUST use *.*

'To use the selector, use the arrow keys. Spacebar to go to the next page.

Selector "", "C:\*.*"

LOCATE 25, 1: COLOR 15, Bkgrnd
IF FiFlag = 1 THEN PRINT "File Selected was: "; Fi$;
IF FiFlag = 0 THEN PRINT "Directory Selected was: "; Fi$;
IF FiFlag < 0 THEN PRINT FL$

Pause$ = INPUT$(1)

FUNCTION DIR$ (FileSpec$) STATIC
Null$ = CHR$(0)

InRegs.ax = SetDTA
InRegs.dx = VARPTR(DTA)
INTERRUPT DOS, InRegs, OutRegs

IF LEN(FileSpec$) THEN
FileSpecZ$ = FileSpec$ + Null$

InRegs.ax = FindFirst
InRegs.cx = &H30
InRegs.dx = SADD(FileSpecZ$)
ELSE
InRegs.ax = FindNext
END IF

INTERRUPT DOS, InRegs, OutRegs

IF OutRegs.flags AND 1 THEN
DIR$ = ""
ELSE
Null = INSTR(31, DTA, Null$)
DIR$ = MID$(DTA, 31, Null - 30)
END IF

END FUNCTION

SUB Selector (Mode$, FileSpec$)

IF LCASE$(Mode$) = "find" THEN
	 IF LEN(DIR$(FileSpec$)) THEN
			FL$ = FileSpec$ + " found."
	 ELSE FL$ = FileSpec$ + " not found."
	END IF
	GOTO Done
END IF

DIM F$(1 TO 500), d$(1 TO 50)
F = 1: d = 1

COLOR , Bkgrnd: CLS
Found$ = DIR$(FileSpec$)

' Get the directories and files into separate arrays.
' f$ holds the files, d$  holds the directories.

DO WHILE LEN(Found$)
	 ' The 22nd byte in the DTA string will be CHR$(32) if its a file,
	 ' and CHR$(16) if its a directory.
	 IF ASC(MID$(DTA, 22, 1)) = 32 THEN F$(F) = Found$: F = F + 1
	 IF ASC(MID$(DTA, 22, 1)) = 16 THEN d$(d) = Found$: d = d + 1
	 Found$ = DIR$("")
LOOP

' Alphabetize the arrays
F = F - 1: FOR a = 1 TO F: FOR b = 1 TO F - 1
	 IF F$(b) > F$(b + 1) THEN SWAP F$(b), F$(b + 1)
NEXT b, a

d = d - 1: FOR a = 1 TO d: FOR b = 1 TO d - 1
	 IF d$(b) > d$(b + 1) THEN SWAP d$(b), d$(b + 1)
NEXT b, a

'Print the color coded Directories and Files
COLOR DirClr: FOR a = 1 TO d: PRINT d$(a), : NEXT
COLOR FileClr:
FOR a = 1 TO F:
 IF UBOUND(d$) + a = 121 THEN PCOPY 0, 1: CLS
 PRINT F$(a), : NEXT: PCOPY 0, 2

'Start up by hilighting the first File or Directory.
'cl stores the foreground color of the file currently being pointed to.
y = 1
Fi$ = "": FOR x = 1 TO 12
Fi$ = Fi$ + CHR$(SCREEN(y, x, 0))
cl = VAL("&H" + RIGHT$(HEX$(SCREEN(y, x, 1)), 1))
NEXT x
x = x - 12
LOCATE y, x: COLOR cl, HiLite
PRINT Fi$;

'Here's the "Main guts" - it lets you select the files.
P$ = "": Page1 = 1: Page2 = 2
PCOPY Page2, 0: SWAP Page1, Page2   'make sure first page is displayed.
Sel:
P$ = INKEY$: IF P$ = "" THEN GOTO Sel
IF P$ = " " THEN        'use space bar to switch pages
	 IF page = 1 THEN page = 2 ELSE page = 1
	 PCOPY page, 0: SWAP Page1, Page2: Fi$ = ""
END IF
IF P$ = CHR$(13) THEN COLOR 7, 0: GOTO Done
IF LEN(P$) = 2 THEN
	 COLOR cl, Bkgrnd: LOCATE y, x: PRINT Fi$
	 P1$ = RIGHT$(P$, 1)
	 IF P1$ = "H" THEN y = y - 1: IF y < 1 THEN y = 1    'up
	 IF P1$ = "K" THEN x = x - 14: IF x < 1 THEN x = 1    'left

	 'down
	 IF P1$ = "P" THEN
			'test to see if there's another file/dir
			IF SCREEN(y + 1, x, 0) <> 32 THEN y = y + 1
			IF y > 23 THEN y = 23
	 END IF

	 'right
	 IF P1$ = "M" THEN
			'test to see if there's another file/dir
			IF SCREEN(y, x + 14, 0) <> 32 THEN x = x + 14
			IF x > 57 THEN x = 57
	 END IF
	 Fi$ = ""
	 cl = VAL("&H" + RIGHT$(HEX$(SCREEN(y, x, 1)), 1))
	 FOR x1 = x TO x + 12
			Fi$ = Fi$ + CHR$(SCREEN(y, x1, 0))
	 NEXT x1
	 LOCATE y, x: COLOR cl, HiLite: PRINT Fi$;
END IF
GOTO Sel

Done:
' Set flags for return to main program. See comments at start of the main
' program.
IF LCASE$(Mode$) <> "find" THEN
	 IF cl = FileClr THEN FiFlag = 1 ELSE FiFlag = 0
ELSE
	 FiFlag = -1
END IF

END SUB

