VERSION 5.00
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.2#0"; "COMCTL32.OCX"
Object = "{248DD890-BB45-11CF-9ABC-0080C7E7B78D}#1.0#0"; "MSWINSCK.OCX"
Begin VB.Form frmMain 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "TCP Chatter"
   ClientHeight    =   5295
   ClientLeft      =   150
   ClientTop       =   435
   ClientWidth     =   7410
   Icon            =   "MainForm.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   5295
   ScaleWidth      =   7410
   StartUpPosition =   3  'Windows Default
   Begin ComctlLib.StatusBar oStatusBar 
      Align           =   2  'Align Bottom
      Height          =   300
      Left            =   0
      TabIndex        =   0
      Top             =   4995
      Width           =   7410
      _ExtentX        =   13070
      _ExtentY        =   529
      SimpleText      =   ""
      _Version        =   327682
      BeginProperty Panels {0713E89E-850A-101B-AFC0-4210102A8DA7} 
         NumPanels       =   3
         BeginProperty Panel1 {0713E89F-850A-101B-AFC0-4210102A8DA7} 
            AutoSize        =   2
            Text            =   "IP Address"
            TextSave        =   "IP Address"
            Key             =   ""
            Object.Tag             =   ""
            Object.ToolTipText     =   "This is YOUR IP address"
         EndProperty
         BeginProperty Panel2 {0713E89F-850A-101B-AFC0-4210102A8DA7} 
            Text            =   "Local Port"
            TextSave        =   "Local Port"
            Key             =   ""
            Object.Tag             =   ""
            Object.ToolTipText     =   "Port on which your system listens for connections."
         EndProperty
         BeginProperty Panel3 {0713E89F-850A-101B-AFC0-4210102A8DA7} 
            AutoSize        =   1
            Object.Width           =   7885
            Text            =   "Status"
            TextSave        =   "Status"
            Key             =   ""
            Object.Tag             =   ""
            Object.ToolTipText     =   "Current connection status"
         EndProperty
      EndProperty
   End
   Begin VB.Frame Frame1 
      Height          =   2535
      Left            =   120
      TabIndex        =   2
      Top             =   2160
      Width           =   7095
      Begin VB.CommandButton Command1 
         Caption         =   "&About "
         Height          =   375
         Left            =   1560
         TabIndex        =   15
         Top             =   2040
         Width           =   1335
      End
      Begin VB.TextBox edInput 
         Enabled         =   0   'False
         Height          =   285
         Left            =   120
         TabIndex        =   14
         TabStop         =   0   'False
         Top             =   240
         Width           =   5295
      End
      Begin VB.CommandButton btnSend 
         Caption         =   "&Send"
         Default         =   -1  'True
         Enabled         =   0   'False
         Height          =   375
         Left            =   5640
         TabIndex        =   13
         Top             =   240
         Width           =   1335
      End
      Begin VB.CommandButton btnListen 
         Caption         =   "&Listen"
         Height          =   375
         Left            =   120
         TabIndex        =   12
         Top             =   1560
         Width           =   1335
      End
      Begin VB.CommandButton btnDisconnect 
         Caption         =   "&Disconnect"
         Enabled         =   0   'False
         Height          =   375
         Left            =   120
         TabIndex        =   11
         Top             =   2040
         Width           =   1335
      End
      Begin VB.Frame frMode 
         Caption         =   "Mode"
         Height          =   855
         Left            =   120
         TabIndex        =   8
         Top             =   600
         Width           =   1335
         Begin VB.OptionButton opListener 
            Caption         =   "L&istener"
            Height          =   255
            Left            =   120
            TabIndex        =   10
            Top             =   480
            Value           =   -1  'True
            Width           =   975
         End
         Begin VB.OptionButton opCaller 
            Caption         =   "&Caller"
            Height          =   255
            Left            =   120
            TabIndex        =   9
            Top             =   240
            Width           =   855
         End
      End
      Begin VB.Frame frCaller 
         Caption         =   "Caller Settings"
         Height          =   1455
         Left            =   4320
         TabIndex        =   3
         Top             =   960
         Visible         =   0   'False
         Width           =   2655
         Begin VB.TextBox edPort 
            Height          =   285
            Left            =   840
            TabIndex        =   5
            Text            =   "2112"
            Top             =   720
            Width           =   615
         End
         Begin VB.TextBox edAddy 
            Height          =   285
            Left            =   840
            TabIndex        =   4
            Top             =   360
            Width           =   1455
         End
         Begin VB.Label Label2 
            Alignment       =   1  'Right Justify
            Caption         =   "Port:"
            Height          =   255
            Left            =   360
            TabIndex        =   7
            Top             =   720
            Width           =   375
         End
         Begin VB.Label Label1 
            Alignment       =   1  'Right Justify
            Caption         =   "Address:"
            Height          =   255
            Left            =   120
            TabIndex        =   6
            Top             =   360
            Width           =   615
         End
      End
      Begin MSWinsockLib.Winsock oWinSock 
         Left            =   3600
         Top             =   1920
         _ExtentX        =   741
         _ExtentY        =   741
         _Version        =   327681
         LocalPort       =   2112
      End
   End
   Begin VB.TextBox edOutput 
      Height          =   2055
      Left            =   120
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   1
      TabStop         =   0   'False
      Top             =   0
      Width           =   7095
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' TCP Chatter
' Copyright 1997 by Shawn Riggins
' Use this program at your own risk.
' This program is freeware and you are welcome to use the
' source code for whatever you want.  Just remember, anything
' you do with the source code is done at your OWN RISK


Option Explicit

Public Sub btnDisconnect_Click()
    oWinSock.Close
    oStatusBar.Panels.Item(3).Text = "Not Connected"
    
    btnDisconnect.Enabled = False
    btnListen.Enabled = True
    btnSend.Enabled = False
    edInput.Enabled = False
    
    'Enable the mode group
    frMode.Enabled = True
    opCaller.Enabled = True
    opListener.Enabled = True
    
    'Enable caller group
    frCaller.Enabled = True
    edAddy.Enabled = True
    edPort.Enabled = True
    
End Sub

Private Sub btnListen_Click()
    'Clear the window
    edOutput.Text = ""

    'Make a connection or listen, based on the dialog values
    On Error GoTo ErrorHandler
        If opListener.Value = True Then
            oWinSock.Listen
            oStatusBar.Panels.Item(3).Text = "Listening..."
        Else
            oWinSock.RemotePort = edPort.Text
            oWinSock.Connect (edAddy.Text)
            oStatusBar.Panels.Item(3).Text = "Calling..."
        End If
    On Error GoTo 0
            
    'Enable / disable controls
    btnDisconnect.Enabled = True
    btnListen.Enabled = False
    
    'Disable the mode group
    frMode.Enabled = False
    opCaller.Enabled = False
    opListener.Enabled = False
    
    'Disable caller group
    frCaller.Enabled = False
    edAddy.Enabled = False
    edPort.Enabled = False
    
    ' Error handling section
    Exit Sub
ErrorHandler:
    If Err.Number = 10048 Then
        edOutput.SelStart = Len(edOutput.Text)
        edOutput.SelText = "Error:  Address already in use.  Basicaly this means that you have previously disconnected from a remote host, but the system thinks you are still connected."
        Exit Sub
    Else
        edOutput.SelStart = Len(edOutput.Text)
        edOutput.SelText = "Error: " & Val(Err.Number) & " " & Err.Description
        Exit Sub
    End If
    Resume Next
    
End Sub

Private Sub btnSend_Click()
    edOutput.SelStart = Len(edOutput.Text)
    edOutput.SelText = "> " & edInput.Text & Chr(13) & Chr(10)
    On Error GoTo ErrorHandler
        oWinSock.SendData (edInput.Text & Chr(13) & Chr(10))
        edInput.Text = ""
    On Error GoTo 0
    Exit Sub

ErrorHandler:
    If Err.Number = 40006 Then
        edOutput.SelStart = Len(edOutput.Text)
        edOutput.SelText = "It appears that you are no longer connected with the other party."
        btnDisconnect_Click
    Else
        edOutput.SelStart = Len(edOutput.Text)
        edOutput.SelText = "Error: " & Val(Err.Number) & " " & Err.Description
    End If
    Resume Next
End Sub

Private Sub Command1_Click()
    frmAbout.Show
End Sub

Private Sub Form_Load()
    'Set the status bar up with current IP configuration
    oStatusBar.Panels.Item(1).Text = "Local IP: " & oWinSock.LocalIP & " "
    oStatusBar.Panels.Item(2).Text = "Local Port: " & oWinSock.LocalPort & " "
    oStatusBar.Panels.Item(3).Text = "Not Connected"
End Sub

Private Sub mnuAbout_Click()
    frmAbout.Show
End Sub

Private Sub opCaller_Click()
    frCaller.Visible = True
    btnListen.Caption = "Ca&ll"
End Sub

Private Sub opListener_Click()
    frCaller.Visible = False
    btnListen.Caption = "&Listen"
End Sub

Private Sub oWinSock_Connect()
    oStatusBar.Panels.Item(3).Text = "Connected"
        
    btnSend.Enabled = True
    edInput.Enabled = True
    edInput.SetFocus
End Sub

Private Sub oWinSock_ConnectionRequest(ByVal requestID As Long)
    ' Close the connection if it is currently open
    ' by testing the State property.
    If oWinSock.State <> sckClosed Then oWinSock.Close

    ' Pass the value of the requestID parameter to the
    ' Accept method.
    oWinSock.Accept requestID
    oStatusBar.Panels.Item(3).Text = "Connected"
        
    btnSend.Enabled = True
    edInput.Enabled = True
    edInput.SetFocus
    oWinSock.SendData ("Connection request accepted.  You are now chatting." & Chr(13) & Chr(10) & Chr(13) & Chr(10))
End Sub

Private Sub oWinSock_DataArrival(ByVal bytesTotal As Long)
    'Post data to the output window
    Dim strData As String
    oWinSock.GetData strData, vbString
    edOutput.SelStart = Len(edOutput.Text)
    edOutput.SelText = strData
End Sub

Private Sub oWinSock_Error(ByVal Number As Integer, Description As String, ByVal Scode As Long, ByVal Source As String, ByVal HelpFile As String, ByVal HelpContext As Long, CancelDisplay As Boolean)
    If Number = 10054 Then
        edOutput.SelStart = Len(edOutput.Text)
        edOutput.SelText = "The other party has closed the connection."
        btnDisconnect_Click
    Else
        edOutput.SelStart = Len(edOutput.Text)
        edOutput.SelText = "Error: " & Val(Number) & " " & Description
        btnDisconnect_Click
    End If
End Sub
