/*****************************************************************************
*       TrueColour Graphics version 1.00                                     *
*                                                                            *
*       The TrueColour Graphics code and documentation are                   *
*       Copyright (c) 1994 by Matthew Hildebrand; all rights reserved.       *
*                                                                            *
*       Unauthorised usage or modification of any or all of TrueColour       *
*       Graphics is strictly prohibited.                                     *
*****************************************************************************/

#if !defined(TCGdotH)
#define TCGdotH



/* Comment out this line to disable output modes */
#define TCG_USE_OUTPUT_MODES
/* Comment out this line to disable virtual screens */
#define TCG_USE_VIRTUAL_SCREENS
/* Comment out this line to disable ellipses and circles */
#define TCG_USE_ELLIPSES
/* Comment out this line to disable images (ie. bitmaps) */
#define TCG_USE_IMAGES
/* Comment out this line to disable putVertLine() and friends */
#define TCG_USE_PUTVERTLINE



/*
 * The structure used to store a colour.
 */

#pragma option -a-

struct Colour
{
  unsigned char r, g, b;
};

#pragma option -a.



/*
 * The basic structure used to store function pointers and mode data.
 */

#pragma option -a-

struct GraphDrv
{
  /* Non-I/O functions */
  int far (*_initGraphics)(void);
  void far (*_deInitGraphics)(void);

  /* Currently active I/O functions */
  void huge (*_getImage)(int ulx, int uly, int lrx, int lry, void far *image);
  void far (*_getHorizLine)(int y, int xOff, int lineLen, void far *buf);
  void far (*_getVertLine)(int y, int xOff, int lineLen, void far *buf);
  void far (*_getPixel)(int x, int y, struct Colour *colour);
  void huge (*_putImage)(int x, int y, void far *image);
  void huge (*_putImageInv)(int x, int y, void far *image);
  void huge (*_putImageMask)(int x, int y, void far *image, void far *mask);
  void far (*_putHorizLine)(int y, int xOff, int lineLen, void far *buf);
  void far (*_putHorizLineInv)(int y, int xOff, int lineLen, void far *buf);
  void far (*_putHorizLineMask)(int y, int xOff, int lineLen, void far *buf, void far *mask);
  void far (*_putVertLine)(int y, int xOff, int lineLen, void far *buf);
  void far (*_putVertLineInv)(int y, int xOff, int lineLen, void far *buf);
  void far (*_putVertLineMask)(int y, int xOff, int lineLen, void far *buf, void far *mask);
  void far (*_putPixel)(int x, int y, struct Colour *colour);
  void far (*_line)(int x1, int y1, int x2, int y2, struct Colour *colour);
  void far (*_horizLine)(int y, int x1, int x2, struct Colour *colour);
  void far (*_vertLine)(int x, int y1, int y2, struct Colour *colour);
  void far (*_drawRect)(int ulx, int uly, int lrx, int lry, struct Colour *colour);
  void far (*_filledRect)(int ulx, int uly, int lrx, int lry, struct Colour *colour);
  void far (*_clearGraphics)(struct Colour *colour);
  void far (*_ellipse)(int xc, int yc, int wide, int deep, struct Colour *colour);
  void far (*_filledEllipse)(int xc, int yc, int wide, int deep, struct Colour *colour);
  void far (*_circle)(int x, int y, int radius, struct Colour *colour);
  void far (*_filledCircle)(int x, int y, int radius, struct Colour *colour);

  /* Input functions */
  void huge (*_getImage_scr)(int ulx, int uly, int lrx, int lry, void far *image);
  void huge (*_getImage_mem)(int ulx, int uly, int lrx, int lry, void far *image);
  void far (*_getHorizLine_scr)(int y, int xOff, int lineLen, void far *buf);
  void far (*_getHorizLine_mem)(int y, int xOff, int lineLen, void far *buf);
  void far (*_getVertLine_scr)(int y, int xOff, int lineLen, void far *buf);
  void far (*_getVertLine_mem)(int y, int xOff, int lineLen, void far *buf);
  void far (*_getPixel_scr)(int x, int y, struct Colour *colour);
  void far (*_getPixel_mem)(int x, int y, struct Colour *colour);

  /* Output functions */
  void huge (*_putImage_scr_copy)(int x, int y, void far *image);
  void huge (*_putImage_scr_and) (int x, int y, void far *image);
  void huge (*_putImage_scr_not) (int x, int y, void far *image);
  void huge (*_putImage_scr_or)  (int x, int y, void far *image);
  void huge (*_putImage_scr_xor) (int x, int y, void far *image);
  void huge (*_putImage_mem_copy)(int x, int y, void far *image);
  void huge (*_putImage_mem_and) (int x, int y, void far *image);
  void huge (*_putImage_mem_not) (int x, int y, void far *image);
  void huge (*_putImage_mem_or)  (int x, int y, void far *image);
  void huge (*_putImage_mem_xor) (int x, int y, void far *image);
  void huge (*_putImageInv_scr_copy)(int x, int y, void far *image);
  void huge (*_putImageInv_scr_and) (int x, int y, void far *image);
  void huge (*_putImageInv_scr_not) (int x, int y, void far *image);
  void huge (*_putImageInv_scr_or)  (int x, int y, void far *image);
  void huge (*_putImageInv_scr_xor) (int x, int y, void far *image);
  void huge (*_putImageInv_mem_copy)(int x, int y, void far *image);
  void huge (*_putImageInv_mem_and) (int x, int y, void far *image);
  void huge (*_putImageInv_mem_not) (int x, int y, void far *image);
  void huge (*_putImageInv_mem_or)  (int x, int y, void far *image);
  void huge (*_putImageInv_mem_xor) (int x, int y, void far *image);
  void huge (*_putImageMask_scr_copy)(int x, int y, void far *image, void far *mask);
  void huge (*_putImageMask_scr_and) (int x, int y, void far *image, void far *mask);
  void huge (*_putImageMask_scr_not) (int x, int y, void far *image, void far *mask);
  void huge (*_putImageMask_scr_or)  (int x, int y, void far *image, void far *mask);
  void huge (*_putImageMask_scr_xor) (int x, int y, void far *image, void far *mask);
  void huge (*_putImageMask_mem_copy)(int x, int y, void far *image, void far *mask);
  void huge (*_putImageMask_mem_and) (int x, int y, void far *image, void far *mask);
  void huge (*_putImageMask_mem_not) (int x, int y, void far *image, void far *mask);
  void huge (*_putImageMask_mem_or)  (int x, int y, void far *image, void far *mask);
  void huge (*_putImageMask_mem_xor) (int x, int y, void far *image, void far *mask);
  void far (*_putHorizLine_scr_copy)(int y, int xOff, int lineLen, void far *buf);
  void far (*_putHorizLine_scr_and) (int y, int xOff, int lineLen, void far *buf);
  void far (*_putHorizLine_scr_not) (int y, int xOff, int lineLen, void far *buf);
  void far (*_putHorizLine_scr_or)  (int y, int xOff, int lineLen, void far *buf);
  void far (*_putHorizLine_scr_xor) (int y, int xOff, int lineLen, void far *buf);
  void far (*_putHorizLine_mem_copy)(int y, int xOff, int lineLen, void far *buf);
  void far (*_putHorizLine_mem_and) (int y, int xOff, int lineLen, void far *buf);
  void far (*_putHorizLine_mem_not) (int y, int xOff, int lineLen, void far *buf);
  void far (*_putHorizLine_mem_or)  (int y, int xOff, int lineLen, void far *buf);
  void far (*_putHorizLine_mem_xor) (int y, int xOff, int lineLen, void far *buf);
  void far (*_putHorizLineInv_scr_copy)(int y, int xOff, int lineLen, void far *buf);
  void far (*_putHorizLineInv_scr_and) (int y, int xOff, int lineLen, void far *buf);
  void far (*_putHorizLineInv_scr_not) (int y, int xOff, int lineLen, void far *buf);
  void far (*_putHorizLineInv_scr_or)  (int y, int xOff, int lineLen, void far *buf);
  void far (*_putHorizLineInv_scr_xor) (int y, int xOff, int lineLen, void far *buf);
  void far (*_putHorizLineInv_mem_copy)(int y, int xOff, int lineLen, void far *buf);
  void far (*_putHorizLineInv_mem_and) (int y, int xOff, int lineLen, void far *buf);
  void far (*_putHorizLineInv_mem_not) (int y, int xOff, int lineLen, void far *buf);
  void far (*_putHorizLineInv_mem_or)  (int y, int xOff, int lineLen, void far *buf);
  void far (*_putHorizLineInv_mem_xor) (int y, int xOff, int lineLen, void far *buf);
  void far (*_putHorizLineMask_scr_copy)(int y, int xOff, int lineLen, void far *buf, void far *mask);
  void far (*_putHorizLineMask_scr_and) (int y, int xOff, int lineLen, void far *buf, void far *mask);
  void far (*_putHorizLineMask_scr_not) (int y, int xOff, int lineLen, void far *buf, void far *mask);
  void far (*_putHorizLineMask_scr_or)  (int y, int xOff, int lineLen, void far *buf, void far *mask);
  void far (*_putHorizLineMask_scr_xor) (int y, int xOff, int lineLen, void far *buf, void far *mask);
  void far (*_putHorizLineMask_mem_copy)(int y, int xOff, int lineLen, void far *buf, void far *mask);
  void far (*_putHorizLineMask_mem_and) (int y, int xOff, int lineLen, void far *buf, void far *mask);
  void far (*_putHorizLineMask_mem_not) (int y, int xOff, int lineLen, void far *buf, void far *mask);
  void far (*_putHorizLineMask_mem_or)  (int y, int xOff, int lineLen, void far *buf, void far *mask);
  void far (*_putHorizLineMask_mem_xor) (int y, int xOff, int lineLen, void far *buf, void far *mask);
  void far (*_putVertLine_scr_copy)(int y, int xOff, int lineLen, void far *buf);
  void far (*_putVertLine_scr_and) (int y, int xOff, int lineLen, void far *buf);
  void far (*_putVertLine_scr_not) (int y, int xOff, int lineLen, void far *buf);
  void far (*_putVertLine_scr_or)  (int y, int xOff, int lineLen, void far *buf);
  void far (*_putVertLine_scr_xor) (int y, int xOff, int lineLen, void far *buf);
  void far (*_putVertLine_mem_copy)(int y, int xOff, int lineLen, void far *buf);
  void far (*_putVertLine_mem_and) (int y, int xOff, int lineLen, void far *buf);
  void far (*_putVertLine_mem_not) (int y, int xOff, int lineLen, void far *buf);
  void far (*_putVertLine_mem_or)  (int y, int xOff, int lineLen, void far *buf);
  void far (*_putVertLine_mem_xor) (int y, int xOff, int lineLen, void far *buf);
  void far (*_putVertLineInv_scr_copy)(int y, int xOff, int lineLen, void far *buf);
  void far (*_putVertLineInv_scr_and) (int y, int xOff, int lineLen, void far *buf);
  void far (*_putVertLineInv_scr_not) (int y, int xOff, int lineLen, void far *buf);
  void far (*_putVertLineInv_scr_or)  (int y, int xOff, int lineLen, void far *buf);
  void far (*_putVertLineInv_scr_xor) (int y, int xOff, int lineLen, void far *buf);
  void far (*_putVertLineInv_mem_copy)(int y, int xOff, int lineLen, void far *buf);
  void far (*_putVertLineInv_mem_and) (int y, int xOff, int lineLen, void far *buf);
  void far (*_putVertLineInv_mem_not) (int y, int xOff, int lineLen, void far *buf);
  void far (*_putVertLineInv_mem_or)  (int y, int xOff, int lineLen, void far *buf);
  void far (*_putVertLineInv_mem_xor) (int y, int xOff, int lineLen, void far *buf);
  void far (*_putVertLineMask_scr_copy)(int y, int xOff, int lineLen, void far *buf, void far *mask);
  void far (*_putVertLineMask_scr_and) (int y, int xOff, int lineLen, void far *buf, void far *mask);
  void far (*_putVertLineMask_scr_not) (int y, int xOff, int lineLen, void far *buf, void far *mask);
  void far (*_putVertLineMask_scr_or)  (int y, int xOff, int lineLen, void far *buf, void far *mask);
  void far (*_putVertLineMask_scr_xor) (int y, int xOff, int lineLen, void far *buf, void far *mask);
  void far (*_putVertLineMask_mem_copy)(int y, int xOff, int lineLen, void far *buf, void far *mask);
  void far (*_putVertLineMask_mem_and) (int y, int xOff, int lineLen, void far *buf, void far *mask);
  void far (*_putVertLineMask_mem_not) (int y, int xOff, int lineLen, void far *buf, void far *mask);
  void far (*_putVertLineMask_mem_or)  (int y, int xOff, int lineLen, void far *buf, void far *mask);
  void far (*_putVertLineMask_mem_xor) (int y, int xOff, int lineLen, void far *buf, void far *mask);
  void far (*_putPixel_scr_copy)(int x, int y, struct Colour *colour);
  void far (*_putPixel_scr_and) (int x, int y, struct Colour *colour);
  void far (*_putPixel_scr_not) (int x, int y, struct Colour *colour);
  void far (*_putPixel_scr_or)  (int x, int y, struct Colour *colour);
  void far (*_putPixel_scr_xor) (int x, int y, struct Colour *colour);
  void far (*_putPixel_mem_copy)(int x, int y, struct Colour *colour);
  void far (*_putPixel_mem_and) (int x, int y, struct Colour *colour);
  void far (*_putPixel_mem_not) (int x, int y, struct Colour *colour);
  void far (*_putPixel_mem_or)  (int x, int y, struct Colour *colour);
  void far (*_putPixel_mem_xor) (int x, int y, struct Colour *colour);
  void far (*_line_scr_copy)(int x1, int y1, int x2, int y2, struct Colour *colour);
  void far (*_line_scr_and) (int x1, int y1, int x2, int y2, struct Colour *colour);
  void far (*_line_scr_not) (int x1, int y1, int x2, int y2, struct Colour *colour);
  void far (*_line_scr_or)  (int x1, int y1, int x2, int y2, struct Colour *colour);
  void far (*_line_scr_xor) (int x1, int y1, int x2, int y2, struct Colour *colour);
  void far (*_line_mem_copy)(int x1, int y1, int x2, int y2, struct Colour *colour);
  void far (*_line_mem_and) (int x1, int y1, int x2, int y2, struct Colour *colour);
  void far (*_line_mem_not) (int x1, int y1, int x2, int y2, struct Colour *colour);
  void far (*_line_mem_or)  (int x1, int y1, int x2, int y2, struct Colour *colour);
  void far (*_line_mem_xor) (int x1, int y1, int x2, int y2, struct Colour *colour);
  void far (*_horizLine_scr_copy)(int y, int x1, int x2, struct Colour *colour);
  void far (*_horizLine_scr_and) (int y, int x1, int x2, struct Colour *colour);
  void far (*_horizLine_scr_not) (int y, int x1, int x2, struct Colour *colour);
  void far (*_horizLine_scr_or)  (int y, int x1, int x2, struct Colour *colour);
  void far (*_horizLine_scr_xor) (int y, int x1, int x2, struct Colour *colour);
  void far (*_horizLine_mem_copy)(int y, int x1, int x2, struct Colour *colour);
  void far (*_horizLine_mem_and) (int y, int x1, int x2, struct Colour *colour);
  void far (*_horizLine_mem_not) (int y, int x1, int x2, struct Colour *colour);
  void far (*_horizLine_mem_or)  (int y, int x1, int x2, struct Colour *colour);
  void far (*_horizLine_mem_xor) (int y, int x1, int x2, struct Colour *colour);
  void far (*_vertLine_scr_copy)(int x, int y1, int y2, struct Colour *colour);
  void far (*_vertLine_scr_and) (int x, int y1, int y2, struct Colour *colour);
  void far (*_vertLine_scr_not) (int x, int y1, int y2, struct Colour *colour);
  void far (*_vertLine_scr_or)  (int x, int y1, int y2, struct Colour *colour);
  void far (*_vertLine_scr_xor) (int x, int y1, int y2, struct Colour *colour);
  void far (*_vertLine_mem_copy)(int x, int y1, int y2, struct Colour *colour);
  void far (*_vertLine_mem_and) (int x, int y1, int y2, struct Colour *colour);
  void far (*_vertLine_mem_not) (int x, int y1, int y2, struct Colour *colour);
  void far (*_vertLine_mem_or)  (int x, int y1, int y2, struct Colour *colour);
  void far (*_vertLine_mem_xor) (int x, int y1, int y2, struct Colour *colour);
  void far (*_drawRect_scr_copy)(int ulx, int uly, int lrx, int lry, struct Colour *colour);
  void far (*_drawRect_scr_and) (int ulx, int uly, int lrx, int lry, struct Colour *colour);
  void far (*_drawRect_scr_not) (int ulx, int uly, int lrx, int lry, struct Colour *colour);
  void far (*_drawRect_scr_or)  (int ulx, int uly, int lrx, int lry, struct Colour *colour);
  void far (*_drawRect_scr_xor) (int ulx, int uly, int lrx, int lry, struct Colour *colour);
  void far (*_drawRect_mem_copy)(int ulx, int uly, int lrx, int lry, struct Colour *colour);
  void far (*_drawRect_mem_and) (int ulx, int uly, int lrx, int lry, struct Colour *colour);
  void far (*_drawRect_mem_not) (int ulx, int uly, int lrx, int lry, struct Colour *colour);
  void far (*_drawRect_mem_or)  (int ulx, int uly, int lrx, int lry, struct Colour *colour);
  void far (*_drawRect_mem_xor) (int ulx, int uly, int lrx, int lry, struct Colour *colour);
  void far (*_filledRect_scr_copy)(int ulx, int uly, int lrx, int lry, struct Colour *colour);
  void far (*_filledRect_scr_and) (int ulx, int uly, int lrx, int lry, struct Colour *colour);
  void far (*_filledRect_scr_not) (int ulx, int uly, int lrx, int lry, struct Colour *colour);
  void far (*_filledRect_scr_or)  (int ulx, int uly, int lrx, int lry, struct Colour *colour);
  void far (*_filledRect_scr_xor) (int ulx, int uly, int lrx, int lry, struct Colour *colour);
  void far (*_filledRect_mem_copy)(int ulx, int uly, int lrx, int lry, struct Colour *colour);
  void far (*_filledRect_mem_and) (int ulx, int uly, int lrx, int lry, struct Colour *colour);
  void far (*_filledRect_mem_not) (int ulx, int uly, int lrx, int lry, struct Colour *colour);
  void far (*_filledRect_mem_or)  (int ulx, int uly, int lrx, int lry, struct Colour *colour);
  void far (*_filledRect_mem_xor) (int ulx, int uly, int lrx, int lry, struct Colour *colour);
  void far (*_clearGraphics_scr_copy)(struct Colour *colour);
  void far (*_clearGraphics_scr_and) (struct Colour *colour);
  void far (*_clearGraphics_scr_not) (struct Colour *colour);
  void far (*_clearGraphics_scr_or)  (struct Colour *colour);
  void far (*_clearGraphics_scr_xor) (struct Colour *colour);
  void far (*_clearGraphics_mem_copy)(struct Colour *colour);
  void far (*_clearGraphics_mem_and) (struct Colour *colour);
  void far (*_clearGraphics_mem_not) (struct Colour *colour);
  void far (*_clearGraphics_mem_or)  (struct Colour *colour);
  void far (*_clearGraphics_mem_xor) (struct Colour *colour);
  void far (*_ellipse_scr_copy)(int xc, int yc, int wide, int deep, struct Colour *colour);
  void far (*_ellipse_scr_and) (int xc, int yc, int wide, int deep, struct Colour *colour);
  void far (*_ellipse_scr_not) (int xc, int yc, int wide, int deep, struct Colour *colour);
  void far (*_ellipse_scr_or)  (int xc, int yc, int wide, int deep, struct Colour *colour);
  void far (*_ellipse_scr_xor) (int xc, int yc, int wide, int deep, struct Colour *colour);
  void far (*_ellipse_mem_copy)(int xc, int yc, int wide, int deep, struct Colour *colour);
  void far (*_ellipse_mem_and) (int xc, int yc, int wide, int deep, struct Colour *colour);
  void far (*_ellipse_mem_not) (int xc, int yc, int wide, int deep, struct Colour *colour);
  void far (*_ellipse_mem_or)  (int xc, int yc, int wide, int deep, struct Colour *colour);
  void far (*_ellipse_mem_xor) (int xc, int yc, int wide, int deep, struct Colour *colour);
  void far (*_filledEllipse_scr_copy)(int xc, int yc, int wide, int deep, struct Colour *colour);
  void far (*_filledEllipse_scr_and) (int xc, int yc, int wide, int deep, struct Colour *colour);
  void far (*_filledEllipse_scr_not) (int xc, int yc, int wide, int deep, struct Colour *colour);
  void far (*_filledEllipse_scr_or)  (int xc, int yc, int wide, int deep, struct Colour *colour);
  void far (*_filledEllipse_scr_xor) (int xc, int yc, int wide, int deep, struct Colour *colour);
  void far (*_filledEllipse_mem_copy)(int xc, int yc, int wide, int deep, struct Colour *colour);
  void far (*_filledEllipse_mem_and) (int xc, int yc, int wide, int deep, struct Colour *colour);
  void far (*_filledEllipse_mem_not) (int xc, int yc, int wide, int deep, struct Colour *colour);
  void far (*_filledEllipse_mem_or)  (int xc, int yc, int wide, int deep, struct Colour *colour);
  void far (*_filledEllipse_mem_xor) (int xc, int yc, int wide, int deep, struct Colour *colour);
  void far (*_circle_scr_copy)(int x, int y, int radius, struct Colour *colour);
  void far (*_circle_scr_and) (int x, int y, int radius, struct Colour *colour);
  void far (*_circle_scr_not) (int x, int y, int radius, struct Colour *colour);
  void far (*_circle_scr_or)  (int x, int y, int radius, struct Colour *colour);
  void far (*_circle_scr_xor) (int x, int y, int radius, struct Colour *colour);
  void far (*_circle_mem_copy)(int x, int y, int radius, struct Colour *colour);
  void far (*_circle_mem_and) (int x, int y, int radius, struct Colour *colour);
  void far (*_circle_mem_not) (int x, int y, int radius, struct Colour *colour);
  void far (*_circle_mem_or)  (int x, int y, int radius, struct Colour *colour);
  void far (*_circle_mem_xor) (int x, int y, int radius, struct Colour *colour);
  void far (*_filledCircle_scr_copy)(int x, int y, int radius, struct Colour *colour);
  void far (*_filledCircle_scr_and) (int x, int y, int radius, struct Colour *colour);
  void far (*_filledCircle_scr_not) (int x, int y, int radius, struct Colour *colour);
  void far (*_filledCircle_scr_or)  (int x, int y, int radius, struct Colour *colour);
  void far (*_filledCircle_scr_xor) (int x, int y, int radius, struct Colour *colour);
  void far (*_filledCircle_mem_copy)(int x, int y, int radius, struct Colour *colour);
  void far (*_filledCircle_mem_and) (int x, int y, int radius, struct Colour *colour);
  void far (*_filledCircle_mem_not) (int x, int y, int radius, struct Colour *colour);
  void far (*_filledCircle_mem_or)  (int x, int y, int radius, struct Colour *colour);
  void far (*_filledCircle_mem_xor) (int x, int y, int radius, struct Colour *colour);

  /* Driver data */
  short scrnMaxX, scrnMaxY;                 /* physical screen dimensions */
  unsigned short xRatio, yRatio;            /* screen aspect ratio */
  unsigned short bitsPerPixel;              /* bits per pixel */
  short inMaxX, inMaxY;                     /* input screen dimensions */
  short outMaxX, outMaxY;                   /* output screen dimensions */
  unsigned short inScreenWide, outScreenWide; /* needed for virtual screens */
  short inViewportULX, inViewportULY;       /* input viewport coords */
  short inViewportLRX, inViewportLRY;
  short outViewportULX, outViewportULY;     /* output viewport coords */
  short outViewportLRX, outViewportLRY;
  void far *inAddr;                         /* current input address */
  void far *outAddr;                        /* current output address */
  void far *scrAddr;                        /* screen address */
  unsigned char curInvR, curInvG, curInvB;  /* current transparent colour */
};

#pragma option -a.



/*
 * Note that this C/C++ bit might not work properly with your compiler.  If
 * you are using C++ and your linker reports that these functions are not
 * found, try explicitly forcing the extern "C" syntax by removing these
 * preprocessor directives.
 */

#if defined(__cplusplus)
extern "C" {
#endif

/* Load/unload routines */
char *TCG_detectGraph(void);
int TCG_loadGraphDriver(char *filename);
void TCG_unloadGraphDriver(void);

/* Image size routines */
unsigned long TCG_imageSize(int ulx, int uly, int lrx, int lry);
unsigned long TCG_imageSizeDim(unsigned width, unsigned height);

/* Virtual/real screen routines */
#if defined(TCG_USE_VIRTUAL_SCREENS)
  void TCG_setGraphicsInputAddr(void far *addr);
  void TCG_setGraphicsOutputAddr(void far *addr);
  void TCG_setGraphicsAddr(void far *addr);
  void far *TCG_getGraphicsInputAddr(void);
  void far *TCG_getGraphicsOutputAddr(void);
  void far *TCG_makeVirtScreen(unsigned wide, unsigned deep);
#endif

/* Output mode control routine */
#if defined(TCG_USE_OUTPUT_MODES)
  void TCG_setOutputMode(int mode);
#endif

/* Viewport routines */
void TCG_setInputViewport(int ulx, int uly, int lrx, int lry);
void TCG_setOutputViewport(int ulx, int uly, int lrx, int lry);
void TCG_setViewports(int ulx, int uly, int lrx, int lry);
void TCG_getInputViewport(int *ulx, int *uly, int *lrx, int *lry);
void TCG_getOutputViewport(int *ulx, int *uly, int *lrx, int *lry);

/* Clipping routines */
int TCG_clipLine(int *x1, int *y1, int *x2, int *y2);
int TCG_clipRect(int *ulx, int *uly, int *lrx, int *lry);

/* Scale bitmap */
void TCG_doubleBitmap(void far *src, void far *dest);

/* PCX file routines */
void *TCG_loadPcxFile(char *filename);
int TCG_displayPcxFile(int x, int y, char *filename);

/* Transparent colour selection routine */
void TCG_setInvisibleColour(struct Colour *colour);

#if defined(__cplusplus)
};
#endif



/*
 * Declare the structure used by the system so that programs can access it.
 */

extern struct GraphDrv far *TCGsys;



/*
 * The function names of TCG's functions are defined here.  Since they are
 * really just macros pretending to be functions, you can easily change
 * their names here if you don't like the default ones.
 */

#define detectGraph             TCG_detectGraph
#define initGraphics            (TCGsys->_initGraphics)
#define deInitGraphics          (TCGsys->_deInitGraphics)
#if defined(TCG_USE_IMAGES)
  #define putImage              (TCGsys->_putImage)
  #define putImageInv           (TCGsys->_putImageInv)
  #define putImageMask          (TCGsys->_putImageMask)
  #define getImage              (TCGsys->_getImage)
#endif
#define getHorizLine            (TCGsys->_getHorizLine)
#define getLine                 (TCGsys->_getHorizLine)
#define putHorizLine            (TCGsys->_putHorizLine)
#define putLine                 (TCGsys->_putHorizLine)
#define putHorizLineInv         (TCGsys->_putHorizLineInv)
#define putLineInv              (TCGsys->_putHorizLineInv)
#define putHorizLineMask        (TCGsys->_putHorizLineMask)
#define putLineMask             (TCGsys->_putHorizLineMask)
#if defined(TCG_USE_PUTVERTLINE)
  #define getVertLine           (TCGsys->_getVertLine)
  #define putVertLine           (TCGsys->_putVertLine)
  #define putVertLineInv        (TCGsys->_putVertLineInv)
  #define putVertLineMask       (TCGsys->_putVertLineMask)
#endif
#if defined(TCG_USE_IMAGES)
  #define imageSize             TCG_imageSize
  #define imageSizeDim          TCG_imageSizeDim
#endif

#define loadGraphDriver       TCG_loadGraphDriver
#define unloadGraphDriver     TCG_unloadGraphDriver

#if defined(TCG_USE_VIRTUAL_SCREENS)
  #define setGraphicsOutputAddr TCG_setGraphicsOutputAddr /* set outputs */
  #define setGraphicsInputAddr  TCG_setGraphicsInputAddr  /* set input   */
  #define setGraphicsAddr       TCG_setGraphicsAddr       /* set I/O     */
  #define makeVirtScreen        TCG_makeVirtScreen        /* make virtual screen */
  #define getGraphicsOutputAddr TCG_getGraphicsOutputAddr /* set output  */
  #define getGraphicsInputAddr  TCG_getGraphicsInputAddr  /* set input   */
#endif

#if defined(TCG_USE_OUTPUT_MODES)
  #define setGraphicsOutputMode TCG_setOutputMode         /* output mode */
#endif

#define setOutputViewport       TCG_setOutputViewport     /* viewports */
#define setInputViewport        TCG_setInputViewport
#define setViewports            TCG_setViewports
#define setViewport             TCG_setViewports
#define getOutputViewport       TCG_getOutputViewport
#define getInputViewport        TCG_getInputViewport
#define getViewport             TCG_getOutputViewport

#define clipLine                TCG_clipLine              /* clipping */
#define clipRect                TCG_clipRect
#define clipFilledRect          TCG_clipRect
#define clipInputPoint          TCG_clipInputPoint
#define clipOutputPoint         TCG_clipOutputPoint
#define clipPoint               TCG_clipPoint
#define pointOnScreen           TCG_pointOnScreen

#define doubleBitmap            TCG_doubleBitmap          /* scaling */

#define loadPcxFile             TCG_loadPcxFile           /* image files */
#define displayPcxFile          TCG_displayPcxFile



/*
 * If we're using C++, overload the functions to allow passing of
 * the red, green, and blue components separately.
 */

#if defined(__cplusplus)

inline void putPixel(int x, int y, unsigned char r, unsigned char g, unsigned char b)
        {
          Colour colour;
          colour.r=r;  colour.g=g;  colour.b=b;
          (TCGsys->_putPixel)(x, y, &colour);
        }
inline void putPixel(int x, int y, Colour *colour)
        {
          (TCGsys->_putPixel)(x, y, colour);
        }
inline void getPixel(int x, int y, unsigned char *r, unsigned char *g, unsigned char *b)
        {
          Colour colour;
          (TCGsys->_getPixel)(x, y, &colour);
          *r=colour.r;  *g=colour.g;  *b=colour.b;
        }
inline void getPixel(int x, int y, Colour *colour)
        {
          (TCGsys->_getPixel)(x, y, colour);
        }
inline void line(int x1, int y1, int x2, int y2, unsigned char r, unsigned char g, unsigned char b)
        {
          Colour colour;
          colour.r=r;  colour.g=g;  colour.b=b;
          (TCGsys->_line)(x1, y1, x2, y2, &colour);
        }
inline void line(int x1, int y1, int x2, int y2, Colour *colour)
        {
          (TCGsys->_line)(x1, y1, x2, y2, colour);
        }
inline void horizLine(int y, int x1, int x2, unsigned char r, unsigned char g, unsigned char b)
        {
          Colour colour;
          colour.r=r;  colour.g=g;  colour.b=b;
          (TCGsys->_horizLine)(y, x1, x2, &colour);
        }
inline void horizLine(int y, int x1, int x2, Colour *colour)
        {
          (TCGsys->_horizLine)(y, x1, x2, colour);
        }
inline void vertLine(int x, int y1, int y2, unsigned char r, unsigned char g, unsigned char b)
        {
          Colour colour;
          colour.r=r;  colour.g=g;  colour.b=b;
          (TCGsys->_vertLine)(x, y1, y2, &colour);
        }
inline void vertLine(int x, int y1, int y2, Colour *colour)
        {
          (TCGsys->_vertLine)(x, y1, y2, colour);
        }
inline void drawRect(int ulx, int uly, int lrx, int lry, unsigned char r, unsigned char g, unsigned char b)
        {
          Colour colour;
          colour.r=r;  colour.g=g;  colour.b=b;
          (TCGsys->_drawRect)(ulx, uly, lrx, lry, &colour);
        }
inline void drawRect(int ulx, int uly, int lrx, int lry, Colour *colour)
        {
          (TCGsys->_drawRect)(ulx, uly, lrx, lry, colour);
        }
inline void filledRect(int ulx, int uly, int lrx, int lry, unsigned char r, unsigned char g, unsigned char b)
        {
          Colour colour;
          colour.r=r;  colour.g=g;  colour.b=b;
          (TCGsys->_filledRect)(ulx, uly, lrx, lry, &colour);
        }
inline void filledRect(int ulx, int uly, int lrx, int lry, Colour *colour)
        {
          (TCGsys->_filledRect)(ulx, uly, lrx, lry, colour);
        }
inline void clearGraphics(unsigned char r, unsigned char g, unsigned char b)
        {
          Colour colour;
          colour.r=r;  colour.g=g;  colour.b=b;
          (TCGsys->_clearGraphics)(&colour);
        }
inline void clearGraphics(Colour *colour)
        {
          (TCGsys->_clearGraphics)(colour);
        }
#if defined(TCG_USE_ELLIPSES)
  inline void ellipse(int xc, int yc, int wide, int deep, unsigned char r, unsigned char g, unsigned char b)
          {
            Colour colour;
            colour.r=r;  colour.g=g;  colour.b=b;
            (TCGsys->_ellipse)(xc, yc, wide, deep, &colour);
          }
  inline void ellipse(int xc, int yc, int wide, int deep, Colour *colour)
          {
            (TCGsys->_ellipse)(xc, yc, wide, deep, colour);
          }
  inline void filledEllipse(int xc, int yc, int wide, int deep, unsigned char r, unsigned char g, unsigned char b)
          {
            Colour colour;
            colour.r=r;  colour.g=g;  colour.b=b;
            (TCGsys->_filledEllipse)(xc, yc, wide, deep, &colour);
          }
  inline void filledEllipse(int xc, int yc, int wide, int deep, Colour *colour)
          {
            (TCGsys->_filledEllipse)(xc, yc, wide, deep, colour);
          }
  inline void circle(int xc, int yc, int radius, unsigned char r, unsigned char g, unsigned char b)
          {
            Colour colour;
            colour.r=r;  colour.g=g;  colour.b=b;
            (TCGsys->_circle)(xc, yc, radius, &colour);
          }
  inline void circle(int xc, int yc, int radius, Colour *colour)
          {
            (TCGsys->_circle)(xc, yc, radius, colour);
          }
  inline void filledCircle(int xc, int yc, int radius, unsigned char r, unsigned char g, unsigned char b)
          {
            Colour colour;
            colour.r=r;  colour.g=g;  colour.b=b;
            (TCGsys->_filledCircle)(xc, yc, radius, &colour);
          }
  inline void filledCircle(int xc, int yc, int radius, Colour *colour)
          {
            (TCGsys->_filledCircle)(xc, yc, radius, colour);
          }
  inline void setInvisibleColour(unsigned char r, unsigned char g, unsigned char b)
          {
            Colour colour;
            colour.r=r;  colour.g=g;  colour.b=b;
            TCG_setInvisibleColour(&colour);
          }
#endif
#else
  #define putPixel              (TGEsys->_putPixel)
  #define getPixel              (TGEsys->_getPixel)
  #define line                  (TGEsys->_line)
  #define horizLine             (TGEsys->_horizLine)
  #define vertLine              (TGEsys->_vertLine)
  #define drawRect              (TGEsys->_drawRect)
  #define filledRect            (TGEsys->_filledRect)
  #define clearGraphics         (TGEsys->_clearGraphics)
  #if defined(TGE_USE_ELLIPSES)
    #define ellipse             (TGEsys->_ellipse)
    #define filledEllipse       (TGEsys->_filledEllipse)
    #define circle              (TGEsys->_circle)
    #define filledCircle        (TGEsys->_filledCircle)
  #endif
  #define setInvisibleColour    TCG_setInvisibleColour
  #define setInvisibleColor     TCG_setInvisibleColour
#endif



/*
 * These macros provide easy access to important mode information in the
 * TCG system structure.
 */

#define INMAXX                  (TCGsys->inMaxX)
#define INMAXY                  (TCGsys->inMaxY)
#define OUTMAXX                 (TCGsys->outMaxX)
#define OUTMAXY                 (TCGsys->outMaxY)
#define XRATIO                  (TCGsys->xRatio)
#define YRATIO                  (TCGsys->yRatio)
#define INVIEWPORTULX           (TCGsys->inViewportULX)
#define INVIEWPORTULY           (TCGsys->inViewportULY)
#define INVIEWPORTLRX           (TCGsys->inViewportLRX)
#define INVIEWPORTLRY           (TCGsys->inViewportLRY)
#define OUTVIEWPORTULX          (TCGsys->outViewportULX)
#define OUTVIEWPORTULY          (TCGsys->outViewportULY)
#define OUTVIEWPORTLRX          (TCGsys->outViewportLRX)
#define OUTVIEWPORTLRY          (TCGsys->outViewportLRY)
#define SCREENMAXX              (TCGsys->scrnMaxX)
#define SCREENMAXY              (TCGsys->scrnMaxY)
#define CURINVRED               (TCGsys->curInvR)
#define CURINVGREEN             (TCGsys->curInvG)
#define CURINVBLUE              (TCGsys->curInvB)



/*
 * These macros are for the various output modes.
 */

#if defined(TCG_USE_OUTPUT_MODES)
  #define TCG_COPY_PUT          0
  #define TCG_AND_PUT           1
  #define TCG_NOT_PUT           2
  #define TCG_OR_PUT            3
  #define TCG_XOR_PUT           4
#endif



/*
 * These macros are the return codes from loadGraphDriver().
 */

#define TCG_SUCCESS      0              /* driver loaded successfully */
#define TCG_OPEN_ERR    -1              /* error opening given file */
#define TCG_FORMAT_ERR  -2              /* file is not a TCG driver */
#define TCG_ALLOC_ERR   -3              /* error allocating memory */
#define TCG_FILE_ERR    -4              /* file I/O error */



/*
 * Point clipping routines.
 */

#define TCG_pointOnScreen(x,y) \
  ((x>=0) && (x<=TCGsys->scrnMaxX) && (y>=0) && (y<=TCGsys->scrnMaxY))
#define TCG_clipInputPoint(x,y) \
  ((x>=INVIEWPORTULX) && (x<=INVIEWPORTLRX) && \
   (y>=INVIEWPORTULY) && (y<=INVIEWPORTLRY))
#define TCG_clipOutputPoint(x,y) \
  ((x>=OUTVIEWPORTULX) && (x<=OUTVIEWPORTLRX) && \
   (y>=OUTVIEWPORTULY) && (y<=OUTVIEWPORTLRY))
#define TCG_clipPoint(x,y) \
  TCG_clipOutputPoint(x,y)



/*
 * Image dimension macros.
 */

#if defined(TCG_USE_IMAGES)
  #define imageWidth(image)     ((unsigned*)image)[0]
  #define imageHeight(image)    ((unsigned*)image)[1]
#endif



/*
 * Ease the use of TGE with different compilers by standardizing #defines.
 */

#if defined(__TURBOC__)
  #define ENABLE_INTERRUPTS     enable()
  #define DISABLE_INTERRUPTS    disable()
  #define GENERATE_INTERRUPT(i) geninterrupt(i)
#else
  #define ENABLE_INTERRUPTS     asm cli
  #define DISABLE_INTERRUPTS    asm sti
  #define GENERATE_INTERRUPT(i) asm int i
#endif

#if !defined(__TURBOC__)
  #define MK_FP(seg,ofs)        (((unsigned long)seg<<16) | ofs)
  #define FP_SEG(fp)            ((unsigned short)(seg>>16))
  #define FP_OFF(fp)            ((unsigned long)fp & 0xFFFF)
#endif



#endif
