/*Ŀ
 ݳ Program Name: TB_PICT.PRG       Copyright: Public Domain             
 ݳ Date Created: 04/22/93           Language: Clipper 5.2               
 ݳ Time Created: ***********          Author: Kevin S Gallagher         
 Ĵ
 ݳ The program demostrates:                                             
 ݳ Editing a single cell in a TBrowse, using the new instance for       
 ݳ TBrowse -> picture  (undocumented as far as I can tell)              
 ݳ                                                                      
 ݳ The original program file was created by, Luiz F. Quintela prior to  
 ݳ the release of CA-Clipper v5.2 and now utilizes 5.2 commands etc...  
 ݳ I used this code so not to waste time, by creating a program that    
 ݳ does the same thing!                                                 
 ݳ                                                                      
 Ĵ
 ݳ Credits:                                                             
 ݳ Some of the code was taken from Greg Lief's coding ideas and if you  
 ݳ have not tried out the GrumpFish library call for a free demo disk;  
 ݳ (800)367-7613                                                        
 
            */

#include "inkey.ch"
#include "setcurs.ch"

#define     DEMOFILE    "TEST"
#define     BARCOLOR    "B/BG"
#define     BUTTONCOLOR "GR+/RB"
#define     TOP         2
#define     LEFT        6
#define     BOTTOM      22
#define     RIGHT       73

// TBrowse cargo slot for validating gets
#xtranslate ValidBlock()      => &("{ |xx| !empty(xx:varget()) }" )

// Stablize current highlighted row
#xtranslate StableOne   (<o>) => <o>:RefreshCurrent() ; <o>:ForceStable()

// Stablize entire TBrowse
#xtranslate ForceRefresh(<o>) => <o>:RefreshAll()     ; <o>:ForceStable()

// Draw a double-line box
#xtranslate DOUBLEBOX(<top>, <left>, <bottom>, <right> [,<color>] ) => ;
            DispBox(<top>, <left>, <bottom>, <right>,'ͻȺ ' [, <color>] )

function main()
    local b, column, nKey, kk ,nRow :=3, nTop, nLeft, nBottom, nRight, xxx

    nTop    := TOP
    nLeft   := LEFT
    nBottom := BOTTOM
    nRight  := RIGHT

    if !file(DEMOFILE+".dbf")
        alert("MISSING DATABASE",{" Quit "})
        quit
    endif

    USE (DEMOFILE) SHARED NEW VIA "dbfntx"

    if !neterr()
        if !file( DEMOFILE+indexext() )
            INDEX ON test->fld3  TO (DEMOFILE)
        else
            SET INDEX TO (DEMOFILE)
        endif
    endif

    dispbegin()
       dispbox(0,0,maxrow(),maxcol(),replicate(chr(176),9),"b+/b")

       DOUBLEBOX( nTop,nLeft,nBottom,nRight-1, "w+/bg" )
       setcolor("n/w")

       // quick shadow
       for kk := 1 to 20
           @nRow++,73 say chr(176) color "n+/n"
       next
       @nRow,7 say replicate(chr(176),67) color "n+/n"
    dispend()

    b := TBrowseDB( nTop+1, nLeft+1, nBottom-1, nRight-2 )
    b:colorSpec := "W+/BG,N/W,W/N,N,GR+/W,N/BG,B+/BG,GR+/BG,W+/B"
    b:headSep   := CHR(205) + CHR(209) + CHR(205)
    b:colSep    := CHR(32)  + CHR(179) + CHR(32)

    column:= TBColumnNew( "Record#", {|| RECNO()} )
    b:addColumn( column )

    column:= TBColumnNew( "Field 2", FIELDBLOCK("fld2") )
    /*
    * Picture clause for editing cell
    * (Have not seen any documentation on this in the Clipper manual)
    */
    column:picture := "!XXXXXXXXX"
    column:width   := 10
    column:cargo   := { ValidBlock() }
    b:addColumn( column )

    column:= TBColumnNew( "Field 3", FIELDBLOCK( "fld3" ) )
    column:picture := "@!"
    column:width   := 30
    column:cargo   := { ValidBlock() }
    b:addColumn( column )

    column:= TBColumnNew( "Field 4", FIELDBLOCK("fld4") )
    column:picture := "99999"
    column:width   := 7
    column:cargo   := { ValidBlock() }
    b:addColumn( column )

    column:= TBColumnNew( "Field 5", FIELDBLOCK("fld5") )
    column:picture := "99999.99"
    column:width   := 10
    column:cargo   := { ValidBlock() }
    b:addColumn( column )

    while .t.

        b:colorRect({b:rowPos, b:freeze + 1, b:rowPos, b:colCount}, {1, 1})

        // keep current record updated for network environment
        StableOne(b)

        b:colorRect({b:rowPos, b:freeze + 1, b:rowPos, b:colCount}, {9, 2})

        // highlight current cell 
        b:hilite()

        // horizontal scroll-bar
        BrowHorizScrollBar( b, nBottom , nLeft +1, nRight -2 )

        if ( b:hitTop .or. b:hitBottom )
            tone(25,1)
        endif

        nKey := INKEY(0)

        if !TBMoveCursor( b, nKey )
            IF ( nKey == K_ESC )
                // seealso exit procedure
                quit
            elseif ( nKey == K_ENTER .and. b:stable )
                // lock record for network environment
                if dbrlock(RECNO())
                    DoGet( b )
                    dbunlock()
                else
                    alert("Record in use by another user")
                endif
            endif
        endif
    enddo

return (nil)

/*
* function name: TBMoveCursor( <object>, <numeric Key> ) --> logical
*       purpose: method for traversing a browse
*       returns: logical .T. if key was scanned, .F. if key not scanned
*      comments: could have used a do-case statemtent.
*/
static function TBMoveCursor( o, nKey )
    local nFound

    static aKeys := ;
    { K_DOWN       , { |obj| obj:down()      }   ,;
      K_UP         , { |obj| obj:up()        }   ,;
      K_PGDN       , { |obj| obj:pageDown()  }   ,;
      K_PGUP       , { |obj| obj:pageUp()    }   ,;
      K_CTRL_PGUP  , { |obj| obj:goTop()     }   ,;
      K_CTRL_PGDN  , { |obj| obj:goBottom()  }   ,;
      K_RIGHT      , { |obj| obj:right()     }   ,;
      K_LEFT       , { |obj| obj:left()      }   ,;
      K_HOME       , { |obj| obj:home()      }   ,;
      K_END        , { |obj| obj:end()       }   ,;
      K_CTRL_LEFT  , { |obj| obj:panLeft()   }   ,;
      K_CTRL_RIGHT , { |obj| obj:panRight()  }   ,;
      K_CTRL_HOME  , { |obj| obj:panHome()   }   ,;
      K_CTRL_END   , { |obj| obj:panEnd()    }    ;
    }

    nFound := ascan( aKeys, nKey )
    if ( nFound != 0 )
        eval( aKeys[ ++nFound ], o )
    endif
return (nFound != 0)

/*
* function name: DoGet( <object> ) --> nil
*       purpose: single editing of a field in a TBrowse
*       returns: Nil
*      comments: uses GetNew
*/
static function DoGet( obj )
    local nCurs, xOldKey, column, nKey, g := getnew(), nRec := 0
    local bNewHandler, bOldHandler

    /*
    * this local error-handler is a little trick that prevents the
    * program from crashing when a user attempts to edit the first
    * column in the browse (record number). Since there is nothing
    * in the cargo slot, as in the other columns.
    */

    bNewHandler := { | oError | DoGetError( oError, bOldhandler) }
    bOldHandler := errorblock( bNewhandler )

    begin sequence
        StableOne( obj )
        column      :=  obj:getColumn( obj:colPos )
        xOldKey     :=  &(indexkey(0))
        nRec        :=  recno()
        nCurs       :=  setcursor(SC_NORMAL)
        g:row       :=  row()
        g:col       :=  col()
        g:block     :=  column:block
        g:postBlock :=  column:cargo[1]
        g:picture   :=  column:picture
        g:colorspec :=  "w+/bg,w+/b"
        READMODAL( {g} )
    end sequence

    // restore original error handler
    errorblock( bOldHandler )

    setcursor(SC_NONE)

    // make sure we are positioned correctly in the browse window
    if !( &(indexkey(0)) == xOldKey )
        ForceRefresh( obj )
        while (recno() <> nRec)
            obj:up()
            obj:ForceStable()
        enddo
    endif

    nKey := lastkey()

    if (nKey==K_UP .or. nKey==K_DOWN .or. nKey==K_PGUP .or. nKey==K_PGDN)
        KEYBOARD CHR( nKey )
    endif

return (nil)


/*
* function name: DoGetError() --> logical
*       purpose: Used to prevent editing of TBs first column
*       returns: Logical
*      comments: None
*/
static function DoGetError( oError, bOldhandler)
    break
return (.t.)

/*
* function name: BrowHorizScrollbar( <numeric coordinates> ) --> nil
*       purpose: show position in a tbrowse
*       returns: Nil
*      comments: None
*/
static function BrowHorizScrollBar(obj, nBottom, nLeft, nRight)
    static lIsStart := .T., nWindow, nInitPos, nNewPos

    DISPBEGIN()
    // First time
    if lIsStart
       lIsStart := .F.
       nWindow  := nRight - nLeft
       nInitPos := 0
       @ nBottom,nLeft say replicate(chr(176),nWindow+1) COLOR BARCOLOR
       @ nBottom,nLeft SAY CHR(4) COLOR BUTTONCOLOR
 
    endif
 
    // Update Bar Gauge
    nNewPos := nWindow / (obj:colCount / obj:colPos)
    if ( obj:colPos == 1 )
       nNewPos := 0
 
    elseif ( obj:colCount == obj:colPos )
       nNewPos := nWindow
 
    endif
 
    if ( nInitPos != nNewPos )
       @ nBottom,nLeft + nInitPos SAY CHR(176) COLOR BARCOLOR
       @ nBottom,nLeft + nNewPos  SAY CHR( 4 ) COLOR BUTTONCOLOR
       nInitPos := nNewPos
 
    endif
    DISPEND()
return (nil)

ANNOUNCE RDDSys


/*
* Procedure name: RDDInit
*        purpose: Tells CA-Clipper which drivers we will need to use
*       comments: In this example the procedure does not need to be
*               : used, because CA-Clipper's default driver is DBFNTX
*               : but I'am including it anyways in all my programs so
*               : that if I need to add another driver, there is just
*               : that much less code to write later.
*/
init Procedure RDDInit()
    request dbfntx
return

/*
* Procedure name: startup
*        purpose: used to set some defaults for the demo prior to main code.
*       comments: None
*/
init Procedure startup
    set(_SET_SCOREBOARD,.F.)
    set(_SET_CONFIRM,.T.)
    READEXIT(.T.)
    // not really needed, since this is the default driver!
    RDDSETDEFAULT("DBFNTX")
    setcursor(SC_NONE)
return

/*
* Procedure name: SoLong
*        purpose: last set of instructions prior to exiting the demo
*       comments: None
*/
exit Procedure SoLong
    setcolor("w/n")    
    CLS
    SETCURSOR(SC_NORMAL)
return
