/*

TBCOLR.PRG by Hannes Ziegler ( CIS 100142,302 )

********
Content:
  Func ToggleTBColor( oTBrowse, aColor1, aColor2 )
    oTbrowse - a Tbrowse-object
    aColor1  - 2 dim array that holds pointers into oTBrowse:Colorspec
    aColor2  - same as aColor1

************
Description:
  The idea to develop func ToggleTBColor() arised from a forum member
  who had the problem to switch colors for a TBrowse between focused
  and unfocused state. Usually this can be achieved by reassigning
  ColorSpec. However, this implies a refreshAll() which really can
  be annoying if TBrowse is displaying a filtered DBF, it gets too slow.
 
  ToggleTBColor() toggles colors and is intended to be used if a TBrowse
  looses focus. It is one more example to access TBrowse internals
  because it takes advantage of the internal ColorRect information of a
  TBrowse.

  The func changes ColorRect-bytes, redisplays current data in different
  colors and resets TBrowse to the original state.

******
Usage:
  ToggleTBColor( oTBrowse , {{1,2},{3,2}} , {{4,5},{6,5}} )

  aColor1 is an array which holds arrays with 2 elements that contain
  pointers into ColorSpec (each element has exactly the same meaning as
  TBColumn:DefColor). The same meaning has aColor2. Within the func the
  colors are being changed from aColor1 to aColor2. In this example, all
  cells that have colors 1,2 will be changed to colors 4,5 and cells
  with colors 3,2 will show up in color 6,5 .

  Try to define following for TBrowse and its TBColumns:
    oTbrowse :ColorSpec  := "W+/BG,W+/R,W+/G,N/BG,N/R,N/G"

    oTBColumn:ColorBlock := {||if( recno() % 2==0 , {1,2}, {3,2} ) }

  Then issue a
    setkey( K_F6 ,;
     {|| ToggleTBColor( oTBrowse, {{1,2},{3,2}} , {{4,5},{6,5}} ) };
    )

  and go into your browse loop. Then watch what happens.

  (I was surprised myself how fast it is. It does not call a stabilize(),
   unlike a oTBrowse:ColorSpec:=cColorString would do, it just redisplays
   the existing virtual screen in different colors)

***********
Disclaimer:
  This is freeware. The function accesses TBrowse internals which are
  not supposed to be accessed. You use the func on your own risk!

  If you are not familiar with TBrowse internals, you are strongly
  advised to refer to TBINFO.ZIP in lib 2 for detailed information

  If you have comments or questions please post a message

*/

************************************************
Func ToggleTBColor( oTBrowse, aColor1, aColor2 )
local nVScreenLen:=bin2i(substr(atail(oTbrowse),13))
local cColorRect :=substr(atail(oTbrowse),85+nVScreenLen+12*oTBrowse:ColCount)
local cOriginal, cBytes1, cBytes2, i, nLen := min(len(aColor1),len(aColor2))

for i:=1 to nLen
  cBytes1   := chr( aColor1[i,1] ) + chr( aColor1[i,2] ) // Match-color
  cBytes2   := chr( aColor2[i,1] ) + chr( aColor2[i,2] ) // Result-color
	cColorRect:= strtran( cColorRect, cBytes1, cBytes2 )
next

// get a true string copy of atail(oTBrowse) using substr()
cOriginal := substr(atail(oTBrowse),1)

oTbrowse[len(oTbrowse)]:=substr(atail(oTbrowse),1,84+nVScreenLen+12*oTBrowse:ColCount)+cColorRect

oTbrowse : invalidate()
while ! oTbrowse:stabilize() ; end

// reset to original state
oTbrowse[len(oTbrowse)]:=cOriginal

return oTBrowse
