unit RegViewM;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Tbag, StdCtrls, ComCtrls, ExtCtrls, Buttons;

type
  TfrmRegViewMain = class(TForm)
    Bag1: TBag32;
    Tree: TTreeView;
    Memo1: TMemo;
    Panel1: TPanel;
    btnDisplay: TButton;
    edSubKey: TEdit;
    cbHKEY: TComboBox;
    udLevels: TUpDown;
    edLevels: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    btnMemoFont: TSpeedButton;
    btnTreeFont: TSpeedButton;
    dlgFont: TFontDialog;
    dlgColor: TColorDialog;
    Bag2: TBag32;
    SpeedButton1: TSpeedButton;
    procedure FormShow(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure Bag2BeforeGetAll(Sender: TObject);
    procedure Bag2AfterGetAll(Sender: TObject);
    procedure btnDisplayClick(Sender: TObject);
    procedure Bag2GetAll(Sender: TObject; const Key: String;
      Level: Integer; const Ident, Value: String; var Continue: Boolean);
    procedure Bag2GetAllNewLevel(Sender: TObject; const Key: String;
      Level: Integer; var Continue: Boolean);
    procedure TreeClick(Sender: TObject);
    procedure cbHKEYChange(Sender: TObject);
    procedure btnMemoFontClick(Sender: TObject);
    procedure btnTreeFontClick(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
  private
    Nodes: array[0..20] of TTreeNode;
    KeyList: TStringList;
  public
    { Public declarations }
  end;

var
  frmRegViewMain: TfrmRegViewMain;

implementation

{$R *.DFM}

uses About3K;

procedure TfrmRegViewMain.FormShow(Sender: TObject);
begin
  with Bag1 do begin
    GetFormPlace('FORMPLACE',Self);
    cbHKey.ItemIndex := GetInteger('HKEY',Ord(RKEY_CURRENT_USER));
    edSubKey.Text := GetString('SUBKEY',edSubKey.Text);
    edLevels.Text := GetString('LEVELS',edLevels.Text);
    
    Tree.Font := GetFont('TREE_FONT',Tree.Font);
    GetFontAndColor('MEMO_FAC',Memo1);
  end;
  KeyList := TStringList.Create;
  cbHKEYChange(cbHKEY);
end;

procedure TfrmRegViewMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  KeyList.Free;
  with Bag1 do begin
    SetFormPlace('FORMPLACE',Self);
    SetInteger('HKEY',cbHKey.ItemIndex);
    SetString('SUBKEY',edSubKey.Text);
    SetString('LEVELS',edLevels.Text);
  end;
end;

procedure TfrmRegViewMain.Bag2BeforeGetAll(Sender: TObject);
begin
  Tree.Items.BeginUpdate;
  Tree.Items.Clear;
  KeyList.Clear;
end;

procedure TfrmRegViewMain.Bag2GetAllNewLevel(Sender: TObject; const Key: String;
  Level: Integer; var Continue: Boolean);
begin
  if Level >= High(Nodes) then Exception.Create('nesting level exceeded');
  Nodes[Level+1] := Tree.Items.AddChild(Nodes[Level],Key);
  Nodes[Level+1].Data := nil;
end;

procedure TfrmRegViewMain.Bag2GetAll(Sender: TObject; const Key: String;
  Level: Integer; const Ident, Value: String; var Continue: Boolean);
var
  s: string;
begin
  if Length(Value) < 36 then s := Value
  else s := Format('<String L=%d>',[Length(Value)]); 
  Nodes[Level+1] := Tree.Items.AddChild(Nodes[Level],Format('%s = %s',[Ident,s]));
  KeyList.Add(Key+'\'+Ident);
  Nodes[Level+1].Data := Pointer(KeyList.Count);
end;

procedure TfrmRegViewMain.Bag2AfterGetAll(Sender: TObject);
begin
  Tree.Items.EndUpdate;
end;

procedure TfrmRegViewMain.btnDisplayClick(Sender: TObject);
begin
  Screen.Cursor := crHourGlass;
  try
    Bag2.GetAll(edSubKey.Text,StrToInt(edLevels.Text));
  finally
    Screen.Cursor := crDefault;
  end;
end;

procedure TfrmRegViewMain.TreeClick(Sender: TObject);
var
  Node: TTreeNode;
begin
  Node := (Sender as TTreeView).Selected;
  if Node.Data <> nil then
    Bag2.GetStrings(KeyList[Integer(Node.Data)-1],Memo1.Lines);
end;

procedure TfrmRegViewMain.cbHKEYChange(Sender: TObject);
begin
  Bag2.RootKey := TRootKey((Sender as TComboBox).ItemIndex);
end;

procedure TfrmRegViewMain.btnMemoFontClick(Sender: TObject);
begin
  with dlgColor do begin
    Color := Memo1.Color;
    if Execute then begin
       Memo1.Color := Color;
       with dlgFont do begin
         Font := Memo1.Font;
         if Execute then Memo1.Font := Font;
         Bag1.SetFontAndColor('MEMO_FAC',Memo1);
       end;
    end;
  end;
end;

procedure TfrmRegViewMain.btnTreeFontClick(Sender: TObject);
begin
  with dlgFont do begin
    Font := Tree.Font;
    if Execute then begin
      Tree.Font := Font;
      Bag1.SetFont('TREE_FONT',Tree.Font);
    end;
  end;
end;

procedure TfrmRegViewMain.SpeedButton1Click(Sender: TObject);
begin
  with TfrmAbout3K.Construct('About RegView') do try
    ShowModal;
  finally
    Free;
  end;
end;

end.
