/*
 * File......: TBACHO.CH
 * Author....: Steve Kolterman
 * CIS ID....: 76320,37
 * Date......: November 5, 1993
 * 
 * See the README.1ST file in TBACHO.ZIP for restrictions on redistribution. 
 *
*/

/*  $DOC$
 *  $FUNCNAME$
 *     A_CHOICE()
 *  $ONELINER$
 *     Psuedo function to simplify TBACHOICE()
 *  $CATEGORY$
 *     Menus/Prompts
 *  $SYNTAX$
 *     TBACHOICE()
 *  $ARGUMENTS$
 *     See TBACHOICE()
 *
 *  $RETURNS$
 *     See TBACHOICE()
 *
 *  $DESCRIPTION$
 *     The A_CHOICE() UDC makes using TBACHOICE() a breeze.
 *     The myriad of parameters can be written in any order.  Only <nToprow>,
 *     <nTopcol>, and <aArrey> are required.  See the example below.
 *
 *     Be sure to check the documentation for TBACHOICE() for more
 *     details.
 *
 *
 *  $EXAMPLES$
 *  nOpt := A_CHOICE( 7,9,, ARRAY:t_arrey USERFUNC:{|a,b| UserFunc(a,b,any1)};
 *          BOXTYPE:B_SINGLE  BOXTITLE:title  SHADOW:"R" TAGCHAR:chr(17);
 *          REST_SCREEN:.F. AUTOEXEC:.F. MES_COLOR:MSG_COLOR ELEVBAR:"" ;
 *          NOSELCOLOR:"bg/n")
 *
 *  Check only the RETURNed element:
 *  IF Was_Tagged(chr(17),t_arrey,nOpt); MoreProcessing(); END
 *
 *  Check entire 't_arrey':
 *  Aeval( t_arrey,{|e,n| IF( Was_Tagged(chr(17),t_arrey,n ), ;
 *                            MoreProcessing(t_arrey),NIL ) } )
 *
 *
 *  $SEEALSO$
 *     TBACHOICE()
 *  $END$
 */


#xtrans A_CHOICE(                                                    ;
        <t>,<l>,[<b>],[<r>]                                          ;
        ARRAY:<arr>                                                  ;
        [USERFUNC:<func>]                                            ;
        [BOXTYPE:<bx>]                                               ;
        [BOXCOLOR:<bxc>]                                             ;
        [BOXTITLE:<bxt>]                                             ;
        [TITLEPOS:<bxp>]                                             ;
        [USELCOLOR:<uselc>]                                          ;
        [TITLECOLOR:<ttlc>]                                          ;
        [BAR_COLOR:<barc>]                                           ;
        [HOTKEYCOLOR:<hkcolor>]                                      ;
        [SHADOW:<sh>]                                                ;
        [AUTOEXEC:<aex>]                                             ;
        [MES_ROW:<mrow>]                                             ;
        [MES_COL:<mcol>]                                             ;
        [MES_COLOR:<mcolor>]                                         ;
        [ELEVBAR:<ebar>]                                             ;
        [ELEVBAR_COLOR:<ebarc>]                                      ;
        [ELEVBAR_SIDE:<ebars>]                                       ;
        [NOSELCOLOR:<nscolor>]                                       ;
        [TAGCHAR:<tagch>]                                            ;
        [START_ELEM:<start>]                                         ;
        [REST_SCREEN:<rscrn>]                                        ;
        [TIME_OUT:<timeout>]                                         ;
        [TIME_OUT VALUE:<toval>]                                     ;
        [SAVE_TAGS:<st>]  )                                          ;
        =>                                                           ;
        TBACHOICE(                                                   ;
                   <t>,<l>,[<b>],[<r>],<arr>, [<bx>],                ;
                   [<bxc>], [<bxt>], [<bxp>], [<uselc>], [<ttlc>],   ;
                   [<barc>], [<hkcolor>], [<sh>], [<aex>], [<mrow>], ;
                   [<mcol>], [<mcolor>], [<ebar>], [<ebarc>],        ;
                   [<ebars>], [<nscolor>], [<tagch>], [<start>],     ;
                   [<rscrn>],[<timeout>],[<toval>],[<st>],[<func>]   ;
                 )

#translate WAS_TAGGED(<tchar>,<arr>,<val>)   =>                         ;
           ( <tchar> $ <arr>\[<val>]\[1] ) 

#translate ONE_TAGGED(<tchar>,<arr>)         =>                         ;
           (Ascan(<arr>,{|e| <tchar> $ e\[1]})) > 0

#translate ALL_TAGGED(<tchar>,<arr>)         =>                         ;
           (Ascan(<arr>,{|e| !(<tchar> $ e\[1]})) ) == 0
