#ifndef _LSYSTEM_H
#define _LSYSTEM_H
/* Number of defines below is to override compiler's */
#define PATHSIZE	260
#ifndef S_IFLNK
#	define S_IFLNK 0120000
#endif

#define OM_RDONLY	0
#define OM_WRONLY	1
#define OM_RDWR		2

#define OA_OPENONLY	1
#define OA_TRUNCATE	2
#define OA_CREATENEW	16

typedef struct {
	char far *filenameP;
	unsigned char far *unopened_fcbP;
	union {
		int lfn_handle;
		unsigned char fcb_reserved[44];
	} reserved;
} lcwdent_t;

extern char lfn_active;

int dosgetdisk(void);
int dossetdisk(int);
int lgetcurdir(int drive, char far *dest);
int laction(int a, char far *path);
int lopen4(char far *filename, int mode, int action, int attributes);
int dosclose(int handle);
int doswrite(int handle, void far *buffer, unsigned length);
int dosread(int handle, void far *buffer, unsigned length);
long dosseek(int handle, long offs, int whence);
int lchmod(char far *filename, int op, int mode);
int near pascal old_find1st(void far *fcbP, char far *nameP);
int lfindfirst(lcwdent_t far *cdwentP, char far *pattern, int attributes);
int lfindnext(lcwdent_t far *cdwentP);
int lfindend(lcwdent_t far *cdwentP);
long lgetmtime(char far *path);
int lrename(char far*, char far*);

#define mkdir(p)	laction(0x39, (p))
#define rmdir(p)	laction(0x3A, (p))
#define chdir(p)	laction(0x3b, (p))
#define unlink(p)       laction(0x41, (p))
#define open(p,m)	lopen4((p),(m),1,0)
#define creat(p,a)	lopen4((p),2,18,(a))
#define creatnew(p,a)	lopen4((p),2,16,(a))
#define read		dosread
#define write		doswrite
#define lseek		dosseek
#define close		dosclose
#define chmod		lchmod
#define rename		lrename
#endif
