# $Revision: 1.20 $
#
# Makefile for tags using Microsoft compilers
#
# Created 03-28-91 JBK
# Last Modified Mon, 09/04/1995 22:42:13
#

#
# The next two variables should be the only thing you need modify for
# users of Microsoft compilers.  This makefile was created and tested
# using MSVC V2.1 (Win32), MSVC V1.52 (Win16) and OPUS Make V6.04.
# To use NMAKE with this file you will need to modify the %set and
# %setenv shell lines appropriately.
#
MSVC_PATH	= c:\msvc
MSVC_PATH_32	= e:\msvc20

#
# Here is a command line for the sort module to create a standalone
# sort executable.  This is not compiled by default for space and
# context reasons.  Note that you must not have a sort.obj from the
# tags package already compiled (or it is guaranteed to mess with
# your mind a bit).  This is the DOS command line.
#
#
#sort.exe: sort.c sort.h std.h
#    $(CC) -F 8000 sort.c $(MSC_PATH)\lib\setargv.obj /link /NOE
#

#
# Default environment, DOS debug
#
PLATFORM = DOS
FLAGS = D_FLAGS_$(PLATFORM)
LFLAGS = D_LFLAGS_$(PLATFORM)

#
# This is environment flags for DOS
#
CC_DOS		= cl /AL /W4 /DMSDOS /Zp1 $(FLAGS)
LINK_DOS	= link /NOI /ST:0x8E00 $(LFLAGS)
P_FLAGS_DOS	= /G2 /Gy /Ocgilptz /Oa /Ob2 /Gs /Gr
P_LFLAGS_DOS	= /E /F /PACKC /EXEPACK
D_FLAGS_DOS	= /Od /Zi /qc /D_DEBUG
D_LFLAGS_DOS	= /CO /M

#
# This is environment flags for Windows GUI (Win16)
#
CC_W16		= cl /AL /W4 /DWIN16 /Zp1 $(FLAGS)
LINK_W16	= link /align:16 /NOL /ON:N /NOE /NOD /M $(LFLAGS)
P_FLAGS_W16	= /G2 /Gy /Ocegilptz /Oa /Ob2 /Gs /Gr
P_LFLAGS_W16	= /F
D_FLAGS_W16	= /Od /Zi /qc /D_DEBUG
D_LFLAGS_W16	= /CO

#
# This is environment flags for NT
#
CC_NT		= cl /W4 /D_CONSOLE /DNT /Zp1 $(FLAGS)
LINK_NT		= link $(LFLAGS)
P_FLAGS_NT	= /D_X86_ /DNT /O2 /Ob2 /G5 /DNDEBUG
P_LFLAGS_NT	= /SUBSYSTEM:console netapi32.lib
D_FLAGS_NT	= /D_X86_ /DNT /D_DEBUG /Zi /Fd"TAGS.PDB"
D_LFLAGS_NT	= /DEBUG /DEBUGTYPE:cv /SUBSYSTEM:console netapi32.lib

#
# This is environment flags for NT GUI (WIN32)
#
CC_W32		= cl /W4 /DWIN32 /Zp1 $(FLAGS)
LINK_W32	= link $(LFLAGS)
P_FLAGS_W32	= /D_X86_ /DNT /O2 /Ob2 /G5 /DNDEBUG
P_LFLAGS_W32	= /SUBSYSTEM:windows,4.0 netapi32.lib
D_FLAGS_W32	= /D_X86_ /DNT /D_DEBUG /Zi /Fd"TAGS.PDB"
D_LFLAGS_W32	= /DEBUG /DEBUGTYPE:cv /SUBSYSTEM:windows,4.0 netapi32.lib


#
# default rule for C and RC file compilation
#
.c.obj:
	$(CC_$(PLATFORM)) /c $<

.rc.res:
	rc -r tags.rc

.rc.rbj:
	rc /DWIN32 /D_WIN32 $*.rc
	cvtres -r -i386 -o $*.rbj $*.res

#
# default target is usage statement
#
usage:
	!message                                        
	!message Usage: 'make target' where target is:  
	!message                                        
	!message   clean                - remove extraneous build offal
	!message                                        
	!message   all                  - make all production binaries
	!message                                        
	!message   debug_dos            - debug DOS     
	!message   debug_nt             - debug NT console mode
	!message   debug_win16          - debug Win16 GUI
	!message   debug_win32          - debug Win32 GUI
	!message   product_dos          - optimized DOS 
	!message   product_nt           - optimized NT console mode
	!message   product_win16        - optimized Win16 GUI
	!message   product_win32        - optimized Win32 GUI
	!message


#
# build targets
#

all:
	@-$(MAKE) clean
	@-$(MAKE) product_dos
	@-$(MAKE) clean
	@-$(MAKE) product_nt 
	@-$(MAKE) clean
	@-$(MAKE) product_win16 
	@-$(MAKE) clean
	@-$(MAKE) product_win32
	@-$(MAKE) clean

debug_dos: _DOS _Debug tagsDOS.exe
debug_nt: _NT _Debug tagsNT.exe
debug_win16: _W16 _Debug tagsW16.exe
debug_win32: _W32 _Debug tagsW32.exe

product_dos: _DOS _Product tagsDOS.exe
product_nt: _NT _Product tagsNT.exe
product_win16: _W16 _Product tagsW16.exe
product_win32: _W32 _Product tagsW32.exe


#
# environment targets
#

_MSVC16:
	%setenv lib=$(MSVC_PATH)\lib;$(MSVC_PATH)\mfc\lib;
	%setenv include=$(MSVC_PATH)\include;$(MSVC_PATH)\mfc\include;
	%setenv helpfiles=$(MSVC_PATH)\help\*.hlp
	%setenv path=$(MSVC_PATH)\bin;$(PATH);

_MSVC32:
	%setenv lib=$(MSVC_PATH_32)\lib;$(MSVC_PATH_32)\mfc\lib;
	%setenv include=$(MSVC_PATH_32)\include;$(MSVC_PATH_32)\mfc\include;
	%setenv helpfiles=$(MSVC_PATH_32)\help\*.hlp
	%setenv path=$(MSVC_PATH_32)\bin;$(PATH);

_DOS: _MSVC16
	%set PLATFORM = DOS

_NT: _MSVC32
	%set PLATFORM = NT

_W16: _MSVC16
	%set PLATFORM = W16

_W32: _MSVC32
	%set PLATFORM = W32

_Debug:
	%set FLAGS = $(D_FLAGS_$(PLATFORM))
	%set LFLAGS = $(D_LFLAGS_$(PLATFORM))

_Product:
	%set FLAGS = $(P_FLAGS_$(PLATFORM))
	%set LFLAGS = $(P_LFLAGS_$(PLATFORM))

clean:
	@del *.obj
	@del *.res
	@del *.pdb
	@del *.ilk
	@del *.map
	@del *.rbj


#
# exe build targets
#

OBJS = arglist.obj asmtag.obj ctag.obj match.obj flags.obj log.obj \
       shell.obj sort.obj tagio.obj validcrc.obj wildfile.obj \
       compile.obj

tagsDOS.exe: $(OBJS)
    $(LINK_$(PLATFORM)) $**, $@;
    CRCSET $@

tagsW16.exe: $(OBJS) tags.res tags.def
    $(LINK_$(PLATFORM)) $(OBJS) $(MSVC_PATH)\lib\oldnames.lib, $@,, libw llibcew, tags.def
    rc -k tags.res $@
    CRCSET $@

tagsNT.exe: $(OBJS)
    $(LINK_$(PLATFORM)) @<<
$**
<< /OUT:$@
    CRCSET $@

tagsW32.exe: $(OBJS) tags.rbj tags.def
    $(LINK_$(PLATFORM)) @<<
$(OBJS) tags.rbj
<< /OUT:$@
    CRCSET $@


#
# OBJ dependencies
#

sort.obj: sort.c sort.h std.h
    $(CC_$(PLATFORM)) /c /DSORT_MODULE /DSTDC_HEADERS /DUSG /D__STDC__ sort.c

match.obj: match.h
    $(CC_$(PLATFORM)) /c /DFILE_MATCH match.c

shell.obj: flags.h log.h sort.h wildfile.h viruscrc.h resource.h \
           tagio.h ctag.h asmtag.h arglist.h flags.h compile.h

wildfile.obj: wildfile.h match.h

tagio.obj: tagio.h log.h flags.h

log.obj: log.h flags.h resource.h

ctag.obj: ctag.h flags.h log.h tagio.h

asmtag.obj: asmtag.h flags.h tagio.h

arglist.obj: arglist.h log.h flags.h

flags.obj: flags.h log.h

validcrc.obj: viruscrc.h

compile.obj: compile.h tagio.h flags.h log.h
