/*example extern-file of OffTag 1.1
  Parameters :
    Com-Handle         File-Handle of an open Com-Port (This is a number)
    NodeNo             for which Node this Script is launched
    filename           Fully qualified and in Quotes (e.g.  "c:\x\HEYYOU.ZIP")

*/
parse upper arg comhandle nodeno '"' filename '.' ext '"'

nodeno=strip(nodeno)
comhandle=strip(comhandle)

SIGNAL ON SYNTAX NAME usergone /* if remote & user hangsup, goto usergone. */

CALL init                      /* register extensions with REXX */

fnamepos=0
startsig=""
stopsig=""
unpack=""

fileid="FILEID.TXT"
tempdir="C:\TEMP"

idnames=3
idname.1="FILE_ID.GER"
idname.2="FILE_ID.DIZ"
idname.3="FEATURES.DOC"

ziplist="@c:\tools\pack\unzip -l"
zipstartsig=" ------"
zipstopsig=" ------"
zipfname=28
unzip="@c:\tools\pack\unzip -x -j -o "

arjlist="@c:\tools\pack\unarj l"
unarj="@c:\tools\pack\unarj e "
arjfname=1
arjstartsig="------------"
arjstopsig= "------------"

lzhlist="@c:\tools\pack\lh l /o"
unlzh="@c:\tools\pack\lh x /o "
lzhfname=22
lzhstartsig="  -------- "
lzhstopsig= "  -------- "


/***********************/

screenlines=23
listlines=screenlines-2

/***********************/
"@if exist "fileid" del "fileid

savedir=directory()
nowdir=directory(tempdir)
if translate(nowdir)<>translate(tempdir) then do
  say "Wrong Temp-Directory"
  exit
end

tempfile="getid"nodeno".tmp"

rc = RxAnsiInit()              /* Set up ANSI variables */
if (Comhandle <>'') & (Comhandle<>0) then do        /* If remote user */
  rc = RxMode(MIXED,Comhandle) /* set mode to mixed */
  local=0
end
else local=1

CRLF='0d'x'0a'x


ok=1
rc=Statusline("Gathering archive data. Please Wait...")
select
  when ext="ARJ" then do
      arjlist filename ">"tempfile
      fnamepos=arjfname
      startsig=arjstartsig
      stopsig=arjstopsig
      unpack=unarj
    end
  when ext="ZIP" then do
      ziplist filename ">"tempfile
      fnamepos=zipfname
      startsig=zipstartsig
      stopsig=zipstopsig
      unpack=unzip
    end
  when ext="LZH" then do
      lzhlist filename ">"tempfile
      fnamepos=lzhfname
      startsig=lzhstartsig
      stopsig=lzhstopsig
      unpack=unlzh
    end
  otherwise do
    rc=BottomLine("Archive-Type not supported.")
    key=RxGetChar()
    ok=0
  end
end

filenum=0
if ok=1 then do
  if startsig<>"" then
    show=0
  else
    show=1
  key=""
  do while Lines(tempfile)>0
    line=substr(linein(tempfile),1,77)
    if stopsig<>"" & substr(line,1,length(stopsig))=stopsig then show=0
    if show then do
      fname=word(substr(line,fnamepos,77),1)
      if fname<>"" then do
        do i=1 to idnames
          if translate(idname.i)=translate(filespec("Name",fname)) then do
            filenum=filenum+1
            files.filenum=fname
          end
        end
      end
    end
    if startsig<>"" & substr(line,1,length(startsig))=startsig then show=1
  end
  rc=lineout(tempfile)

  if filenum>0 then do
    i=1
    do until i>filenum
      rc=StatusLine("Unpacking Filename : "files.i)

      name=filespec("Name",files.i)
      "@if exist "name" del "name
      unpack" "filename" "files.i
      call dumpfile name

      rc=BottomLine("Take this file as File-Description ? (Yes/No/ESC)")
      do until key="Y" | key="N" | key="ESCAPE"
        key=translate(RxGetChar())
      end
      if key="Y" then do
        i=filenum /*end loop after this*/
        "@copy "name" "savedir"\"fileid
      end
      if key="ESCAPE" then i=filenum /*end loop*/

      "@if exist "name" del "name
      i=i+1
    end
  end
  else do
    rc=BottomLine("None of the defined description filenames has been found.")
    key=RxGetChar()
  end
end
"@if exist "tempfile" del "tempfile
rc=directory(savedir)
rc=BottomLine("Returning to OffTag")
exit

/**************************/
dumpfile:
parse arg fname

buffer=""
maxbufflen=100

if fname<>"" then do
  rc=StatusLine("Displaying File "fname)
  line=0
  eof=0
  do while eof=0
    if dumpline(fname)=0 then eof=1
    line=line+1
    if line>=listlines then eof=1
  end
  rc=lineout(fname)
end
else say "No Parameter passed"
return 0

/*************/
dumpline:
parse arg name

if (length(buffer)>0) | (chars(name)>0) then do
  buffer=buffer""Charin(name,,maxbufflen-length(buffer))
  nextcr=pos('0D'x,buffer)
  if (nextcr=0) | (nextcr>80) then
    nextcr=80
  else
    if substr(buffer,nextcr+1,1)='0A'x then
      buffer=delstr(buffer,nextcr+1,1)
  rc=RxPutChars(translate(substr(buffer,1,nextcr-1),,Xrange('00'x,'1F'x),'.')""CRLF)
  buffer=delstr(buffer,1,nextcr)
  if (length(buffer)>0) | (chars(name)>0) then
    return 1
  else
    return 0
end
else return 0

/**************************/
statusline:
  parse arg title
  rc=RxGoto(1,1)
  if length(title)>76 then title=left(title,76)"..."
  leftfillup=40-trunc(length(title)/2)
  rc=RxPutChars(INTENSE""CYAN""ON_BLUE""CLS)
  rc=RxPutChars(YELLOW""ON_Red""left("",leftfillup)""title""left("",79-leftfillup-length(title)))
  rc=RxPutChars(CRLF""CYAN""ON_BLUE)
return 0

/**************************/
bottomline:
  parse arg title
  rc=RxGoto(screenlines,1)
  if length(title)>76 then title=left(title,76)"..."
  leftfillup=40-trunc(length(title)/2)
  rc=RxPutChars(YELLOW""ON_RED""left("",leftfillup)""title""left("",79-leftfillup-length(title)))
  rc=RxGoto(screenlines,1)
return 0


/* --------------------------------------------------------------------- */
/* Register all the functions to REXX                                    */
/* --------------------------------------------------------------------- */
init:
CALL RxFuncAdd 'RXANSIINIT','RXANSI','RXANSIINIT'
CALL RxFuncAdd 'RXGOTO',    'RXANSI','RXGOTO'
CALL RxFuncAdd 'RXMODE',    'RXANSI','RXMODE'
CALL RxFuncAdd 'RXLINE',    'RXANSI','RXLINE'
CALL RxFuncAdd 'RXLINETYPE','RXANSI','RXLINETYPE'
CALL RxFuncAdd 'RXBOX',     'RXANSI','RXBOX'
CALL RxFuncAdd 'RXGETCHAR', 'RXANSI','RXGETCHAR'
CALL RxFuncAdd 'RXGETCHARS','RXANSI','RXGETCHARS'
CALL RxFuncAdd 'RXPUTCHARS','RXANSI','RXPUTCHARS'
RETURN

/* --------------------------------------------------------------------- */
/* Remote user has hung up - tell host and quit                          */
/* --------------------------------------------------------------------- */
usergone:
  IF lastkey = 'USER GONE' THEN
     say 'User gone'
  ELSE
     SAY 'Bug in your Rexx procedure'
  rc=directory(savedir)
  Exit

