
/* Main benchmark file */

#define INCL_DOSMISC
#define INCL_DOSPROCESS
#define INCL_DOSSEMAPHORES   /* Semaphore values */
#include <os2.h>

#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <math.h>

#include "types.h"
#include "pmbbench.h"
#include "pmbdatat.h"


#define KB 1024
#define MB (1204*1204)
#define d1 (12345678.901*(((double)rand())/RAND_MAX+0.5))
#define d2 (12.345678901*(((double)rand())/RAND_MAX+0.5))
#define MIN_DHRY_TIME 10.0
#define MIN_MEASURE 0.1
#define MARGINAL 1.1

static bool mult;  // true -> runs multiple tests in one thread
static void* p;
double mh, mv, md, mm, mc;

extern void PostFin(int);
double dtime(void);
static void EndBench(void);
extern double pmb_fft(void);
extern double pmb_flops(void);
extern double pmb_linpack(void);
extern double pmb_dhry(int);
extern double pmb_hanoi(void);
extern double pmb_heaps(void);
extern double pmb_sieve(void);
extern double pmb_diskio_avseek(int);
extern double pmb_buscache_xfer(int);
extern double pmb_diskio_transfer(int);
extern double pmb_diskio_cpupct(int);
extern double pmb_cdio_avseek(int);
extern double pmb_cdio_transfer(int);
extern double pmb_cdio_cpupct(int);
extern double pmb_dive_bw(void);
extern double pmb_dive_rot(void);
extern double pmb_dive_ms11(void);
extern double pmb_gfx_bitblitss(void);
extern double pmb_gfx_bitblitms(void);
extern double pmb_gfx_dlines(void);
extern double pmb_gfx_hlines(void);
extern double pmb_gfx_patrect(void);
extern double pmb_gfx_fillrect(void);
extern double pmb_gfx_textrender(void);
extern double pmb_gfx_vlines(void);
extern double pmb_memspeed(s32);
extern double pmb_memspeedr(s32);
extern double pmb_memspeedw(s32);
extern void _Optlink TimeThread(void*);
extern double DoFileIO(ULONG, BOOL, BOOL, BOOL);
extern void  AddTitle(char* s);
extern void  DelTitle(void);
extern HEV   hevFileIO;
extern ULONG ulPostCount2;

extern struct glob_data data;
extern int gtWarp;
extern int Beep;
extern ULONG swapfilegrown;
extern ULONG maxswapfilesize;
extern float startsize;
extern volatile int Timeout;
extern BOOL fileiodisabled;

double rt;

void DoAll(void* p)
{
  mult = true;
  DoAllGraphics(p);
  DoAllCPUInt(p);
  DoAllCPUFloat(p);
  DoAllDIVE(p);
  DoFileIOAll(p);
  DoAllMem(p);
  DoAllDiskIOAll(p);
  if (data.nr_cd_drives)
     {
     DoAllCDIOAll(p);
     }
  mult = false;
  PostFin(false);
  if (Beep)
     {
     DosBeep(440, 100);
     DosBeep(550, 75);
     DosBeep(687, 75);
     DosBeep(860, 250);
     }
}


void DoAllCPUFloat(void* p)
{
  if (!mult)
     {
     mult = true;
     AddTitle("Linpack");
     DoCPUFloatLinpack(p);
     DelTitle();
     AddTitle("Flops");
     DoCPUFloatFlops(p);
     DelTitle();
     AddTitle("FFT");
     DoCPUFloatFFT(p);
     DelTitle();
     mult = false;
     PostFin(false);
     }
  else
     {
     AddTitle("Linpack");
     DoCPUFloatLinpack(p);
     DelTitle();
     AddTitle("Flops");
     DoCPUFloatFlops(p);
     DelTitle();
     AddTitle("FFT");
     DoCPUFloatFFT(p);
     DelTitle();
     }
}


void DoAllCPUInt(void* p)
{
  if (!mult)
     {
     mult = true;
     AddTitle("Dhrystone");
     DoCPUIntDhry(p);
     DelTitle();
     AddTitle("Hanoi");
     DoCPUIntHanoi(p);
     DelTitle();
     AddTitle("Heapsort");
     DoCPUIntHeaps(p);
     DelTitle();
     AddTitle("Sieve");
     DoCPUIntSieve(p);
     DelTitle();
     mult = false;
     PostFin(false);
     }
  else
     {
     AddTitle("Dhrystone");
     DoCPUIntDhry(p);
     DelTitle();
     AddTitle("Hanoi");
     DoCPUIntHanoi(p);
     DelTitle();
     AddTitle("Heapsort");
     DoCPUIntHeaps(p);
     DelTitle();
     AddTitle("Sieve");
     DoCPUIntSieve(p);
     DelTitle();
     }
}


void DoAllDIVE(void* p)
{
  if (!mult)
     {
     mult = true;
     AddTitle("DIVE Bandwidth");
     DoDiveVBW(p);
     DelTitle();
     AddTitle("DIVE Fun");
     DoDiveRot(p);
     DelTitle();
     AddTitle("DIVE M->S");
     DoDiveMS11(p);
     DelTitle();
     mult = false;
     PostFin(false);
     }
  else
     {
     AddTitle("DIVE Bandwidth");
     DoDiveVBW(p);
     DelTitle();
     AddTitle("DIVE Fun");
     DoDiveRot(p);
     DelTitle();
     AddTitle("DIVE M->S");
     DoDiveMS11(p);
     DelTitle();
     }
  }


void DoAllDiskIO(void* p)
{
  if (!mult)
     {
     mult = true;
     AddTitle("Disk Avg time");
     DoDiskIOAvSeek(p);
     DelTitle();
     AddTitle("Cache/bus");
     DoDiskCacheXfer(p);
     DelTitle();
     AddTitle("Xfer speed");
     DoDiskIOTransSpeed(p);
     DelTitle();
     AddTitle("CPU %");
     DoDiskIOCPUUsage(p);
     DelTitle();
     mult = false;
     PostFin(false);
     }
  else
     {
     AddTitle("Disk Avg time");
     DoDiskIOAvSeek(p);
     DelTitle();
     AddTitle("Cache/bus");
     DoDiskCacheXfer(p);
     DelTitle();
     AddTitle("Xfer speed");
     DoDiskIOTransSpeed(p);
     DelTitle();
     AddTitle("CPU %");
     DoDiskIOCPUUsage(p);
     DelTitle();
     }
}


void DoAllCDIOAll(void* p)
{
 int i, saved;

 saved = data.selected_cd;

 if (!mult)
    {
    mult = true;
    for (i = 0; i < data.nr_cd_drives; i++)
       {
       data.selected_cd = i;
       DoAllCDIO((void*)i);
       }
    mult = false;
    PostFin(false);
    }
 else
    {
    for (i = 0; i < data.nr_cd_drives; i++)
       {
       data.selected_cd = i;
       DoAllCDIO((void*)i);
       }
    }
 data.selected_cd = saved;
 }


void DoAllDiskIOAll(void* p)
{
 int i, saved;

 saved = data.selected_disk;

 if (!mult)
    {
    mult = true;
    for (i = 0; i < data.nr_fixed_disks; i++)
       {
       data.selected_disk = i;
       DoAllDiskIO((void*)i);
       }
    mult = false;
    PostFin(false);
    }
 else
    {
    for (i = 0; i < data.nr_fixed_disks; i++)
       {
       data.selected_disk = i;
       DoAllDiskIO((void*)i);
       }
    }
 data.selected_disk = saved;
 }


void DoAllCDIO(void* p)
{
  if (!mult)
     {
     mult = true;
     AddTitle("CD Seek time");
     DoCDIOAvSeek(p);
     DelTitle();
     AddTitle("CD Xfer speed");
     DoCDIOTransSpeed(p);
     DelTitle();
     AddTitle("CD CPU %");
     DoCDIOCPUUsage(p);
     DelTitle();
     mult = false;
     PostFin(false);
     }
  else
     {
     AddTitle("CD Seek time");
     DoCDIOAvSeek(p);
     DelTitle();
     AddTitle("CD Xfer speed");
     DoCDIOTransSpeed(p);
     DelTitle();
     AddTitle("CD CPU %");
     DoCDIOCPUUsage(p);
     DelTitle();
     }
}



void DoAllGraphics(void* p)
{
  if (!mult)
     {
     mult = true;
     AddTitle("BitBltS->S");
     DoGfxBlitBlitSS(p);
     DelTitle();
     AddTitle("BitBltM->S");
     DoGfxBlitBlitMS(p);
     DelTitle();
     AddTitle("Filled Rectangle");
     DoGfxFillRect(p);
     DelTitle();
     AddTitle("Pattern Fill");
     DoGfxPatFil(p);
     DelTitle();
     AddTitle("Vertical Lines");
     DoGfxVLines(p);
     DelTitle();
     AddTitle("Horizontal Lines");
     DoGfxHLines(p);
     DelTitle();
     AddTitle("Diagonal Lines");
     DoGfxDLines(p);
     DelTitle();
     AddTitle("Text Render");
     DoGfxTextRender(p);
     DelTitle();
     mult = false;
     PostFin(false);
     }
  else
     {
     AddTitle("BitBltS->S");
     DoGfxBlitBlitSS(p);
     DelTitle();
     AddTitle("BitBltM->S");
     DoGfxBlitBlitMS(p);
     DelTitle();
     AddTitle("Filled Rectangle");
     DoGfxFillRect(p);
     DelTitle();
     AddTitle("Pattern Fill");
     DoGfxPatFil(p);
     DelTitle();
     AddTitle("Vertical Lines");
     DoGfxVLines(p);
     DelTitle();
     AddTitle("Horizontal Lines");
     DoGfxHLines(p);
     DelTitle();
     AddTitle("Diagonal Lines");
     DoGfxDLines(p);
     DelTitle();
     AddTitle("Text Render");
     DoGfxTextRender(p);
     DelTitle();
     }
}


void DoAllMem(void* p)
{
  if (!mult)
     {
     mult = true;
     AddTitle("Mem Copy 5Kb");
     DoMem5(p);
     DelTitle();
     AddTitle("Mem Copy 10Kb");
     DoMem10(p);
     DelTitle();
     AddTitle("Mem Copy 20Kb");
     DoMem20(p);
     DelTitle();
     AddTitle("Mem Copy 40Kb");
     DoMem40(p);
     DelTitle();
     AddTitle("Mem Copy 80Kb");
     DoMem80(p);
     DelTitle();
     AddTitle("Mem Copy 160Kb");
     DoMem160(p);
     DelTitle();
     AddTitle("Mem Copy 320Kb");
     DoMem320(p);
     DelTitle();
     AddTitle("Mem Copy 640Kb");
     DoMem640(p);
     DelTitle();
     AddTitle("Mem Copy 1280Kb");
     DoMem1280(p);
     DelTitle();
     AddTitle("Mem Read 5Kb");
     DoMemR5(p);
     DelTitle();
     AddTitle("Mem Read 10Kb");
     DoMemR10(p);
     DelTitle();
     AddTitle("Mem Read 20Kb");
     DoMemR20(p);
     DelTitle();
     AddTitle("Mem Read 40Kb");
     DoMemR40(p);
     DelTitle();
     AddTitle("Mem Read 80Kb");
     DoMemR80(p);
     DelTitle();
     AddTitle("Mem Read 160Kb");
     DoMemR160(p);
     DelTitle();
     AddTitle("Mem Read 320Kb");
     DoMemR320(p);
     DelTitle();
     AddTitle("Mem Read 640Kb");
     DoMemR640(p);
     DelTitle();
     AddTitle("Mem Read 1280Kb");
     DoMemR1280(p);
     DelTitle();
     AddTitle("Mem Write 5Kb");
     DoMemW5(p);
     DelTitle();
     AddTitle("Mem Write 10Kb");
     DoMemW10(p);
     DelTitle();
     AddTitle("Mem Write 20Kb");
     DoMemW20(p);
     DelTitle();
     AddTitle("Mem Write 40Kb");
     DoMemW40(p);
     DelTitle();
     AddTitle("Mem Write 80Kb");
     DoMemW80(p);
     DelTitle();
     AddTitle("Mem Write 160Kb");
     DoMemW160(p);
     DelTitle();
     AddTitle("Mem Write 320Kb");
     DoMemW320(p);
     DelTitle();
     AddTitle("Mem Write 640Kb");
     DoMemW640(p);
     DelTitle();
     AddTitle("Mem Write 1280Kb");
     DoMemW1280(p);
     DelTitle();
     mult = false;
     PostFin(false);
     }
  else
     {
     AddTitle("Mem Copy 5Kb");
     DoMem5(p);
     DelTitle();
     AddTitle("Mem Copy 10Kb");
     DoMem10(p);
     DelTitle();
     AddTitle("Mem Copy 20Kb");
     DoMem20(p);
     DelTitle();
     AddTitle("Mem Copy 40Kb");
     DoMem40(p);
     DelTitle();
     AddTitle("Mem Copy 80Kb");
     DoMem80(p);
     DelTitle();
     AddTitle("Mem Copy 160Kb");
     DoMem160(p);
     DelTitle();
     AddTitle("Mem Copy 320Kb");
     DoMem320(p);
     DelTitle();
     AddTitle("Mem Copy 640Kb");
     DoMem640(p);
     DelTitle();
     AddTitle("Mem Copy 1280Kb");
     DoMem1280(p);
     DelTitle();
     AddTitle("Mem Read 5Kb");
     DoMemR5(p);
     DelTitle();
     AddTitle("Mem Read 10Kb");
     DoMemR10(p);
     DelTitle();
     AddTitle("Mem Read 20Kb");
     DoMemR20(p);
     DelTitle();
     AddTitle("Mem Read 40Kb");
     DoMemR40(p);
     DelTitle();
     AddTitle("Mem Read 80Kb");
     DoMemR80(p);
     DelTitle();
     AddTitle("Mem Read 160Kb");
     DoMemR160(p);
     DelTitle();
     AddTitle("Mem Read 320Kb");
     DoMemR320(p);
     DelTitle();
     AddTitle("Mem Read 640Kb");
     DoMemR640(p);
     DelTitle();
     AddTitle("Mem Read 1280Kb");
     DoMemR1280(p);
     DelTitle();
     AddTitle("Mem Write 5Kb");
     DoMemW5(p);
     DelTitle();
     AddTitle("Mem Write 10Kb");
     DoMemW10(p);
     DelTitle();
     AddTitle("Mem Write 20Kb");
     DoMemW20(p);
     DelTitle();
     AddTitle("Mem Write 40Kb");
     DoMemW40(p);
     DelTitle();
     AddTitle("Mem Write 80Kb");
     DoMemW80(p);
     DelTitle();
     AddTitle("Mem Write 160Kb");
     DoMemW160(p);
     DelTitle();
     AddTitle("Mem Write 320Kb");
     DoMemW320(p);
     DelTitle();
     AddTitle("Mem Write 640Kb");
     DoMemW640(p);
     DelTitle();
     AddTitle("Mem Write 1280Kb");
     DoMemW1280(p);
     DelTitle();
     }
}


void DoFileIOAll(void* p)
{
if (!fileiodisabled)
   {
   if (!mult)
      {
      mult = true;
      AddTitle("4Kb File");
      DoFileIO4(p);
      DelTitle();
      AddTitle("8Kb File");
      DoFileIO8(p);
      DelTitle();
      AddTitle("16Kb File");
      DoFileIO16(p);
      DelTitle();
      AddTitle("32Kb File");
      DoFileIO32(p);
      DelTitle();
      AddTitle("64Kb File");
      DoFileIO64(p);
      DelTitle();
      mult = false;
      PostFin(false);
      }
   else
      {
      AddTitle("4Kb File");
      DoFileIO4(p);
      DelTitle();
      AddTitle("8Kb File");
      DoFileIO8(p);
      DelTitle();
      AddTitle("16Kb File");
      DoFileIO16(p);
      DelTitle();
      AddTitle("32Kb File");
      DoFileIO32(p);
      DelTitle();
      AddTitle("64Kb File");
      DoFileIO64(p);
      DelTitle();
      }
   }
}


void DoCPUFloatFFT(void* p)
{
  data.c[comp_cpufloat].datalines[cpufloat_fft].value = pmb_fft();
  EndBench();
}


void DoCPUFloatFlops(void* p)
{
  data.c[comp_cpufloat].datalines[cpufloat_flops].value = pmb_flops();
  EndBench();
}


void DoCPUFloatLinpack(void* p)
{
  data.c[comp_cpufloat].datalines[cpufloat_linpack].value = pmb_linpack();
  EndBench();
}


void DoCPUIntDhry(void* p)
{
  double t1, t2, r, tot_time;
  int loops;
  int notstop = 1;
  loops = 1000;

  while (notstop)
     {
     t1 = dtime();
     r = pmb_dhry(loops);
     t2 = dtime();
     tot_time = (t2-t1);
     if (((tot_time) < MIN_DHRY_TIME) || (r < 0))
        {
        if ((tot_time) < MIN_MEASURE)
           {
           loops = MIN_DHRY_TIME/MIN_MEASURE*loops;
           }
        else
           {
           loops = MIN_DHRY_TIME*MARGINAL/(tot_time)*loops;
           }
        }
     else
         {
         break;
         }
     }
  data.c[comp_cpuint].datalines[cpuint_dhrystone].value = r;
  EndBench();
}


void DoCPUIntHanoi(void* p)
{
  data.c[comp_cpuint].datalines[cpuint_hanoi].value = pmb_hanoi();
  EndBench();
}


void DoCPUIntHeaps(void* p)
{
  data.c[comp_cpuint].datalines[cpuint_heapsort].value = pmb_heaps();
  EndBench();
}


void DoCPUIntSieve(void* p)
{
  data.c[comp_cpuint].datalines[cpuint_sieve].value = pmb_sieve();
  EndBench();
}


void DoDiskIOAvSeek(void* p)
{
  data.c[comp_disk+data.selected_disk].datalines[disk_avseek].value = (pmb_diskio_avseek(data.selected_disk)/(10*1000));
  EndBench();
}


void DoDiskCacheXfer(void* p)
{
  data.c[comp_disk+data.selected_disk].datalines[disk_busxfer].value = (pmb_buscache_xfer(data.selected_disk)*KB);
  EndBench();
}


void DoDiskIOTransSpeed(void* p)
{
  data.c[comp_disk+data.selected_disk].datalines[disk_transf].value = (pmb_diskio_transfer(data.selected_disk)*KB);
  EndBench();
}


void DoDiskIOCPUUsage(void* p)
{
  data.c[comp_disk+data.selected_disk].datalines[disk_cpupct].value = (pmb_diskio_cpupct(data.selected_disk));
  EndBench();
}


void DoCDIOAvSeek(void* p)
{
  data.c[comp_disk+data.nr_fixed_disks+data.selected_cd].datalines[cdio_avseek].value = (pmb_cdio_avseek(data.selected_cd)/(10*1000));
  EndBench();
}


void DoCDIOTransSpeed(void* p)
{
  data.c[comp_disk+data.nr_fixed_disks+data.selected_cd].datalines[cdio_transf].value = (pmb_cdio_transfer(data.selected_cd)*KB);
  EndBench();
}


void DoCDIOCPUUsage(void* p)
{
  data.c[comp_disk+data.nr_fixed_disks+data.selected_cd].datalines[cdio_cpupct].value = (pmb_cdio_cpupct(data.selected_cd));
  EndBench();
}


void DoDiveVBW(void* p)
  {
  double r = -1;
  if (gtWarp)
     {
     r = pmb_dive_bw();
     if (r < 0)
        {
        r = -1.0;
        }
     }
  data.c[comp_dive].datalines[dive_videobw].value = r;
  EndBench();
}


void DoDiveRot(void* p)
{
  double r = -1;
  if (gtWarp)
     {
     r = pmb_dive_rot();
     if (r < 0)
        {
        r = -1.0;
        }
     }
  data.c[comp_dive].datalines[dive_rotate].value = r;
  EndBench();
}


void DoDiveMS11(void* p)
{
  double r = 1;
  if (gtWarp)
     {
     r = pmb_dive_ms11();
     if (r < 0)
        {
        r = -1.0;
        }
     }
  data.c[comp_dive].datalines[dive_ms_11].value = r;
  EndBench();
}


void DoGfxBlitBlitSS(void* p)
{
  data.c[comp_gfx].datalines[gfx_bitblt_SS].value = pmb_gfx_bitblitss();
  EndBench();
}


void DoGfxBlitBlitMS(void* p)
{
  data.c[comp_gfx].datalines[gfx_bitblt_MS].value = pmb_gfx_bitblitms();
  EndBench();
}


void DoGfxDLines(void* p)
{
  data.c[comp_gfx].datalines[gfx_dlines].value = pmb_gfx_dlines();
  EndBench();
}


void DoGfxHLines(void* p)
{
  data.c[comp_gfx].datalines[gfx_hlines].value = pmb_gfx_hlines();
  EndBench();
}


void DoGfxPatFil(void* p)
{
  data.c[comp_gfx].datalines[gfx_patt_fill].value = pmb_gfx_patrect();
  EndBench();
}

void DoGfxFillRect(void* p)
{
  data.c[comp_gfx].datalines[gfx_filled_rect].value = pmb_gfx_fillrect();
  EndBench();
}


void DoGfxTextRender(void* p)
{
  data.c[comp_gfx].datalines[gfx_textrender].value = pmb_gfx_textrender();
  EndBench();
}


void DoGfxVLines(void* p)
{
  data.c[comp_gfx].datalines[gfx_vlines].value = pmb_gfx_vlines();
  EndBench();
}


void DoMem5(void* p)
{
  data.c[comp_mem].datalines[mem_5].value = pmb_memspeed(5*KB);
  EndBench();
}


void DoMem10(void* p)
{
  data.c[comp_mem].datalines[mem_10].value = pmb_memspeed(10*KB);
  EndBench();
}


void DoMem20(void* p)
{
  data.c[comp_mem].datalines[mem_20].value = pmb_memspeed(20*KB);
  EndBench();
}


void DoMem40(void* p)
{
  data.c[comp_mem].datalines[mem_40].value = pmb_memspeed(40*KB);
  EndBench();
}


void DoMem80(void* p)
{
  data.c[comp_mem].datalines[mem_80].value = pmb_memspeed(80*KB);
  EndBench();
}


void DoMem160(void* p)
{
  data.c[comp_mem].datalines[mem_160].value = pmb_memspeed(160*KB);
  EndBench();
}


void DoMem320(void* p)
{
  data.c[comp_mem].datalines[mem_320].value = pmb_memspeed(320*KB);
  EndBench();
}


void DoMem640(void* p)
{
  data.c[comp_mem].datalines[mem_640].value = pmb_memspeed(640*KB);
  EndBench();
}


void DoMem1280(void* p)
{
  data.c[comp_mem].datalines[mem_1280].value = pmb_memspeed(1280*KB);
  EndBench();
}


void DoMemR5(void* p)
{
  data.c[comp_mem].datalines[memr_5].value = pmb_memspeedr(5*KB);
  EndBench();
}


void DoMemR10(void* p)
{
  data.c[comp_mem].datalines[memr_10].value = pmb_memspeedr(10*KB);
  EndBench();
}


void DoMemR20(void* p)
{
  data.c[comp_mem].datalines[memr_20].value = pmb_memspeedr(20*KB);
  EndBench();
}


void DoMemR40(void* p)
{
  data.c[comp_mem].datalines[memr_40].value = pmb_memspeedr(40*KB);
  EndBench();
}


void DoMemR80(void* p)
{
  data.c[comp_mem].datalines[memr_80].value = pmb_memspeedr(80*KB);
  EndBench();
}


void DoMemR160(void* p)
{
  data.c[comp_mem].datalines[memr_160].value = pmb_memspeedr(160*KB);
  EndBench();
}


void DoMemR320(void* p)
{
  data.c[comp_mem].datalines[memr_320].value = pmb_memspeedr(320*KB);
  EndBench();
}


void DoMemR640(void* p)
{
  data.c[comp_mem].datalines[memr_640].value = pmb_memspeedr(640*KB);
  EndBench();
}


void DoMemR1280(void* p)
{
  data.c[comp_mem].datalines[memr_1280].value = pmb_memspeedr(1280*KB);
  EndBench();
}


void DoMemW5(void* p)
{
  data.c[comp_mem].datalines[memw_5].value = pmb_memspeedw(5*KB);
  EndBench();
}


void DoMemW10(void* p)
{
  data.c[comp_mem].datalines[memw_10].value = pmb_memspeedw(10*KB);
  EndBench();
}


void DoMemW20(void* p)
{
  data.c[comp_mem].datalines[memw_20].value = pmb_memspeedw(20*KB);
  EndBench();
}


void DoMemW40(void* p)
{
  data.c[comp_mem].datalines[memw_40].value = pmb_memspeedw(40*KB);
  EndBench();
}


void DoMemW80(void* p)
{
  data.c[comp_mem].datalines[memw_80].value = pmb_memspeedw(80*KB);
  EndBench();
}


void DoMemW160(void* p)
{
  data.c[comp_mem].datalines[memw_160].value = pmb_memspeedw(160*KB);
  EndBench();
}


void DoMemW320(void* p)
{
  data.c[comp_mem].datalines[memw_320].value = pmb_memspeedw(320*KB);
  EndBench();
}


void DoMemW640(void* p)
{
  data.c[comp_mem].datalines[memw_640].value = pmb_memspeedw(640*KB);
  EndBench();
}


void DoMemW1280(void* p)
{
  data.c[comp_mem].datalines[memw_1280].value = pmb_memspeedw(1280*KB);
  EndBench();
}


void DoFileIO4(void* p)
{
 if (!mult)
    {
    mult = true;
    DoFileIOBuf(4096);
    mult = false;
    EndBench();
    }
 else
    {
    DoFileIOBuf(4096);
    }
}


void DoFileIO8(void* p)
{
 if (!mult)
    {
    mult = true;
    DoFileIOBuf(8192);
    mult = false;
    EndBench();
    }
 else
    {
    DoFileIOBuf(8192);
    }
}


void DoFileIO16(void* p)
{
 if (!mult)
    {
    mult = true;
    DoFileIOBuf(16384);
    mult = false;
    EndBench();
    }
 else
    {
    DoFileIOBuf(16384);
    }
}


void DoFileIO32(void* p)
{
 if (!mult)
    {
    mult = true;
    DoFileIOBuf(32768);
    mult = false;
    EndBench();
    }
 else
    {
    DoFileIOBuf(32768);
    }
}


void DoFileIO64(void* p)
{
 if (!mult)
    {
    mult = true;
    DoFileIOBuf(65536);
    mult = false;
    EndBench();
    }
 else
    {
    DoFileIOBuf(65536);
    }
}


void DoFileIOBuf(ULONG buffersize)
{
int n, linenum;
BOOL cache, random, reading;
APIRET rc = 0;

rc = DosCreateEventSem(NULL,           /* Unnamed semaphore            */
                       &hevFileIO,     /* Handle of semaphore returned */
                       DC_SEM_SHARED,  /* Indicate a shared semaphore  */
                       FALSE);         /* Put in RESET state           */

for (cache = 0; cache <= 1; cache++)        /* toggle cache off then on for each */
   {
   for (random = 0; random <= 1; random++)     /* toggle sequential or random access */
      {
      for (reading = 0; reading <= 1; reading++)  /* toggle writing or reading */
         {
         rc = DosResetEventSem(hevFileIO,        /* Reset the semaphore         */
                              &ulPostCount2);
         n = frexp(buffersize/4096, &linenum);
         linenum = ((linenum - 1) * 8) + (cache * 4) + (random * 2) + (reading);
         _beginthread(TimeThread, NULL, 8192, NULL);                             /* start timer thread */
         data.c[comp_file].datalines[linenum].value = DoFileIO(buffersize, cache, reading, random); /* go do current test */
         EndBench();                                                             /* update display */
         }
      }
   }
rc = DosCloseEventSem(hevFileIO);      /* Get rid of semaphore       */
}


void DoRef1Info(void)
{
}

void DoRef1Load(void)
{
}


void DoRef2Info(void)
{
}


void DoRef2Load(void)
{
}


double CalcGfxAv(void)
{
  return (
          (data.c[comp_gfx].datalines[gfx_bitblt_SS].value * 10) +
          (data.c[comp_gfx].datalines[gfx_bitblt_MS].value * 8) +
          (data.c[comp_gfx].datalines[gfx_filled_rect].value * 7) +
          (data.c[comp_gfx].datalines[gfx_patt_fill].value * 4) +
          (data.c[comp_gfx].datalines[gfx_vlines].value * 5) +
          (data.c[comp_gfx].datalines[gfx_hlines].value * 5) +
          (data.c[comp_gfx].datalines[gfx_dlines].value * 4) +
          (data.c[comp_gfx].datalines[gfx_textrender].value * 8)
         ) / 51 / 1.0e6;
}


double CalcCPUIntAv(void)
{
  return (
          (data.c[comp_cpuint].datalines[cpuint_dhrystone].value * 12) +
          (data.c[comp_cpuint].datalines[cpuint_hanoi].value * 5 * 1.0e6)+
          (data.c[comp_cpuint].datalines[cpuint_heapsort].value * 6) +
          (data.c[comp_cpuint].datalines[cpuint_sieve].value * 6)
         ) / 29 / 1.0e6;
}


double CalcCPUFloatAv(void)
{
  return (
          (data.c[comp_cpufloat].datalines[cpufloat_linpack].value * 10 * 1000) +
          (data.c[comp_cpufloat].datalines[cpufloat_flops].value * 20) +
          (data.c[comp_cpufloat].datalines[cpufloat_fft].value * 9 * 1.0e6)
         ) / 39 / 1.0e6;
}


double CalcMemAv(void)
{
  return (
          (data.c[comp_mem].datalines[mem_5].value * 7) +
          (data.c[comp_mem].datalines[mem_10].value * 8) +
          (data.c[comp_mem].datalines[mem_20].value * 7) +
          (data.c[comp_mem].datalines[mem_40].value * 7) +
          (data.c[comp_mem].datalines[mem_80].value * 6) +
          (data.c[comp_mem].datalines[mem_160].value * 5) +
          (data.c[comp_mem].datalines[mem_320].value * 4) +
          (data.c[comp_mem].datalines[mem_640].value * 4) +
          (data.c[comp_mem].datalines[mem_1280].value * 3) +
          (data.c[comp_mem].datalines[memr_5].value * 7) +
          (data.c[comp_mem].datalines[memr_10].value * 8) +
          (data.c[comp_mem].datalines[memr_20].value * 7) +
          (data.c[comp_mem].datalines[memr_40].value * 7) +
          (data.c[comp_mem].datalines[memr_80].value * 6) +
          (data.c[comp_mem].datalines[memr_160].value * 5) +
          (data.c[comp_mem].datalines[memr_320].value * 4) +
          (data.c[comp_mem].datalines[memr_640].value * 4) +
          (data.c[comp_mem].datalines[memr_1280].value * 3) +
          (data.c[comp_mem].datalines[memw_5].value * 7) +
          (data.c[comp_mem].datalines[memw_10].value * 8) +
          (data.c[comp_mem].datalines[memw_20].value * 7) +
          (data.c[comp_mem].datalines[memw_40].value * 7) +
          (data.c[comp_mem].datalines[memw_80].value * 6) +
          (data.c[comp_mem].datalines[memw_160].value * 5) +
          (data.c[comp_mem].datalines[memw_320].value * 4) +
          (data.c[comp_mem].datalines[memw_640].value * 4) +
          (data.c[comp_mem].datalines[memw_1280].value * 3)
         ) / (51*3.0) / MB;
}


double CalcDIVEAv(void)
{
  return (
          (data.c[comp_dive].datalines[dive_videobw].value * 10) +
          (data.c[comp_dive].datalines[dive_rotate].value * 3 * 1.0e6) +
          (data.c[comp_dive].datalines[dive_ms_11].value * 10 * 1.0e6)
         ) / 43 / 1.0e6;
}


double CalcDiskIOAv(s32 comp)
{
  double x;
  x =     ((1/(data.c[comp].datalines[disk_avseek].value / 1.0e-3)) * 1.0e9 / 20.0) +
          (data.c[comp].datalines[disk_busxfer].value * 1) +
          (data.c[comp].datalines[disk_transf].value * 5);

  return (x + ( x / (data.c[comp].datalines[disk_cpupct].value * 5) ) ) / 1.0e6;
}


double CalcCDIOAv(s32 comp)
{
  double x;
  x =     ((1/(data.c[comp].datalines[cdio_avseek].value / 1.0e-3)) * 1.0e8 / 20.0) +
          (data.c[comp].datalines[cdio_transf].value * 50);

  return (x + ( x / (data.c[comp].datalines[cdio_cpupct].value * 5) ) ) / 1.0e6;
}



double CalcFileIOAv(void)
{
  double x = 0;
  int linenum, i, j, k, l;

  for (i = 0; i <= 4; i++) /* for number of buffer sizes */
     {
     for (j = 0; j <= 1; j++) /* cached or not */
        {
        for (k = 0; k <= 1; k++) /* seq or random */
           {
           for (l = 0; l <= 1; l++) /* writing or reading */
              {
              linenum = (i * 8) + (j * 4) + (k * 2) + (l);
              x = x + (data.c[comp_file].datalines[linenum].value / KB);
              }
           }
        }
     }
  return (x / 40);   /* total divided by # of tests */
}


double dtime(void)
{
   return ((double)clock())/CLOCKS_PER_SEC;
/*
   ULONG value[QSV_MAX] = {0};
   APIRET rc = 0UL;

   rc = DosQuerySysInfo(QSV_MS_COUNT, QSV_MS_COUNT, (PVOID)value, sizeof(ULONG));

   return((double)*value/CLOCKS_PER_SEC); */
}


double rtime(void)
{
   return ((double)clock())/CLOCKS_PER_SEC;
/*
   ULONG value[QSV_MAX] = {0};
   APIRET rc = 0UL;

   rc = DosQuerySysInfo(QSV_MS_COUNT, QSV_MS_COUNT, (PVOID)value, sizeof(ULONG));

   return((double)*value); */
}


void logit(char* s)
{
  FILE* f;
  f = fopen("sb_error.log", "a+");
  if (!f)
     {
     exit(234);
     }
  fprintf(f, "%s\n", s);
  fclose(f);
}


static void EndBench(void)
{
  float size = GetSwapFileSize();

  if (startsize < size)
     {
     swapfilegrown++;
     if (size > maxswapfilesize)
        {
        maxswapfilesize = size;
        }
     }

  if (!mult)
     {
     PostFin(true);
     PostFin(false);
     _heapmin();        /* free off memory allocated by previous test */
     }
  else
     {
     PostFin(true);
     DosSleep(500); // wait for the window thread to update the screen
     _heapmin();        /* free off memory allocated by previous test */
     }
}

