// Sysbench main file
#define INCL_DOSMISC
#define INCL_DOSDEVICES
#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#define INCL_DOSPROCESS
#define INCL_DOSSEMAPHORES   /* Semaphore values */

#define INCL_WIN
#define INCL_PM
#define IDM_RESOURCE 1
#define INCL_GPI
#define INCL_GPILCIDS
#define INCL_GPIPRIMITIVES
#define INCL_GPICONTROL

#include <os2.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include <dive.h>
#include <fourcc.h>
#include "types.h"
#include "pmb.h"
#include "pmbbench.h"
#include "pmbdatat.h"
#include <bsedev.h>

#define CLS_CLIENT   "SysBenchWindowClass"
#define SYSB_VER     "0.9.1d"
#define THR_DONE     (WM_USER + 1)
#define THR_UPDATE   (WM_USER + 2)
#define NUM_LINES    (110)
#define LINES_PER_DISK 8
#define LINES_PER_CD   7
#define MB           (1048576)
#define KB            1024
#define MN            1000000

// ********** IMPORTED FUNCTIONS
extern double pmb_diskio_disksize(int nr);
extern int    pmb_diskio_nrdisks(void);
extern double pmb_cdio_disksize(int nDrive);
extern int    pmb_cdio_nrcds(void);
extern void   logit(char* s);
extern void   DoFileIOAll(void*);
extern void   DoFileIO4(void*);
extern void   DoFileIO8(void*);
extern void   DoFileIO16(void*);
extern void   DoFileIO32(void*);
extern void   DoFileIO64(void*);

extern void   DoAllCDIOAll(void*);
extern void   DoAllCDIO(void*);
extern void   DoCDIOAvSeek(void* p);
extern void   DoCDIOTransSpeed(void* p);
extern void   DoCDIOCPUUsage(void* p);

// ********** EXPORTED FUNCTIONS
void err(char* s);
void InfoBox(char* s);
void WarnBox(char* s);
void ErrorBox(char* s);
int gtWarp = 0;
ULONG ulDriveNum = 1;
ULONG ulDriveMap = 0;
ULONG ulDriveMap1 = 0;
void AddTitle(char*);
void DelTitle(void);

// ********** LOCAL FUNCTIONS
static void      SetTitle(char* s);
static void      UpdateWindow(HPS hpsPaint, PRECTL pRect, s32 scrollValue);
static void      Print(s32 row, s32 col, char* string, PRECTL pRect,
                       s32 scrollValue, HPS hpsPaint, s32 color);
static void      SetMenuState(bool active);
static void      UpdateAll(void);
static void      SaveResults(void);
static void      SaveResultsHtml(void);
static void      PrintFile(s32 newlines, s32 col, char* string, FILE* fp);
void _Optlink    ShowWaitWindow(void*);
void _Optlink    Flashlight(void*);
MRESULT APIENTRY fnShowWait(HWND, ULONG, MPARAM, MPARAM);
void _Optlink    GetDriveInfo(void*);
void _Optlink    WakeMeUp(void*);
PSZ              DoScanConfigSys(PSZ, int);
void             GetMachineStuff(HWND);
MRESULT APIENTRY fnMachineStuff (HWND, ULONG, MPARAM, MPARAM);
MRESULT APIENTRY fnMachdlgStuff (HWND, ULONG, MPARAM, MPARAM);
MRESULT APIENTRY fnDiskStuff (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);

void GetBIOSInfo(void);
ULONG VideoMem = 0;
char  VideoMan[15] = "Unknown";
char  VideoType[15] = "type";
USHORT VideoAdapter, VideoChip;
char  BIOSname[50]  = "Unknown";
char  BusName[9]    = "ISA";

ULONG BootDriveLetter;
ULONG action, minfree, pdisknum, swapfilegrown = 0, maxswapfilesize = 0;
float startsize, fatcachesize, hpfscachesize;
char  CSpath[_MAX_PATH];
ULONG value[QSV_MAX] = {0};
BYTE  coproc;
int   fatdisks = 0, hpfsdisks = 0, curdiskFAT = 0;
double fatdiskspace = 0, hpfsdiskspace = 0;
BOOL   fileiodisabled = 0;
HWND   hwndDlgB;
volatile int  flashit  = 0;
HEV    hevEvent2 = 0, hevEvent3 = 0;

MRESULT EXPENTRY ClientWindowProc ( HWND hwndWnd,
   ULONG ulMsg,
   MPARAM mpParm1,
   MPARAM mpParm2 );

// ********** EXPORTED DATA
double test_time;
static HWND   hwndClient = NULLHANDLE;
static HWND   hwndVertScroll;
static HWND   hwndMenu;
HWND hwndPage1;
HWND hwndPage2;

// ********** LOCAL DATA
static bool thread_running;
static s32  fontW;
static s32  fontH;
static HPS  mainHps = NULLHANDLE;
//static HAB  hab = NULLHANDLE;
static s32 scroll = 0;
static s32 oldscroll = 0;
static  HWND        hwndFrame = NULLHANDLE;
ULONG       vernum[QSV_MAX] = {0};
char pszFullFile[CCHMAXPATH] = "RESULT.TXT";/* File filter string       */
char pszFullFileHTML[CCHMAXPATH] = "RESULT.HTM";/* File filter string       */

HINI hini;
char* szIniFileName   = "SYSBENCH.INI";
char* pszApp          = "SYSBENCH";
char* pszKeyName      = "Name";
char* pszKeyMobo      = "Mobo";
char* pszKeyProcessor = "Processor";
char* pszKeyMake      = "Make";
char* pszKeyCache     = "Cache";
char* pszKeyChipset   = "Chipset";
char* pszKeyGraphics  = "Graphics";
char* pszKeyDisk      = "Disk";
char* pszKeyBeep      = "Beep";
char szDiskname[40];
char pszDisk[20];

char Machinename[100]     = "Unknown machine name";
char Moboname[100]        = "Unknown motherboard make";
char Processor[100]       = "Unknown processor";
char MachineMake[100]     = "Unknown machine manufacturer";
char CacheAmount[100]     = "Unknown external cache";
char Chipset[100]         = "Unknown motherboard chipset";
char Graphicscard[100]    = "Unknown graphics card";
char DiskController[100]  = "Unknown disk controller";
int  Beep                 = 0;

char *szDisk[20]          = {"Undefined                                ",
                             "Undefined                                ",
                             "Undefined                                ",
                             "Undefined                                ",
                             "Undefined                                ",
                             "Undefined                                ",
                             "Undefined                                ",
                             "Undefined                                ",
                             "Undefined                                ",
                             "Undefined                                ",
                             "Undefined                                ",
                             "Undefined                                ",
                             "Undefined                                ",
                             "Undefined                                ",
                             "Undefined                                ",
                             "Undefined                                ",
                             "Undefined                                ",
                             "Undefined                                ",
                             "Undefined                                ",
                             "Undefined                                "};

int NamedC = 0, MobodC = 0, ChipdC = 0, MakedC = 0, CachdC = 0, ProcdC = 0, GrapdC = 0, DiskdC = 0, DisknC;
int MDataPrompt = 0;
ULONG Machnlen, Mobonlen, Procnlen, Mmaknlen, Cachnlen, Chipnlen, Grapnlen, Disknlen, BeepnLen;

int AutoBench = 0;
int Initialised = 0;

int disp_lines = NUM_LINES;

struct glob_data data = {
  1,
  1,
  { 100, 100, 100, 100, 100, 100, 100, 100, 100, 100 },
  1,
  1,
  { 100, 100, 100, 100, 100, 100, 100, 100, 100, 100 },
  {
    {
      1,
      "Graphics",
      8,
      {
        { "BitBlt S->S cpy",  -1.0, MN, "Mpixels/s" },
        { "BitBlt M->S cpy",  -1.0, MN, "Mpixels/s" },
        { "Filled Rectangle", -1.0, MN, "Mpixels/s" },
        { "Pattern Fill",     -1.0, MN, "Mpixels/s" },
        { "Vertical Lines",   -1.0, MN, "Mpixels/s" },
        { "Horizontal Lines", -1.0, MN, "Mpixels/s" },
        { "Diagonal Lines",   -1.0, MN, "Mpixels/s" },
        { "Text Render",      -1.0, MN, "Mpixels/s" }
      },
      -1.0,
      "PM-marks"
    },
    {
      1,
      "CPU integer",
      4,
      {
        { "Dhrystone",      -1.0, MN, "VAX 11/780 MIPS" },
        { "Hanoi",          -1.0, 1, "moves/25 usec" },
        { "Heapsort",       -1.0, MN, "MIPS" },
        { "Sieve",          -1.0, MN, "MIPS" }
      },
      -1.0,
      "CPUint-marks"
    },
    {
      1,
      "CPU float",
      3,
      {
        { "Linpack",            -1.0, 1000, "MFLOPS" },
        { "Flops",              -1.0, MN, "MFLOPS" },
        { "Fast Fourier Tr.",   -1.0, 1, "VAX FFT's" }
      },
      -1.0,
      "CPUfloat-marks"
    },
    {
      1,
      "Direct Interface to video extensions - DIVE",
      3,
      {
        { "Video bus bandw.",    -1.0, MB, "MB/s" },
        { "DIVE fun",            -1.0, 1, "fps at 640x480x256"  },
        { "M->S, DD,   1.00:1",  -1.0, 1, "fps at 640x480x256"  }
      },
      -1.0,
      "DIVE-marks"
    },
     {
      1,
      "File I/O - cache read - Drive C:",
      40,
      {
        { "4Kb seq.   N     N   ",  -1.0, KB, "KB/sec" },
        { "4Kb seq.   N     Y   ",  -1.0, KB, "KB/sec" },
        { "4Kb random N     N   ",  -1.0, KB, "KB/sec" },
        { "4Kb random N     Y   ",  -1.0, KB, "KB/sec" },
        { "4Kb seq.   Y     N   ",  -1.0, KB, "KB/sec" },
        { "4Kb seq.   Y     Y   ",  -1.0, KB, "KB/sec" },
        { "4Kb random Y     N   ",  -1.0, KB, "KB/sec" },
        { "4Kb random Y     Y   ",  -1.0, KB, "KB/sec" },
        { "8Kb seq.   N     N   ",  -1.0, KB, "KB/sec" },
        { "8Kb seq.   N     Y   ",  -1.0, KB, "KB/sec" },
        { "8Kb random N     N   ",  -1.0, KB, "KB/sec" },
        { "8Kb random N     Y   ",  -1.0, KB, "KB/sec" },
        { "8Kb seq.   Y     N   ",  -1.0, KB, "KB/sec" },
        { "8Kb seq.   Y     Y   ",  -1.0, KB, "KB/sec" },
        { "8Kb random Y     N   ",  -1.0, KB, "KB/sec" },
        { "8Kb random Y     Y   ",  -1.0, KB, "KB/sec" },
        { "16K seq.   N     N   ",  -1.0, KB, "KB/sec" },
        { "16K seq.   N     Y   ",  -1.0, KB, "KB/sec" },
        { "16K random N     N   ",  -1.0, KB, "KB/sec" },
        { "16K random N     Y   ",  -1.0, KB, "KB/sec" },
        { "16K seq.   Y     N   ",  -1.0, KB, "KB/sec" },
        { "16K seq.   Y     Y   ",  -1.0, KB, "KB/sec" },
        { "16K random Y     N   ",  -1.0, KB, "KB/sec" },
        { "16K random Y     Y   ",  -1.0, KB, "KB/sec" },
        { "32K seq.   N     N   ",  -1.0, KB, "KB/sec" },
        { "32K seq.   N     Y   ",  -1.0, KB, "KB/sec" },
        { "32K random N     N   ",  -1.0, KB, "KB/sec" },
        { "32K random N     Y   ",  -1.0, KB, "KB/sec" },
        { "32K seq.   Y     N   ",  -1.0, KB, "KB/sec" },
        { "32K seq.   Y     Y   ",  -1.0, KB, "KB/sec" },
        { "32K random Y     N   ",  -1.0, KB, "KB/sec" },
        { "32K random Y     Y   ",  -1.0, KB, "KB/sec" },
        { "64K seq.   N     N   ",  -1.0, KB, "KB/sec" },
        { "64K seq.   N     Y   ",  -1.0, KB, "KB/sec" },
        { "64K random N     N   ",  -1.0, KB, "KB/sec" },
        { "64K random N     Y   ",  -1.0, KB, "KB/sec" },
        { "64K seq.   Y     N   ",  -1.0, KB, "KB/sec" },
        { "64K seq.   Y     Y   ",  -1.0, KB, "KB/sec" },
        { "64K random Y     N   ",  -1.0, KB, "KB/sec" },
        { "64K random Y     Y   ",  -1.0, KB, "KB/sec" },
      },
      -1.0,
      "File I/O-marks"
    },
    {
      1,
      "Memory",
      27,
      {
        { "5    kB copy", -1.0, MB, "MB/s" },
        { "10   kB copy", -1.0, MB, "MB/s" },
        { "20   kB copy", -1.0, MB, "MB/s" },
        { "40   kB copy", -1.0, MB, "MB/s" },
        { "80   kB copy", -1.0, MB, "MB/s" },
        { "160  kB copy", -1.0, MB, "MB/s" },
        { "320  kB copy", -1.0, MB, "MB/s" },
        { "640  kB copy", -1.0, MB, "MB/s" },
        { "1280 kB copy", -1.0, MB, "MB/s" },
        { "5    kB read", -1.0, MB, "MB/s" },
        { "10   kB read", -1.0, MB, "MB/s" },
        { "20   kB read", -1.0, MB, "MB/s" },
        { "40   kB read", -1.0, MB, "MB/s" },
        { "80   kB read", -1.0, MB, "MB/s" },
        { "160  kB read", -1.0, MB, "MB/s" },
        { "320  kB read", -1.0, MB, "MB/s" },
        { "640  kB read", -1.0, MB, "MB/s" },
        { "1280 kB read", -1.0, MB, "MB/s" },
        { "5    kB write", -1.0, MB, "MB/s" },
        { "10   kB write", -1.0, MB, "MB/s" },
        { "20   kB write", -1.0, MB, "MB/s" },
        { "40   kB write", -1.0, MB, "MB/s" },
        { "80   kB write", -1.0, MB, "MB/s" },
        { "160  kB write", -1.0, MB, "MB/s" },
        { "320  kB write", -1.0, MB, "MB/s" },
        { "640  kB write", -1.0, MB, "MB/s" },
        { "1280 kB write", -1.0, MB, "MB/s" },
      },
      -1.0,
      "Mem-marks"
    },
    {
      1,
      "Disk I/O",
      4,
      {
        { "Avg. data access time",   -1.0, 1.0e-03, "ms" },
        { "Cache/Bus xfer rate  ",   -1.0, MB, "MB/s" },
        { "Average Transfer rate",   -1.0, MB, "MB/s" },
        { "Disk use CPU load    ",   -1.0, 1, "percent" }
      },
      -1.0,
      "Disk I/O-marks"
    },
    {
      1,
      "CD-ROM I/O",
      3,
      {
        { "Avg. data access time",   -1.0, 1.0e-03, "ms" },
        { "Average Transfer rate",   -1.0, KB, "KB/s" },
        { "CD-ROM use CPU load  ",   -1.0, 1, "percent" }
      },
      -1.0,
      "CD I/O-marks"
    },
  }
};


INT main (int argc, char * argv[])
{
  FATTRS      fat;
  LONG        match;
  HMQ         hmq          = NULLHANDLE;
  HAB         hab          = NULLHANDLE;      /* PM anchor block handle         */
  HWND        hwndDeskTop;
  ERRORID     erridErrorCode;/* last error id code                   */
  ULONG       flCreate     = 0UL, ulPostCount = 0;
  BOOL        bLoop;
  QMSG        qmsg;
  RECTL       rect;
  s32         x,y,w,h, i;
  CHAR        tmp[256];
  int         rc           = 1, index = 0;
  APIRET      ulrc         = 0;
  BOOL        drivechecked = 0;
  DATETIME    datetime     = {0};
  FONTMETRICS fmMetrics ;

  if (argc > 1)
    {                                             /* if any argument passed */
    for(index = 1;index < argc;index++)
       {
       if (strcmpi(argv[index],"/all") == 0)
          {
          AutoBench = 1;                 /* set auto mode on */
          }
       else
          {
          if (strstr(strupr(argv[index]),"/R:"))
             {
             char* n1 = strstr(strupr(argv[index]), "/R:");
             n1 = n1 +3;
             strcpy(pszFullFile, n1);
             }
          else
             {
             if (strstr(strupr(argv[index]),"/H:"))
                {
                char* n1 = strstr(strupr(argv[index]), "/H:");
                n1 = n1 +3;
                strcpy(pszFullFileHTML, n1);
                }
             }
          }
       }                                 /* end for */
    }

  rc = DosQuerySysInfo(QSV_VERSION_MAJOR,
                      QSV_VERSION_MINOR,
                      (PVOID)vernum,
                      sizeof(ULONG)*QSV_MAX);

  if ((vernum[0] <= 20) &&
      (vernum[1] <  30))     /* if prior to Warp */
     {
     gtWarp = 0;
     }
  else
     {
     gtWarp = 1;
     }

  rc = DosCreateEventSem(NULL,          /* Unnamed semaphore            */
                        &hevEvent2,     /* Handle of semaphore returned */
                        DC_SEM_SHARED,  /* Indicate a shared semaphore  */
                        FALSE);         /* Put in RESET state           */

  _beginthread(ShowWaitWindow, NULL, START_STACKSIZE, NULL); /* show Wait... window */

  GetMachineInfo();                /* scan CONFIG.SYS for SWAPPATH etc. */

  GetBIOSInfo();

  DosSleep(500);                   /* give time for show wait thread to display dialog */

  ulrc = DosQueryCurrentDisk(&ulDriveNum, &ulDriveMap);

  DosError(FERR_DISABLEHARDERR);

  for (i = 2; i <= 25; i++)   /* do from first possible HD upwards */
     {
     if ( ((ulDriveMap << (31-i)) >> 31) ) /* if bit in drive array is on */
        {
        typedef struct _FSINFOBUF
           {  ULONG        ulVolser;   /* Volume serial number */
           VOLUMELABEL  vol;        /* Volume label         */
           } FSINFOBUF;
        typedef FSINFOBUF *PFSINFOBUF;
        char szDeviceName[3];
        FSINFOBUF    VolumeInfo       = {0};        /* File system info buffer */
        BYTE         fsqBuffer[sizeof(FSQBUFFER2) + (3 * CCHMAXPATH)] = {0};
        ULONG        cbBuffer         = sizeof(fsqBuffer);        /* Buffer length) */
        PFSQBUFFER2  pfsqBuffer       = (PFSQBUFFER2) fsqBuffer;
        ULONG        ulOrdinal        = 0;     /* Ordinal of entry in name list      */
        PBYTE        pszFSDName       = NULL;  /* pointer to FS name                 */
        ULONG        aulFSInfoBuf[40] = {0};         /* File system info buffer     */

        ulrc = DosQueryFSInfo(i+1,
                             FSIL_VOLSER,      /* Request volume information */
                             &VolumeInfo,      /* Buffer for information     */
                             sizeof(FSINFOBUF));  /* Size of buffer          */

        if (ulrc != NO_ERROR)
           {
           if (ulrc == ERROR_BAD_NETPATH || ulrc == ERROR_NOT_READY || ulrc == ERROR_BAD_NET_NAME)
              {
              continue;
              }
           else
              {
              sprintf(tmp, "DosQueryFSInfo error: return code = %u\n", ulrc);
              logit(tmp);
              continue;
              }
           }

        szDeviceName[0] = 'A'+i;
        szDeviceName[1] = ':';
        szDeviceName[2] = (char)NULL;

        ulrc = DosQueryFSAttach(szDeviceName,   /* Logical drive of attached FS      */
                             ulOrdinal,       /* ignored for FSAIL_QUERYNAME       */
                             FSAIL_QUERYNAME, /* Return data for a Drive or Device */
                             pfsqBuffer,      /* returned data                     */
                             &cbBuffer);      /* returned data length              */

        if (ulrc != NO_ERROR)
           {
           sprintf(tmp, "DosQueryFSAttach error: return code = %u\n", ulrc);
           logit(tmp);
           return 1;
           }
        else
           {
           pszFSDName = (PBYTE)(pfsqBuffer->szName + pfsqBuffer->cbName + 1);
           }

        if (!strcmp(pszFSDName, "FAT"))
           {
           fatdisks++;
           curdiskFAT = 1;
           }
        else
           {
           if (!strcmp(pszFSDName, "HPFS"))
              {
              hpfsdisks++;
              curdiskFAT = 2;
              }
           else
              {
              curdiskFAT = 0; /*  if anything except FAT or HPFS */
              }
           }


        if (curdiskFAT)
           {
           rc = DosQueryFSInfo(i+1,            /* Drive number      */
                              FSIL_ALLOC,             /* Level 1 allocation info */
                              (PVOID)aulFSInfoBuf,    /* Buffer                  */
                              sizeof(aulFSInfoBuf));  /* Size of buffer          */

           if (rc != NO_ERROR)
              {
              sprintf(tmp, "DosQueryFSInfo error: return code = %u\n", rc);
              logit(tmp);
              return 1;
              }
           else
              {
              if (curdiskFAT == 1)
                 {
                 fatdiskspace = fatdiskspace + (aulFSInfoBuf[1] * aulFSInfoBuf[2] * (USHORT)aulFSInfoBuf[4])/(MB);
                 }
              if (curdiskFAT == 2)
                 {
                 hpfsdiskspace = hpfsdiskspace + (aulFSInfoBuf[1] * aulFSInfoBuf[2] * (USHORT)aulFSInfoBuf[4])/(MB);
                 }
              }

           if ((aulFSInfoBuf[1] * aulFSInfoBuf[3] * (USHORT)aulFSInfoBuf[4]) > (10 * MB)) /* if freespace > 10Mb */
              {
              ulDriveMap1 = ulDriveMap1 | (0x80000000 >> 31-i);
              }
           }
        }
     }

  DosError(FERR_ENABLEHARDERR);

  hab = WinInitialize ( 0UL );

  if (hab == NULLHANDLE)
     {
     erridErrorCode = WinGetLastError(hab);
     printf("WinGetLastError after WinInitialize returned %x\n", erridErrorCode);
     exit(2);
     }

  hmq = WinCreateMsgQueue ( hab, 0UL );

  if (hmq == NULLHANDLE)
     {
     erridErrorCode = WinGetLastError(hab);
     printf("WinGetLastError after WinCreateMsgQueue returned %x\n", erridErrorCode);
     exit(2);
     }

  rc = DosWaitEventSem(hevEvent2, 60000); /* wait 1 minute for flashlight thread to initialise */

  if (rc != NO_ERROR)
     {
     sprintf(tmp, "DosWaitEventSem returned rc = %d", rc);
     logit(tmp);
     return 1;
     }
  else
     {
     WinSendMsg(hwndDlgB, /* simulate pushing the non-existent button */
               WM_COMMAND,
               (MPARAM)MPFROMSHORT(IDD_SHOWWAIT5),
               (MPARAM)MPFROM2SHORT(CMDSRC_PUSHBUTTON, TRUE));
     rc = DosResetEventSem(hevEvent2,            /* reset him so we can wait again */
                          &ulPostCount);
     }

  rc = WinRegisterClass(hab,
                       CLS_CLIENT,
                       ClientWindowProc,
                       CS_SIZEREDRAW,       /*  CS_SYNCPAINT |  */
                       0UL );

  if ( rc != TRUE )
     {
     logit("WinRegisterClass failed") ;
     exit(4);
     }

  flCreate = FCF_TITLEBAR    |
             FCF_SYSMENU     |
             FCF_SIZEBORDER  |
             FCF_MENU        |
             FCF_MINMAX      |
             FCF_TASKLIST    |
             FCF_NOBYTEALIGN |
             FCF_VERTSCROLL;

  hwndDeskTop = WinQueryDesktopWindow(hab,
                                     NULLHANDLE);

  hwndFrame = WinCreateStdWindow(hwndDeskTop,
                                WS_VISIBLE,
                                &flCreate,
                                CLS_CLIENT,
                                SYSB_VER,
                                CS_SIZEREDRAW,
                                NULLHANDLE,
                                WND_MAIN,
                                &hwndClient );

  if ( hwndFrame == NULLHANDLE )
     {
     logit("hwndFrame is NULLHANDLE");
     exit(6);
     }

  mainHps = WinGetPS(hwndClient);

  fat.usRecordLength  = sizeof(FATTRS); /* sets size of structure   */
  fat.fsSelection     = 0;              /* uses default selection           */
  fat.lMatch          = 0;              /* does not force match             */
  fat.idRegistry      = 0;              /* uses default registry            */
  fat.usCodePage      = 0;              /* code-page 850                    */
  fat.lMaxBaselineExt = 12L;            /* requested font height is 12 pels */
  fat.lAveCharWidth   = 8L;             /* requested font width is 12 pels  */
  fat.fsType          = 0;              /* uses default type                */
  fat.fsFontUse       = 0;              /* doesn't mix with graphics */

  strcpy(fat.szFacename ,"System VIO");

  match = GpiCreateLogFont(mainHps,        /* presentation space               */
                          NULL,       /* does not use logical font name   */
                          1L,         /* local identifier                 */
                          &fat);      /* structure with font attributes   */

  // match should now be 2 == FONT_MATCH */

   if (match != FONT_MATCH)
      {
      logit("Can't get the right font");
      exit(1);
      }

  hwndMenu = WinWindowFromID(hwndFrame, FID_MENU);

  thread_running = true;               /* set drives info running */
  SetTitle("Initialising");
  SetMenuState(false);

  _beginthread(GetDriveInfo, NULL, START_STACKSIZE, NULL); /* get Drive information */

  GpiSetCharSet(mainHps, 1L);      /* sets font for presentation space */

  GpiQueryFontMetrics(mainHps,
                     sizeof ( fmMetrics ) ,
                     &fmMetrics ) ;

  fontH = (14 * fmMetrics.lMaxBaselineExt)/10;
  fontW = fmMetrics.lMaxCharInc;

  GpiSetBackMix( mainHps, BM_OVERPAINT );  // how it mixes,
  GpiSetMix( mainHps, FM_OVERPAINT );  // how it mixes,

  hwndVertScroll = WinWindowFromID( hwndFrame, FID_VERTSCROLL);

  WinQueryWindowRect(HWND_DESKTOP, &rect);

  w = 636;
  h = (rect.yTop-rect.yBottom) - 40;
  x = (rect.xRight-rect.xLeft)/2 - w/2;
  y = 40;

  WinSetWindowPos(hwndFrame,
                 false,
                 x,
                 y,
                 w,
                 h,
                 SWP_SIZE |
                 SWP_MOVE |
                 SWP_SHOW |
                 SWP_ACTIVATE);

  WinQueryWindowRect(hwndClient,
                    &rect);

  WinSendMsg( hwndVertScroll,
              SBM_SETSCROLLBAR,
              MPFROMSHORT(0),
              MPFROM2SHORT(0, (disp_lines * fontH) - (rect.yTop - rect.yBottom)));

  WinSendMsg( hwndVertScroll,
              SBM_SETTHUMBSIZE,
              MPFROM2SHORT(rect.yTop - rect.yBottom, disp_lines * fontH),
              NULL);

  rc = DosCloseEventSem(hevEvent2); /* close and delete semaphore */

  UpdateAll();

  if ( hwndFrame != NULLHANDLE )
     {
     bLoop = WinGetMsg ( hab,
                        &qmsg,
                        NULLHANDLE,
                        0,
                        0 );
     while ( bLoop )
        {
        WinDispatchMsg ( hab, &qmsg );
        bLoop = WinGetMsg ( hab,
                           &qmsg,
                           NULLHANDLE,
                           0,
                           0 );
        }

     WinReleasePS(mainHps);
     WinDestroyWindow ( hwndFrame );
     }

  WinDestroyMsgQueue ( hmq );
  WinTerminate ( hab );
  return 0;
}

MRESULT EXPENTRY ClientWindowProc ( HWND hwndWnd,
                                 ULONG ulMsg,
                                 MPARAM mpParm1,
                                 MPARAM mpParm2 )
{
  void *pv = null;
  static bool initialized = false;
  RECTL rect;
  s32 tmp, tmp1;
  bool updateScroll;
  QMSG qmsgPeek;
  bool fDone, exitmsg = 0;
  char tmps[512];
  HAB hab;
  int i;

  switch ( ulMsg ) {

  case WM_CREATE:
    /* The client window has been created but is not visible yet.        */
    /* Initialize the window here.                                       */
    hab  = WinQueryAnchorBlock( hwndWnd);
    hini = PrfOpenProfile(hab, szIniFileName); /* open our profile file */

    BeepnLen = sizeof(Beep);
    if (!PrfQueryProfileData(hini,             /* get the contents of "beep" field */
                            pszApp,
                            pszKeyBeep,
                            &Beep,
                            &BeepnLen))
       {
       Beep = 0;   /* fill in with defaults if not found */
       }

    Machnlen = sizeof(Machinename);
    if (!PrfQueryProfileData(hini,             /* get the contents of machine name field */
                            pszApp,
                            pszKeyName,
                            &Machinename,
                            &Machnlen))
       {
       strcpy(Machinename,    "Unknown machine");  /* fill in with defaults if not found */
       MDataPrompt = 1;
       }

    Mobonlen = sizeof(Moboname);
    if (!PrfQueryProfileData(hini,             /* get the contents of machine name field */
                            pszApp,
                            pszKeyMobo,
                            &Moboname,
                            &Mobonlen))
       {
       strcpy(Moboname,       "Unknown motherboard");
       MDataPrompt = 1;
       }

    Procnlen = sizeof(Processor);
    if (!PrfQueryProfileData(hini,             /* get the contents of machine name field */
                            pszApp,
                            pszKeyProcessor,
                            &Processor,
                            &Procnlen))
       {
       strcpy(Processor,      "Unknown processor");
       MDataPrompt = 1;
       }

    Mmaknlen = sizeof(MachineMake);
    if (!PrfQueryProfileData(hini,             /* get the contents of machine name field */
                            pszApp,
                            pszKeyMake,
                            &MachineMake,
                            &Mmaknlen))
       {
       strcpy(MachineMake,    "Unknown manufacturer");
       MDataPrompt = 1;
       }

    Cachnlen = sizeof(CacheAmount);
    if (!PrfQueryProfileData(hini,             /* get the contents of machine name field */
                            pszApp,
                            pszKeyCache,
                            &CacheAmount,
                            &Cachnlen))
       {
       strcpy(CacheAmount,    "Unknown external cache amount");
       MDataPrompt = 1;
       }

    Chipnlen = sizeof(Chipset);
    if (!PrfQueryProfileData(hini,             /* get the contents of machine name field */
                            pszApp,
                            pszKeyChipset,
                            &Chipset,
                            &Chipnlen))
       {
       strcpy(Chipset,        "Unknown motherboard chipset");
       MDataPrompt = 1;
       }

    Grapnlen = sizeof(Graphicscard);
    if (!PrfQueryProfileData(hini,             /* get the contents of machine name field */
                            pszApp,
                            pszKeyGraphics,
                            &Graphicscard,
                            &Grapnlen))
       {
       strcpy(Graphicscard,   "Unknown graphics card");
       MDataPrompt = 1;
       }

    Disknlen = sizeof(DiskController);
    if (!PrfQueryProfileData(hini,             /* get the contents of machine name field */
                            pszApp,
                            pszKeyDisk,
                            &DiskController,
                            &Disknlen))
       {
       strcpy(DiskController, "Unknown disk controller");
       MDataPrompt = 1;
       }

    for (i = 0; i < MAX_FIXED_DISKS+MAX_CD_DRIVES; i++)
       {
       ULONG Keylen = 40;
       char pszDisk[20];

       sprintf(pszDisk, "DiskCD%d", i);

       if (!PrfQueryProfileData(hini,
                               pszApp,
                               pszDisk,
                               szDisk[i],  /* read INI data into temp area */
                               &Keylen))
          {
          strcpy(szDisk[i], "Undefined");  /* else set it default */
          }
       strcpy(data.c[comp_disk+i].title, szDisk[i]); /* set it up in real list */
       }

    PrfCloseProfile(hini);

    if (MDataPrompt)
       {
       WinPostMsg(hwndClient,
                 WM_COMMAND,                        /* and send ourselves a message to display dialog box */
                 (MPARAM)MPFROMSHORT(MI_MACHINE_DATA),  /* to be processed when we're initialised */
                 (MPARAM)0);
       }
    break;

  case WM_COMMAND:

    if (thread_running)
       {
       switch (SHORT1FROMMP(mpParm1))
          {
          case MI_PROJ_QUIT:
             WinPostMsg(hwndWnd, WM_CLOSE, NULL, NULL);
             break;

          case MI_PROJ_ABOUT:
             InfoBox("SysBench "SYSB_VER" maintained by\nTrevor Hemsley"
                     " : 1996-05-18\nEmail: Trevor-Hemsley@dial.pipex.com\n"
                     "\nOriginal code by Henrik Harmsen 1994-10-01.\n"
                     "\nThanks to Kai Uwe Rommel for the disk IO tests, and Al Aburto for the CPU tests.");
             break;

          case MI_MACHINE_DATA:
             if (!Initialised)
                {
                _beginthread(WakeMeUp, NULL, START_STACKSIZE, NULL); /* Come back when we are */
                }
             else
                {
                GetMachineStuff(hwndWnd);
                }
             break;
          }
       return false;
       }

    if ((SHORT1FROMMP(mpParm1) > MI_MENU_DISKIO_SELECT) &&
        (SHORT1FROMMP(mpParm1) <= (data.nr_fixed_disks + MI_MENU_DISKIO_SELECT)))
       {
       s32 i, disk;
       disk = SHORT1FROMMP(mpParm1) - (MI_MENU_DISKIO_SELECT + 1);
       if (disk == data.selected_disk)
          return false;
       data.selected_disk = disk;
       for (i = 0; i < data.nr_fixed_disks; i++)
          {
          WinCheckMenuItem(hwndMenu,
                          MI_MENU_DISKIO_SELECT + i + 1,
                          false);
           }
       WinCheckMenuItem(hwndMenu,
                       MI_MENU_DISKIO_SELECT + data.selected_disk + 1,
                       true);
       UpdateAll();
       return false;
       }

    if ((SHORT1FROMMP(mpParm1) > MI_MENU_CDIO_SELECT) &&
        (SHORT1FROMMP(mpParm1) <= (data.nr_cd_drives + MI_MENU_CDIO_SELECT)))
       {
       s32 i, disk;

       disk = SHORT1FROMMP(mpParm1) - (MI_MENU_CDIO_SELECT + 1);
       if (disk == data.selected_cd)
          return false;
       data.selected_cd = disk;
       for (i = 0; i < data.nr_cd_drives; i++)
          {
          WinCheckMenuItem(hwndMenu,
                          MI_MENU_CDIO_SELECT + i + 1,
                          false);
           }
       WinCheckMenuItem(hwndMenu,
                       MI_MENU_CDIO_SELECT + data.selected_cd + 1,
                       true);
       UpdateAll();
       return false;
       }


    if ((SHORT1FROMMP(mpParm1) > MI_MENU_FILEIO_SELECT) &&
        (SHORT1FROMMP(mpParm1) <= (MI_MENU_FILEIO_SELECT + 26)))
       {
       ULONG ulDriveNum1;
       ulDriveNum1 = SHORT1FROMMP(mpParm1) - MI_MENU_FILEIO_SELECT;
       WinCheckMenuItem(hwndMenu,
                       MI_MENU_FILEIO_SELECT + ulDriveNum,
                       false);
       WinCheckMenuItem(hwndMenu,
                       MI_MENU_FILEIO_SELECT + ulDriveNum1,
                       true);
       ulDriveNum = ulDriveNum1;
       DosSetDefaultDisk(ulDriveNum);
       sprintf(tmps, "File I/O - cache read - Drive %c:", 'A'+ ulDriveNum-1);
       strcpy(data.c[comp_file].title, tmps);
       UpdateAll();
       return false;
       }


    switch (SHORT1FROMMP(mpParm1))
       {
       case MI_PROJ_QUIT:
          sprintf(tmps,"");
          if (swapfilegrown)
             {
             sprintf(tmps, "Swapfile was larger than initial allocation after %u of these tests (maximum size was %uKB).\n\n",
                    swapfilegrown,
                    (maxswapfilesize/1024));
             exitmsg = 1;
             }

          if (fatcachesize)                           /* if any FAT cache allocated */
             {
             float ramsize = value[QSV_TOTPHYSMEM - QSV_BOOT_DRIVE];
             float cachepercent = ramsize / fatcachesize;
             BOOL cachewarn = 0;

             if (fatdisks)
                {
                if (ramsize >= (4 * MB) &&
                    ramsize <= (8 * MB) &&
                    fatcachesize > (256 * KB))
                    {
                    cachewarn = 1;
                    sprintf(tmps, "%sWith 4-8Mb RAM you might want to set DISKCACHE=256 or less\n\n", tmps);
                    }
                if (ramsize >= ((8 * MB)+1) &&
                    ramsize <= (12 * MB) &&
                    fatcachesize > (384 * KB))
                    {
                    cachewarn = 1;
                    sprintf(tmps, "%sWith 8-12Mb RAM you might want to set DISKCACHE=384 or less\n\n", tmps);
                    }
                if (ramsize >= ((12 * MB)+1) &&
                    ramsize <= (16 * MB) &&
                    fatcachesize > (512 * KB))
                    {
                    cachewarn = 1;
                    sprintf(tmps, "%sWith 12-16Mb RAM you might want to set DISKCACHE=512 or less\n\n", tmps);
                    }
                if (ramsize >= ((16 * MB)+1) &&
                   cachepercent <= 10.1)
                   {
                   cachewarn = 1;
                   sprintf(tmps, "%sYour FAT diskcache is set to 10%% or more of your RAM\n\n", tmps);
                   }
                if (cachewarn)
                   {
                   sprintf(tmps, "%sDISKCACHE is set to %.0fKb of your total %.0uKb RAM\n\n",
                          tmps,
                          (fatcachesize/KB),
                          (value[QSV_TOTPHYSMEM - QSV_BOOT_DRIVE]/KB));
                   exitmsg = 1;
                   }
                }
             else
                {
                sprintf(tmps, "%sDISKCACHE is set to %.0fKb but you have no FAT disks\n\n",
                       tmps,
                       (fatcachesize/KB));
                exitmsg = 1;
                }
             }

          if (hpfscachesize)
             {
             float ramsize = value[QSV_TOTPHYSMEM - QSV_BOOT_DRIVE];
             float cachepercent = ramsize / hpfscachesize;
             BOOL cachewarn = 0;

             if (hpfsdisks)
                {
                if (ramsize >= (4 * MB) &&
                    ramsize <= (8 * MB) &&
                    (hpfscachesize >= (48 * KB) && hpfscachesize < (128 * KB) ))
                    {
                    cachewarn = 1;
                    sprintf(tmps, "%sWith 4-8Mb RAM you might want to set IFS=HPFS.IFS /CACHE between 48 and 128\n\n", tmps);
                    }
                if (ramsize >= ((8 * MB)+1) &&
                    ramsize <= (12 * MB) &&
                    (hpfscachesize >= (128 * KB) && hpfscachesize < (384 * KB)))
                    {
                    cachewarn = 1;
                    sprintf(tmps, "%sWith 8-12Mb RAM you might want to set IFS=HPFS.IFS /CACHE between 128 and 384\n\n", tmps);
                    }
                if (ramsize >= ((12 * MB)+1) &&
                    ramsize <= (16 * MB) &&
                    (hpfscachesize >= (512 * KB) && hpfscachesize < (1024 * KB)))
                    {
                    cachewarn = 1;
                    sprintf(tmps, "%sWith 12-16Mb RAM you might want to set IFS=HPFS.IFS /CACHE between 512 and 1024\n\n", tmps);
                    }
                if (ramsize >= ((16 * MB)+1) &&
                    ramsize <= (24 * MB) &&
                    (hpfscachesize >= (1024 * KB) && hpfscachesize < (1536 * KB)))
                    {
                    cachewarn = 1;
                    sprintf(tmps, "%sWith 16-24Mb RAM you might want to set IFS=HPFS.IFS /CACHE between 1024 and 1536\n\n", tmps);
                    }
                if (ramsize >= ((24 * MB)+1) &&
                   (hpfscachesize >= (1536 * KB) && hpfscachesize <= (2048 * KB)-1 ))
                   {
                   cachewarn = 1;
                   sprintf(tmps, "%sWith more than 24Mb RAM you might want to set IFS=HPFS.IFS /CACHE between 1536 and 2048\n\n", tmps);
                   }

                if (cachewarn)
                   {
                   sprintf(tmps, "%sHPFS.IFS /CACHE is set to %.0fKb of your total %.0uKb RAM\n\n",
                          tmps,
                          (hpfscachesize/KB),
                          (value[QSV_TOTPHYSMEM - QSV_BOOT_DRIVE]/KB));
                   exitmsg = 1;
                   }
                }
             else
                {
                sprintf(tmps, "%sIFS=HPFS.IFS /CACHE is set to %.0fKb but you have no HPFS disks\n\n",
                       tmps,
                       (hpfscachesize/KB));
                exitmsg = 1;
                }
             }

          if (fatdiskspace > hpfsdiskspace)
             {
             if (fatcachesize < hpfscachesize)
                {
                sprintf(tmps, "%sYou have more FAT diskspace than HPFS but your DISKCACHE is less than your HPFS cache.\n\n", tmps);
                }
             }
          if (fatdiskspace < hpfsdiskspace)
             {
             if (fatcachesize > hpfscachesize)
                {
                sprintf(tmps, "%sYou have more HPFS diskspace than FAT but your DISKCACHE is greater than your HPFS cache.\n\n", tmps);
                }
             }

          if (data.c[comp_cpuint].total > 0)
             {
             if (data.c[comp_cpuint].total >= 40 &&
                 value[QSV_MAX_WAIT - QSV_BOOT_DRIVE] > 2)
                {
                sprintf(tmps, "%sBased on integer score consider setting MAXWAIT=2 instead of current setting of %d\n\n",
                       tmps,
                       value[QSV_MAX_WAIT - QSV_BOOT_DRIVE]);
                exitmsg = 1;
                }

             if (data.c[comp_cpuint].total >= 70 &&
                 value[QSV_MAX_WAIT - QSV_BOOT_DRIVE] > 1)
                {
                sprintf(tmps, "%sBased on integer score consider setting MAXWAIT=1 instead of current setting of %d\n\n",
                       tmps,
                       value[QSV_MAX_WAIT - QSV_BOOT_DRIVE]);
                exitmsg = 1;
                }

             if (data.c[comp_cpuint].total <= 39 &&
                 value[QSV_MAX_WAIT - QSV_BOOT_DRIVE] < 3)
                {
                sprintf(tmps, "%sBased on integer score consider setting MAXWAIT=3 instead of current setting of %d\n\n",
                       tmps,
                       value[QSV_MAX_WAIT - QSV_BOOT_DRIVE]);
                exitmsg = 1;
                }
             }

          if (exitmsg)
             {
             if (!AutoBench)
                {
                InfoBox(tmps); /* display diagnostic messages about system */
                }
             }

          WinPostMsg(hwndWnd, WM_CLOSE, NULL, NULL);
          break;

       case MI_PROJ_ABOUT:
          InfoBox("SysBench "SYSB_VER" maintained by\nTrevor Hemsley : 1996-05-18\nEmail: Trevor-Hemsley@dial.pipex.com\n\nOriginal code by Henrik Harmsen 1994-10-01.\n"
                "\nThanks to Kai Uwe Rommel for the disk IO tests, and Al Aburto for the CPU tests.");
          break;

       case MI_PROJ_SAVE:
          SaveResults();
          break;

       case MI_PROJ_SAVE_HTML:
          SaveResultsHtml();
          break;

       case MI_PROJ_ALL:
          SetTitle("Running All tests");
          SetMenuState(false);
          _beginthread(DoAll, null, START_STACKSIZE, pv);
          break;

       case MI_GFX_BITBLIT_SS:
          SetTitle("Running BitBlit S->S");
          SetMenuState(false);
          _beginthread(DoGfxBlitBlitSS, null, START_STACKSIZE, pv);
          break;

       case MI_GFX_BITBLIT_MS:
          SetTitle("Running BitBlit M->S");
          SetMenuState(false);
          _beginthread(DoGfxBlitBlitMS, null, START_STACKSIZE, pv);
          break;

       case MI_GFX_FILLRECT:
          SetTitle("Running Filled Rectangle");
          SetMenuState(false);
          _beginthread(DoGfxFillRect, null, START_STACKSIZE, pv);
          break;

       case MI_GFX_PATFIL:
          SetTitle("Running Pattern Fill");
          SetMenuState(false);
          _beginthread(DoGfxPatFil, null, START_STACKSIZE, pv);
          break;

       case MI_GFX_VLINES:
          SetTitle("Running VerticalLines");
          SetMenuState(false);
          _beginthread(DoGfxVLines, null, START_STACKSIZE, pv);
          break;

       case MI_GFX_HLINES:
          SetTitle("Running HorizontalLines");
          SetMenuState(false);
          _beginthread(DoGfxHLines, null, START_STACKSIZE, pv);
          break;

       case MI_GFX_DLINES:
          SetTitle("Running DiagonalLines");
          SetMenuState(false);
          _beginthread(DoGfxDLines, null, START_STACKSIZE, pv);
          break;

       case MI_GFX_TEXTRENDER:
          SetTitle("Running TextRender");
          SetMenuState(false);
          _beginthread(DoGfxTextRender, null, START_STACKSIZE, pv);
          break;

       case MI_GFX_ALL:
          SetTitle("Running All Graphics tests");
          SetMenuState(false);
          _beginthread(DoAllGraphics, null, START_STACKSIZE, pv);
          break;

       case MI_CPUINT_DHRY:
          SetTitle("Running Dhrystone");
          SetMenuState(false);
          _beginthread(DoCPUIntDhry, null, START_STACKSIZE, pv);
          break;

       case MI_CPUINT_HANOI:
          SetTitle("Running Hanoi");
          SetMenuState(false);
          _beginthread(DoCPUIntHanoi, null, START_STACKSIZE, pv);
          break;

       case MI_CPUINT_HEAPS:
          SetTitle("Running Heapsort");
          SetMenuState(false);
          _beginthread(DoCPUIntHeaps, null, START_STACKSIZE, pv);
          break;

       case MI_CPUINT_SIEVE:
          SetTitle("Running Sieve");
          SetMenuState(false);
          _beginthread(DoCPUIntSieve, null, START_STACKSIZE, pv);
          break;

       case MI_CPUINT_ALL:
          SetTitle("Running All CPU integer tests");
          SetMenuState(false);
          _beginthread(DoAllCPUInt, null, START_STACKSIZE, pv);
          break;

       case MI_CPUFLOAT_LINPACK:
          SetTitle("Running Linpack");
          SetMenuState(false);
          _beginthread(DoCPUFloatLinpack, null, START_STACKSIZE, pv);
          break;

       case MI_CPUFLOAT_FLOPS:
          SetTitle("Running FLOPS");
          SetMenuState(false);
          _beginthread(DoCPUFloatFlops, null, START_STACKSIZE, pv);
          break;

       case MI_CPUFLOAT_FFT:
          SetTitle("Running FFT");
          SetMenuState(false);
          _beginthread(DoCPUFloatFFT, null, START_STACKSIZE, pv);
          break;

       case MI_CPUFLOAT_ALL:
          SetTitle("Running All CPU float tests");
          SetMenuState(false);
          _beginthread(DoAllCPUFloat, null, START_STACKSIZE, pv);
          break;

       case MI_MEM_5:
          SetTitle("Running Memcopy 5kB");
          SetMenuState(false);
          _beginthread(DoMem5, null, START_STACKSIZE, pv);
          break;

       case MI_MEM_10:
          SetTitle("Running Memcopy 10kB");
          SetMenuState(false);
          _beginthread(DoMem10, null, START_STACKSIZE, pv);
          break;

       case MI_MEM_20:
          SetTitle("Running Memcopy 20kB");
          SetMenuState(false);
          _beginthread(DoMem20, null, START_STACKSIZE, pv);
          break;

       case MI_MEM_40:
          SetTitle("Running Memcopy 40kB");
          SetMenuState(false);
          _beginthread(DoMem40, null, START_STACKSIZE, pv);
          break;

       case MI_MEM_80:
          SetTitle("Running Memcopy 80kB");
          SetMenuState(false);
          _beginthread(DoMem80, null, START_STACKSIZE, pv);
          break;

       case MI_MEM_160:
          SetTitle("Running Memcopy 160kB");
          SetMenuState(false);
          _beginthread(DoMem160, null, START_STACKSIZE, pv);
          break;

       case MI_MEM_320:
          SetTitle("Running Memcopy 320kB");
          SetMenuState(false);
          _beginthread(DoMem320, null, START_STACKSIZE, pv);
          break;

       case MI_MEM_640:
          SetTitle("Running Memcopy 640kB");
          SetMenuState(false);
          _beginthread(DoMem640, null, START_STACKSIZE, pv);
          break;

       case MI_MEM_1280:
          SetTitle("Running Memcopy 1280kB");
          SetMenuState(false);
          _beginthread(DoMem1280, null, START_STACKSIZE, pv);
          break;

       case MI_MEMR_5:
          SetTitle("Running Memory Read 5kB");
          SetMenuState(false);
          _beginthread(DoMemR5, null, START_STACKSIZE, pv);
          break;

       case MI_MEMR_10:
          SetTitle("Running Memory Read 10kB");
          SetMenuState(false);
          _beginthread(DoMemR10, null, START_STACKSIZE, pv);
          break;

       case MI_MEMR_20:
          SetTitle("Running Memory Read 20kB");
          SetMenuState(false);
          _beginthread(DoMemR20, null, START_STACKSIZE, pv);
          break;

       case MI_MEMR_40:
          SetTitle("Running Memory Read 40kB");
          SetMenuState(false);
          _beginthread(DoMemR40, null, START_STACKSIZE, pv);
          break;

       case MI_MEMR_80:
          SetTitle("Running Memory Read 80kB");
          SetMenuState(false);
          _beginthread(DoMemR80, null, START_STACKSIZE, pv);
          break;

       case MI_MEMR_160:
          SetTitle("Running Memory Read 160kB");
          SetMenuState(false);
          _beginthread(DoMemR160, null, START_STACKSIZE, pv);
          break;

       case MI_MEMR_320:
          SetTitle("Running Memory Read 320kB");
          SetMenuState(false);
          _beginthread(DoMemR320, null, START_STACKSIZE, pv);
          break;

       case MI_MEMR_640:
          SetTitle("Running Memory Read 640kB");
          SetMenuState(false);
          _beginthread(DoMemR640, null, START_STACKSIZE, pv);
          break;

       case MI_MEMR_1280:
          SetTitle("Running Memory Read 1280kB");
          SetMenuState(false);
          _beginthread(DoMemR1280, null, START_STACKSIZE, pv);
          break;

       case MI_MEMW_5:
          SetTitle("Running Memory Write 5kB");
          SetMenuState(false);
          _beginthread(DoMemW5, null, START_STACKSIZE, pv);
          break;

       case MI_MEMW_10:
          SetTitle("Running Memory Write 10kB");
          SetMenuState(false);
          _beginthread(DoMemW10, null, START_STACKSIZE, pv);
          break;

       case MI_MEMW_20:
          SetTitle("Running Memory Write 20kB");
          SetMenuState(false);
          _beginthread(DoMemW20, null, START_STACKSIZE, pv);
          break;

       case MI_MEMW_40:
          SetTitle("Running Memory Write 40kB");
          SetMenuState(false);
          _beginthread(DoMemW40, null, START_STACKSIZE, pv);
          break;

       case MI_MEMW_80:
          SetTitle("Running Memory Write 80kB");
          SetMenuState(false);
          _beginthread(DoMemW80, null, START_STACKSIZE, pv);
          break;

       case MI_MEMW_160:
          SetTitle("Running Memory Write 160kB");
          SetMenuState(false);
          _beginthread(DoMemW160, null, START_STACKSIZE, pv);
          break;

       case MI_MEMW_320:
          SetTitle("Running Memory Write 320kB");
          SetMenuState(false);
          _beginthread(DoMemW320, null, START_STACKSIZE, pv);
          break;

       case MI_MEMW_640:
          SetTitle("Running Memory Write 640kB");
          SetMenuState(false);
          _beginthread(DoMemW640, null, START_STACKSIZE, pv);
          break;

       case MI_MEMW_1280:
          SetTitle("Running Memory Write 1280kB");
          SetMenuState(false);
          _beginthread(DoMemW1280, null, START_STACKSIZE, pv);
          break;

       case MI_MEM_ALL:
          SetTitle("Running All Memory tests");
          SetMenuState(false);
          _beginthread(DoAllMem, null, START_STACKSIZE, pv);
          break;

       case MI_DIVE_VIDEO_BW:
          SetTitle("Running Video Bandwidth");
          SetMenuState(false);
          _beginthread(DoDiveVBW, null, START_STACKSIZE, pv);
          break;

       case MI_DIVE_ROTATE_SCREEN:
          SetTitle("Running DIVE fun");
          SetMenuState(false);
          _beginthread(DoDiveRot, null, START_STACKSIZE, pv);
          break;

       case MI_DIVE_MS_11:
          SetTitle("Running DIVE M->S 1:1");
          SetMenuState(false);
          _beginthread(DoDiveMS11, null, START_STACKSIZE, pv);
          break;

       case MI_DIVE_ALL:
          SetTitle("Running All DIVE tests");
          SetMenuState(false);
          _beginthread(DoAllDIVE, null, START_STACKSIZE, pv);
          break;

       case MI_DISKIO_AVSEEK:
          SetTitle("Running Average Data Access Time");
          SetMenuState(false);
          _beginthread(DoDiskIOAvSeek, null, START_STACKSIZE, pv);
          break;

       case MI_DISKIO_CBXFER:
          SetTitle("Running Cache/Bus Transfer");
          SetMenuState(false);
          _beginthread(DoDiskCacheXfer, null, START_STACKSIZE, pv);
          break;

       case MI_DISKIO_TRANS_SPEED:
          SetTitle("Running Max. transfer speed");
          SetMenuState(false);
          _beginthread(DoDiskIOTransSpeed, null, START_STACKSIZE, pv);
          break;

       case MI_DISKIO_CPU_USAGE:
          SetTitle("Running CPU Usage percentage");
          SetMenuState(false);
          _beginthread(DoDiskIOCPUUsage, null, START_STACKSIZE, pv);
          break;

       case MI_DISKIO_ALL:
          SetTitle("Running disk I/O tests");
          SetMenuState(false);
          _beginthread(DoAllDiskIO, null, START_STACKSIZE, pv);
          break;

       case MI_DISKIO_ALL_DISKS:
          SetTitle("Running All disks I/O tests");
          SetMenuState(false);
          _beginthread(DoAllDiskIOAll, null, START_STACKSIZE, pv);
          break;

       case MI_FILEIO_ALL:
          SetTitle("Running All file I/O tests");
          SetMenuState(false);
          _beginthread(DoFileIOAll, null, START_STACKSIZE, pv);
          break;

       case MI_FILEIO_4KB:
          SetTitle("Running 4KB file I/O tests");
          SetMenuState(false);
          _beginthread(DoFileIO4, null, START_STACKSIZE, pv);
          break;

       case MI_FILEIO_8KB:
          SetTitle("Running 8KB file I/O tests");
          SetMenuState(false);
          _beginthread(DoFileIO8, null, START_STACKSIZE, pv);
          break;

       case MI_FILEIO_16KB:
          SetTitle("Running 16KB file I/O tests");
          SetMenuState(false);
          _beginthread(DoFileIO16, null, START_STACKSIZE, pv);
          break;

       case MI_FILEIO_32KB:
          SetTitle("Running 32KB file I/O tests");
          SetMenuState(false);
          _beginthread(DoFileIO32, null, START_STACKSIZE, pv);
          break;

       case MI_FILEIO_64KB:
          SetTitle("Running 64KB file I/O tests");
          SetMenuState(false);
          _beginthread(DoFileIO64, null, START_STACKSIZE, pv);
          break;

       case MI_CDIO_AVSEEK:
          SetTitle("Running CD Seek Time");
          SetMenuState(false);
          _beginthread(DoCDIOAvSeek, null, START_STACKSIZE, pv);
          break;

       case MI_CDIO_TRANS_SPEED:
          SetTitle("Running CD transfer speed");
          SetMenuState(false);
          _beginthread(DoCDIOTransSpeed, null, START_STACKSIZE, pv);
          break;

       case MI_CDIO_CPU_USAGE:
          SetTitle("Running CD CPU percentage");
          SetMenuState(false);
          _beginthread(DoCDIOCPUUsage, null, START_STACKSIZE, pv);
          break;

       case MI_CDIO_ALL:
          SetTitle("Running CD I/O tests");
          SetMenuState(false);
          _beginthread(DoAllCDIO, null, START_STACKSIZE, pv);
          break;

       case MI_CDIO_ALL_DRIVES:
          SetTitle("Running All drives CD test");
          SetMenuState(false);
          _beginthread(DoAllCDIOAll, null, START_STACKSIZE, pv);
          break;

       case MI_MACHINE_DATA:
          GetMachineStuff(hwndWnd);
          break;

       case MI_PROJ_BEEP:
          if (!WinIsMenuItemChecked(hwndMenu, MI_PROJ_BEEP))
             {
             WinCheckMenuItem(hwndMenu, MI_PROJ_BEEP, TRUE);
             Beep = 1;
             }
          else
             {
             WinCheckMenuItem(hwndMenu, MI_PROJ_BEEP, FALSE);
             Beep = 0;
             }
          break;
       }
       break;

  case WM_PAINT:
     {
     FATTRS      fat;
     LONG        match;
     FONTMETRICS fmMetrics ;
     HPS               hpsPaint ;
     RECTL             rclRect ;
     RECTL             rclWindow ;
     ULONG             ulCharHeight ;
     HWND              hwndEnum ;
     HWND              hwndFrame ;
     HENUM             heEnum ;
     POINTL            point;
     HRGN              newHrgn, oldHrgn, dummy;
     s32               complexity;
     RECTL             clipRect;

     if (!initialized)
        {
        initialized = true;
        }

     hpsPaint = WinBeginPaint ( hwndWnd,
                             NULLHANDLE,
                             &rclRect ) ;

// This should work, but there was a bug in Warp II
//      newHrgn = GpiQueryClipRegion(hpsPaint);
//      complexity = GpiSetClipRegion(mainHps, newHrgn, &oldHrgn);
//      WinEndPaint(hpsPaint);

     GpiQueryClipBox(hpsPaint, &clipRect);
     clipRect.xRight++;
     clipRect.yTop++;
     newHrgn = GpiCreateRegion(mainHps, 1, &clipRect);
     GpiSetClipRegion(mainHps, newHrgn, &oldHrgn);
     if (NULLHANDLE != oldHrgn)
        {
        GpiDestroyRegion(mainHps, oldHrgn);
        }

     WinFillRect(mainHps, &rclRect, CLR_BLACK);

     WinQueryWindowRect ( hwndWnd, &rclWindow );
     UpdateWindow(mainHps,
                 &rclWindow,
                 scroll);

     oldscroll = scroll;
     WinEndPaint(hpsPaint);
     }
     break;

  case THR_DONE:
     SetTitle("Ready");
     Initialised = 1;
     SetMenuState(true);
     thread_running = false;
     if (AutoBench)
        {
        if (AutoBench == 2)
           {
           WinPostMsg(hwndClient,
                     WM_COMMAND,
                     (MPARAM)MPFROMSHORT(MI_PROJ_SAVE),
                     (MPARAM)MPFROM2SHORT(CMDSRC_MENU, TRUE));
           AutoBench++;
           }
        }
     break;

  case THR_UPDATE:
     UpdateAll();
     if (AutoBench)
        {
        if (AutoBench == 1)
           {
           WinPostMsg(hwndClient,
                     WM_COMMAND,
                     (MPARAM)MPFROMSHORT(MI_PROJ_ALL),
                     (MPARAM)MPFROM2SHORT(CMDSRC_MENU, TRUE));
           AutoBench++;
           }
        }
     break;

  case WM_SIZE:
     {
     s32 tmp;

     WinQueryWindowRect(hwndClient, &rect);

     tmp = disp_lines * fontH - (rect.yTop - rect.yBottom);

     if (tmp < 0)
        tmp = 0;
     if (scroll > tmp)
        scroll = tmp;

     WinSendMsg( hwndVertScroll,
               SBM_SETSCROLLBAR,
               MPFROMSHORT(scroll),
               MPFROM2SHORT(0, tmp));

     WinSendMsg( hwndVertScroll,
               SBM_SETTHUMBSIZE,
               MPFROM2SHORT(rect.yTop - rect.yBottom, disp_lines * fontH),
               NULL);
     }
     break;

  case WM_VSCROLL:
     updateScroll = false;
     WinQueryWindowRect(hwndClient, &rect);
     switch( SHORT2FROMMP( mpParm2) )
        {
        case SB_LINEUP:
          scroll -= fontH;
          updateScroll = true;;
          break;

        case SB_LINEDOWN:
          scroll += fontH;
          updateScroll = true;;
          break;

        case SB_PAGEUP:
          scroll -= rect.yTop-rect.yBottom;
          updateScroll = true;;
          break;

        case SB_PAGEDOWN:
          scroll += rect.yTop-rect.yBottom;
          updateScroll = true;;
          break;

        case SB_SLIDERTRACK:
        case SB_SLIDERPOSITION:
           scroll = SHORT1FROMMP( mpParm2);
           break;

        case SB_ENDSCROLL:
           break;
        default:
           break;
        }

    if (updateScroll)
       {
       WinQueryWindowRect(hwndClient, &rect);
       tmp = disp_lines * fontH - (rect.yTop - rect.yBottom);
       if (tmp < 0)
          tmp = 0;
       if (scroll > tmp)
          scroll = tmp;
       WinSendMsg( hwndVertScroll,
                  SBM_SETSCROLLBAR,
                  MPFROMSHORT(scroll),
                  MPFROM2SHORT(0, tmp));
       WinSendMsg( hwndVertScroll,
                  SBM_SETTHUMBSIZE,
                  MPFROM2SHORT(rect.yTop - rect.yBottom, disp_lines * fontH),
                  NULL);
       }

    tmp = disp_lines * fontH - (rect.yTop - rect.yBottom);
    if (scroll > tmp)
       scroll = tmp;
    if (scroll < 0)
       scroll = 0;

    WinScrollWindow(hwndClient,
                   0,
                   scroll-oldscroll,
                   NULL,
                   NULL,
                   NULLHANDLE,
                   NULL,
                   SW_INVALIDATERGN);

    WinUpdateWindow(hwndClient);
    break;

  case WM_ERASEBACKGROUND:
     return MRFROMSHORT ( false );  // No, we'll do this ourselves
     break;

  case WM_CHAR:
     if (!(CHARMSG(&ulMsg)->fs & KC_KEYUP))
        {
        switch (CHARMSG(&ulMsg)->vkey)
           {
           case VK_UP:
           case VK_DOWN:
           case VK_PAGEUP:
           case VK_PAGEDOWN:
              return WinSendMsg(hwndVertScroll, ulMsg, mpParm1, mpParm2);
           }
        }
     break;

  case WM_CLOSE:
     {
     hini = PrfOpenProfile(hab, szIniFileName); /* open our profile file */
     PrfWriteProfileData(hini,
                        pszApp,
                        pszKeyBeep,
                        &Beep,
                        sizeof(Beep));
     PrfCloseProfile(hini);
     return WinDefWindowProc ( hwndWnd,
                              ulMsg,
                              mpParm1,
                              mpParm2 );
     }
     break;

  default:
     return WinDefWindowProc ( hwndWnd,
                              ulMsg,
                              mpParm1,
                              mpParm2 );
  }

  return MRFROMSHORT ( FALSE );
}

void PostFin(int onlyupdate)
{
if (onlyupdate)
   {
   WinPostMsg(hwndClient, THR_UPDATE, NULL, NULL);
   }
else
   {
   WinPostMsg(hwndClient, THR_DONE, NULL, NULL);
   }
}

void err(char* s)
{
logit(s);
ErrorBox(s);
exit(1);
}

void warn(char* s)
{
WarnBox(s);
}

static void SetTitle(char* s)
  {
  char tmp[100];
  sprintf(tmp, "SysBench %s - %s", SYSB_VER, s);
  WinSetWindowText(hwndFrame, tmp);
  }

void AddTitle(char* s)
  {
  char tmp[100];
  int  i, j;
  HAB hab;
  HMQ hmq;

  hab = WinInitialize(0);
  hmq = WinCreateMsgQueue ( hab, 0UL );

  i = WinQueryWindowText(hwndFrame, 100L, tmp);
  i = 60-i-3;
  j = strlen(s);
  if (j > i)
     {
     s[i] = 0;
     }

  strcat(tmp, " (");
  strcat(tmp, s);
  strcat(tmp, ")");

  WinSetWindowText(hwndFrame, tmp);

  WinDestroyMsgQueue(hmq);
  WinTerminate(hab);
  }


void DelTitle(void)
  {
  char tmp[100];
  int  i;
  HAB hab;
  HMQ hmq;
  char* n1;

  hab = WinInitialize(0);
  hmq = WinCreateMsgQueue ( hab, 0UL );

  i = WinQueryWindowText(hwndFrame, 100L, tmp);

  n1 = strstr(tmp, " (");
  strcpy(n1, "");

  WinSetWindowText(hwndFrame, tmp);

  WinDestroyMsgQueue(hmq);
  WinTerminate(hab);
  }


static void UpdateWindow(HPS hpsPaint, PRECTL pRect, s32 scrollValue)
  {
  static char tmp[256];
  s32 i, comp, count = 0, iterations = NUM_COMPONENTS + (data.nr_fixed_disks-1) + (data.nr_cd_drives-1);
  s32 line = 0;

  // print header
  line++;
  //  line++;

  for (comp = 0; comp < iterations; comp++)
     {
    // print title
    Print(line,
         1,
         data.c[comp].title,
         pRect,
         scrollValue,
         hpsPaint,
         CLR_GREEN);

    line++;
    // print lines of data
    for (i = 0; i <= data.c[comp].ndatalines-1; i++)
       {
       if (data.c[comp].datalines[i].value < 0.0)
          sprintf(tmp, "%-21s :       --.---    %s",
                 data.c[comp].datalines[i].entry,
                 data.c[comp].datalines[i].unit);
       else
          sprintf(tmp, "%-21s : %12.3f    %s",
                 data.c[comp].datalines[i].entry,
                 data.c[comp].datalines[i].value / data.c[comp].datalines[i].unit_val,
                 data.c[comp].datalines[i].unit);
       Print(line,
            3,
            tmp,
            pRect,
            scrollValue,
            hpsPaint,
            CLR_WHITE);

       line++;
       }

    Print(line,
         3,
         "",
         pRect,
         scrollValue,
         hpsPaint,
         CLR_PALEGRAY);

    line++;
    if (data.c[comp].total < 0.0)
       sprintf(tmp, "Total                 :       --.---    %s",
              data.c[comp].unit_total);
    else
       sprintf(tmp, "Total                 : %12.3f    %s",
              data.c[comp].total,
              data.c[comp].unit_total);

    Print(line,
         3,
         tmp,
         pRect,
         scrollValue,
         hpsPaint,
         CLR_YELLOW);

    line++;
    line++;
    }
}

static void Print(s32 row, s32 col, char* string, PRECTL pRect, s32 scrollValue, HPS hpsPaint, s32 color)
  {
  RECTL printRect;

  printRect.xLeft = col * fontW;
  printRect.xRight = pRect->xRight;
  printRect.yTop = pRect->yTop - row * fontH + scrollValue;
  printRect.yBottom = printRect.yTop - fontH;

  WinDrawText(hpsPaint,
             -1,
             (PCH)string,
             &printRect,
             color,
             CLR_BLACK,
             DT_TOP |
             DT_LEFT);
  }

static void PrintFile(s32 newlines, s32 col, char* string, FILE* fp)
  {
  s32 i;
  for (i = 0; i < col; i++)
      fprintf(fp, " ");

  fprintf(fp, "%s", string);

  for (i = 0; i < newlines; i++)
      fprintf(fp, "\n");
  }

void InfoBox(char* s)
  {
  WinMessageBox(HWND_DESKTOP,
                hwndFrame,
                s,
                "Info",
                WND_MESSAGEB,
                MB_OK | MB_INFORMATION | MB_APPLMODAL | MB_MOVEABLE);
  }


void ErrorBox(char* s)
  {
  WinMessageBox(HWND_DESKTOP,
                hwndFrame,
                s,
                "Error !",
                WND_MESSAGEB,
                MB_OK | MB_ERROR | MB_APPLMODAL | MB_MOVEABLE);
  }


void WarnBox(char* s)
  {
  WinMessageBox(HWND_DESKTOP,
                hwndFrame,
                s,
                "Warning !",
                WND_MESSAGEB,
                MB_OK | MB_WARNING | MB_APPLMODAL | MB_MOVEABLE);
  }

void UpdateAll(void)
  {
  RECTL rclWindow, cliprect;
  HRGN  newHrgn, oldHrgn, dummy;
  s32 i, comp;
  bool calcav = true;

  // calculate averages
  for (comp = 0; comp < NUM_COMPONENTS+(data.nr_fixed_disks-1)+(data.nr_cd_drives-1); comp++)
     {
     calcav = true;
     for (i = 0; i < data.c[comp].ndatalines; i++)
        {
        calcav = calcav && (data.c[comp].datalines[i].value >= 0.0);
        }
     if (!calcav)
        continue;
     switch (comp)
        {
        case comp_gfx:
           data.c[comp_gfx].total = CalcGfxAv();
           break;
        case comp_cpuint:
           data.c[comp_cpuint].total = CalcCPUIntAv();
           break;
        case comp_cpufloat:
           data.c[comp_cpufloat].total = CalcCPUFloatAv();
           break;
        case comp_dive:
           data.c[comp_dive].total = CalcDIVEAv();
           break;
        case comp_file:
           data.c[comp_file].total = CalcFileIOAv();
           break;
        case comp_mem:
           data.c[comp_mem].total = CalcMemAv();
           break;
        default: /* for all disk and CD entries */
           {
           if (Initialised)
              {
              if (comp < data.nr_fixed_disks+comp_disk)
                 data.c[comp].total = CalcDiskIOAv(comp);
              else
                 if (comp < data.nr_fixed_disks+data.nr_cd_drives+comp_disk)
                    data.c[comp].total = CalcCDIOAv(comp);
              }
           }
           break;
        }
     }

  // update screen
  WinQueryWindowRect ( hwndClient, &rclWindow ); // update whole window
  cliprect.xLeft = rclWindow.xLeft;
  cliprect.xRight = rclWindow.xRight+1;
  cliprect.yBottom = rclWindow.yBottom;
  cliprect.yTop = rclWindow.yTop+1;
  newHrgn = GpiCreateRegion(mainHps, 1, &cliprect);
  GpiSetClipRegion(mainHps, newHrgn, &oldHrgn);
  if (NULLHANDLE != oldHrgn)
     GpiDestroyRegion(mainHps, oldHrgn);
  UpdateWindow(mainHps, &rclWindow, scroll);
  oldscroll = scroll;
  }

static void SetMenuState(bool active)
  { // if active == true => all items enabled
    // otherw. all items but the about and close are disabled
  WinEnableMenuItem(hwndMenu, MI_PROJ_SAVE, active);
  WinEnableMenuItem(hwndMenu, MI_PROJ_SAVE_HTML, active);
  WinEnableMenuItem(hwndMenu, MI_PROJ_ALL, active);
  WinEnableMenuItem(hwndMenu, MI_PROJ_BEEP, active);
  WinCheckMenuItem(hwndMenu,  MI_PROJ_BEEP, Beep);
  WinEnableMenuItem(hwndMenu, MI_MACHINE_DATA, active);
  WinEnableMenuItem(hwndMenu, MI_MENU_GFX, active);
  WinEnableMenuItem(hwndMenu, MI_MENU_CPUINT, active);
  WinEnableMenuItem(hwndMenu, MI_MENU_CPUFLOAT, active);
  WinEnableMenuItem(hwndMenu, MI_MENU_MEM, active);
  if (gtWarp)
     {
     WinEnableMenuItem(hwndMenu,
                      MI_MENU_DIVE,
                      active);
     }
  else
     {
     WinEnableMenuItem(hwndMenu,
                      MI_MENU_DIVE,
                      false);
     }
  if (data.nr_fixed_disks)
     WinEnableMenuItem(hwndMenu, MI_MENU_DISKIO, active);
  else
     WinEnableMenuItem(hwndMenu, MI_MENU_DISKIO, FALSE);

  if (data.nr_cd_drives)
     WinEnableMenuItem(hwndMenu, MI_MENU_CDIO, active);
  else
     WinEnableMenuItem(hwndMenu, MI_MENU_CDIO, FALSE);

  if (!fileiodisabled)
     WinEnableMenuItem(hwndMenu, MI_MENU_FILEIO, active);
}


static void SaveResults(void)
  {
  FILE* fp;
  static char tmp[256];
  s32 i, comp, iterations = NUM_COMPONENTS + (data.nr_fixed_disks-1) + (data.nr_cd_drives-1);
  struct tm *newtime;
  time_t ltime;

  FILEDLG fild;            /* File dialog info structure           */
  char pszTitle[24] = "Save Results to file..."; /* Title of dialog              */
  HWND hwndDlg;            /* File dialog window */

  APIRET rc = 0UL, ret;
  double meg = MB;
  static DIVE_CAPS dc;
  float size;
  char  IDrive[2];

  memset(&fild, 0, sizeof(FILEDLG)); /* set fields in file dlg to zero */

  fild.cbSize   = sizeof(FILEDLG);       /* Size of structure        */
  fild.fl       = FDS_CENTER | FDS_SAVEAS_DIALOG | FDS_ENABLEFILELB      ;
                                    /* FDS_* flags              */
  fild.pszTitle = pszTitle;         /* Dialog title string         */
  if (pszFullFile[1] == ':')
     {
     fild.pszIDrive = (char*)&IDrive;
     IDrive[0] = pszFullFile[0];
     IDrive[1] = pszFullFile[1];
     IDrive[2] = 0;
     strcpy(fild.szFullFile, pszFullFile+2);  /* Initial path,file name, or file filter */
     }
  else
     {
     strcpy(fild.szFullFile, pszFullFile);  /* Initial path,file name, or file filter */
     }

  if (!AutoBench)
     {
     hwndDlg = WinFileDlg(HWND_DESKTOP, hwndClient, &fild);

     if (hwndDlg && (fild.lReturn == DID_OK))
        {
        fp = fopen(fild.szFullFile, "wb");
        }
     else
        {
        return;
        }
     }
  else
     {
     fp = fopen(pszFullFile, "wb");
     }

  if (!fp)
     {
     WarnBox("Cannot open output file");
     return;
     }

  time(&ltime);
  newtime = localtime(&ltime);
  fprintf(fp, "\n\nSysbench " SYSB_VER " result file created %s\n", asctime(newtime));

  fprintf(fp, "Machine name    - %s\n"
              "Manufacturer    - %s\n"
              "Motherboard     - %s\n"
              "Chipset         - %s\n"
              "Processor       - %s\n"
              "External cache  - %s\n"
              "Graphics card   - %s\n"
              "Disk Controller - %s\n\n",
              Machinename,
              MachineMake,
              Moboname,
              Chipset,
              Processor,
              CacheAmount,
              Graphicscard,
              DiskController);

  fprintf(fp, "Machine data\n"
              "Coprocessor     = %s\n"
              "RAM             = %3.2f MB\n"
              "Priority        = %s\n"
              "Maxwait         = %d\n"
              "Timeslice       = (%d,%d)\n",
               (coproc ? "Yes" : "No"),
               (double)(value[QSV_TOTPHYSMEM - QSV_BOOT_DRIVE]+(384*KB))/meg,
               (value[QSV_DYN_PRI_VARIATION - QSV_BOOT_DRIVE] ? "Dynamic" : "Absolute"),
               value[QSV_MAX_WAIT - QSV_BOOT_DRIVE],
               value[QSV_MIN_SLICE - QSV_BOOT_DRIVE],
               value[QSV_MAX_SLICE - QSV_BOOT_DRIVE]);

  size = GetSwapFileSize();

  if (size)
     {
     fprintf(fp, "Swap file size  = %4.2fMB\n"
                 "  ...initially  = %4.2fMB\n",
                 (float)size/MB,
                 (float)startsize/MB);
     }
  else
     {
     fprintf(fp, "Unable to determine current swapfile size\n"
                 "   ...initially = %4.2fMB\n",
                 (float)startsize/MB);
     }

   if (gtWarp)
     {
     memset(&dc, 0, sizeof(dc));
     dc.ulStructLen    = sizeof(dc);
     dc.ulFormatLength = 0;
     ret = DiveQueryCaps(&dc, DIVE_BUFFER_SCREEN);
     if (DIVE_SUCCESS != ret)
        {
        if (ret == DIVE_ERR_INSUFFICIENT_LENGTH)
           {
           dc.pFormatData = calloc(dc.ulFormatLength,1);
           ret = DiveQueryCaps(&dc, DIVE_BUFFER_SCREEN); // let's try again
           if (DIVE_SUCCESS != ret)
              {
              err("Error in call to DiveQueryCaps()");
              }
           }
        else
           {
           err("Error in call to DiveQueryCaps()");
           }
        }

     fprintf(fp, "\nVideo data\n"
                 "Resolution      = %dx%dx%d bits/pixel\n",
            dc.ulHorizontalResolution,
            dc.ulVerticalResolution,
            dc.ulDepth);

     fprintf(fp, "Number planes   = %d\n"
                 "Screen Access   = %s\n"
                 "Bank Switched   = %s\n"
                 "Bytes/scanline  = %d\n"
                 "Aperture size   = %d\n",
            dc.ulPlaneCount,
            (dc.fScreenDirect ? "Direct" : "Not Direct"),
            (dc.fBankSwitched ? "Yes" : "No"),
            dc.ulScanLineBytes,
            dc.ulApertureSize);
     fprintf(fp, "Manufact. code  = %d\n"
                 "Chipset code    = %d\n\n",
                 VideoAdapter,
                 VideoChip);
     }
  else
     {
     fprintf(fp, "Video data not listed because OS/2 release less than Warp\n");
     }

  for (comp = 0; comp < iterations; comp++)
     {
     // print title
     PrintFile(1, 1, data.c[comp].title, fp);
     // print lines of data
     for (i = 0; i <= data.c[comp].ndatalines-1; i++)
        {
        if (data.c[comp].datalines[i].value < 0.0)
           sprintf(tmp, "%-21s :       --.---    %s",
                  data.c[comp].datalines[i].entry,
                  data.c[comp].datalines[i].unit);
        else
           sprintf(tmp, "%-21s : %12.3f    %s",
                  data.c[comp].datalines[i].entry,
                  data.c[comp].datalines[i].value / data.c[comp].datalines[i].unit_val,
                  data.c[comp].datalines[i].unit);

        PrintFile(1, 3, tmp, fp);
        }
//  PrintFile(1, 3, "", fp);
     PrintFile(1, 3, "------------------------------------------------------------", fp);
     if (data.c[comp].total < 0.0)
        sprintf(tmp, "Total                 :       --.---    %s",
                data.c[comp].unit_total);
     else
        sprintf(tmp, "Total                 : %12.3f    %s",
               data.c[comp].total,
               data.c[comp].unit_total);
     PrintFile(2, 3, tmp, fp);
     }

  fclose(fp);

  if (AutoBench)
     {
     SaveResultsHtml();
     WinPostMsg(hwndClient,
               WM_COMMAND,
               (MPARAM)MPFROMSHORT(MI_PROJ_QUIT),
               (MPARAM)MPFROM2SHORT(CMDSRC_MENU, TRUE));
     }
}


static void SaveResultsHtml(void)
  {
  FILE* fp;
  static char tmp[256];
  s32 i, comp, iterations = NUM_COMPONENTS + (data.nr_fixed_disks-1) + (data.nr_cd_drives-1);

  FILEDLG fild;            /* File dialog info structure           */
  char pszTitle[24] = "Save Results to file..."; /* Title of dialog              */
  HWND hwndDlg;            /* File dialog window */

  APIRET rc = 0UL, ret;
  double meg = MB;
  static DIVE_CAPS dc;
  float size;
  int colours;
  char  IDrive[2], vidres[20];

  memset(&fild, 0, sizeof(FILEDLG)); /* set fields in file dlg to zero */

  fild.cbSize   = sizeof(FILEDLG);       /* Size of structure        */
  fild.fl       = FDS_CENTER | FDS_SAVEAS_DIALOG | FDS_ENABLEFILELB      ;
                                    /* FDS_* flags              */
  fild.pszTitle = pszTitle;         /* Dialog title string         */
  if (pszFullFile[1] == ':')
     {
     fild.pszIDrive = (char*)&IDrive;
     IDrive[0] = pszFullFileHTML[0];
     IDrive[1] = pszFullFileHTML[1];
     IDrive[2] = 0;
     strcpy(fild.szFullFile, pszFullFileHTML+2);  /* Initial path,file name, or file filter */
     }
  else
     {
     strcpy(fild.szFullFile, pszFullFileHTML);  /* Initial path,file name, or file filter */
     }

  if (!AutoBench)
     {
     hwndDlg = WinFileDlg(HWND_DESKTOP, hwndClient, &fild);

     if (hwndDlg && (fild.lReturn == DID_OK))
        {
        fp = fopen(fild.szFullFile, "wb");
        }
     else
        {
        return;
        }
     }
  else
     {
     fp = fopen(pszFullFileHTML, "wb");
     }

  if (!fp)
     {
     WarnBox("Cannot open output file");
     return;
     }

  if (gtWarp)
     {
     memset(&dc, 0, sizeof(dc));
     dc.ulStructLen    = sizeof(dc);
     dc.ulFormatLength = 0;
     ret = DiveQueryCaps(&dc, DIVE_BUFFER_SCREEN);
     if (DIVE_SUCCESS != ret)
        {
        if (ret == DIVE_ERR_INSUFFICIENT_LENGTH)
           {
           dc.pFormatData = calloc(dc.ulFormatLength,1);
           ret = DiveQueryCaps(&dc, DIVE_BUFFER_SCREEN); // let's try again
           if (DIVE_SUCCESS != ret)
              {
              err("Error in call to DiveQueryCaps()");
              }
           }
        else
           {
           err("Error in call to DiveQueryCaps()");
           }
        }

     colours = pow(2, dc.ulDepth);

     sprintf(vidres, "%dx%dx%d",
            dc.ulHorizontalResolution,
            dc.ulVerticalResolution,
            colours);
     }
  else
     {
     sprintf(vidres, "Unknown");
     }

  fprintf(fp, "<HTML>\n<HEAD>\n<TITLE>Sysbench " SYSB_VER " results</TITLE>\n</HEAD>\n");

  fprintf(fp, "<BODY>\n<H3>Sysbench " SYSB_VER " results</H3>\n");

  fprintf(fp, "<H4>CPU Integer tests </H4>\n"
              "<TABLE BORDER>\n"
              "<TR>\n<TH>CPU</TH>\n"
              "<TH>Brand/Board</TH>\n"
              "<TH>Chip set</TH>\n"
              "<TH>Bios</TH>\n"
              "<TH>Cache</TH>\n"
              "<TH>Cache Type</TH>\n"
              "<TH>Dhrystone</TH>\n"
              "<TH>Hanoi</TH>\n"
              "<TH>Heapsort</TH>\n"
              "<TH>Sieve</TH>\n"
              "<TH>CpuI-marks</TH>\n"
              "</TR>\n\n");

  fprintf(fp, "<TR>\n"
              "<TD>%s</TD>\n" /* CPU */
              "<TD>%s/%s</TD>\n" /* mobo */
              "<TD>%s</TD>\n" /*Chipset */
              "<TD>%s</TD>\n"   /* BIOS */
              "<TD>%s</TD>\n" /* Cache */
              "<TD></TD>\n"   /* cachetype */
              "<TD ALIGN=CENTER> %12.3f </TD>\n"  /* dhrystone */
              "<TD ALIGN=CENTER> %12.3f </TD>\n"  /* Hanoi */
              "<TD ALIGN=CENTER> %12.3f </TD>\n"  /* heapsort */
              "<TD ALIGN=CENTER> %12.3f </TD>\n"  /* sieve */
              "<TD ALIGN=CENTER> %12.3f </TD>\n"  /* CPUint */
              "</TR></TABLE>\n\n",
              Processor,
              MachineMake,
              Moboname,
              Chipset,
              BIOSname,
              CacheAmount,
              data.c[comp_cpuint].datalines[0].value / data.c[comp_cpuint].datalines[0].unit_val,
              data.c[comp_cpuint].datalines[1].value / data.c[comp_cpuint].datalines[1].unit_val,
              data.c[comp_cpuint].datalines[2].value / data.c[comp_cpuint].datalines[2].unit_val,
              data.c[comp_cpuint].datalines[3].value / data.c[comp_cpuint].datalines[3].unit_val,
              data.c[comp_cpuint].total);

  fprintf(fp, "<H4>CPU Floating Point tests </H4>\n"
              "<TABLE BORDER>\n"
              "<TR>\n"
              "<TH>CPU</TH>\n"
              "<TH>Brand/Board</TH>\n"
              "<TH>Chip set</TH>\n"
              "<TH>Bios</TH>\n"
              "<TH>Cache</TH>\n"
              "<TH>Cache Type</TH>\n"
              "<TH>LinPack</TH>\n"
              "<TH>Flops</TH>\n"
              "<TH>FFT</TH>\n"
              "<TH>CpuF-marks</TH>\n"
              "</TR>\n\n");

  fprintf(fp, "<TR>\n"
              "<TD>%s</TD>\n" /* CPU */
              "<TD>%s/%s</TD>\n" /* mobo */
              "<TD>%s</TD>\n" /*Chipset */
              "<TD>%s</TD>\n"   /* BIOS */
              "<TD>%s</TD>\n" /* Cache */
              "<TD></TD>\n"   /* cachetype */
              "<TD ALIGN=CENTER>%12.3f</TD>\n"  /* linpack */
              "<TD ALIGN=CENTER>%12.3f</TD>\n"  /* Flops */
              "<TD ALIGN=CENTER>%12.3f</TD>\n"  /* FFT */
              "<TD ALIGN=CENTER>%12.3f</TD>\n"  /* CPUfloat */
              "</TR></TABLE>\n\n",
              Processor,
              MachineMake,
              Moboname,
              Chipset,
              BIOSname,
              CacheAmount,
              data.c[comp_cpufloat].datalines[0].value / data.c[comp_cpufloat].datalines[0].unit_val,
              data.c[comp_cpufloat].datalines[1].value / data.c[comp_cpufloat].datalines[1].unit_val,
              data.c[comp_cpufloat].datalines[2].value / data.c[comp_cpufloat].datalines[2].unit_val,
              data.c[comp_cpufloat].total);

  fprintf(fp, "<H4>DIVE tests </H4>\n"
              "<TABLE BORDER>\n"
              "<TR>\n"
              "<TH>CPU</TH>\n"
              "<TH>Vid Bus</TH>\n"
              "<TH>Vid Card</TH>\n"
              "<TH>Chip Set</TH>\n"
              "<TH>Vid Mem</TH>\n"
              "<TH>Video Bus Bandwidth</TH>\n"
              "<TH>DIVE fun</TH>\n"
              "<TH>M->S DD 1.00:1</TH>\n"
              "<TH>Dive-marks</TH>\n"
              "</TR>\n\n");

  fprintf(fp, "<TR>\n"
              "<TD>%s</TD>\n" /* CPU */
              "<TD>%s</TD>\n"   /* video bus */
              "<TD>%s</TD>\n" /* video card */
              "<TD>%s %s</TD>\n"   /* video chipset */
              "<TD> %d MB</TD>\n"   /* video memory */
              "<TD ALIGN=CENTER>%12.3f</TD>\n"  /* Video Bus Bandwidth */
              "<TD ALIGN=CENTER>%12.3f</TD>\n"  /* DIVE fun */
              "<TD ALIGN=CENTER>%12.3f</TD>\n"  /* M->S DD 1.00:1 */
              "<TD ALIGN=CENTER>%12.3f</TD>\n"  /* Dive-marks */
              "</TR></TABLE>\n\n",
              Processor,
              BusName,
              Graphicscard,
              VideoMan,
              VideoType,
              VideoMem / MB,
              data.c[comp_dive].datalines[0].value / data.c[comp_dive].datalines[0].unit_val,
              data.c[comp_dive].datalines[1].value / data.c[comp_dive].datalines[1].unit_val,
              data.c[comp_dive].datalines[2].value / data.c[comp_dive].datalines[2].unit_val,
              data.c[comp_dive].total);

  fprintf(fp, "<H4>Video tests </H4>\n"
              "<H4>%s</H4>\n"
              "<TABLE BORDER>\n"
              "<TR>\n"
              "<TH>CPU</TH>\n"
              "<TH>Vid Bus</TH>\n"
              "<TH>Vid Card</TH>\n"
              "<TH>Chip Set</TH>\n"
              "<TH>Vid Mem</TH>\n"
              "<TH>BitBlt S->S Copy</TH>\n"
              "<TH>BitBlt M->S Copy</TH>\n"
              "<TH>Filled Rect.</TH>\n"
              "<TH>Pattern Fill</TH>\n"
              "<TH>Vert. Lines</TH>\n"
              "<TH>Horiz. Lines</TH>\n"
              "<TH>Diag. Lines</TH>\n"
              "<TH>Text Render</TH>\n"
              "<TH>PM-marks</TH>\n"
              "</TR>\n\n",
              vidres);

  fprintf(fp, "<TR>\n"
              "<TD>%s</TD>\n" /* CPU */
              "<TD>%s</TD>\n"   /* video bus */
              "<TD>%s</TD>\n" /* video card */
              "<TD>%s %s</TD>\n"   /* video chipset */
              "<TD> %d MB</TD>\n"   /* video memory */
              "<TD ALIGN=CENTER>%12.3f</TD>\n"  /* BitBLT S->S */
              "<TD ALIGN=CENTER>%12.3f</TD>\n"  /* BitBLT M->S */
              "<TD ALIGN=CENTER>%12.3f</TD>\n"  /* Filled rect */
              "<TD ALIGN=CENTER>%12.3f</TD>\n"  /* pattern fill */
              "<TD ALIGN=CENTER>%12.3f</TD>\n"  /* Vert lines */
              "<TD ALIGN=CENTER>%12.3f</TD>\n"  /* Horiz lines */
              "<TD ALIGN=CENTER>%12.3f</TD>\n"  /* diag lines */
              "<TD ALIGN=CENTER>%12.3f</TD>\n"  /* text render */
              "<TD ALIGN=CENTER>%12.3f</TD>\n"  /* PM-marks */
              "</TR></TABLE>\n\n",
              Processor,
              BusName,
              Graphicscard,
              VideoMan,
              VideoType,
              VideoMem / MB,
              data.c[comp_gfx].datalines[0].value / data.c[comp_gfx].datalines[0].unit_val,
              data.c[comp_gfx].datalines[1].value / data.c[comp_gfx].datalines[1].unit_val,
              data.c[comp_gfx].datalines[2].value / data.c[comp_gfx].datalines[2].unit_val,
              data.c[comp_gfx].datalines[3].value / data.c[comp_gfx].datalines[3].unit_val,
              data.c[comp_gfx].datalines[4].value / data.c[comp_gfx].datalines[4].unit_val,
              data.c[comp_gfx].datalines[5].value / data.c[comp_gfx].datalines[5].unit_val,
              data.c[comp_gfx].datalines[6].value / data.c[comp_gfx].datalines[6].unit_val,
              data.c[comp_gfx].datalines[7].value / data.c[comp_gfx].datalines[7].unit_val,
              data.c[comp_gfx].total);

  fprintf(fp, "<H4>Disk tests</H4>\n"
              "<TABLE BORDER>\n"
              "<TR>\n"
              "<TH>CPU</TH>\n"
              "<TH>Brand/Board</TH>\n"
              "<TH>Bus</TH>\n"
              "<TH>Controller</TH>\n"
              "<TH>Drive</TH>\n"
              "<TH>Avg. Data Access time</TH>\n"
              "<TH>Cache/Bus xfer</TH>\n"
              "<TH>Avg. Transfer</TH>\n"
              "<TH>Disk use CPU load</TH>\n"
              "<TH>DiskIO-marks</TH>\n"
              "</TR>\n\n");

  for (i = 0; i < data.nr_fixed_disks; i++)
     {
     char* n1 = strstr(data.c[comp_disk+i].title, " -");

     fprintf(fp, "<TR>\n"
                 "<TD>%s</TD>\n" /* CPU */
                 "<TD>%s/%s</TD>\n" /* mobo */
                 "<TD>%s</TD>\n"   /* Bus */
                 "<TD>%s</TD>\n" /* Controller */
                 "<TD>%s</TD>\n"   /* Drive */
                 "<TD ALIGN=CENTER>%12.3f</TD>\n"  /* data access time */
                 "<TD ALIGN=CENTER>%12.3f</TD>\n"  /* cache/bus */
                 "<TD ALIGN=CENTER>%12.3f</TD>\n"  /* xfer rate */
                 "<TD ALIGN=CENTER>%12.3f</TD>\n"  /* CPU % */
                 "<TD ALIGN=CENTER>%12.3f</TD>\n"  /* CD mark */
                 "</TR>\n\n",
                 Processor,
                 MachineMake,
                 Moboname,
                 BusName,
                 DiskController,
                 n1+2,
                 data.c[comp_disk+i].datalines[0].value / data.c[comp_disk+i].datalines[0].unit_val,
                 data.c[comp_disk+i].datalines[1].value / data.c[comp_disk+i].datalines[1].unit_val,
                 data.c[comp_disk+i].datalines[2].value / data.c[comp_disk+i].datalines[2].unit_val,
                 data.c[comp_disk+i].datalines[3].value / data.c[comp_disk+i].datalines[3].unit_val,
                 data.c[comp_disk+i].total);
     }

  fprintf(fp, "</TABLE>\n\n");

  if (data.nr_cd_drives)
     {
     fprintf(fp, "<H4>CD-ROM tests</H4>\n"
                 "<TABLE BORDER>\n"
                 "<TR>\n"
                 "<TH>CPU</TH>\n"
                 "<TH>Brand/Board</TH>\n"
                 "<TH>Bus</TH>\n"
                 "<TH>Controller</TH>\n"
                 "<TH>Drive</TH>\n"
                 "<TH>Avg. Data Access time</TH>\n"
                 "<TH>Avg. Transfer</TH>\n"
                 "<TH>CD use CPU load</TH>\n"
                 "<TH>CD I/O-marks</TH>\n"
                 "</TR>\n\n");

     for (i = 0; i < data.nr_cd_drives; i++)
        {
        char* n1 = strstr(data.c[comp_disk+data.nr_fixed_disks+i].title, " -");
        fprintf(fp, "<TR>\n"
                    "<TD>%s</TD>\n" /* CPU */
                    "<TD>%s/%s</TD>\n" /* mobo */
                    "<TD>%s</TD>\n"   /* Bus */
                    "<TD>%s</TD>\n" /* Controller */
                    "<TD>%s</TD>\n"   /* Drive */
                    "<TD ALIGN=CENTER>%12.3f</TD>\n"  /* data access time */
                    "<TD ALIGN=CENTER>%12.3f</TD>\n"  /* xfer rate */
                    "<TD ALIGN=CENTER>%12.3f</TD>\n"  /* CPU % */
                    "<TD ALIGN=CENTER>%12.3f</TD>\n"  /* CD mark */
                    "</TR>\n\n",
                    Processor,
                    MachineMake,
                    Moboname,
                    BusName,
                    DiskController,
                    n1+2,
                    data.c[comp_disk+data.nr_fixed_disks+i].datalines[0].value / data.c[comp_disk+data.nr_fixed_disks+i].datalines[0].unit_val,
                    data.c[comp_disk+data.nr_fixed_disks+i].datalines[1].value / data.c[comp_disk+data.nr_fixed_disks+i].datalines[1].unit_val,
                    data.c[comp_disk+data.nr_fixed_disks+i].datalines[2].value / data.c[comp_disk+data.nr_fixed_disks+i].datalines[2].unit_val,
                    data.c[comp_disk+data.nr_fixed_disks+i].total);
        }

     fprintf(fp, "</TABLE>\n\n</BODY>\n</HTML>\n");
     }

  fclose(fp);
}


PSZ DoScanConfigSys(PSZ Keyword, int notstart)
  {
  char CSPath[_MAX_PATH];
  FILE *fp;
  static char Buffer[1025];
  char *p;
  char* n1;
  int notstop = 1;

  CSPath[0] = (char)(BootDriveLetter + 'A'- 1);
  CSPath[1] = 0;
  strcat(CSPath, ":\\CONFIG.SYS");

  fp = fopen(CSPath, "r");
  if (!fp)
     {
     return  0;
     }

  while(fgets(Buffer, sizeof(Buffer), fp) )
     {
     if (Buffer[strlen(Buffer)-1] == '\n')
        {
        Buffer[strlen(Buffer)-1] = 0;
        }

     p = strupr(Buffer);
     n1 = strstr((char*)p, (char*)Keyword);

     if (n1)
        {
        if (n1 == p)               /* if keyword at start of line */
           {
           n1 = strstr(n1, "=");
           n1 = n1+1;
           fclose (fp);
           return (PSZ)n1;
           }
        else
           {
           if (notstart)
              {
              fclose(fp);
              return (PSZ)n1;
              }
           }
        }
     }
  fclose (fp); /* close file at end */
  return 0;
}

void GetMachineInfo(void)
{
PSZ Swappath, charsp = "SWAPPATH";
PSZ diskcache, hpfscache;

  char* n1;
  DosDevConfig(&coproc,DEVINFO_COPROCESSOR);

  DosQuerySysInfo(QSV_BOOT_DRIVE,
                 QSV_TOTPHYSMEM,
                 (PVOID)value,
                 sizeof(ULONG)*QSV_MAX);

  BootDriveLetter = value[QSV_BOOT_DRIVE - QSV_BOOT_DRIVE];

  Swappath = DoScanConfigSys(charsp, false);

  pdisknum = Swappath[0] - 'A' +1;

  sscanf(Swappath, "%s %u %f", CSpath, &minfree, &startsize);

  if (CSpath[strlen(CSpath)-1] == '\\')  /* if last character of path \ */
     {
     CSpath[strlen(CSpath)-1] = 0;       /* back up a bit */
     }

  startsize = startsize * 1024;

  strcat(CSpath, "\\swapper.dat");

  diskcache = DoScanConfigSys("DISKCACHE", false);

  if (diskcache)
     {
     char cache[12], rest[100];
     sscanf(diskcache, "%[^, ]s %s", cache, rest);
     if (strcmp(strupr(cache), "D"))
        {
        fatcachesize = atoi(cache) * KB;          /* hard coded cache size */
        }
     else
        {
        fatcachesize = value[QSV_TOTPHYSMEM - QSV_BOOT_DRIVE] / 10;  /* cache size is 10% of RAM */
        if (fatcachesize > (14400 * KB))
           {
           fatcachesize = 14400 * KB;
           }
        if (value[QSV_TOTPHYSMEM - QSV_BOOT_DRIVE] >= ((6 * MB) +1) &&
            value[QSV_TOTPHYSMEM - QSV_BOOT_DRIVE] <= (8 * MB))
           {
           fatcachesize = 512 * KB;
           }
        if (value[QSV_TOTPHYSMEM - QSV_BOOT_DRIVE] >= ((5 * MB) +1) &&
            value[QSV_TOTPHYSMEM - QSV_BOOT_DRIVE] <= (6 * MB))
           {
           fatcachesize = 128 * KB;
           }
        if (value[QSV_TOTPHYSMEM - QSV_BOOT_DRIVE] <= (5 * MB))
           {
           fatcachesize = 64 * KB;
           }
        }
     }
  else
     {
     fatcachesize = 0;
     }

  hpfscache = DoScanConfigSys("HPFS.IFS", true);

  if (hpfscache)
     {
     n1 = strstr((char*)hpfscache, "/CACHE");
     if (!n1)
        {
        n1 = strstr((char*)hpfscache, "/C:");
        }

     if (n1)
        {
        char cache[12], rest[100];
        n1 = strstr(n1, ":");
        n1 = n1+1;
        sscanf(n1, "%s %s", cache, rest);
        hpfscachesize = atoi(cache) * KB;
        }
     else
        {
        hpfscachesize = value[QSV_TOTPHYSMEM - QSV_BOOT_DRIVE] / 10;  /* cache size is 10% of RAM */
        if (hpfscachesize > (2048 * KB))
           {
           hpfscachesize = 2048 * KB;
           }
        }
     }
  else
     {
     hpfscachesize = 0;
     }
}


float GetSwapFileSize(void)
{
FILESTATUS3 pInfoBuf1;
if (!DosQueryPathInfo(CSpath,
                  FIL_STANDARD,
                  &pInfoBuf1,
                  sizeof(FILESTATUS3)))
     {
     return (float)pInfoBuf1.cbFile;
     }
  else
     {
     return 0;
     }
}


void _Optlink ShowWaitWindow(void* arg)
{
  HMQ         hmq = NULLHANDLE;
  HAB         hab = NULLHANDLE;      /* PM anchor block handle         */
  ERRORID erridErrorCode;
  APIRET      rc  = 0 ;

  hab = WinInitialize ( 0UL );
  if (hab == NULLHANDLE)
     {
     erridErrorCode = WinGetLastError(hab);
     printf("ShowWaitWindow WinInitialize returned %x\n", erridErrorCode);
     exit(2);
     }
  hmq = WinCreateMsgQueue ( hab, 0UL );
  if (hmq == NULLHANDLE)
     {
     erridErrorCode = WinGetLastError(hab);
     printf("ShowWaitWindow WinCreateMsgQueue returned %x\n", erridErrorCode);
     exit(2);
     }

  flashit = 1;

  rc = DosCreateEventSem(NULL,          /* Unnamed semaphore            */
                        &hevEvent3,     /* Handle of semaphore returned */
                        DC_SEM_SHARED,  /* Indicate a shared semaphore  */
                        FALSE);         /* Put in RESET state           */

  _beginthread(Flashlight, NULL, START_STACKSIZE, NULL); /* show Wait... window */

  hwndDlgB = WinLoadDlg(HWND_DESKTOP,
           HWND_DESKTOP,
           fnShowWait,
           NULLHANDLE,
           IDD_SHOWWAIT,
           NULL);

  rc = WinProcessDlg(hwndDlgB);

  flashit = 0;

  rc = DosWaitEventSem(hevEvent3, 60000);  /* wait for flashlight thread to end */

  rc = DosCloseEventSem(hevEvent3);

  WinDestroyMsgQueue ( hmq );
  WinTerminate ( hab );
  _endthread();
}


/* routine to handle messages from gathering info  box */
MRESULT APIENTRY fnShowWait (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
int rc = 0;
 switch (msg)
    {
    case WM_INITDLG:
       rc = DosPostEventSem(hevEvent2);  /* say we're ready to take close msg */
       break;

    case WM_COMMAND:
       switch (COMMANDMSG(&msg)->cmd)
          {
          case IDD_SHOWWAIT5:
             rc = WinSetFocus(HWND_DESKTOP,    /* due to an apparent bug in OS/2 that means that
                                                  the WinProcessDlg that invokes this msg handling routine
                                                  never ends if it doesn't have the focus when the
                                                  WinDismissDlg() is issued, let's give it the focus */
                             hwndDlgB);
             rc = WinDismissDlg(hwndDlgB, 0UL);  /* dismiss the dialog */
             flashit = 0;
             return 0L;
          }
       break;

    default:
       break;
    }
 return (MRESULT)WinDefDlgProc (hwnd, msg, mp1, mp2);
}                                       /* end PromptWinProc     */


void _Optlink Flashlight(void* arg)
{
  HMQ         hmq = NULLHANDLE;
  HAB         hab = NULLHANDLE;      /* PM anchor block handle         */
  ERRORID erridErrorCode;
  BOOL i = 0;

  hab = WinInitialize ( 0UL );
  if (hab == NULLHANDLE)
     {
     erridErrorCode = WinGetLastError(hab);
     printf("Flashlight WinInitialize returned %x\n", erridErrorCode);
     exit(2);
     }
  hmq = WinCreateMsgQueue ( hab, 0UL );
  if (hmq == NULLHANDLE)
     {
     erridErrorCode = WinGetLastError(hab);
     printf("Flashlight WinCreateMsgQueue returned %x\n", erridErrorCode);
     exit(2);
     }

  while (flashit)
     {
     WinShowWindow(WinWindowFromID(hwndDlgB, IDD_SHOWICON2), /* toggle LED window visibility */
                  (i%2));
     i++;
     DosSleep(500);
     }

  DosPostEventSem(hevEvent3);    /* allow parent thread to end */

  WinDestroyMsgQueue ( hmq );
  WinTerminate ( hab );
  _endthread();
}


void _Optlink GetDriveInfo(void* arg)
{
  HWND        hwndPullDown;
  CHAR        tmp[256];
  APIRET      ulrc         = 0;
  BOOL        drivechecked = 0;
  int         i            = 0;
  MENUITEM    mi;
  ERRORID     erridErrorCode;
  HMQ         hmq          = NULLHANDLE;
  HAB         hab          = NULLHANDLE;      /* PM anchor block handle         */

  hab = WinInitialize ( 0UL );
  if (hab == NULLHANDLE)
     {
     erridErrorCode = WinGetLastError(hab);
     printf("GetDriveInfo WinInitialize returned %x\n", erridErrorCode);
     exit(2);
     }
  hmq = WinCreateMsgQueue ( hab, 0UL );
  if (hmq == NULLHANDLE)
     {
     erridErrorCode = WinGetLastError(hab);
     printf("GetDriveInfo WinCreateMsgQueue returned %x\n", erridErrorCode);
     exit(2);
     }

  AddTitle("Listing formatted drives");

  for (i = 2; i <= 25; i++)   /* do from first possible HD upwards */
     {
     if ( ((ulDriveMap1 << (31-i)) >> 31) ) /* if bit in drive array is on */
        {
        typedef struct _FSINFOBUF
           {  ULONG        ulVolser;   /* Volume serial number */
           VOLUMELABEL  vol;        /* Volume label         */
           } FSINFOBUF;
        typedef FSINFOBUF *PFSINFOBUF;
        double drivesize = 300;
        char szDeviceName[3];
        FSINFOBUF VolumeInfo = {0};        /* File system info buffer */
        BYTE         fsqBuffer[sizeof(FSQBUFFER2) + (3 * CCHMAXPATH)] = {0};
        ULONG        cbBuffer   = sizeof(fsqBuffer);        /* Buffer length) */
        PFSQBUFFER2  pfsqBuffer = (PFSQBUFFER2) fsqBuffer;
        ULONG        ulOrdinal        = 0;     /* Ordinal of entry in name list      */
        PBYTE        pszFSDName       = NULL;  /* pointer to FS name                 */
        ULONG        aulFSInfoBuf[40] = {0};         /* File system info buffer     */

        ulrc = DosQueryFSInfo(i+1,
                             FSIL_VOLSER,      /* Request volume information */
                             &VolumeInfo,      /* Buffer for information     */
                             sizeof(FSINFOBUF));  /* Size of buffer          */

        if (ulrc != NO_ERROR)
           {
           if (ulrc == ERROR_BAD_NETPATH || ulrc == ERROR_NOT_READY || ulrc == ERROR_BAD_NET_NAME)
              {
              continue;
              }
           else
              {
              sprintf(tmp, "DosQueryFSInfo error: return code = %u\n", ulrc);
              logit(tmp);
              continue;
              }
           }

        szDeviceName[0] = 'A'+i;
        szDeviceName[1] = ':';
        szDeviceName[2] = (char)NULL;

        ulrc = DosQueryFSAttach(szDeviceName,   /* Logical drive of attached FS      */
                             ulOrdinal,       /* ignored for FSAIL_QUERYNAME       */
                             FSAIL_QUERYNAME, /* Return data for a Drive or Device */
                             pfsqBuffer,      /* returned data                     */
                             &cbBuffer);      /* returned data length              */

        if (ulrc != NO_ERROR)
           {
           sprintf(tmp, "DosQueryFSAttach error: return code = %u\n", ulrc);
           logit(tmp);
           return;
           }
        else
           {
           pszFSDName = (PBYTE)(pfsqBuffer->szName + pfsqBuffer->cbName + 1);
           }

        if (!strcmp(pszFSDName, "FAT"))
           {
           curdiskFAT = 1;
           }
        else
           {
           if (!strcmp(pszFSDName, "HPFS"))
              {
              curdiskFAT = 2;
              }
           else
              {
              curdiskFAT = 0; /*  if anything except FAT or HPFS */
              }
           }

        if (curdiskFAT)
           {
           ulrc = DosQueryFSInfo(i+1,            /* Drive number      */
                                FSIL_ALLOC,             /* Level 1 allocation info */
                                (PVOID)aulFSInfoBuf,    /* Buffer                  */
                                sizeof(aulFSInfoBuf));  /* Size of buffer          */

           if (ulrc != NO_ERROR)
              {
              sprintf(tmp, "DosQueryFSInfo error: return code = %u\n", ulrc);
              logit(tmp);
              }
           else
              {
              drivesize = (((double)aulFSInfoBuf[1] * (double)aulFSInfoBuf[2] * (USHORT)aulFSInfoBuf[4])/MB);
              /* (Sectors per allocation unit) * number of allocationunits * (Bytes per sector) */
              }

           if ((aulFSInfoBuf[1] * aulFSInfoBuf[3] * (USHORT)aulFSInfoBuf[4]) > (10 * MB)) /* if freespace > 10Mb */
              {
              char drive[3];
              drive[0] = 'A'+i;
              drive[1] = ':';
              drive[2] = 0;
              sprintf(tmp, "Drive % 4s % 7.0f MB", drive, drivesize);  /* print menu item inc. size */
              if (WinSendMsg(hwndMenu,
                            MM_QUERYITEM,
                            MPFROM2SHORT(MI_MENU_FILEIO_SELECT, TRUE),
                            (MPARAM)&mi))
                 {
                 hwndPullDown   = mi.hwndSubMenu;
                 mi.iPosition   = MIT_END;
                 mi.afStyle     = MIS_TEXT;
                 mi.afAttribute = (ULONG)NULL;
                 mi.id          = (ULONG)MI_MENU_FILEIO_SELECT+1+i;
                 mi.hwndSubMenu = (HWND)NULL;
                 mi.hItem       = (ULONG)NULL;
                 WinSendMsg(hwndPullDown,
                           MM_INSERTITEM,
                           (MPARAM)&mi,
                           (MPARAM)tmp);
                 if (i == ulDriveNum-1)
                    {
                    sprintf(tmp, "File I/O - cache read - Drive %c:", 'A'+ulDriveNum-1);
                    strcpy(data.c[comp_file].title, tmp);
                    drivechecked = 1;
                    WinCheckMenuItem(hwndMenu,
                                    MI_MENU_FILEIO_SELECT + ulDriveNum,
                                    true);
                    }
                 }
              else
                 {
                 erridErrorCode = WinGetLastError(hab);
                 }
              }
           }
        }
     }

  if (!drivechecked)      /* if current drive didn't have enough space */
     {
     ULONG testDrive = 0x00000001; /* bit array to reflect current drive */

     if ((ulDriveMap1 & (0xffffffff-(testDrive << ulDriveNum))) == ulDriveMap1) /* if current drive is not valid */
        {
        for (i = 3; i <= 26; i++)
           {
           if ((ulDriveMap1 & (0xffffffff-(testDrive << i))) != ulDriveMap1)
              {
              ulDriveNum = i; /* set to first drive with enough space */
              sprintf(tmp, "File I/O - cache read - Drive %c:", 'A'+ulDriveNum-1);
              strcpy(data.c[comp_file].title, tmp);
              drivechecked = 1;
              WinCheckMenuItem(hwndMenu,
                              MI_MENU_FILEIO_SELECT + ulDriveNum,
                              true);
              DosSetDefaultDisk(ulDriveNum);
              break;         /* drop out of for (i = 3; i <= 26) */
              }
           }
        }
     }

  if (!drivechecked) /* still ?! */
     {
     fileiodisabled = 1;
     }

  DelTitle();
  AddTitle("Listing available disks");

  data.nr_fixed_disks = pmb_diskio_nrdisks();
  if (data.nr_fixed_disks > MAX_FIXED_DISKS)
     {
     logit("Number of fixed disks is too high");
     exit(1);
     }

  for (i = 0; i < data.nr_fixed_disks; i++)
     {
     data.fixed_disk_size[i] = pmb_diskio_disksize(i);
     sprintf(tmp, "Disk %d: %5.0f MB", i+1, data.fixed_disk_size[i]/(KB));
     sprintf(data.c[comp_disk+i].title,
            "Disk I/O disk %d: %5.0f MB - %s",
            i+1,
            data.fixed_disk_size[i]/(KB),
            szDisk[i]);
     data.c[comp_disk+i].ndatalines = 4;

     strcpy(data.c[comp_disk+i].datalines[0].entry, "Avg. data access time");
     data.c[comp_disk+i].datalines[0].value = -1.0;
     data.c[comp_disk+i].datalines[0].unit_val = 1.0e-03;
     strcpy(data.c[comp_disk+i].datalines[0].unit, "ms");

     strcpy(data.c[comp_disk+i].datalines[1].entry, "Cache/Bus xfer rate  ");
     data.c[comp_disk+i].datalines[1].value = -1.0;
     data.c[comp_disk+i].datalines[1].unit_val = MB;
     strcpy(data.c[comp_disk+i].datalines[1].unit, "MB/s");

     strcpy(data.c[comp_disk+i].datalines[2].entry, "Average Transfer rate");
     data.c[comp_disk+i].datalines[2].value = -1.0;
     data.c[comp_disk+i].datalines[2].unit_val = MB;
     strcpy(data.c[comp_disk+i].datalines[2].unit, "MB/s");

     strcpy(data.c[comp_disk+i].datalines[3].entry, "Disk use CPU load    ");
     data.c[comp_disk+i].datalines[3].value = -1.0;
     data.c[comp_disk+i].datalines[3].unit_val = 1;
     strcpy(data.c[comp_disk+i].datalines[3].unit, "percent");

     data.c[comp_disk+i].total = -1.0;
     strcpy(data.c[comp_disk+i].unit_total, "Disk I/O-marks");

     if (WinSendMsg(hwndMenu,
                MM_QUERYITEM,
                MPFROM2SHORT(MI_MENU_DISKIO_SELECT, TRUE),
                (MPARAM)&mi))
        {
        hwndPullDown   = mi.hwndSubMenu;
        mi.iPosition   = MIT_END;
        mi.afStyle     = MIS_TEXT;
        mi.afAttribute = (ULONG)NULL;
        mi.id          = (ULONG)MI_MENU_DISKIO_SELECT+1+i;
        mi.hwndSubMenu = (HWND)NULL;
        mi.hItem       = (ULONG)NULL;
        WinSendMsg(hwndPullDown,
                  MM_INSERTITEM,
                  (MPARAM)&mi,
                  (MPARAM)tmp);
        }
     }

  if (!data.nr_fixed_disks)
     {
     WinSendMsg(hwndMenu,
               MM_QUERYITEM,
               MPFROM2SHORT(MI_MENU_DISKIO_SELECT, TRUE),
               (MPARAM) &mi);

    hwndPullDown   = mi.hwndSubMenu;
    mi.iPosition   = MIT_END;
    mi.afStyle     = MIS_TEXT;
    mi.afAttribute = 0;
    mi.id          = MI_MENU_DISKIO_SELECT+1;
    mi.hwndSubMenu = null;
    mi.hItem       = 0;
    WinSendMsg(hwndPullDown,
              MM_INSERTITEM,
              (MPARAM) &mi,
              (MPARAM)"No fixed disks found");
    }
 else
    {
    WinCheckMenuItem(hwndMenu,
                    MI_MENU_DISKIO_SELECT + 1,
                    true);
    data.selected_disk = 0;
    }

  DelTitle();
  AddTitle("Listing available CDs");

  data.nr_cd_drives = pmb_cdio_nrcds();
  if (data.nr_cd_drives > MAX_CD_DRIVES)
     {
     logit("Number of CD drives is too high");
     exit(1);
     }

  for (i = 0; i < data.nr_cd_drives; i++)
     {
     data.cd_drive_size[i] = pmb_cdio_disksize(i);
     sprintf(tmp, "Drive %d: %5.0f MB", i+1, data.cd_drive_size[i]/(KB));

     sprintf(data.c[comp_disk+data.nr_fixed_disks+i].title,
            "CD-ROM I/O disk %d: %5.0f MB - %s",
            i+1,
            data.cd_drive_size[i]/(KB),
            szDisk[i+10]);

     data.c[comp_disk+data.nr_fixed_disks+i].ndatalines = 3;

     strcpy(data.c[comp_disk+data.nr_fixed_disks+i].datalines[0].entry, "Avg. data access time");
     data.c[comp_disk+data.nr_fixed_disks+i].datalines[0].value = -1.0;
     data.c[comp_disk+data.nr_fixed_disks+i].datalines[0].unit_val = 1.0e-03;
     strcpy(data.c[comp_disk+data.nr_fixed_disks+i].datalines[0].unit, "ms");

     strcpy(data.c[comp_disk+data.nr_fixed_disks+i].datalines[1].entry, "Average Transfer rate");
     data.c[comp_disk+data.nr_fixed_disks+i].datalines[1].value = -1.0;
     data.c[comp_disk+data.nr_fixed_disks+i].datalines[1].unit_val = KB;
     strcpy(data.c[comp_disk+data.nr_fixed_disks+i].datalines[1].unit, "KB/s");

     strcpy(data.c[comp_disk+data.nr_fixed_disks+i].datalines[2].entry, "CD-ROM use CPU load ");
     data.c[comp_disk+data.nr_fixed_disks+i].datalines[2].value = -1.0;
     data.c[comp_disk+data.nr_fixed_disks+i].datalines[2].unit_val = 1;
     strcpy(data.c[comp_disk+data.nr_fixed_disks+i].datalines[2].unit, "percent");

     data.c[comp_disk+data.nr_fixed_disks+i].total = -1.0;
     strcpy(data.c[comp_disk+data.nr_fixed_disks+i].unit_total, "CD I/O-marks");

     if (WinSendMsg(hwndMenu,
               MM_QUERYITEM,
               MPFROM2SHORT(MI_MENU_CDIO_SELECT, TRUE),
               (MPARAM)&mi))
        {
        hwndPullDown   = mi.hwndSubMenu;
        mi.iPosition   = MIT_END;
        mi.afStyle     = MIS_TEXT;
        mi.afAttribute = (ULONG)NULL;
        mi.id          = (ULONG)MI_MENU_CDIO_SELECT+1+i;
        mi.hwndSubMenu = (HWND)NULL;
        mi.hItem       = (ULONG)NULL;
        WinSendMsg(hwndPullDown,
                  MM_INSERTITEM,
                  (MPARAM)&mi,
                  (MPARAM)tmp);
        }
     }

  if (!data.nr_cd_drives)
     {
     WinSendMsg(hwndMenu,
               MM_QUERYITEM,
               MPFROM2SHORT(MI_MENU_CDIO_SELECT, TRUE),
               (MPARAM) &mi);

    hwndPullDown   = mi.hwndSubMenu;
    mi.iPosition   = MIT_END;
    mi.afStyle     = MIS_TEXT;
    mi.afAttribute = 0;
    mi.id          = MI_MENU_CDIO_SELECT+1;
    mi.hwndSubMenu = null;
    mi.hItem       = 0;
    WinSendMsg(hwndPullDown,
              MM_INSERTITEM,
              (MPARAM) &mi,
              (MPARAM)"No CD drives found");
    }
 else
    {
    WinCheckMenuItem(hwndMenu,
                    MI_MENU_CDIO_SELECT + 1,
                    true);
    data.selected_cd = 0;
    }
// DosSleep(30000);

  DelTitle();

 disp_lines = NUM_LINES + (data.nr_fixed_disks * LINES_PER_DISK) + (data.nr_cd_drives * LINES_PER_CD);
 data.c[comp_disk].nrepeatcount = data.nr_fixed_disks;
 data.c[comp_cd].nrepeatcount   = data.nr_cd_drives;

 WinSendMsg(hwndClient,
           THR_DONE,
           (MPARAM)0,
           (MPARAM)0);

 WinSendMsg(hwndClient,
           THR_UPDATE,
           (MPARAM)0,
           (MPARAM)0);

 WinDestroyMsgQueue ( hmq );
 WinTerminate ( hab );

 _endthread();
}


void GetMachineStuff(HWND hwnd)
{
  HAB         hab = NULLHANDLE;      /* PM anchor block handle         */
  ERRORID erridErrorCode;
  APIRET      rc  = 0 ;
  HWND        hwndDlgM;

  hab = WinQueryAnchorBlock( hwnd );
  if (hab == NULLHANDLE)
     {
     erridErrorCode = WinGetLastError(hab);
     printf("GetMachineInfo WinQueryAnchorBlock returned %x\n", erridErrorCode);
     exit(2);
     }

  hwndDlgM = WinLoadDlg(HWND_DESKTOP,
           hwnd,
           fnMachineStuff,
           NULLHANDLE,
           IDD_MACHINE_DATA,
           NULL);

  rc = WinProcessDlg(hwndDlgM);
}


/* routine to handle messages from machine info  box */
MRESULT APIENTRY fnMachineStuff (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
int rc = 0, i, j, k;
HAB hab = WinQueryAnchorBlock(hwnd);

 switch (msg)
    {
    ULONG ulPageId;
    ULONG ipt = 0;
    CHAR pszMleBuffer[512];

    case WM_INITDLG:
       {
       ulPageId = (LONG)WinSendDlgItemMsg(hwnd,
                                         IDD_MACHINE,
                                         BKM_INSERTPAGE,
                                         NULL,
                                         MPFROM2SHORT((BKA_STATUSTEXTON |
                                                       BKA_AUTOPAGESIZE |
                                                       BKA_MAJOR),
                                         BKA_LAST));

       if ( !ulPageId)
          return FALSE;

       if ( !WinSendDlgItemMsg(hwnd,
                               IDD_MACHINE,
                               BKM_SETDIMENSIONS,
                               MPFROM2SHORT(120, 30),
                               MPFROMP(BKA_MAJORTAB)))
           return FALSE;

       if ( !WinSendDlgItemMsg(hwnd,
                               IDD_MACHINE,
                               BKM_SETSTATUSLINETEXT,
                               MPFROMLONG(ulPageId),
                               MPFROMP("Page 1 of 2")))
           return FALSE;

       if ( !WinSendDlgItemMsg(hwnd,
                               IDD_MACHINE,
                               BKM_SETTABTEXT,
                               MPFROMLONG(ulPageId),
                               MPFROMP("~Machine Info")))
          return FALSE;

       hwndPage1 = WinLoadDlg(hwnd,          /* load dialog for entry fields */
                            hwnd,
                            fnMachdlgStuff,
                            0,
                            IDD_MACH_DLG_DATA,
                            NULL);

       if (!hwndPage1)
         return FALSE;

       if ( !WinSendDlgItemMsg(hwnd,
                              IDD_MACHINE,
                              BKM_SETPAGEWINDOWHWND,
                              MPFROMLONG(ulPageId),
                              MPFROMHWND(hwndPage1)))
         return FALSE;

       /*
        * Insert the second page.
        */
       ulPageId = (LONG)WinSendDlgItemMsg(hwnd,
                                         IDD_MACHINE,
                                         BKM_INSERTPAGE,
                                         NULL,
                                         MPFROM2SHORT((BKA_STATUSTEXTON |
                                                       BKA_AUTOPAGESIZE |
                                                       BKA_MAJOR),
                                         BKA_LAST));

       if (!ulPageId)
         return FALSE;

       if ( !WinSendDlgItemMsg(hwnd,
                              IDD_MACHINE,
                              BKM_SETSTATUSLINETEXT,
                              MPFROMLONG(ulPageId),
                              MPFROMP("Page 2 of 2")))
          return FALSE;

       if ( !WinSendDlgItemMsg(hwnd,
                              IDD_MACHINE,
                              BKM_SETTABTEXT,
                              MPFROMLONG(ulPageId),
                              MPFROMP("~Disks/CDs")))
         return FALSE;

       hwndPage2 = WinCreateWindow(hwnd,                      /* parent-window handle                    */
                                 WC_LISTBOX,                 /* pointer to registered class name        */
                                 "Doubleclick item to define", /* pointer to window text                  */
                                 WS_VISIBLE,
                                 0,                          /* horizontal position of window           */
                                 0,                          /* vertical position of window             */
                                 0,                          /* window width                            */
                                 0,                          /* window height                           */
                                 hwnd,                       /* owner-window handle                     */
                                 HWND_TOP,                   /* handle to sibling window                */
                                 0,                          /* window identifier                       */
                                 NULL,                       /* pointer to buffer                       */
                                 NULL);                      /* pointer to structure with pres. params. */

       if (!hwndPage2)
         return FALSE;

      for (i = 0; i < data.nr_fixed_disks; i++)
         {
         char disktext[80];
         sprintf(disktext, "Disk %d: %5.0f MB - %s",
                i+1,
                data.fixed_disk_size[i]/(KB),
                szDisk[i]);

         WinSendMsg(hwndPage2,
                   LM_INSERTITEM,
                   MPFROMSHORT(LIT_END),
                   MPFROMP(disktext));
         }

      for (i = 0; i < data.nr_cd_drives; i++)
         {
         char disktext[80];
         sprintf(disktext, "CD %d: %5.0f MB - %s",
                i+1,
                data.cd_drive_size[i]/(KB),
                szDisk[i+10]);

         WinSendMsg(hwndPage2,
                   LM_INSERTITEM,
                   MPFROMSHORT(LIT_END),
                   MPFROMP(disktext));
         }

       if( !WinSendDlgItemMsg(hwnd,
                             IDD_MACHINE,
                             BKM_SETPAGEWINDOWHWND,
                             MPFROMLONG(ulPageId),
                             MPFROMHWND(hwndPage2)))
         return FALSE;
       }
    break;

    case WM_CONTROL:
       {
       switch (SHORT2FROMMP(mp1))
          {
          case LN_ENTER:                            /* if list box item doubleclicked */
             {
             char szDiskname[60];
             char* n1;
             HWND hwndDlgD;
             SHORT sTextLength;

             i = (int)WinSendMsg(HWNDFROMMP(mp2),   /* find out which line it was... */
                               LM_QUERYSELECTION,
                               (MPARAM)MPFROMSHORT(LIT_CURSOR),
                               (MPARAM)0);

             if (i >= data.nr_fixed_disks)
                j = i + 10 - data.nr_fixed_disks;       /* it's a CD */
             else
                j = i;            /* otherwise it's a disk */

             WinSendMsg(HWNDFROMMP(mp2),   /* find out which line it was... */
                       LM_QUERYITEMTEXT,
                       (MPARAM)MPFROM2SHORT(i, sizeof(szDiskname)),
                       (MPARAM)MPFROMLONG(szDiskname));

             n1 = strstr(szDiskname, " - ");

             strcpy(szDisk[j], n1+3);

             hwndDlgD = WinLoadDlg(HWND_DESKTOP,
                                  hwnd,
                                  fnDiskStuff,
                                  NULLHANDLE,
                                  IDD_DISK,
                                  &j);

             rc = WinProcessDlg(hwndDlgD);
             } /* end case LN_ENTER */
             break;

           default:
              break;
           } /* end switch */
        }    /* end case WM_CONTROL */
        break;

    case WM_COMMAND:
       switch (COMMANDMSG(&msg)->cmd)
          {
          case IDD_DID_OK:
             {
             if (NamedC)                      /* if contents of text window changed */
                {
                WinQueryWindowText(           /* get text from display window */
                                  WinWindowFromID(hwndPage1, IDD_MACH_NAMED),
                                  sizeof(Machinename),
                                  Machinename);
                 }

             if (MobodC)                      /* if contents of text window changed */
                {
                WinQueryWindowText(           /* get text from display window */
                                  WinWindowFromID(hwndPage1, IDD_MACH_MOBOD),
                                  sizeof(Moboname),
                                  Moboname);
                 }

             if (ChipdC)                      /* if contents of text window changed */
                {
                WinQueryWindowText(           /* get text from display window */
                                  WinWindowFromID(hwndPage1, IDD_MACH_CHIPD),
                                  sizeof(Chipset),
                                  Chipset);
                 }

             if (MakedC)                      /* if contents of text window changed */
                {
                WinQueryWindowText(           /* get text from display window */
                                  WinWindowFromID(hwndPage1, IDD_MACH_MAKED),
                                  sizeof(MachineMake),
                                  MachineMake);
                 }

             if (CachdC)                      /* if contents of text window changed */
                {
                WinQueryWindowText(           /* get text from display window */
                                  WinWindowFromID(hwndPage1, IDD_MACH_CACHD),
                                  sizeof(CacheAmount),
                                  CacheAmount);
                 }

             if (ProcdC)                      /* if contents of text window changed */
                {
                WinQueryWindowText(           /* get text from display window */
                                  WinWindowFromID(hwndPage1, IDD_MACH_PROCD),
                                  sizeof(Processor),
                                  Processor);
                 }

             if (GrapdC)                      /* if contents of text window changed */
                {
                WinQueryWindowText(           /* get text from display window */
                                  WinWindowFromID(hwndPage1, IDD_MACH_GRAPD),
                                  sizeof(Graphicscard),
                                  Graphicscard);
                 }

             if (DiskdC)                      /* if contents of text window changed */
                {
                WinQueryWindowText(           /* get text from display window */
                                  WinWindowFromID(hwndPage1, IDD_MACH_DISKD),
                                  sizeof(DiskController),
                                  DiskController);
                 }
             hini = PrfOpenProfile(hab, szIniFileName); /* open our profile file */
             PrfWriteProfileData(hini,
                                pszApp,
                                pszKeyName,
                                &Machinename,
                                sizeof(Machinename));
             PrfWriteProfileData(hini,
                                pszApp,
                                pszKeyMobo,
                                &Moboname,
                                sizeof(Moboname));
             PrfWriteProfileData(hini,
                                pszApp,
                                pszKeyProcessor,
                                &Processor,
                                sizeof(Processor));
             PrfWriteProfileData(hini,
                                pszApp,
                                pszKeyMake,
                                &MachineMake,
                                sizeof(MachineMake));
             PrfWriteProfileData(hini,
                                pszApp,
                                pszKeyCache,
                                &CacheAmount,
                                sizeof(CacheAmount));
             PrfWriteProfileData(hini,
                                pszApp,
                                pszKeyChipset,
                                &Chipset,
                                sizeof(Chipset));
             PrfWriteProfileData(hini,
                                pszApp,
                                pszKeyGraphics,
                                &Graphicscard,
                                sizeof(Graphicscard));
             PrfWriteProfileData(hini,
                                pszApp,
                                pszKeyDisk,
                                &DiskController,
                                sizeof(DiskController));

             for (i = 0; i < MAX_FIXED_DISKS; i++)
                {
                sprintf(pszDisk, "DiskCD%d", i); /* set key name */

                PrfWriteProfileData(hini,
                                   pszApp,
                                   pszDisk,
                                   szDisk[i],
                                   sizeof(szDiskname));
                sprintf(data.c[comp_disk+i].title,
                       "Disk I/O disk %d: %5.0f MB - %s",
                       i+1,
                       data.fixed_disk_size[i]/(KB),
                       szDisk[i]);
                }

             for (i = 0; i < MAX_CD_DRIVES; i++)
                {
                sprintf(pszDisk, "DiskCD%d", i+10); /* set key name */

                PrfWriteProfileData(hini,
                                   pszApp,
                                   pszDisk,
                                   szDisk[i+10],
                                   sizeof(szDiskname));
                sprintf(data.c[comp_disk+data.nr_fixed_disks+i].title,
                       "CD-ROM I/O disk %d: %5.0f MB - %s",
                       i+1,
                       data.cd_drive_size[i]/(KB),
                       szDisk[i+10]);
                }

             PrfCloseProfile(hini);

             rc = WinDismissDlg(hwnd, 0UL);  /* dismiss the dialog */
             return 0L;
             }
             break;

          case IDD_DID_CANCEL:
             rc = WinDismissDlg(hwnd, 0UL);  /* dismiss the dialog */

             for (i = 0; i < data.nr_fixed_disks; i++)
                {
                char* n1;

                n1 = strstr(data.c[comp_disk+i].title, " - ");

                strcpy(szDisk[i], n1+3);
                }

             for (i = 0; i < data.nr_cd_drives; i++)
                {
                char* n1;

                n1 = strstr(data.c[comp_disk+data.nr_fixed_disks+i].title, " - ");

                strcpy(szDisk[i+10], n1+3);
                }

             return 0L;
          }
       break;


    default:
       break;
    }
 return (MRESULT)WinDefDlgProc (hwnd, msg, mp1, mp2);
}                                       /* end fnMachineStuff     */

MRESULT APIENTRY fnMachdlgStuff (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
int rc = 0;
HAB hab = WinQueryAnchorBlock(hwnd);

 switch (msg)
    {
    case WM_INITDLG:

       WinSendDlgItemMsg(hwnd, IDD_MACH_NAMED,
                        EM_SETTEXTLIMIT,
                        (MPARAM)99,
                        (MPARAM)0);
       WinSetWindowText(WinWindowFromID(hwnd, IDD_MACH_NAMED),
                       Machinename);
       WinSendDlgItemMsg(hwnd, IDD_MACH_MOBOD,
                        EM_SETTEXTLIMIT,
                        (MPARAM)99,
                        (MPARAM)0);
       WinSetWindowText(WinWindowFromID(hwnd, IDD_MACH_MOBOD),
                       Moboname);
       WinSendDlgItemMsg(hwnd, IDD_MACH_CHIPD,
                        EM_SETTEXTLIMIT,
                        (MPARAM)99,
                        (MPARAM)0);
       WinSetWindowText(WinWindowFromID(hwnd, IDD_MACH_CHIPD),
                       Chipset);
       WinSendDlgItemMsg(hwnd, IDD_MACH_MAKED,
                        EM_SETTEXTLIMIT,
                        (MPARAM)99,
                        (MPARAM)0);
       WinSetWindowText(WinWindowFromID(hwnd, IDD_MACH_MAKED),
                       MachineMake);
       WinSendDlgItemMsg(hwnd, IDD_MACH_CACHD,
                        EM_SETTEXTLIMIT,
                        (MPARAM)99,
                        (MPARAM)0);
       WinSetWindowText(WinWindowFromID(hwnd, IDD_MACH_CACHD),
                       CacheAmount);
       WinSendDlgItemMsg(hwnd, IDD_MACH_PROCD,
                        EM_SETTEXTLIMIT,
                        (MPARAM)99,
                        (MPARAM)0);
       WinSetWindowText(WinWindowFromID(hwnd, IDD_MACH_PROCD),
                       Processor);
       WinSendDlgItemMsg(hwnd, IDD_MACH_GRAPD,
                        EM_SETTEXTLIMIT,
                        (MPARAM)99,
                        (MPARAM)0);
       WinSetWindowText(WinWindowFromID(hwnd, IDD_MACH_GRAPD),
                       Graphicscard);
       WinSendDlgItemMsg(hwnd, IDD_MACH_DISKD,
                        EM_SETTEXTLIMIT,
                        (MPARAM)99,
                        (MPARAM)0);
       WinSetWindowText(WinWindowFromID(hwnd, IDD_MACH_DISKD),
                       DiskController);
       break;

    case WM_CONTROL:
        {
        switch (SHORT1FROMMP(mp1))
           {
           case IDD_MACH_NAMED:                         /* if text box event */
              {
              if (SHORT2FROMMP(mp1) == EN_CHANGE)       /* if text has changed */
                 {
                 NamedC = 1;                            /* remember that */
                 }
              if (SHORT2FROMMP(mp1) == EN_SETFOCUS)     /* if focus given to this box */
                 {
                 WinSendMsg(WinWindowFromID(hwnd, IDD_MACH_NAMED), /* select text between... */
                            EM_SETSEL,
                            (MPARAM)MPFROM2SHORT(0,99), (MPARAM)0);      /* position 0 and 99 (all of it) */
                 }
              }
              break;

           case IDD_MACH_MOBOD:                         /* if text box event */
              {
              if (SHORT2FROMMP(mp1) == EN_CHANGE)       /* if text has changed */
                 {
                 MobodC = 1;                            /* remember that */
                 }
              if (SHORT2FROMMP(mp1) == EN_SETFOCUS)     /* if focus given to this box */
                 {
                 WinSendMsg(WinWindowFromID(hwnd, IDD_MACH_MOBOD), /* select text between... */
                            EM_SETSEL,
                            (MPARAM)MPFROM2SHORT(0,99), (MPARAM)0);      /* position 0 and 99 (all of it) */
                 }
              }
              break;

           case IDD_MACH_CHIPD:                         /* if text box event */
              {
              if (SHORT2FROMMP(mp1) == EN_CHANGE)       /* if text has changed */
                 {
                 ChipdC = 1;                            /* remember that */
                 }
              if (SHORT2FROMMP(mp1) == EN_SETFOCUS)     /* if focus given to this box */
                 {
                 WinSendMsg(WinWindowFromID(hwnd, IDD_MACH_CHIPD), /* select text between... */
                            EM_SETSEL,
                            (MPARAM)MPFROM2SHORT(0,99), (MPARAM)0);      /* position 0 and 99 (all of it) */
                 }
              }
              break;

           case IDD_MACH_MAKED:                         /* if text box event */
              {
              if (SHORT2FROMMP(mp1) == EN_CHANGE)       /* if text has changed */
                 {
                 MakedC = 1;                            /* remember that */
                 }
              if (SHORT2FROMMP(mp1) == EN_SETFOCUS)     /* if focus given to this box */
                 {
                 WinSendMsg(WinWindowFromID(hwnd, IDD_MACH_MAKED), /* select text between... */
                            EM_SETSEL,
                            (MPARAM)MPFROM2SHORT(0,99), (MPARAM)0);      /* position 0 and 99 (all of it) */
                 }
              }
              break;

           case IDD_MACH_CACHD:                         /* if text box event */
              {
              if (SHORT2FROMMP(mp1) == EN_CHANGE)       /* if text has changed */
                 {
                 CachdC = 1;                            /* remember that */
                 }
              if (SHORT2FROMMP(mp1) == EN_SETFOCUS)     /* if focus given to this box */
                 {
                 WinSendMsg(WinWindowFromID(hwnd, IDD_MACH_CACHD), /* select text between... */
                            EM_SETSEL,
                            (MPARAM)MPFROM2SHORT(0,99), (MPARAM)0);      /* position 0 and 99 (all of it) */
                 }
              }
              break;

           case IDD_MACH_PROCD:                         /* if text box event */
              {
              if (SHORT2FROMMP(mp1) == EN_CHANGE)       /* if text has changed */
                 {
                 ProcdC = 1;                            /* remember that */
                 }
              if (SHORT2FROMMP(mp1) == EN_SETFOCUS)     /* if focus given to this box */
                 {
                 WinSendMsg(WinWindowFromID(hwnd, IDD_MACH_PROCD), /* select text between... */
                            EM_SETSEL,
                            (MPARAM)MPFROM2SHORT(0,99), (MPARAM)0);      /* position 0 and 99 (all of it) */
                 }
              }
              break;

           case IDD_MACH_GRAPD:                         /* if text box event */
              {
              if (SHORT2FROMMP(mp1) == EN_CHANGE)       /* if text has changed */
                 {
                 GrapdC = 1;                            /* remember that */
                 }
              if (SHORT2FROMMP(mp1) == EN_SETFOCUS)     /* if focus given to this box */
                 {
                 WinSendMsg(WinWindowFromID(hwnd, IDD_MACH_GRAPD), /* select text between... */
                            EM_SETSEL,
                            (MPARAM)MPFROM2SHORT(0,99), (MPARAM)0);      /* position 0 and 99 (all of it) */
                 }
              }
              break;

           case IDD_MACH_DISKD:                         /* if text box event */
              {
              if (SHORT2FROMMP(mp1) == EN_CHANGE)       /* if text has changed */
                 {
                 DiskdC = 1;                            /* remember that */
                 }
              if (SHORT2FROMMP(mp1) == EN_SETFOCUS)     /* if focus given to this box */
                 {
                 WinSendMsg(WinWindowFromID(hwnd, IDD_MACH_DISKD), /* select text between... */
                            EM_SETSEL,
                            (MPARAM)MPFROM2SHORT(0,99), (MPARAM)0);      /* position 0 and 99 (all of it) */
                 }
              }
              break;
           }
        }

    default:
       break;
    }
 return (MRESULT)WinDefDlgProc (hwnd, msg, mp1, mp2);
}                                       /* end PromptWinProc     */


MRESULT APIENTRY fnDiskStuff (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
int rc = 0, *k, j;
HAB hab = WinQueryAnchorBlock(hwnd);

 switch (msg)
    {
    case WM_INITDLG:

       WinSendDlgItemMsg(hwnd, IDD_DISK_NAME,
                        EM_SETTEXTLIMIT,
                        (MPARAM)39,
                        (MPARAM)0);

       k = (int*)PVOIDFROMMP(mp2);

       j = *k;

       WinSetWindowText(WinWindowFromID(hwnd, IDD_DISK_NAME),
                       szDisk[j]);

       WinSetWindowUShort(hwnd,
                         QWL_USER,
                         (SHORT)j);
       break;

    case WM_CONTROL:
        {
        switch (SHORT1FROMMP(mp1))
           {
           case IDD_DISK_NAME:                         /* if text box event */
              {
              if (SHORT2FROMMP(mp1) == EN_CHANGE)       /* if text has changed */
                 {
                 DisknC = 1;                            /* remember that */
                 }
              }
              break;
           }
        }
     break;

    case WM_COMMAND:
       switch (COMMANDMSG(&msg)->cmd)
          {
          case IDD_DID_OK:
             {
             if (DisknC)                      /* if contents of text window changed */
                {
                char disktext[80];
                int i;

                WinQueryWindowText(           /* get text from display window */
                                  WinWindowFromID(hwnd, IDD_DISK_NAME),
                                  sizeof(szDiskname),
                                  szDiskname);

                j = (int)WinQueryWindowUShort(hwnd,
                                           QWL_USER);

                strcpy(szDisk[j], szDiskname);

                if (j >= 10)
                   {
                   i = j + data.nr_fixed_disks - 10;
                   sprintf(disktext, "CD %d: %5.0f MB - %s",
                          j-9,
                          data.cd_drive_size[j-10]/(KB),
                          szDisk[j]);
                   }
                else
                   {
                   i = j;
                   sprintf(disktext, "Disk %d: %5.0f MB - %s",
                          i+1,
                          data.fixed_disk_size[i]/(KB),
                          szDisk[i]);
                   }
                WinSendMsg(hwndPage2,
                          LM_SETITEMTEXT,
                          MPFROMSHORT(i),
                          MPFROMP(disktext));
                }

             rc = WinDismissDlg(hwnd, 0UL);  /* dismiss the dialog */
             return 0L;
             }
             break;

          case IDD_DID_CANCEL:
             rc = WinDismissDlg(hwnd, 0UL);  /* dismiss the dialog */
             return 0L;
          }
       break;

    default:
       break;
    }
 return (MRESULT)WinDefDlgProc (hwnd, msg, mp1, mp2);
}                                       /* end PromptWinProc     */


void _Optlink WakeMeUp(void* arg)
{
HAB hab;
HMQ hmq;

while (!Initialised)
   {
   DosSleep(500);
   }
   if (!AutoBench)
      {
      hab  = WinInitialize(0);
      hmq  = WinCreateMsgQueue (hab, 0);

      WinPostMsg(hwndClient,
                WM_COMMAND,                        /* and send ourselves a message to display dialog box */
                (MPARAM)MPFROMSHORT(MI_MACHINE_DATA),  /* to be processed when we're initialised */
                (MPARAM)0);

      WinDestroyMsgQueue(hmq);
      WinTerminate ( hab );
      }

   _endthread;
}


void GetBIOSInfo(void)
{
  HFILE   DevHandle        = NULLHANDLE;   /* Handle for device */
  ULONG   ulCategory       = IOCTL_TESTCFG_SYS;         /* Device category */
  ULONG   ulFunction       = TESTCFG_SYS_GETBIOSADAPTER; /* Device-specific function */
  PUCHAR  pRomCopy;
  ULONG   u;
  ULONG   uBusArch;
  char*   Bustype[]        = {"ISA", "MCA", "EISA"};
  BYTE    bZero            = 0;

  struct  biosparms {
        ULONG Command;
        ULONG Addr;
        USHORT Numbytes;
        };
  struct biosparms uchParms  = {0, 0x000f0000, 0x0064};

  struct  viddata {
        USHORT Adapter;
        USHORT Chiptype;
        ULONG  Memory;
        };
  struct viddata uvidData  = {0, 0, 0};

  ULONG   ulParmLen        = 0;            /* Input and output parameter size */
  ULONG   ulDataLen        = 0;            /* Input and output data size */
  ULONG   ulAction         = 0;
  APIRET  rc               = NO_ERROR;     /* Return code */

  char    Award[10]        = "Award";
  char    AMI[10]          = "AMIBIOS";
  char    Phoenix[10]      = "Phoenix";
  char    MRBIOS[10]       = "MR BIOS";
  char    Compaq[10]       = "Compaq ";
  char    IBM[10]          = "GHT IBM C";
  BOOL    BIOSided         = 0;

  struct vidtype {
        char name[15];
        };
#define MAX_MANUFACTURERS 33
#define MAX_MODELS        11

  struct mantab {
        USHORT uEntries;
        char   Manufacturer[12];
        struct vidtype type[MAX_MODELS];
        };

   struct vidtab {
        USHORT uEntries;
        struct mantab VidMan[MAX_MANUFACTURERS];
        };

   struct vidtab VidTable = {MAX_MANUFACTURERS,
                               {{1, "Unknown",    /* #0 */
                                  {"type",
                                  "Undef.",
                                  "Undef.",
                                  "Undef.",
                                  "Undef.",
                                  "Undef.",
                                  "Undef.",
                                  "Undef.",
                                  "Undef."}
                               },
                              {3, "Headland",          /* #1 */
                                 {"HT205",
                                 "HT208",
                                 "HT209"}
                               },
                              {2, "Trident",          /* #2 */
                                 {"8800",
                                 "8900"}
                               },
                              {11, "Tseng",           /* #3 */
                                 {"ET3000",
                                 "ET4000",
                                 "ET4000W32",
                                 "ET4000W32I",
                                 "ET4000W32IB",
                                 "ET4000W32IC",
                                 "ET4000W32PA",
                                 "ET4000W32PB",
                                 "ET4000W32PC",
                                 "ET4000W32ID",
                                 "ET4000W32PD"}
                               },
                              {9, "WD",              /* #4 */
                                 {"PVGA1A",
                                 "WD9000",
                                 "WD9011",
                                 "WD9030",
                                 "WD9026",
                                 "WD9027",
                                 "WD9031",
                                 "WD9024",
                                 "WD9033"}
                               },
                              {6, "ATI",            /* #5 */
                                 {"18800",
                                 "28800",
                                 "38800",
                                 "68800",
                                 "88800",
                                 "88800CT"}
                               },
                              {2, "IBM",            /* #6 */
                                 {"VGA-256C",
                                 "IBMSVGA"}
                               },
                              {11, "CL",              /* #7 */
                                 {"5420", /* 1 */
                                 "5422",  /* 2 */
                                 "5424",  /* 3 */
                                 "5426",  /* 4 */
                                 "5428",  /* 5 */
                                 "5429",  /* 6 */
                                 "543x",  /* 7 */
                                 "5434",  /* 8 */
                                 "xxxx",  /* 9 */
                                 "xxxx",  /* 10 */
                                 "5436"}  /* 11 */
                               },
                              {5, "S3",                /* #8 */
                                 {"86C805",
                                 "86C928",
                                 "86C911",
                                 "86C864",
                                 "86C964"}
                               },
                              {1, "C&T",               /* #9 */
                                 {"type"}
                               },
                              {3, "Weitek",            /* #10 */
                                 {"P9000",
                                 "W5186",
                                 "W5286"}
                               },
                              {1, "#9",                /* #11 */
                                 {"type"}
                               },
                              {1, "Generic",           /* #12 */
                                 {"type"}
                               },
                              {1, "Oak",               /* #13 */
                                 {"type"}
                               },
                              {1, "Matrox",       /* #14 */
                                 {"type"}
                               },
                              {1, "Brooktree",    /* #15 */
                                 {"type"}
                               },
                              {1, "NVidea",       /* #16 */
                                 {"type"}
                               },
                              {1, "Alliance",     /* #17 */
                                 {"type"}
                               },
                              {1, "Avance",       /* #18 */
                                 {"type"}
                               },
                              {1, "MediaVision",  /* #19 */
                                 {"type"}
                               },
                              {1, "Ark",          /* #20 */
                                 {"type"}
                               },
                              {1, "Radius",       /* #21 */
                                 {"type"}
                               },
                              {1, "3D Labs",      /* #22 */
                                 {"type"}
                               },
                              {1, "NCR",          /* #23 */
                                 {"type"}
                               },
                              {1, "IIT",          /* #24 */
                                 {"type"}
                               },
                              {1, "Appian",       /* #25 */
                                 {"type"}
                               },
                              {1, "Sierra",       /* #26 */
                                 {"type"}
                               },
                              {1, "Cornerstone",  /* #27 */
                                 {"type"}
                               },
                              {1, "Digital",      /* #28 */
                                 {"type"}
                               },
                              {1, "Compaq",       /* #29 */
                                 {"type"}
                               },
                              {1, "Infotronic",   /* #30 */
                                 {"type"}
                               },
                              {1, "Opti",         /* #31 */
                                 {"type"}
                               },
                              {1, "Undef.",       /* #32 */
                                 {"type"}
                               }
                            }
                           };

   uchParms.Command  = 0;
   uchParms.Addr     = 0x000f0000;
   uchParms.Numbytes = 65535;

   DosAllocMem((void*)&pRomCopy,
              65536,
              PAG_COMMIT |
              PAG_READ   |
              PAG_WRITE);

   ulParmLen = sizeof(ULONG)+sizeof(ULONG)+sizeof(USHORT);   /* Length of input parameters */

   rc = DosOpen("TESTCFG$",
               &DevHandle,
               &ulAction,
               (ULONG)NULL,
               (ULONG)NULL,
               1,
               0x40,
               0);

   rc = DosDevIOCtl(DevHandle,           /* Handle to device */
                    ulCategory,          /* Category of request */
                    TESTCFG_SYS_GETBUSARCH,   /* Function being requested */
                    (void*)&uchParms,    /* Input/Output parameter list */
                    sizeof(uchParms),    /* Maximum output parameter size */
                    &ulParmLen,          /* Input:  size of parameter list */
                                         /* Output: size of parameters returned */
                    &uBusArch,           /* Input/Output data area */
                    4,                   /* Maximum output data size */
                    &ulDataLen);         /* Input:  size of input data area */
                                         /* Output: size of data returned   */


   rc = DosDevIOCtl(DevHandle,           /* Handle to device */
                    ulCategory,          /* Category of request */
                    ulFunction,          /* Function being requested */
                    (void*)&uchParms,    /* Input/Output parameter list */
                    sizeof(uchParms),    /* Maximum output parameter size */
                    &ulParmLen,          /* Input:  size of parameter list */
                                         /* Output: size of parameters returned */
                    pRomCopy,            /* Input/Output data area */
                    65535,               /* Maximum output data size */
                    &ulDataLen);         /* Input:  size of input data area */
                                         /* Output: size of data returned   */

   DosClose(DevHandle);

   if (uBusArch > 2)
      uBusArch = 0;

   strcpy(BusName, Bustype[uBusArch]);     /* set bus architecture name */

   if (!rc)
      {
      for (u = 0; u < 0xffffL-(sizeof(Phoenix)-1); u++)
         {
         if (!memcmp(&pRomCopy[u], Award, sizeof(Award-1)))
            {
            strcpy(BIOSname, "Award");
            BIOSided = TRUE;
            break;
            }
         if (!memcmp(&pRomCopy[u], Phoenix, sizeof(Phoenix-1)))
            {
            strcpy(BIOSname, "Phoenix");
            BIOSided = TRUE;
            break;
            }
         if (!memcmp(&pRomCopy[u], MRBIOS, sizeof(MRBIOS-1)))
            {
            strcpy(BIOSname, "MR BIOS");
            BIOSided = TRUE;
            break;
            }
         if (!memcmp(&pRomCopy[u], AMI, sizeof(AMI-1)))
            {
            strcpy(BIOSname, "AMI");
            BIOSided = TRUE;
            break;
            }
         if (!memcmp(&pRomCopy[u], Compaq, sizeof(Compaq-1)))
            {
            strcpy(BIOSname, "Compaq");
            BIOSided = TRUE;
            break;
            }
         if (!memcmp(&pRomCopy[u], IBM, sizeof(IBM-1)))
            {
            strcpy(BIOSname, "IBM");
            BIOSided = TRUE;
            break;
            }
         }
      }

   DosFreeMem(pRomCopy);

   if (!BIOSided)
      strcpy(BIOSname, "Unknown");

   ulCategory        = IOCTL_OEMHLP;         /* Device category */
   ulFunction        = OEMHLP_GETSVGAINFO;   /* Device-specific function */
   ulDataLen = sizeof(uvidData);

   rc = DosOpen("OEMHLP$",
               &DevHandle,
               &ulAction,
               (ULONG)NULL,
               (ULONG)NULL,
               1,
               0x40,
               0);

   if (!rc)
      {
      rc = DosDevIOCtl(DevHandle,           /* Handle to device */
                      ulCategory,          /* Category of request */
                      ulFunction,          /* Function being requested */
                      (void*)&uchParms,    /* Input/Output parameter list */
                      sizeof(uchParms),    /* Maximum output parameter size */
                      &ulParmLen,          /* Input:  size of parameter list */
                                           /* Output: size of parameters returned */
                      (void*)&uvidData,    /* Input/Output data area */
                      sizeof(uvidData),    /* Maximum output data size */
                      &ulDataLen);         /* Input:  size of input data area */
                                           /* Output: size of data returned   */
      if (!rc)
         {
         VideoMem = uvidData.Memory;
         VideoAdapter = uvidData.Adapter;
         VideoChip    = uvidData.Chiptype;

         if (VidTable.uEntries > uvidData.Adapter)
            {
            strcpy(VideoMan, VidTable.VidMan[uvidData.Adapter].Manufacturer);

            if ((VidTable.VidMan[uvidData.Adapter].uEntries >= uvidData.Chiptype) &&
                (uvidData.Chiptype))
               {
               strcpy(VideoType, VidTable.VidMan[uvidData.Adapter].type[uvidData.Chiptype-1].name);
               }
            else
               {
               strcpy(VideoType, "Unknown");
               }
            }
         else
            {
            strcpy(VideoMan, "Unknown");
            strcpy(VideoType, "Unknown");
            }

         if (VideoAdapter == 0 && VideoChip == 4139)  /* Matrox Millenium Bodge */
            {
            strcpy(VideoMan, "Matrox");
            strcpy(VideoType, "Mill./Myst.");
            VideoMem = VideoMem * 4;
            }
         }
      else
         {
         printf("DosDevIOCtl for video info error: return code = %u\n", rc);
         }
      rc = DosDevIOCtl(DevHandle,           /* Handle to device */
                      ulCategory,          /* Category of request */
                      OEMHLP_PCI,          /* Function being requested */
                      (void*)&uchParms,    /* Input/Output parameter list */
                      sizeof(uchParms),    /* Maximum output parameter size */
                      &ulParmLen,          /* Input:  size of parameter list */
                                           /* Output: size of parameters returned */
                      (void*)&uvidData,    /* Input/Output data area */
                      sizeof(uvidData),    /* Maximum output data size */
                      &ulDataLen);         /* Input:  size of input data area */
                                           /* Output: size of data returned   */
      if (!memcmp((const void*)&uvidData, (const void*)&bZero, 1))
         {
         strcat(BusName, "/PCI");
         }
      }
   else
      {
      printf("DosOpen OEMHLP$ error: return code = %u\n", rc);
      }

   DosClose(DevHandle);

   if (rc != NO_ERROR) {
       printf("DosDevIOCtl error: return code = %u\n", rc);
       return;
   }
}



