/************************************************/
/*  hanoi.c, Version 1.0, 18 Sep 1992  --- AAA  */
/*           Version 1.1, 06 Jul 1993  --- AAA  */
/*           Added print out for all disks      */
/*           Version 1.2, 28 May 1994  --- AAA  */
/*           Calculate average Moves/25usec     */
/************************************************/

/**************************************************/
/* Adapted from the MUSBUS test suite.            */
/* hanoi.c, V3.5 87/08/06 08:11:14 kenj           */
/*                                                */
/* Various timer routines are included. Please    */
/* select the appropriate timer routine for your  */
/* system from the options below. If no option is */
/* available then you will need to create your    */
/* own similar 'hanoi_time()' timer routine.           */
/*                                                */
/* You can uncomment one of the timer options     */
/* below to use it, or you can compile with the   */
/* option name. For example you can compile with  */
/* '-DUNIX', or '-DVMS', '-DMSC',..., etc.        */
/*                                                */
/* Example compilation:                           */
/*  cc -DUNIX hanoi.c -o hanoi, or                */
/* gcc -DUNIX -O hanoi.c -o hanoi, or             */
/*  cc -dAmiga hanoi.c -o hanoi, ..., etc         */
/**************************************************/

#define INCL_DOSMISC
#include <stdio.h>
#include <time.h>
#include <os2.h>

/***************************************************************/
/* Timer options. You MUST uncomment one of the options below  */
/* or compile, for example, with the '-DUNIX' option.          */
/***************************************************************/
/* #define Amiga       */
/* #define UNIX        */
/* #define UNIX_Old    */
/* #define VMS         */
/* #define BORLAND_C   */
/* #define MSC         */
/* #define MAC         */
/* #define IPSC        */
/* #define FORTRAN_SEC */
/* #define GTODay      */
/* #define CTimer      */
/* #define UXPM        */

#define other(i,j) (6-(i+j))

static double TimeArray[3];
static int num[4];
static long count;

static mov(int n, int f,int t);
static hanoi_time(double *p);


double pmb_hanoi(void)
{
  double RunTime = 0.0, sum_mps = 0.0, TLimit, mps;
  int disk, Loops = 0;

//printf("\n");
//printf("Towers of Hanoi Puzzle Test Program\n");
//printf("Disks     Moves     Time(sec)   Moves/25usec\n");

TLimit  = (30.0);
disk    = 15;

while ( RunTime < TLimit )
{
 disk++;
 num[0] = 0;
 num[1] = disk;
 num[2] = 0;
 num[3] = 0;
 count  = 0;

 hanoi_time(TimeArray);
 mov(disk,1,3);
 hanoi_time(TimeArray);

 RunTime = TimeArray[1];
 if (RunTime != 0.0)
    {
     mps = 2.5E-05 * ( (double)count/RunTime );
     Loops = Loops + 1;
     sum_mps = sum_mps + mps;
     //printf("%3ld  %10ld  %12.5lf  %10.4lf\n",disk,count,RunTime,mps);
     }
 if ( disk == 30 ) break;
}

sum_mps = sum_mps / (double)Loops;
//printf("\nAverage Moves Per 25 usec = %10.4lf\n",sum_mps);
//printf("\n");

return sum_mps;
}

static mov(n,f,t)
{
   int o;
   if(n == 1)
   {
      num[f]--;
      num[t]++;
      count++;
      return(0);
   }
   o = other(f,t);
   mov(n-1,f,o);
   mov(1,f,t);
   mov(n-1,o,t);
   return(0);
}

/*****************************************************/
/* Various timer routines.                           */
/* Al Aburto, aburto@marlin.nosc.mil, 26 Sep 1992    */
/*                                                   */
/* hanoi_time(p) outputs the elapsed time seconds in p[1] */
/* from a call of hanoi_time(p) to the next call of       */
/* hanoi_time(p).  Use CAUTION as some of these routines  */
/* will mess up when timing across the hour mark!!!  */
/*                                                   */
/* For timing I use the 'user' time whenever         */
/* possible. Using 'user+sys' time is a separate     */
/* issue.                                            */
/*                                                   */
/*****************************************************/

/*************************************/
/* Timer code.                       */
/*************************************/
/*******************/
/*  Amiga hanoi_time()  */
/*******************/
#ifdef Amiga
#include <ctype.h>
#define HZ 50

hanoi_time(p)
double p[];
{
   double q;

   struct   tt {
      long  days;
      long  minutes;
      long  ticks;
   } tt;

   q = p[2];

   DateStamp(&tt);

   p[2] = ( (double)(tt.ticks + (tt.minutes * 60L * 50L)) ) / (double)HZ;
   p[1] = p[2] - q;

   return 0;
}
#endif

/*****************************************************/
/*  UNIX hanoi_time(). This is the preferred UNIX timer.  */
/*  Provided by: Markku Kolkka, mk59200@cc.tut.fi    */
/*  HP-UX Addition by: Bo Thide', bt@irfu.se         */
/*****************************************************/
#ifdef UNIX
#include <sys/time.h>
#include <sys/resource.h>

#ifdef hpux
#include <sys/syscall.h>
#define getrusage(a,b) syscall(SYS_getrusage,a,b)
#endif

struct rusage rusage;

hanoi_time(p)
double p[];
{
   double q;

   q = p[2];

   getrusage(RUSAGE_SELF,&rusage);

   p[2] = (double)(rusage.ru_utime.tv_sec);
   p[2] = p[2] + (double)(rusage.ru_utime.tv_usec) * 1.0e-06;
   p[1] = p[2] - q;

   return 0;
}
#endif

/***************************************************/
/*  UNIX_Old hanoi_time(). This is the old UNIX timer.  */
/*  Use only if absolutely necessary as HZ may be  */
/*  ill defined on your system.                    */
/***************************************************/
#ifdef UNIX_Old
#include <sys/types.h>
#include <sys/times.h>
#include <sys/param.h>

#ifndef HZ
#define HZ 60
#endif

struct tms tms;

hanoi_time(p)
double p[];
{
   double q;

   q = p[2];

   times(&tms);

   p[2] = (double)(tms.tms_utime) / (double)HZ;
   p[1] = p[2] - q;

   return 0;
}
#endif

/*********************************************************/
/*  VMS hanoi_time() for VMS systems.                         */
/*  Provided by: RAMO@uvphys.phys.UVic.CA                */
/*  Some people have run into problems with this timer.  */
/*********************************************************/
#ifdef VMS
#include time

#ifndef HZ
#define HZ 100
#endif

struct tbuffer_t
       {
	int proc_user_time;
	int proc_system_time;
	int child_user_time;
	int child_system_time;
       };
struct tbuffer_t tms;

hanoi_time(p)
double p[];
{
   double q;

   q = p[2];

   times(&tms);

   p[2] = (double)(tms.proc_user_time) / (double)HZ;
   p[1] = p[2] - q;

   return 0;
}
#endif

/******************************/
/*  BORLAND C hanoi_time() for DOS */
/******************************/
#ifdef BORLAND_C
#include <ctype.h>
#include <dos.h>
#include <time.h>

#define HZ 100
struct time tnow;

hanoi_time(p)
double p[];
{
   double q;

   q = p[2];

   gettime(&tnow);

   p[2] = 60.0 * (double)(tnow.ti_min);
   p[2] = p[2] + (double)(tnow.ti_sec);
   p[2] = p[2] + (double)(tnow.ti_hund)/(double)HZ;
   p[1] = p[2] - q;

   return 0;
}
#endif

/**************************************/
/*  Microsoft C (MSC) hanoi_time() for DOS */
/**************************************/
#ifdef MSC
#include <time.h>
#include <ctype.h>

#define HZ CLK_TCK
clock_t tnow;

hanoi_time(p)
double p[];
{
   double q;

   q = p[2];

   tnow = clock();

   p[2] = (double)tnow / (double)HZ;
   p[1] = p[2] - q;

   return 0;
}
#endif

/*************************************/
/*  Macintosh (MAC) Think C hanoi_time()  */
/*************************************/
#ifdef MAC
#include <time.h>

#define HZ 60

hanoi_time(p)
double p[];
{
   double q;

   q = p[2];

   p[2] = (double)clock() / (double)HZ;
   p[1] = p[2] - q;

   return 0;
}
#endif

/************************************************************/
/*  iPSC/860 (IPSC) hanoi_time() for i860.                       */
/*  Provided by: Dan Yergeau, yergeau@gloworm.Stanford.EDU  */
/************************************************************/
#ifdef IPSC
extern double dclock();

hanoi_time(p)
double p[];
{
   double q;

   q = p[2];

   p[2] = dclock();
   p[1] = p[2] - q;

   return 0;
}
#endif

/**************************************************/
/*  FORTRAN hanoi_time() for Cray type systems.        */
/*  This is the preferred timer for Cray systems. */
/**************************************************/
#ifdef FORTRAN_SEC

fortran double second();

hanoi_time(p)
double p[];
{
   double q,v;

   q = p[2];

   second(&v);
   p[2] = v;
   p[1] = p[2] - q;

   return 0;
}
#endif

/***********************************************************/
/*  UNICOS C hanoi_time() for Cray UNICOS systems.  Don't use   */
/*  unless absolutely necessary as returned time includes  */
/*  'user+system' time.  Provided by: R. Mike Dority,      */
/*  dority@craysea.cray.com                                */
/***********************************************************/
#ifdef CTimer
#include <time.h>

hanoi_time(p)
double p[];
{
   double    q;
   clock_t   t;

       q = p[2];

       t = clock();

       p[2] = (double)t / (double)CLOCKS_PER_SEC;
       p[1] = p[2] - q;

       return 0;
}
#endif

/********************************************/
/* Another UNIX timer using gettimeofday(). */
/* However, getrusage() is preferred.       */
/********************************************/
#ifdef GTODay
#include <sys/time.h>

struct timeval tnow;

hanoi_time(p)
double p[];
{
   double q;

   q = p[2];

   gettimeofday(&tnow,NULL);
   p[2] = (double)tnow.tv_sec + (double)tnow.tv_usec * 1.0e-6;
   p[1] = p[2] - q;

   return 0;
}
#endif




static hanoi_time(p)
double p[];
{
   double q;
   ULONG value[QSV_MAX] = {0};
   APIRET rc = NULL;

   q = p[2];

 /*  p[2] = ((double)clock()); /* /CLOCKS_PER_SEC; */
   rc = DosQuerySysInfo(QSV_MS_COUNT, QSV_MS_COUNT, (PVOID)value, sizeof(ULONG));
   //printf("Millisecond count is %d\n",*value);
   p[2] = (double)*value/CLOCKS_PER_SEC;
   p[1] = p[2] - q;
   /* if (p[1] == 0.0) {
      p[1] = 0.0001;
      } */

   return 0;
}
