(*
 * This DOS program will extract a random bitmap from a zip file and rename
 * it so that each time Microsoft Windows (c) is run, a new bitmap will
 * appear
 *
 * The program SWAPBMP and the source code are released to the public
 * domain.
 *
 * Date   : December 01, 1993
 * Author : David Zangger
 *
 * Pkzip, PkUnzip, and Zip are (c) and (r) by PKWARE, INC.
 *
 *)

Program SwapBmp;

Uses
  DOS;

  {$M $4000, 0, 0}

Const
   MaxBitMaps = 250;

Var
   BitmapsLST_FILE : Text;
   BitmapBMP_FILE  : File;
   Count           : Integer;
   ListOfFiles     : Array[1..MaxBitMaps] of String[12];
   Index           : Integer;
   Env             : String;

function Exist ( Filename : string ) : boolean;
var
   SR   : SearchRec;

begin
     FindFirst ( Filename, Archive, SR );
     Exist := ( DOSError = 0 );
end;

procedure   ExecuteDosCommand ( str : String );
begin
     SwapVectors;
     Exec ( Env, '/C ' + Str + ' >NUL ' );
     SwapVectors;
end;

Begin
     Env := GetEnv ( 'COMSPEC' );

     if ( not Exist ( 'Bitmaps.zip' ) ) then
     begin
          Write ( 'Creating BITMAPS.ZIP...All the BMP files will be MOVED into the ZIP file...' );
          ExecuteDosCommand ( 'pkzip -m bitmaps.zip *.bmp' );
          Writeln ( 'Done' );
     end;

     if ( not Exist ( 'Bitmaps.LST' ) ) then
     begin
          Write ( 'Creating BITMAPS.LST...' );
          ExecuteDosCommand ( 'pkunzip.exe -@bitmaps.lst bitmaps.zip' );
          Writeln ( 'Done' );
     end;

     (* Init the variables *)

     Assign ( BitmapsLST_FILE, 'Bitmaps.LST' ); Reset ( BitmapsLST_FILE );
     FillChar ( ListOfFiles, Sizeof(ListOfFiles), #0 );
     Count := 0;

     (* Read the file to determine how many bitmaps are in the zip file *)

     While ( not EOF ( BitmapsLST_FILE ) and ( Count < MaxBitMaps )) do
     begin
       Inc ( Count, 1 );
       Readln ( BitmapsLST_FILE, ListOfFiles[Count] );
     end;

     (* Pick a BMP, any BMP *)

     Randomize;
     Index := Random(Count-1) + 1;
     Writeln ( 'Next BMP will be : ', ListOfFiles[Index] );

     ExecuteDosCommand ( 'Pkunzip bitmaps.zip ' + ListOfFiles[Index] );

     (* Now delete the current bitmap.bmp file *)

     Assign ( BitmapBMP_FILE, 'Bitmap.Bmp' );
     {$I-}
       Erase ( BitmapBMP_FILE );
     {$I+}

     (* Now rename the file we just unzipped to bitmap.bmp *)

     Assign ( BitmapBMP_FILE, ListOfFiles[Index] );
     {$I-}
       Rename ( BitmapBMP_FILE, 'Bitmap.bmp' );
     {$I+}
End.
