VERSION 2.00
Begin Form Form1 
   BorderStyle     =   3  'Fixed Double
   Caption         =   "System Color Tracker"
   ClientHeight    =   855
   ClientLeft      =   1095
   ClientTop       =   1485
   ClientWidth     =   4935
   Height          =   1260
   Left            =   1035
   LinkTopic       =   "Form1"
   ScaleHeight     =   855
   ScaleWidth      =   4935
   Top             =   1140
   Width           =   5055
   Begin MsgHook MsgHook 
      Left            =   135
      Top             =   135
   End
   Begin Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Label1"
      Height          =   195
      Index           =   0
      Left            =   1845
      TabIndex        =   0
      Top             =   135
      Width           =   585
   End
End
Option Explicit

' Array to hold system colors
Dim SysColor(0 To 20) As Long

' Windows message to watch for
Const WM_SYSCOLORCHANGE = &H15

' Win16 API calls
Declare Function GetSysColor Lib "User" (ByVal nIndex As Integer) As Long
Declare Function SendMessage Lib "User" (ByVal hWnd As Integer, ByVal wMsg As Integer, ByVal wParam As Integer, lParam As Any) As Long

' System Colors
Const COLOR_SCROLLBAR = 0
Const COLOR_BACKGROUND = 1
Const COLOR_ACTIVECAPTION = 2
Const COLOR_INACTIVECAPTION = 3
Const COLOR_MENU = 4
Const COLOR_WINDOW = 5
Const COLOR_WINDOWFRAME = 6
Const COLOR_MENUTEXT = 7
Const COLOR_WINDOWTEXT = 8
Const COLOR_CAPTIONTEXT = 9
Const COLOR_ACTIVEBORDER = 10
Const COLOR_INACTIVEBORDER = 11
Const COLOR_APPWORKSPACE = 12
Const COLOR_HIGHLIGHT = 13
Const COLOR_HIGHLIGHTTEXT = 14
Const COLOR_BTNFACE = 15
Const COLOR_BTNSHADOW = 16
Const COLOR_GRAYTEXT = 17
Const COLOR_BTNTEXT = 18
Const COLOR_INACTIVECAPTIONTEXT = 19
Const COLOR_BTNHIGHLIGHT = 20

Sub Form_Load ()
   '
   ' Setup MsgHook control
   '
   MsgHook.HwndHook = Me.hWnd
   MsgHook.Message(WM_SYSCOLORCHANGE) = True
   '
   ' Preload system colors into an array
   '
   Dim nRet As Long
   nRet = SendMessage(Me.hWnd, WM_SYSCOLORCHANGE, 0, 0&)
   '
   ' Load, Size, and Position controls
   '
   Dim i As Integer
   For i = 1 To 20
      Load Label1(i)
      Label1(i).Visible = True
      Label1(i).Top = Label1(i - 1).Top + Label1(i - 1).Height * 1.5
   Next i
   Me.Height = (Me.Height - Me.ScaleHeight) + Label1(20).Top + Label1(20).Height + Label1(0).Top
   Me.Move (Screen.Width - Me.Width) \ 2, (Screen.Height - Me.Height) \ 2
   '
   ' Fill label array
   '
   Label1(0) = "COLOR_SCROLLBAR"
   Label1(1) = "COLOR_BACKGROUND"
   Label1(2) = "COLOR_ACTIVECAPTION"
   Label1(3) = "COLOR_INACTIVECAPTION"
   Label1(4) = "COLOR_MENU"
   Label1(5) = "COLOR_WINDOW"
   Label1(6) = "COLOR_WINDOWFRAME"
   Label1(7) = "COLOR_MENUTEXT"
   Label1(8) = "COLOR_WINDOWTEXT"
   Label1(9) = "COLOR_CAPTIONTEXT"
   Label1(10) = "COLOR_ACTIVEBORDER"
   Label1(11) = "COLOR_INACTIVEBORDER"
   Label1(12) = "COLOR_APPWORKSPACE"
   Label1(13) = "COLOR_HIGHLIGHT"
   Label1(14) = "COLOR_HIGHLIGHTTEXT"
   Label1(15) = "COLOR_BTNFACE"
   Label1(16) = "COLOR_BTNSHADOW"
   Label1(17) = "COLOR_GRAYTEXT"
   Label1(18) = "COLOR_BTNTEXT"
   Label1(19) = "COLOR_INACTIVECAPTIONTEXT"
   Label1(20) = "COLOR_BTNHIGHLIGHT"
End Sub

Sub Form_Paint ()
   Dim i As Integer
   Dim Offset As Integer
   '
   ' Paint a box showing color by each label
   '
   Offset = Label1(0).Top
   For i = COLOR_SCROLLBAR To COLOR_BTNHIGHLIGHT
      Me.ForeColor = SysColor(i)
      Line (Offset, Label1(i).Top)-(Label1(i).Left - Offset, Label1(i).Top + Label1(i).Height), , BF
      Line (Offset, Label1(i).Top)-(Label1(i).Left - Offset, Label1(i).Top + Label1(i).Height), 0&, B
   Next i
End Sub

Sub MsgHook_Message (Msg As Integer, wParam As Integer, lParam As Long, Result As Long)
   Dim i As Integer
   If Msg = WM_SYSCOLORCHANGE Then
      '
      ' Update color table when msg arrives.
      '
      For i = COLOR_SCROLLBAR To COLOR_BTNHIGHLIGHT
         SysColor(i) = GetSysColor(i)
      Next i
   End If
End Sub

